/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-01-21 19:13:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpbd_bpspro_db_backup` (
  `bps_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bps_table_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `bps_desc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `bps_job_type` varchar(9) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_frequency` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_last_job` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_next_job` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_next_job_unix` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_email_zip` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bps_job_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `bps_id` (`bps_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_bpspro_login_security` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `public_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `role` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `human_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_time` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lockout_time` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `failed_logins` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hostname` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `request_uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_bpspro_mscan` (
  `mscan_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mscan_status` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `mscan_pattern` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `mscan_skipped` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_ignored` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_db_table` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_db_column` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mscan_db_pkid` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `mscan_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`mscan_id`),
  UNIQUE KEY `id` (`mscan_id`)
) ENGINE=MyISAM AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_bpspro_seclog_ignore` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_agent_bot` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_cbnetpo_ping_optimizer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci,
  `log_data` text COLLATE utf8mb4_unicode_ci,
  `type` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4195 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_et_bloom_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `record_type` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `optin_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `list_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `removed_flag` tinyint(1) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbd_et_social_stats` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `sharing_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `network` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbd_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `count` int(10) NOT NULL DEFAULT '0',
  `lockout` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=151904 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=32272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path` (`path`(191)),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbd_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_wfBadLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfBlockedCommentLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'gsb',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfBlocks` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `wfsn` tinyint(3) unsigned DEFAULT '0',
  `permanent` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`),
  KEY `k1` (`wfsn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfBlocksAdv` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockType` char(2) NOT NULL,
  `blockString` varchar(255) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `reason` varchar(255) NOT NULL,
  `totalBlocked` int(10) unsigned DEFAULT '0',
  `lastBlocked` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=104922 DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=777 DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6015 DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfLockedOut` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=193 DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfNet404s` (
  `sig` binary(16) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `URI` varchar(1000) NOT NULL,
  PRIMARY KEY (`sig`),
  KEY `k1` (`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=156 DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfScanners` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wpbd_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=16254 DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfThrottleLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `startTime` int(10) unsigned NOT NULL,
  `endTime` int(10) unsigned NOT NULL,
  `timesThrottled` int(10) unsigned NOT NULL,
  `lastReason` varchar(255) NOT NULL,
  PRIMARY KEY (`IP`),
  KEY `k2` (`endTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpbd_wfVulnScanners` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpbd_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=8716 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpbd_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wpbd_bpspro_login_security */
INSERT INTO `wpbd_bpspro_login_security` VALUES("1", "Not Locked", "2", "Budman", "Bud Gregson", "budgregson@gmail.com", "administrator", "2017-11-20 19:02:42", "1511204562", "0", "0", "73.243.133.68", "c-73-243-133-68.hsd1.co.comcast.net", "/wp-login.php");
INSERT INTO `wpbd_bpspro_login_security` VALUES("2", "Not Locked", "2", "Budman", "Bud Gregson", "budgregson@gmail.com", "administrator", "2017-11-21 02:04:06", "1511229846", "0", "0", "73.243.133.68", "c-73-243-133-68.hsd1.co.comcast.net", "/wp-login.php");
INSERT INTO `wpbd_bpspro_login_security` VALUES("3", "Not Locked", "3", "Liora", "Liora Faibish", "liora127@gmail.com", "editor", "2018-01-19 19:12:37", "1516389157", "0", "0", "75.166.209.211", "75-166-209-211.hlrn.qwest.net", "/wp-login.php");

/* INSERT TABLE DATA: wpbd_bpspro_mscan */
INSERT INTO `wpbd_bpspro_mscan` VALUES("2", "clean", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/scripts/builder.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("3", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/frontend-builder/assets/vendors/tinymce.min.js", "\\x20\\", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("4", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/frontend-builder/bundle.js", "visibility:hidden", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("5", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/google-analytics-for-wordpress/assets/js/chartjs/Chart.bundle.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("6", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/jetpack/_inc/build/admin.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("7", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/wp-seo-term-scraper-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("8", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/configuration-wizard-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("9", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/wp-seo-admin-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("10", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/wp-seo-metabox-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("11", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/wp-seo-post-scraper-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("12", "safe", "js", "/home/gregso5/public_html/wp-content/plugins/wordpress-seo/js/dist/wp-seo-recalculate-551.min.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("13", "clean", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/scripts/builder.js", "", "skipped", "", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("14", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/frontend-builder/assets/vendors/tinymce.min.js", "\\x20\\", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("15", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/frontend-builder/bundle.js", "visibility:hidden", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("16", "suspect", "php|html|other", "/home/gregso5/public_html/wp-snapshots/20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_installer.php", "base64_decode(", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("17", "suspect", "php|html|other", "/home/gregso5/public_html/wp-snapshots/20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_installer.php", "base64_decode(", "skipped", "ignore", "", "", "", "2017-09-30 23:28:08");
INSERT INTO `wpbd_bpspro_mscan` VALUES("62", "", "image", "/home/gregso5/public_html/wp-content/themes/twentyfifteen/screenshot.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("63", "", "image", "/home/gregso5/public_html/wp-content/themes/twentysixteen/screenshot.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("64", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/30-UCN.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("21", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/js/custom.min.js", "visibility:hidden", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("22", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/themes/Divi/core/components/Portability.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("23", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/scripts/salvattore.min.js", "visibility:hidden", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("24", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/scripts/ext/jquery.validate.js", "%28ty", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("25", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/frontend-builder/assets/vendors/plugins/codesample/plugin.min.js", "|exec|", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("26", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/frontend-builder/assets/vendors/plugins/legacyoutput/plugin.min.js", "s||c);r", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("27", "suspect", "js", "/home/gregso5/public_html/wp-content/themes/Divi/includes/builder/frontend-builder/assets/vendors/plugins/wordcount/plugin.min.js", "\\x0B", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("28", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/divi-switch/divi-switch.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("29", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/divi-switch/plugin-updates/github-checker.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("30", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/divi-switch/plugin-updates/vendor/readme-parser.php", "\\xEF\\xBB", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("31", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/monarch/core/components/Portability.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("32", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/monarch/includes/oauth.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("33", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/bloom/dashboard/js/tinymce/js/tinymce/tinymce.min.js", "\\x20\\", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("34", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/bloom/dashboard/js/tinymce/js/tinymce/plugins/legacyoutput/plugin.min.js", "s||c);r", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("35", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/bloom/dashboard/js/tinymce/js/tinymce/plugins/wordcount/plugin.min.js", "\\x27\\", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("36", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/bloom/core/components/Portability.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("37", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/divi-booster/core/fixes/034-import-settings/functions.php", "gzinflate(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("38", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/loginizer/IPv6/BigInteger.php", "10000000", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("39", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/accelerated-mobile-pages/accelerated-moblie-pages.php", "o0", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("40", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/dashboard/js/tinymce/js/tinymce/tinymce.min.js", "\\x20\\", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("41", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/dashboard/js/tinymce/js/tinymce/plugins/legacyoutput/plugin.min.js", "s||c);r", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("42", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/dashboard/js/tinymce/js/tinymce/plugins/wordcount/plugin.min.js", "\\x27\\", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("43", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/js/divi-builder.min.js", "visibility:hidden", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("44", "suspect", "php|html|other", "/home/gregso5/public_html/wp-content/plugins/divi-builder/core/components/Portability.php", "base64_decode(", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("45", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/scripts/salvattore.min.js", "visibility:hidden", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("46", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/scripts/ext/jquery.validate.js", "%28ty", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("47", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/frontend-builder/assets/vendors/plugins/codesample/plugin.min.js", "|exec|", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("48", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/frontend-builder/assets/vendors/plugins/legacyoutput/plugin.min.js", "s||c);r", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("49", "suspect", "js", "/home/gregso5/public_html/wp-content/plugins/divi-builder/includes/builder/frontend-builder/assets/vendors/plugins/wordcount/plugin.min.js", "\\x0B", "", "ignore", "", "", "", "2017-09-30 23:21:17");
INSERT INTO `wpbd_bpspro_mscan` VALUES("50", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30922", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("51", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30902", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("52", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30909", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("53", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30910", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("54", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30911", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("55", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30912", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("56", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30913", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("57", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30914", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("58", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30916", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("59", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30915", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("60", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30917", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("61", "suspect", "db", "", "<iframe", "", "", "wpbd_posts", "post_content", "30923", "2017-09-30 23:21:18");
INSERT INTO `wpbd_bpspro_mscan` VALUES("65", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/31-Guitars-Exposed.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("66", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/19-MaraLago.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("67", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/18-Live-Streaming.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("68", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/15-Stone-Cold-Secrets.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("69", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/29-Cooking-For-Singles.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("70", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/25-Live-At-The-Sheldon.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("71", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/28-All-Star-Guitar-Night.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("72", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/08-Sockville-Live.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("73", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/07-Combat-Showcase.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("74", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/23-Hotshots-Sports.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("75", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/03-Sockville.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("76", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/08/12-BillyCraze.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("77", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/131-1080x559.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("78", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/0042-768x440.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:50");
INSERT INTO `wpbd_bpspro_mscan` VALUES("79", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/07.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("80", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/20-503x1024.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("81", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/06.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("82", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/022.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("83", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/081-1.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("84", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/011.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("85", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/003.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("86", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/07-2880x1800.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("87", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/042.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("88", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/06-2.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("89", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/20-610x1242.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("90", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/032.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("91", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/03-768x444.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("92", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/04-2-1024x841.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("93", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/0042.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("94", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/04-2-1080x887.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("95", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/09.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("96", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/0210.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("97", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/0111.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("98", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/051.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("99", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/06-2-1080x675.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("100", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/092-2880x1440.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("101", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/092.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("102", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/20-674x675.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("103", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/081.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:51");
INSERT INTO `wpbd_bpspro_mscan` VALUES("104", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/018.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:52");
INSERT INTO `wpbd_bpspro_mscan` VALUES("105", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/08.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("106", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/004.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("107", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/09-1.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("108", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/131-1024x530.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("109", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/131-1080x586.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("110", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/04-2-1080x675.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:53");
INSERT INTO `wpbd_bpspro_mscan` VALUES("111", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/131.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:54");
INSERT INTO `wpbd_bpspro_mscan` VALUES("112", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/0113.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:54");
INSERT INTO `wpbd_bpspro_mscan` VALUES("113", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/04-2-768x631.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:54");
INSERT INTO `wpbd_bpspro_mscan` VALUES("114", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/03.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:54");
INSERT INTO `wpbd_bpspro_mscan` VALUES("115", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/04-2.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:55");
INSERT INTO `wpbd_bpspro_mscan` VALUES("116", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/01.jpg", "", "skipped", "", "", "", "", "2017-09-30 23:31:55");
INSERT INTO `wpbd_bpspro_mscan` VALUES("117", "", "image", "/home/gregso5/public_html/wp-content/uploads/2017/07/20.png", "", "skipped", "", "", "", "", "2017-09-30 23:31:56");

/* INSERT TABLE DATA: wpbd_cbnetpo_ping_optimizer */
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4194", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4193", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4192", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4191", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4190", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4189", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4188", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4187", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4186", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4185", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4184", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4183", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4182", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4181", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4180", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4179", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4178", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4177", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4176", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4175", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4174", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4173", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4172", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4171", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4170", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4169", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4168", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4167", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4166", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4165", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4164", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4163", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4162", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4161", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4160", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4159", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4158", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4157", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4156", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4155", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4154", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3085", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3086", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4153", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3088", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3090", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4152", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3092", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3093", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3094", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4151", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3096", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4150", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3098", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4149", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3100", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4148", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3103", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4147", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4146", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3106", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4145", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4144", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4143", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4142", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4141", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4140", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4139", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4138", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4137", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3117", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3118", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4136", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4135", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4134", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4133", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4132", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3125", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3127", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3128", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3129", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3130", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3131", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3132", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3133", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3134", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3135", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3136", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3137", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3138", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3139", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3140", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3141", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3142", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3143", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3144", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3145", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3146", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3147", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3148", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3149", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3150", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3151", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3152", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3153", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3154", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3155", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3156", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3157", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3158", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3159", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3160", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3161", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3162", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3163", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3164", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3165", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3166", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3167", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3168", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3169", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3170", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3171", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3172", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3173", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3174", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3175", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3176", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3177", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3178", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3179", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3180", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3181", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3182", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3183", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3184", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3185", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3186", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3187", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3188", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3189", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3190", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3191", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3192", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3193", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3194", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3195", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3196", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3197", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3198", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3199", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3200", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3201", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3202", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3203", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3204", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3205", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3206", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3207", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3208", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3209", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3210", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3211", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3212", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3213", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3214", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3215", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3216", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3217", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3218", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3219", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3220", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3221", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3222", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3223", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3224", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3225", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3226", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3227", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3228", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3229", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3230", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3231", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3232", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3233", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3234", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3235", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3236", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3237", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3238", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3239", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3240", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3241", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3242", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3243", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3244", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3245", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3246", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3247", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3248", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3249", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3250", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3251", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3252", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4130", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4131", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3254", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4129", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3256", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4128", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4127", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4126", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4125", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4124", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4123", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4122", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4121", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4120", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4119", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4118", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4117", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4116", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4115", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4114", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4113", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4112", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4111", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3278", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3279", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3280", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3281", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3282", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3283", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3284", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3285", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3286", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3287", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3288", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3289", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3290", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3291", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3292", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3293", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3294", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3295", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3296", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3297", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3298", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4110", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4109", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4108", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4107", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4106", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3306", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3307", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3308", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3309", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3310", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3311", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3312", "2018-01-14 07:25:33", "Top 5 Reasons to Use Social Media in Your Business", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3313", "2018-01-14 07:43:43", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3314", "2018-01-14 07:43:43", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3315", "2018-01-14 07:44:23", "Learn From How Starbucks Uses Online & Offline Marketing Effectively", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3316", "2018-01-14 07:53:49", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3317", "2018-01-14 07:53:49", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3318", "2018-01-14 07:56:26", "Use Fear Setting to Overcome Anything", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3319", "2018-01-14 07:56:26", "Use Fear Setting to Overcome Anything", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3320", "2018-01-14 07:58:06", "Learn From Starbucks Marketing", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3321", "2018-01-14 07:58:06", "Learn From Starbucks Marketing", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3322", "2018-01-14 07:59:38", "10 Ways to Build Your Credibility on Social Media", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3323", "2018-01-14 08:02:48", "10 Ways to Build Your Credibility on Social Media", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3324", "2018-01-14 08:20:25", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3325", "2018-01-14 08:20:25", "", "NOT Pinging (Excessive Pinging Limit Reached)", "8");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3326", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3327", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3328", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3329", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3330", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3331", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3332", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3333", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3334", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3335", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3336", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3337", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3338", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3339", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3340", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3341", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3342", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3343", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3344", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3345", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3346", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3347", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3348", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3349", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3350", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3351", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3352", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3353", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3354", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3355", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3356", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3357", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3358", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3359", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3360", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3361", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3362", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3363", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3364", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3365", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3366", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3367", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3368", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3369", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3370", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3371", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3372", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3373", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3374", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3375", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3376", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3377", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3378", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3379", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3380", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3381", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3382", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3383", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3384", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3385", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3386", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3387", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3388", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3389", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3390", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3391", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3392", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3393", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3394", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3395", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3396", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3397", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3398", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3399", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3400", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3401", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3402", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3403", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3404", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3405", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3406", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3407", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3408", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3409", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3410", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3411", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3412", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3413", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3414", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3415", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3416", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3417", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3418", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3419", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3420", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3421", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3422", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3423", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3424", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3425", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3426", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3427", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3428", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3429", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3430", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3431", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3432", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3433", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3434", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3435", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3436", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3437", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3438", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3439", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3440", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3441", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3442", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3443", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3444", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3445", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3446", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3447", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3448", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3449", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3450", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3451", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3452", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3453", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3454", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3455", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3456", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3457", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3458", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3459", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3460", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3461", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3462", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3463", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3464", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3465", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3466", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3467", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3468", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3469", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3470", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3471", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3472", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3473", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3474", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3475", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3476", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3477", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3478", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3479", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3480", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3481", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3482", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3483", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3484", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3485", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3486", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3487", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3488", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3489", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3490", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3491", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3492", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3493", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3494", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3495", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3496", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3497", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3498", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3499", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3500", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3501", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3502", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3503", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3504", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3505", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3506", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3507", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3508", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3509", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3510", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3511", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3512", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3513", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3514", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3515", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3516", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3517", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3518", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3519", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3520", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3521", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3522", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3523", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3524", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3525", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3526", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3527", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3528", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3529", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3530", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3531", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3532", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3533", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3534", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3535", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3536", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3537", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3538", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3539", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3540", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3541", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3542", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3543", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3544", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3545", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3546", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3547", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3548", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3549", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3550", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3551", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3552", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3553", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3554", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3555", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3556", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3557", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3558", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3559", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3560", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3561", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3562", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3563", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3564", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3565", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3566", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3567", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3568", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3569", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3570", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3571", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3572", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3573", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3574", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3575", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3576", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3577", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3578", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3579", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3580", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3581", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3582", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3583", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3584", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3585", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3586", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3587", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3588", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3589", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3590", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3591", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3592", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3593", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3594", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3595", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3596", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3597", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3598", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3599", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3600", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3601", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3602", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3603", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3604", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3605", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3606", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3607", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3608", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3609", "2018-01-14 08:56:00", "Gregson Studios Blog", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3610", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3611", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3612", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3613", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3614", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3615", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3616", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3617", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3618", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3619", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3620", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3621", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3622", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3623", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3624", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3625", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3626", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3627", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3628", "2018-01-14 09:00:01", "Gregson Studios Blog", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3629", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3630", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3631", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3632", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3633", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3634", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3635", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://rpc.weblogs.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3636", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://services.newsgator.com/ngws/xmlrpcping.aspx was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3637", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://topicexchange.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3638", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://trackback.bakeinu.jp/bakeping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3639", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.a2b.cc/setloc/bp.a2b could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3640", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.bitacoles.net/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3641", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogdigger.com/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3642", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogoole.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3643", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogoon.net/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3644", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogpeople.net/servlet/weblogUpdates was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3645", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogroots.com/tb_populi.blog?id=1 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3646", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogshares.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3647", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogsnow.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3648", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.blogstreet.com/xrbin/xmlrpc.cgi could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3649", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.feedsubmitter.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3650", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3651", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3652", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3653", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3654", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3655", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3656", "2018-01-14 08:51:51", "Public Speaking Series - Part 1", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3657", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.lasermemory.com/lsrpc/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3658", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.mod-pubsub.org/kn_apps/blogchatter/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3659", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.newsisfree.com/RPCCloud could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3660", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.newsisfree.com/xmlrpctest.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3661", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.pingerati.net could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3662", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.pingmyblog.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3663", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.popdex.com/addsite.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3664", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.snipsnap.org/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3665", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.weblogalot.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3666", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://www.weblogues.com/RPC/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3667", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://xmlrpc.blogg.de could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3668", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "http://xping.pubsub.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3669", "2018-01-14 08:53:02", "Public Speaking Series - Part 1", "https://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3670", "2018-01-15 05:37:00", "Video Editing Services", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3671", "2018-01-16 01:17:52", "10 Ways to Build Your Credibility on Social Media", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3672", "2018-01-16 01:18:00", "Benefits of Having a YouTube Channel", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3673", "2018-01-16 01:18:22", "7 Tips to Make Your Video Content Really Stand Out", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3674", "2018-01-16 01:19:07", "Benefits of Having a YouTube Channel", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3675", "2018-01-16 01:19:07", "7 Tips to Make Your Video Content Really Stand Out", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3676", "2018-01-16 01:19:07", "Why You Should Be Using Video Marketing", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3677", "2018-01-16 01:19:07", "Launch That Dream Start-Up Business", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3678", "2018-01-16 01:19:07", "Public Speaking Series - Part 1", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3679", "2018-01-16 01:19:07", "Use Fear Setting to Overcome Anything", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3680", "2018-01-16 01:19:07", "Top 5 Reasons to Use Social Media in Your Business", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3681", "2018-01-16 01:19:07", "Learn From Starbucks Marketing", "NOT Pinging (%title% was edited)", "5");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3682", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3683", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3684", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3685", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3686", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3687", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3688", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3689", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3690", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3691", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3692", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3693", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3694", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3695", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3696", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3697", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3698", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3699", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3700", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3701", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3702", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3703", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3704", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3705", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3706", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3707", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3708", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3709", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3710", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3711", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3712", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3713", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3714", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3715", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3716", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3717", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3718", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3719", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3720", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3721", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3722", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3723", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3724", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3725", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3726", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3727", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3728", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3729", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3730", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3731", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3732", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3733", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3734", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3735", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3736", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3737", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3738", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3739", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3740", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3741", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3742", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3743", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3744", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3745", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3746", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3747", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3748", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3749", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3750", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3751", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3752", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3753", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3754", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3755", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3756", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3757", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3758", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3759", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3760", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3761", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3762", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3763", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3764", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3765", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3766", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3767", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3768", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3769", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3770", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3771", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3772", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3773", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3774", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3775", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3776", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3777", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3778", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3779", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3780", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3781", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3782", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3783", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3784", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3785", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3786", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3787", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3788", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3789", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3790", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3791", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3792", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://1470.net/api/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3793", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3794", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3795", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://api.feedster.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3796", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3797", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3798", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://api.moreover.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3799", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3800", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3801", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3802", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://api.my.yahoo.com/rss/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3803", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3804", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3805", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://bblog.com/ping.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3806", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://bing.com/webmaster/ping.aspx could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3807", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3808", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://bitacoras.net/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3809", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3810", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blo.gs/ping.php could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3811", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3812", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blog.goo.ne.jp/XMLRPC could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3813", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3814", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blog.with2.net/ping.php was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3815", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3816", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3817", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogdb.jp/xmlrpc could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3818", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3819", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3820", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogmatcher.com/u.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3821", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3822", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3823", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3824", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3825", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3826", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3827", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3828", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3829", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3830", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogping.unidatum.com/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3831", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3832", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3833", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3834", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3835", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogpingr.de/ping/rpc2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3836", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3837", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3838", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3839", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3840", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogs.yandex.ru/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3841", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3842", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ae/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3843", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3844", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3845", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3846", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.at/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3847", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.be/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3848", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3849", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3850", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.bg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3851", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3852", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ca/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3853", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3854", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ch/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3855", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3856", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3857", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.cl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3858", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3859", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.cr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3860", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3861", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.hu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3862", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3863", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.id/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3864", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3865", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3866", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.il/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3867", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3868", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.in/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3869", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3870", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3871", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3872", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3873", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3874", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3875", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3876", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3877", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3878", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3879", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3880", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3881", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3882", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3883", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3884", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3885", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.it/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3886", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3887", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3888", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ma/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3889", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3890", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.nz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3891", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3892", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.th/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3893", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3894", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.uk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3895", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.ve/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3896", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.co.za/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3897", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3898", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3899", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ar/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3900", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3901", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.au/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3902", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3903", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.br/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3904", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3905", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.co/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3906", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3907", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.do/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3908", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3909", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.mx/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3910", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.my/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3911", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3912", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3913", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3914", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.pe/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3915", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3916", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3917", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3918", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sa/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3919", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.sg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3920", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3921", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3922", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3923", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.tw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3924", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.ua/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3925", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3926", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3927", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.uy/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3928", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3929", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com.vn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3930", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3931", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3932", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.com/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3933", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3934", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.de/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3935", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.es/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3936", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3937", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fi/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3938", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3939", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.fr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3940", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3941", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3942", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.gr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3943", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3944", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.hr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3945", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ie/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3946", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3947", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.in/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3948", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.it/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3949", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3950", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.jp/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3951", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3952", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3953", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3954", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ki/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3955", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3956", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3957", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.kz/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3958", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.la/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3959", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3960", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3961", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.li/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3962", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3963", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3964", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3965", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3966", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3967", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3968", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.lu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3969", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3970", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.md/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3971", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3972", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ms/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3973", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3974", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3975", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3976", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mv/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3977", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3978", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.mw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3979", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3980", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3981", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3982", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3983", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3984", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.no/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3985", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3986", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nr/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3987", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3988", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.nu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3989", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3990", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3991", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3992", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3993", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3994", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.pt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3995", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3996", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ro/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3997", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ru/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3998", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.rw/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("3999", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4000", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sc/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4001", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4002", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.se/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4003", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sh/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4004", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.si/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4005", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4006", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4007", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4008", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.sn/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4009", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4010", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.st/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4011", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4012", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tk/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4013", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4014", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tl/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4015", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4016", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tm/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4017", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4018", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.to/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4019", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4020", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tp/ping/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4021", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4022", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tt/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4023", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4024", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.tw/ping/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4025", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4026", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.us/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4027", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4028", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vg/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4029", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4030", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4031", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.vu/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4032", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4033", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://blogsearch.google.ws/ping/RPC2 was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4034", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://bulkfeeds.net/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4035", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4036", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://coreblog.org/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4037", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4038", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4039", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4040", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://geourl.org/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4041", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4042", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4043", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4044", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ipings.com could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4045", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://mod-pubsub.org/kn_apps/blogchatt could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4046", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4047", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://news2paper.com/ping could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4048", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.amagle.com/ could not be pinged. Error message: \"parse error. not well formed\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4049", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4050", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bitacoras.com could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4051", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4052", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4053", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4054", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4055", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4056", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4057", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4058", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4059", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4060", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4061", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blo.gs/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4062", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4063", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4064", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.bloggers.jp/rpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4065", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4066", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogmura.jp/rpc/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4067", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4068", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.blogs.yandex.ru/RPC2 could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4069", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4070", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.cocolog-nifty.com/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4071", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4072", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4073", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.exblog.jp/xmlrpc could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4074", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.fc2.com was successfully pinged", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4075", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.feedburner.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4076", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.myblog.jp could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4077", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4078", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rootblog.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4079", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.rss.drecom.jp was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4080", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4081", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.syndic8.com/xmlrpc.php could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4082", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4083", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogalot.com/rpc.php could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4084", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://ping.weblogs.se/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4085", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://pingoat.com/goat/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4086", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rcs.datashed.net/RPC2/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4087", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogbuzzmachine.com/RPC2 could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4088", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4089", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.bloggerei.de/ping/ was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4090", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.blogrolling.com/pinger/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4091", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4092", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4093", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4094", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4095", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4096", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4097", "2018-01-16 01:37:56", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4098", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.copygator.com/ping/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4099", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.icerocket.com:10080/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4100", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.newsgator.com/ could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4101", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.odiogo.com/ping/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4102", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.pingomatic.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4103", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.technorati.com/rpc/ping could not be pinged. Error message: \"transport error - could not open socket\"", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4104", "2018-01-16 01:37:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.twingly.com was successfully pinged (extended format)", "2");
INSERT INTO `wpbd_cbnetpo_ping_optimizer` VALUES("4105", "2018-01-16 01:36:55", "5 Things Every Internet Marketing Millionaire Does", "http://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/ could not be pinged. Error message: \"transport error - HTTP status code was not 200\"", "2");

/* INSERT TABLE DATA: wpbd_commentmeta */
INSERT INTO `wpbd_commentmeta` VALUES("6", "2", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"gqzoitxhid\";s:20:\"comment_author_email\";s:19:\"jzrrqlz@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/\";s:15:\"comment_content\";s:270:\"Why You Should Be Using Video Marketing - Gregson Studios\r\ngqzoitxhid http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/\r\n[url=http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/]ugqzoitxhid[/url]\r\n<a href=\"http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/\">agqzoitxhid</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"121.57.150.126\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("5", "2", "akismet_history", "a:2:{s:4:\"time\";d:1515904894.3816249370574951171875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("4", "2", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("7", "3", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("8", "3", "akismet_history", "a:2:{s:4:\"time\";d:1515904998.6233069896697998046875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("9", "3", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"nyxfhgkrz\";s:20:\"comment_author_email\";s:19:\"mufqpcy@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/\";s:15:\"comment_content\";s:267:\"Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/\">anyxfhgkrz</a>\r\nnyxfhgkrz http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/\r\n[url=http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/]unyxfhgkrz[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"112.28.106.231\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("10", "4", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("11", "4", "akismet_history", "a:2:{s:4:\"time\";d:1515905098.937552928924560546875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("12", "4", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"lgegobxtib\";s:20:\"comment_author_email\";s:19:\"waareid@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/\";s:15:\"comment_content\";s:270:\"Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/\">algegobxtib</a>\r\n[url=http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/]ulgegobxtib[/url]\r\nlgegobxtib http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"113.3.247.140\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("13", "5", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("14", "5", "akismet_history", "a:2:{s:4:\"time\";d:1515905130.567780017852783203125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("15", "5", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"nzvxvlqpwq\";s:20:\"comment_author_email\";s:19:\"utnsvpn@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/\";s:15:\"comment_content\";s:270:\"Why You Should Be Using Video Marketing - Gregson Studios\r\n[url=http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/]unzvxvlqpwq[/url]\r\n<a href=\"http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/\">anzvxvlqpwq</a>\r\nnzvxvlqpwq http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"60.170.190.26\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("16", "6", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("17", "6", "akismet_history", "a:2:{s:4:\"time\";d:1515905176.58446788787841796875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("18", "6", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"cjywjvnpeb\";s:20:\"comment_author_email\";s:19:\"vxstqvx@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/\";s:15:\"comment_content\";s:270:\"Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/\">acjywjvnpeb</a>\r\n[url=http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/]ucjywjvnpeb[/url]\r\ncjywjvnpeb http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"110.166.197.186\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("19", "7", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("20", "7", "akismet_history", "a:2:{s:4:\"time\";d:1515905221.434113979339599609375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("21", "7", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:6:\"jvvtkf\";s:20:\"comment_author_email\";s:19:\"uzbmxpw@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/\";s:15:\"comment_content\";s:258:\"Why You Should Be Using Video Marketing - Gregson Studios\r\njvvtkf http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/\r\n<a href=\"http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/\">ajvvtkf</a>\r\n[url=http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/]ujvvtkf[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"119.86.174.45\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("22", "8", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("23", "8", "akismet_history", "a:2:{s:4:\"time\";d:1515905408.754129886627197265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("24", "8", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"cdqzdpddj\";s:20:\"comment_author_email\";s:19:\"jrtltdo@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/\";s:15:\"comment_content\";s:267:\"Why You Should Be Using Video Marketing - Gregson Studios\r\ncdqzdpddj http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/\r\n<a href=\"http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/\">acdqzdpddj</a>\r\n[url=http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/]ucdqzdpddj[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"116.54.70.125\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("25", "9", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("26", "9", "akismet_history", "a:2:{s:4:\"time\";d:1515905505.056273937225341796875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("27", "9", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:11:\"oeiıtlzpzt\";s:20:\"comment_author_email\";s:19:\"gdgudqg@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/\";s:15:\"comment_content\";s:273:\"Why You Should Be Using Video Marketing - Gregson Studios\r\noeiıtlzpzt http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/\r\n<a href=\"http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/\">aoeiıtlzpzt</a>\r\n[url=http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/]uoeiıtlzpzt[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"85.105.155.216\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("28", "10", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("29", "10", "akismet_history", "a:2:{s:4:\"time\";d:1515905627.5191090106964111328125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("30", "10", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"iywtehigzm\";s:20:\"comment_author_email\";s:19:\"elyuepi@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/\";s:15:\"comment_content\";s:270:\"Why You Should Be Using Video Marketing - Gregson Studios\r\n[url=http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/]uiywtehigzm[/url]\r\n<a href=\"http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/\">aiywtehigzm</a>\r\niywtehigzm http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"116.24.66.200\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:48:\"http://gregsonstudios.com/using-video-marketing/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("31", "11", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("32", "11", "akismet_history", "a:2:{s:4:\"time\";d:1515915119.798162937164306640625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("33", "11", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"yqwrwwmzrh\";s:20:\"comment_author_email\";s:19:\"rgrlzwe@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/]uyqwrwwmzrh[/url]\r\n<a href=\"http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/\">ayqwrwwmzrh</a>\r\nyqwrwwmzrh http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"123.145.74.34\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("34", "12", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("35", "12", "akismet_history", "a:2:{s:4:\"time\";d:1515915377.93156909942626953125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("36", "12", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"yridjfhee\";s:20:\"comment_author_email\";s:19:\"kfkcilm@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/\";s:15:\"comment_content\";s:278:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nyridjfhee http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/\r\n[url=http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/]uyridjfhee[/url]\r\n<a href=\"http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/\">ayridjfhee</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"183.214.95.186\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("37", "13", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("38", "13", "akismet_history", "a:2:{s:4:\"time\";d:1515915379.13564205169677734375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("39", "13", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"ivtdrdzv\";s:20:\"comment_author_email\";s:19:\"qfnjdhe@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/\";s:15:\"comment_content\";s:275:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/\">aivtdrdzv</a>\r\n[url=http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/]uivtdrdzv[/url]\r\nivtdrdzv http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"113.224.70.113\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("40", "14", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("41", "14", "akismet_history", "a:2:{s:4:\"time\";d:1515915401.3814389705657958984375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("42", "14", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"fknxogwwqf\";s:20:\"comment_author_email\";s:19:\"czokcva@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nfknxogwwqf http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/\r\n[url=http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/]ufknxogwwqf[/url]\r\n<a href=\"http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/\">afknxogwwqf</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"114.244.144.59\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("43", "15", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("44", "15", "akismet_history", "a:2:{s:4:\"time\";d:1515915419.1598351001739501953125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("45", "15", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"eismqkkvrh\";s:20:\"comment_author_email\";s:19:\"yivlmgq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/]ueismqkkvrh[/url]\r\neismqkkvrh http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/\r\n<a href=\"http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/\">aeismqkkvrh</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"58.40.206.67\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("46", "16", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("47", "16", "akismet_history", "a:2:{s:4:\"time\";d:1515915447.35725498199462890625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("48", "16", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"bvnmsnlg\";s:20:\"comment_author_email\";s:19:\"wjcobid@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g4b79w928ela4mipnxww655040b5i86ls.org/\";s:15:\"comment_content\";s:275:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g4b79w928ela4mipnxww655040b5i86ls.org/]ubvnmsnlg[/url]\r\n<a href=\"http://www.g4b79w928ela4mipnxww655040b5i86ls.org/\">abvnmsnlg</a>\r\nbvnmsnlg http://www.g4b79w928ela4mipnxww655040b5i86ls.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"119.182.24.205\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("49", "17", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("50", "17", "akismet_history", "a:2:{s:4:\"time\";d:1515915467.805056095123291015625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("51", "17", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"wfpdfkih\";s:20:\"comment_author_email\";s:19:\"jhocwty@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/\";s:15:\"comment_content\";s:275:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/\">awfpdfkih</a>\r\n[url=http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/]uwfpdfkih[/url]\r\nwfpdfkih http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"114.93.181.165\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("52", "18", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("53", "18", "akismet_history", "a:2:{s:4:\"time\";d:1515915471.57322788238525390625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("54", "18", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"dehhrwlz\";s:20:\"comment_author_email\";s:19:\"ktqfrqk@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/\";s:15:\"comment_content\";s:275:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/]udehhrwlz[/url]\r\ndehhrwlz http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/\r\n<a href=\"http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/\">adehhrwlz</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"114.219.117.252\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("55", "19", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("56", "19", "akismet_history", "a:2:{s:4:\"time\";d:1515915478.00409793853759765625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("57", "19", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"nssrovrwyq\";s:20:\"comment_author_email\";s:19:\"iifxhxg@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nnssrovrwyq http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/\r\n[url=http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/]unssrovrwyq[/url]\r\n<a href=\"http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/\">anssrovrwyq</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"119.108.160.35\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("58", "20", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("59", "20", "akismet_history", "a:2:{s:4:\"time\";d:1515915484.870688915252685546875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("60", "20", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"mfggzxijx\";s:20:\"comment_author_email\";s:19:\"fztqndo@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/\";s:15:\"comment_content\";s:278:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nmfggzxijx http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/\r\n<a href=\"http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/\">amfggzxijx</a>\r\n[url=http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/]umfggzxijx[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"202.110.156.144\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("61", "21", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("62", "21", "akismet_history", "a:2:{s:4:\"time\";d:1515915491.2746889591217041015625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("63", "21", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"nzloipykjx\";s:20:\"comment_author_email\";s:19:\"pbjqdmm@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g4tbta7939mxarc5j645hk425el5t861s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g4tbta7939mxarc5j645hk425el5t861s.org/]unzloipykjx[/url]\r\nnzloipykjx http://www.g4tbta7939mxarc5j645hk425el5t861s.org/\r\n<a href=\"http://www.g4tbta7939mxarc5j645hk425el5t861s.org/\">anzloipykjx</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"125.95.96.46\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("64", "22", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("65", "22", "akismet_history", "a:2:{s:4:\"time\";d:1515915498.522921085357666015625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("66", "22", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"ofekbsztr\";s:20:\"comment_author_email\";s:19:\"tbujdzd@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gkiayas15rj260m406z4594lg522lu2ws.org/\";s:15:\"comment_content\";s:278:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.gkiayas15rj260m406z4594lg522lu2ws.org/\">aofekbsztr</a>\r\nofekbsztr http://www.gkiayas15rj260m406z4594lg522lu2ws.org/\r\n[url=http://www.gkiayas15rj260m406z4594lg522lu2ws.org/]uofekbsztr[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"117.84.155.106\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("67", "23", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("68", "23", "akismet_history", "a:2:{s:4:\"time\";d:1515915502.2186839580535888671875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("69", "23", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"dpnpdyclgh\";s:20:\"comment_author_email\";s:19:\"nurdqtr@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g45960re36cm0efg175k3ww08dtx58yls.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g45960re36cm0efg175k3ww08dtx58yls.org/\">adpnpdyclgh</a>\r\n[url=http://www.g45960re36cm0efg175k3ww08dtx58yls.org/]udpnpdyclgh[/url]\r\ndpnpdyclgh http://www.g45960re36cm0efg175k3ww08dtx58yls.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"117.157.64.21\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("70", "24", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("71", "24", "akismet_history", "a:2:{s:4:\"time\";d:1515915559.3815519809722900390625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("72", "24", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"jwsncymmyq\";s:20:\"comment_author_email\";s:19:\"lbkmbpf@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/]ujwsncymmyq[/url]\r\njwsncymmyq http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/\r\n<a href=\"http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/\">ajwsncymmyq</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"116.231.39.13\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("73", "25", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("74", "25", "akismet_history", "a:2:{s:4:\"time\";d:1515915567.38677501678466796875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("75", "25", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"jqilmemsjd\";s:20:\"comment_author_email\";s:19:\"futseoq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/\">ajqilmemsjd</a>\r\n[url=http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/]ujqilmemsjd[/url]\r\njqilmemsjd http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"218.77.80.131\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("76", "26", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("77", "26", "akismet_history", "a:2:{s:4:\"time\";d:1515915575.25115299224853515625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("78", "26", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"rzrqfgzvrq\";s:20:\"comment_author_email\";s:19:\"lgajbvx@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nrzrqfgzvrq http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/\r\n<a href=\"http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/\">arzrqfgzvrq</a>\r\n[url=http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/]urzrqfgzvrq[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"49.71.212.163\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("79", "27", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("80", "27", "akismet_history", "a:2:{s:4:\"time\";d:1515915667.6189720630645751953125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("81", "27", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"jehprzliec\";s:20:\"comment_author_email\";s:19:\"nmhoenp@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/\";s:15:\"comment_content\";s:281:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/]ujehprzliec[/url]\r\njehprzliec http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/\r\n<a href=\"http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/\">ajehprzliec</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"116.228.200.206\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("82", "28", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("83", "28", "akismet_history", "a:2:{s:4:\"time\";d:1515915716.8489739894866943359375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("84", "28", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"vrsbzhrm\";s:20:\"comment_author_email\";s:19:\"bbhflfv@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g55izjsg510nomahf00381j6s4f871y0s.org/\";s:15:\"comment_content\";s:275:\"Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g55izjsg510nomahf00381j6s4f871y0s.org/\">avrsbzhrm</a>\r\n[url=http://www.g55izjsg510nomahf00381j6s4f871y0s.org/]uvrsbzhrm[/url]\r\nvrsbzhrm http://www.g55izjsg510nomahf00381j6s4f871y0s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"114.225.114.52\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:66:\"http://gregsonstudios.com/top-5-reasons-use-social-media-business/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("85", "29", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("86", "29", "akismet_history", "a:2:{s:4:\"time\";d:1515920276.1025369167327880859375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("87", "29", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"itjwnilkxo\";s:20:\"comment_author_email\";s:19:\"mbueivf@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\nitjwnilkxo http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/\r\n[url=http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/]uitjwnilkxo[/url]\r\n<a href=\"http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/\">aitjwnilkxo</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"113.13.186.15\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("88", "30", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("89", "30", "akismet_history", "a:2:{s:4:\"time\";d:1515920542.5560181140899658203125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("90", "30", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"enxzojtdw\";s:20:\"comment_author_email\";s:19:\"vebqufn@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/]uenxzojtdw[/url]\r\n<a href=\"http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/\">aenxzojtdw</a>\r\nenxzojtdw http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"119.100.209.167\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("91", "31", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("92", "31", "akismet_history", "a:2:{s:4:\"time\";d:1515920563.893250942230224609375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("93", "31", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"tgsibkmzjw\";s:20:\"comment_author_email\";s:19:\"tpjbbjz@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gd80l9942ztiz834geak39oiv35893hls.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\ntgsibkmzjw http://www.gd80l9942ztiz834geak39oiv35893hls.org/\r\n[url=http://www.gd80l9942ztiz834geak39oiv35893hls.org/]utgsibkmzjw[/url]\r\n<a href=\"http://www.gd80l9942ztiz834geak39oiv35893hls.org/\">atgsibkmzjw</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"123.232.154.79\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("94", "32", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("95", "32", "akismet_history", "a:2:{s:4:\"time\";d:1515920570.2097179889678955078125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("96", "32", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"mfzdrifqm\";s:20:\"comment_author_email\";s:19:\"kyuqrtq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/]umfzdrifqm[/url]\r\nmfzdrifqm http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/\r\n<a href=\"http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/\">amfzdrifqm</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"58.221.121.90\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("97", "33", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("98", "33", "akismet_history", "a:2:{s:4:\"time\";d:1515920597.9452850818634033203125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("99", "33", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"qzsbvbty\";s:20:\"comment_author_email\";s:19:\"oyombmg@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/\";s:15:\"comment_content\";s:256:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/]uqzsbvbty[/url]\r\nqzsbvbty http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/\r\n<a href=\"http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/\">aqzsbvbty</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"111.40.116.175\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("100", "34", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("101", "34", "akismet_history", "a:2:{s:4:\"time\";d:1515920610.5192759037017822265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("102", "34", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"liityrpycy\";s:20:\"comment_author_email\";s:19:\"bmymegi@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gwb6k68scu091tdks460632m134tlv5ds.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gwb6k68scu091tdks460632m134tlv5ds.org/\">aliityrpycy</a>\r\nliityrpycy http://www.gwb6k68scu091tdks460632m134tlv5ds.org/\r\n[url=http://www.gwb6k68scu091tdks460632m134tlv5ds.org/]uliityrpycy[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"115.212.59.99\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("103", "35", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("104", "35", "akismet_history", "a:2:{s:4:\"time\";d:1515920621.6028740406036376953125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("105", "35", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"rzosrnkfi\";s:20:\"comment_author_email\";s:19:\"icdoyen@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\nrzosrnkfi http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/\r\n[url=http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/]urzosrnkfi[/url]\r\n<a href=\"http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/\">arzosrnkfi</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"222.32.87.89\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("106", "36", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("107", "36", "akismet_history", "a:2:{s:4:\"time\";d:1515920628.9918711185455322265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("108", "36", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:7:\"zhkqbmt\";s:20:\"comment_author_email\";s:19:\"dnkqvjj@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/\";s:15:\"comment_content\";s:253:\"Public Speaking Series - Part 1 - Gregson Studios\r\nzhkqbmt http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/\r\n<a href=\"http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/\">azhkqbmt</a>\r\n[url=http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/]uzhkqbmt[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"220.172.48.217\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("109", "37", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("110", "37", "akismet_history", "a:2:{s:4:\"time\";d:1515920629.7486360073089599609375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("111", "37", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"sxqrmcbizw\";s:20:\"comment_author_email\";s:19:\"ztsqedg@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/\">asxqrmcbizw</a>\r\nsxqrmcbizw http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/\r\n[url=http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/]usxqrmcbizw[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"120.37.233.108\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("112", "38", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("113", "38", "akismet_history", "a:2:{s:4:\"time\";d:1515920648.892529964447021484375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("114", "38", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"kkfjkthmpc\";s:20:\"comment_author_email\";s:19:\"ccxfnqn@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g988384a4tgtl87dar08n72k2iy11yths.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\nkkfjkthmpc http://www.g988384a4tgtl87dar08n72k2iy11yths.org/\r\n[url=http://www.g988384a4tgtl87dar08n72k2iy11yths.org/]ukkfjkthmpc[/url]\r\n<a href=\"http://www.g988384a4tgtl87dar08n72k2iy11yths.org/\">akkfjkthmpc</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"125.95.96.46\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("115", "39", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("116", "39", "akismet_history", "a:2:{s:4:\"time\";d:1515920656.412602901458740234375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("117", "39", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"ltjrcgvdks\";s:20:\"comment_author_email\";s:19:\"thhgozh@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\nltjrcgvdks http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/\r\n[url=http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/]ultjrcgvdks[/url]\r\n<a href=\"http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/\">altjrcgvdks</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"42.224.79.39\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("118", "40", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("119", "40", "akismet_history", "a:2:{s:4:\"time\";d:1515920657.9724409580230712890625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("120", "40", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"kccopkhrmx\";s:20:\"comment_author_email\";s:19:\"bnondwa@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/\">akccopkhrmx</a>\r\nkccopkhrmx http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/\r\n[url=http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/]ukccopkhrmx[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"218.6.244.67\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("121", "41", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("122", "41", "akismet_history", "a:2:{s:4:\"time\";d:1515920667.571691036224365234375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("123", "41", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"htilfbzvod\";s:20:\"comment_author_email\";s:19:\"bxtmpye@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\nhtilfbzvod http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/\r\n[url=http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/]uhtilfbzvod[/url]\r\n<a href=\"http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/\">ahtilfbzvod</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"110.166.197.216\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("124", "42", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("125", "42", "akismet_history", "a:2:{s:4:\"time\";d:1515920675.3162829875946044921875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("126", "42", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"rgocckrik\";s:20:\"comment_author_email\";s:19:\"anofyoh@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\nrgocckrik http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/\r\n[url=http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/]urgocckrik[/url]\r\n<a href=\"http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/\">argocckrik</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"221.234.223.190\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("127", "43", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("128", "43", "akismet_history", "a:2:{s:4:\"time\";d:1515920676.21323490142822265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("129", "43", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"bnvxkqpkj\";s:20:\"comment_author_email\";s:19:\"wirciav@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/]ubnvxkqpkj[/url]\r\nbnvxkqpkj http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/\r\n<a href=\"http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/\">abnvxkqpkj</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"111.123.108.65\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("130", "44", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("131", "44", "akismet_history", "a:2:{s:4:\"time\";d:1515920678.377358913421630859375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("132", "44", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"rzjkermtvq\";s:20:\"comment_author_email\";s:19:\"suurhzu@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/]urzjkermtvq[/url]\r\n<a href=\"http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/\">arzjkermtvq</a>\r\nrzjkermtvq http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"113.138.228.146\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("133", "45", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("134", "45", "akismet_history", "a:2:{s:4:\"time\";d:1515920701.11040592193603515625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("135", "45", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"snocohiekf\";s:20:\"comment_author_email\";s:19:\"kubiffj@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\nsnocohiekf http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/\r\n[url=http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/]usnocohiekf[/url]\r\n<a href=\"http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/\">asnocohiekf</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"175.13.191.54\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("136", "46", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("137", "46", "akismet_history", "a:2:{s:4:\"time\";d:1515920754.9814798831939697265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("138", "46", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"yxydstgx\";s:20:\"comment_author_email\";s:19:\"wvdggyb@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/\";s:15:\"comment_content\";s:256:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/\">ayxydstgx</a>\r\nyxydstgx http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/\r\n[url=http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/]uyxydstgx[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"183.158.16.116\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("139", "47", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("140", "47", "akismet_history", "a:2:{s:4:\"time\";d:1515920789.5191919803619384765625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("141", "47", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"psnkjipcfe\";s:20:\"comment_author_email\";s:19:\"vcucsdf@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\npsnkjipcfe http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/\r\n<a href=\"http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/\">apsnkjipcfe</a>\r\n[url=http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/]upsnkjipcfe[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"58.52.223.97\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("142", "48", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("143", "48", "akismet_history", "a:2:{s:4:\"time\";d:1515920873.947801113128662109375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("144", "48", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:7:\"okhpdwg\";s:20:\"comment_author_email\";s:19:\"vdcyqfd@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/\";s:15:\"comment_content\";s:253:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/]uokhpdwg[/url]\r\n<a href=\"http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/\">aokhpdwg</a>\r\nokhpdwg http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"1.180.158.238\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("145", "49", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("146", "49", "akismet_history", "a:2:{s:4:\"time\";d:1515920982.9987199306488037109375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("147", "49", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"rvsmcgtnqe\";s:20:\"comment_author_email\";s:19:\"mauiymw@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/]urvsmcgtnqe[/url]\r\nrvsmcgtnqe http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/\r\n<a href=\"http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/\">arvsmcgtnqe</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"180.127.239.108\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("148", "50", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("149", "50", "akismet_history", "a:2:{s:4:\"time\";d:1515921009.6129629611968994140625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("150", "50", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:7:\"wzfbmww\";s:20:\"comment_author_email\";s:19:\"ayxjjhn@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/\";s:15:\"comment_content\";s:253:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/\">awzfbmww</a>\r\nwzfbmww http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/\r\n[url=http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/]uwzfbmww[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"218.77.80.131\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("151", "51", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("152", "51", "akismet_history", "a:2:{s:4:\"time\";d:1515921117.728888988494873046875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("153", "51", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"rtpryshsfl\";s:20:\"comment_author_email\";s:19:\"kbbnlfj@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/\";s:15:\"comment_content\";s:262:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/\">artpryshsfl</a>\r\nrtpryshsfl http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/\r\n[url=http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/]urtpryshsfl[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"118.40.228.157\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("154", "52", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("155", "52", "akismet_history", "a:2:{s:4:\"time\";d:1515922399.0093080997467041015625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("156", "52", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"xgvgibeei\";s:20:\"comment_author_email\";s:19:\"losijio@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/\";s:15:\"comment_content\";s:259:\"Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/\">axgvgibeei</a>\r\nxgvgibeei http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/\r\n[url=http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/]uxgvgibeei[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"114.222.186.174\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://gregsonstudios.com/public-speaking-series-part-1/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("157", "53", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("158", "53", "akismet_history", "a:2:{s:4:\"time\";d:1516067087.7828800678253173828125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("159", "53", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"nrhbftvqjt\";s:20:\"comment_author_email\";s:19:\"gcwsnxy@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nnrhbftvqjt http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/\r\n<a href=\"http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/\">anrhbftvqjt</a>\r\n[url=http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/]unrhbftvqjt[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"123.114.206.206\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("160", "54", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("161", "54", "akismet_history", "a:2:{s:4:\"time\";d:1516067122.5970089435577392578125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("162", "54", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"ionribhlt\";s:20:\"comment_author_email\";s:19:\"vywkrtp@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/]uionribhlt[/url]\r\n<a href=\"http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/\">aionribhlt</a>\r\nionribhlt http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"113.206.93.214\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("163", "55", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("164", "55", "akismet_history", "a:2:{s:4:\"time\";d:1516067125.918199062347412109375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("165", "55", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"cnlyzvgzq\";s:20:\"comment_author_email\";s:19:\"hwvzijk@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/]ucnlyzvgzq[/url]\r\n<a href=\"http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/\">acnlyzvgzq</a>\r\ncnlyzvgzq http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"117.25.215.12\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("166", "56", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("167", "56", "akismet_history", "a:2:{s:4:\"time\";d:1516067134.4462680816650390625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("168", "56", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"njnqqsleq\";s:20:\"comment_author_email\";s:19:\"ktsdgek@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g99854saff3i87fe30nhmrqqm948q248s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g99854saff3i87fe30nhmrqqm948q248s.org/]unjnqqsleq[/url]\r\nnjnqqsleq http://www.g99854saff3i87fe30nhmrqqm948q248s.org/\r\n<a href=\"http://www.g99854saff3i87fe30nhmrqqm948q248s.org/\">anjnqqsleq</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"222.80.153.132\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("169", "57", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("170", "57", "akismet_history", "a:2:{s:4:\"time\";d:1516067140.409451961517333984375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("171", "57", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"eidimbyo\";s:20:\"comment_author_email\";s:19:\"thjjarc@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/\";s:15:\"comment_content\";s:275:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\neidimbyo http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/\r\n<a href=\"http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/\">aeidimbyo</a>\r\n[url=http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/]ueidimbyo[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"124.42.239.117\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("172", "58", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("173", "58", "akismet_history", "a:2:{s:4:\"time\";d:1516067148.9080460071563720703125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("174", "58", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"txxmzjflm\";s:20:\"comment_author_email\";s:19:\"soxyydo@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/\">atxxmzjflm</a>\r\ntxxmzjflm http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/\r\n[url=http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/]utxxmzjflm[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"222.216.130.111\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("175", "59", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("176", "59", "akismet_history", "a:2:{s:4:\"time\";d:1516067244.2016289234161376953125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("177", "59", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:8:\"hswjjmxd\";s:20:\"comment_author_email\";s:19:\"chwollo@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/\";s:15:\"comment_content\";s:275:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nhswjjmxd http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/\r\n<a href=\"http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/\">ahswjjmxd</a>\r\n[url=http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/]uhswjjmxd[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:12:\"58.63.64.100\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("178", "60", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("179", "60", "akismet_history", "a:2:{s:4:\"time\";d:1516067248.8994960784912109375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("180", "60", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"kiqccsqhym\";s:20:\"comment_author_email\";s:19:\"eiracay@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nkiqccsqhym http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/\r\n<a href=\"http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/\">akiqccsqhym</a>\r\n[url=http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/]ukiqccsqhym[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"124.193.178.222\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("181", "61", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("182", "61", "akismet_history", "a:2:{s:4:\"time\";d:1516067320.1881220340728759765625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("183", "61", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"lztbrioqr\";s:20:\"comment_author_email\";s:19:\"ljtkvah@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/]ulztbrioqr[/url]\r\n<a href=\"http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/\">alztbrioqr</a>\r\nlztbrioqr http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"116.224.88.132\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("184", "62", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("185", "62", "akismet_history", "a:2:{s:4:\"time\";d:1516067330.77488803863525390625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("186", "62", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"ovztxqmhic\";s:20:\"comment_author_email\";s:19:\"enhbfrt@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/]uovztxqmhic[/url]\r\novztxqmhic http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/\r\n<a href=\"http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/\">aovztxqmhic</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"113.108.192.2\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("187", "63", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("188", "63", "akismet_history", "a:2:{s:4:\"time\";d:1516067355.6072089672088623046875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("189", "63", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"tlgtfemblx\";s:20:\"comment_author_email\";s:19:\"denkfml@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/]utlgtfemblx[/url]\r\n<a href=\"http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/\">atlgtfemblx</a>\r\ntlgtfemblx http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"106.92.20.201\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("190", "64", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("191", "64", "akismet_history", "a:2:{s:4:\"time\";d:1516067376.4118740558624267578125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("192", "64", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"lwciootmb\";s:20:\"comment_author_email\";s:19:\"gbcweqn@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/]ulwciootmb[/url]\r\n<a href=\"http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/\">alwciootmb</a>\r\nlwciootmb http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:11:\"1.192.240.8\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("193", "65", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("194", "65", "akismet_history", "a:2:{s:4:\"time\";d:1516067395.040112018585205078125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("195", "65", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"btywmcegi\";s:20:\"comment_author_email\";s:19:\"tbmujti@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/\">abtywmcegi</a>\r\n[url=http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/]ubtywmcegi[/url]\r\nbtywmcegi http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"116.116.109.213\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("196", "66", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("197", "66", "akismet_history", "a:2:{s:4:\"time\";d:1516067483.73272991180419921875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("198", "66", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"cvtyndmkv\";s:20:\"comment_author_email\";s:19:\"ovhelvk@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/]ucvtyndmkv[/url]\r\ncvtyndmkv http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/\r\n<a href=\"http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/\">acvtyndmkv</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"58.58.178.104\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("199", "67", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("200", "67", "akismet_history", "a:2:{s:4:\"time\";d:1516067508.9897849559783935546875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("201", "67", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"dsfomncfh\";s:20:\"comment_author_email\";s:19:\"dzbnktb@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/\">adsfomncfh</a>\r\ndsfomncfh http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/\r\n[url=http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/]udsfomncfh[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"59.39.183.102\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("202", "68", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("203", "68", "akismet_history", "a:2:{s:4:\"time\";d:1516067533.828012943267822265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("204", "68", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"binbpknfds\";s:20:\"comment_author_email\";s:19:\"bqytnhq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nbinbpknfds http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/\r\n[url=http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/]ubinbpknfds[/url]\r\n<a href=\"http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/\">abinbpknfds</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"183.82.123.244\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("205", "69", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("206", "69", "akismet_history", "a:2:{s:4:\"time\";d:1516067534.8988330364227294921875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("207", "69", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"nypdymvqx\";s:20:\"comment_author_email\";s:19:\"extugvj@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nnypdymvqx http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/\r\n<a href=\"http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/\">anypdymvqx</a>\r\n[url=http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/]unypdymvqx[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"118.254.207.190\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("208", "70", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("209", "70", "akismet_history", "a:2:{s:4:\"time\";d:1516067548.502420902252197265625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("210", "70", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"idqxbldxx\";s:20:\"comment_author_email\";s:19:\"ismhbpq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/]uidqxbldxx[/url]\r\n<a href=\"http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/\">aidqxbldxx</a>\r\nidqxbldxx http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"175.8.207.111\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("211", "71", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("212", "71", "akismet_history", "a:2:{s:4:\"time\";d:1516067558.5751059055328369140625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("213", "71", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:9:\"cqzlkyqel\";s:20:\"comment_author_email\";s:19:\"seqddlw@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/\";s:15:\"comment_content\";s:278:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/\">acqzlkyqel</a>\r\ncqzlkyqel http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/\r\n[url=http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/]ucqzlkyqel[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"222.244.72.38\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("214", "72", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("215", "72", "akismet_history", "a:2:{s:4:\"time\";d:1516067560.9142620563507080078125;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("216", "72", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"ybpxnveljo\";s:20:\"comment_author_email\";s:19:\"epxhjjq@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/]uybpxnveljo[/url]\r\nybpxnveljo http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/\r\n<a href=\"http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/\">aybpxnveljo</a>\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:14:\"125.211.72.125\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("217", "73", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("218", "73", "akismet_history", "a:2:{s:4:\"time\";d:1516067583.2594621181488037109375;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("219", "73", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"lxdsxgmqbe\";s:20:\"comment_author_email\";s:19:\"lkezlej@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/]ulxdsxgmqbe[/url]\r\n<a href=\"http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/\">alxdsxgmqbe</a>\r\nlxdsxgmqbe http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"113.116.88.60\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("220", "74", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("221", "74", "akismet_history", "a:2:{s:4:\"time\";d:1516067657.6284770965576171875;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("222", "74", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"esoqfejowt\";s:20:\"comment_author_email\";s:19:\"sxhmnxi@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nesoqfejowt http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/\r\n<a href=\"http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/\">aesoqfejowt</a>\r\n[url=http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/]uesoqfejowt[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:13:\"180.105.88.32\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");
INSERT INTO `wpbd_commentmeta` VALUES("223", "75", "akismet_result", "true");
INSERT INTO `wpbd_commentmeta` VALUES("224", "75", "akismet_history", "a:2:{s:4:\"time\";d:1516067855.9114611148834228515625;s:5:\"event\";s:10:\"check-spam\";}");
INSERT INTO `wpbd_commentmeta` VALUES("225", "75", "akismet_as_submitted", "a:11:{s:14:\"comment_author\";s:10:\"vfegxrbsxs\";s:20:\"comment_author_email\";s:19:\"peltdnj@outlook.com\";s:18:\"comment_author_url\";s:49:\"http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/\";s:15:\"comment_content\";s:281:\"5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/\">avfegxrbsxs</a>\r\nvfegxrbsxs http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/\r\n[url=http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/]uvfegxrbsxs[/url]\";s:12:\"comment_type\";s:0:\"\";s:7:\"user_ip\";s:15:\"119.144.125.136\";s:10:\"user_agent\";s:50:\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\";s:4:\"blog\";s:25:\"http://gregsonstudios.com\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:72:\"http://gregsonstudios.com/5-things-every-internet-marketing-millionaire/\";}");

/* INSERT TABLE DATA: wpbd_comments */
INSERT INTO `wpbd_comments` VALUES("2", "32015", "gqzoitxhid", "jzrrqlz@outlook.com", "http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/", "121.57.150.126", "2018-01-14 04:41:34", "2018-01-14 04:41:34", "Why You Should Be Using Video Marketing - Gregson Studios\r\ngqzoitxhid http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/\r\n[url=http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/]ugqzoitxhid[/url]\r\n<a href=\"http://www.gghx9ir4667mqh9j1oj339nd1515j3d5s.org/\" rel=\"nofollow\">agqzoitxhid</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("3", "32015", "nyxfhgkrz", "mufqpcy@outlook.com", "http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/", "112.28.106.231", "2018-01-14 04:43:18", "2018-01-14 04:43:18", "Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/\" rel=\"nofollow\">anyxfhgkrz</a>\r\nnyxfhgkrz http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/\r\n[url=http://www.gm7y2106p30q8n59037jty85ia5bnskas.org/]unyxfhgkrz[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("4", "32015", "lgegobxtib", "waareid@outlook.com", "http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/", "113.3.247.140", "2018-01-14 04:44:58", "2018-01-14 04:44:58", "Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/\" rel=\"nofollow\">algegobxtib</a>\r\n[url=http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/]ulgegobxtib[/url]\r\nlgegobxtib http://www.g396u8tn7misab8p43467w52ii4r8d4ms.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("5", "32015", "nzvxvlqpwq", "utnsvpn@outlook.com", "http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/", "60.170.190.26", "2018-01-14 04:45:30", "2018-01-14 04:45:30", "Why You Should Be Using Video Marketing - Gregson Studios\r\n[url=http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/]unzvxvlqpwq[/url]\r\n<a href=\"http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/\" rel=\"nofollow\">anzvxvlqpwq</a>\r\nnzvxvlqpwq http://www.gzb0z3a0yb1x477w9yz77386wim5t2f5s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("6", "32015", "cjywjvnpeb", "vxstqvx@outlook.com", "http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/", "110.166.197.186", "2018-01-14 04:46:16", "2018-01-14 04:46:16", "Why You Should Be Using Video Marketing - Gregson Studios\r\n<a href=\"http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/\" rel=\"nofollow\">acjywjvnpeb</a>\r\n[url=http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/]ucjywjvnpeb[/url]\r\ncjywjvnpeb http://www.gf2uen47l2i9mza028rwl8i3o865k825s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("7", "32015", "jvvtkf", "uzbmxpw@outlook.com", "http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/", "119.86.174.45", "2018-01-14 04:47:01", "2018-01-14 04:47:01", "Why You Should Be Using Video Marketing - Gregson Studios\r\njvvtkf http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/\r\n<a href=\"http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/\" rel=\"nofollow\">ajvvtkf</a>\r\n[url=http://www.g0x3fn2rq63u249q3et3w3yqm79vh610s.org/]ujvvtkf[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("8", "32015", "cdqzdpddj", "jrtltdo@outlook.com", "http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/", "116.54.70.125", "2018-01-14 04:50:08", "2018-01-14 04:50:08", "Why You Should Be Using Video Marketing - Gregson Studios\r\ncdqzdpddj http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/\r\n<a href=\"http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/\" rel=\"nofollow\">acdqzdpddj</a>\r\n[url=http://www.g7xd8018f6n20656wxl5b27shm6r5okcs.org/]ucdqzdpddj[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("9", "32015", "oeiıtlzpzt", "gdgudqg@outlook.com", "http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/", "85.105.155.216", "2018-01-14 04:51:44", "2018-01-14 04:51:44", "Why You Should Be Using Video Marketing - Gregson Studios\r\noeiıtlzpzt http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/\r\n<a href=\"http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/\" rel=\"nofollow\">aoeiıtlzpzt</a>\r\n[url=http://www.gv58z062j46n2xvpwdh04k76kq6361fds.org/]uoeiıtlzpzt[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("10", "32015", "iywtehigzm", "elyuepi@outlook.com", "http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/", "116.24.66.200", "2018-01-14 04:53:47", "2018-01-14 04:53:47", "Why You Should Be Using Video Marketing - Gregson Studios\r\n[url=http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/]uiywtehigzm[/url]\r\n<a href=\"http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/\" rel=\"nofollow\">aiywtehigzm</a>\r\niywtehigzm http://www.g4eu9712b16e93jo34dm8g9h8pxml7c4s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("11", "32051", "yqwrwwmzrh", "rgrlzwe@outlook.com", "http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/", "123.145.74.34", "2018-01-14 07:31:59", "2018-01-14 07:31:59", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/]uyqwrwwmzrh[/url]\r\n<a href=\"http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/\" rel=\"nofollow\">ayqwrwwmzrh</a>\r\nyqwrwwmzrh http://www.g72ja269xq0x9m9x8p51pd734vrrv3e4s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("12", "32051", "yridjfhee", "kfkcilm@outlook.com", "http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/", "183.214.95.186", "2018-01-14 07:36:17", "2018-01-14 07:36:17", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nyridjfhee http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/\r\n[url=http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/]uyridjfhee[/url]\r\n<a href=\"http://www.gf520i3p46uto6wp1y7dar3650r5i24qs.org/\" rel=\"nofollow\">ayridjfhee</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("13", "32051", "ivtdrdzv", "qfnjdhe@outlook.com", "http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/", "113.224.70.113", "2018-01-14 07:36:18", "2018-01-14 07:36:18", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/\" rel=\"nofollow\">aivtdrdzv</a>\r\n[url=http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/]uivtdrdzv[/url]\r\nivtdrdzv http://www.g1143z6i7gubh1355m2zo0pzy28r17oks.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("14", "32051", "fknxogwwqf", "czokcva@outlook.com", "http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/", "114.244.144.59", "2018-01-14 07:36:41", "2018-01-14 07:36:41", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nfknxogwwqf http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/\r\n[url=http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/]ufknxogwwqf[/url]\r\n<a href=\"http://www.gb32yex44d65i8738u78vj3ez40juok8s.org/\" rel=\"nofollow\">afknxogwwqf</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("15", "32051", "eismqkkvrh", "yivlmgq@outlook.com", "http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/", "58.40.206.67", "2018-01-14 07:36:58", "2018-01-14 07:36:58", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/]ueismqkkvrh[/url]\r\neismqkkvrh http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/\r\n<a href=\"http://www.g6z803q9n2ke291txfqn1h1940m4dcm9s.org/\" rel=\"nofollow\">aeismqkkvrh</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("16", "32051", "bvnmsnlg", "wjcobid@outlook.com", "http://www.g4b79w928ela4mipnxww655040b5i86ls.org/", "119.182.24.205", "2018-01-14 07:37:27", "2018-01-14 07:37:27", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g4b79w928ela4mipnxww655040b5i86ls.org/]ubvnmsnlg[/url]\r\n<a href=\"http://www.g4b79w928ela4mipnxww655040b5i86ls.org/\" rel=\"nofollow\">abvnmsnlg</a>\r\nbvnmsnlg http://www.g4b79w928ela4mipnxww655040b5i86ls.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("17", "32051", "wfpdfkih", "jhocwty@outlook.com", "http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/", "114.93.181.165", "2018-01-14 07:37:47", "2018-01-14 07:37:47", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/\" rel=\"nofollow\">awfpdfkih</a>\r\n[url=http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/]uwfpdfkih[/url]\r\nwfpdfkih http://www.gcz7cnz2pd373202403ucgr1es73j9v2s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("18", "32051", "dehhrwlz", "ktqfrqk@outlook.com", "http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/", "114.219.117.252", "2018-01-14 07:37:51", "2018-01-14 07:37:51", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/]udehhrwlz[/url]\r\ndehhrwlz http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/\r\n<a href=\"http://www.gyjxqd1w25d8ay59027j8l0v654u1c5as.org/\" rel=\"nofollow\">adehhrwlz</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("19", "32051", "nssrovrwyq", "iifxhxg@outlook.com", "http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/", "119.108.160.35", "2018-01-14 07:37:57", "2018-01-14 07:37:57", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nnssrovrwyq http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/\r\n[url=http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/]unssrovrwyq[/url]\r\n<a href=\"http://www.g27z61sackn12333z9my9ck2k83v3kd7s.org/\" rel=\"nofollow\">anssrovrwyq</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("20", "32051", "mfggzxijx", "fztqndo@outlook.com", "http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/", "202.110.156.144", "2018-01-14 07:38:04", "2018-01-14 07:38:04", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nmfggzxijx http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/\r\n<a href=\"http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/\" rel=\"nofollow\">amfggzxijx</a>\r\n[url=http://www.g59yo4bv3gpy5z6786ad309rm0o55ac3s.org/]umfggzxijx[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("21", "32051", "nzloipykjx", "pbjqdmm@outlook.com", "http://www.g4tbta7939mxarc5j645hk425el5t861s.org/", "125.95.96.46", "2018-01-14 07:38:10", "2018-01-14 07:38:10", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g4tbta7939mxarc5j645hk425el5t861s.org/]unzloipykjx[/url]\r\nnzloipykjx http://www.g4tbta7939mxarc5j645hk425el5t861s.org/\r\n<a href=\"http://www.g4tbta7939mxarc5j645hk425el5t861s.org/\" rel=\"nofollow\">anzloipykjx</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("22", "32051", "ofekbsztr", "tbujdzd@outlook.com", "http://www.gkiayas15rj260m406z4594lg522lu2ws.org/", "117.84.155.106", "2018-01-14 07:38:18", "2018-01-14 07:38:18", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.gkiayas15rj260m406z4594lg522lu2ws.org/\" rel=\"nofollow\">aofekbsztr</a>\r\nofekbsztr http://www.gkiayas15rj260m406z4594lg522lu2ws.org/\r\n[url=http://www.gkiayas15rj260m406z4594lg522lu2ws.org/]uofekbsztr[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("23", "32051", "dpnpdyclgh", "nurdqtr@outlook.com", "http://www.g45960re36cm0efg175k3ww08dtx58yls.org/", "117.157.64.21", "2018-01-14 07:38:21", "2018-01-14 07:38:21", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g45960re36cm0efg175k3ww08dtx58yls.org/\" rel=\"nofollow\">adpnpdyclgh</a>\r\n[url=http://www.g45960re36cm0efg175k3ww08dtx58yls.org/]udpnpdyclgh[/url]\r\ndpnpdyclgh http://www.g45960re36cm0efg175k3ww08dtx58yls.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("24", "32051", "jwsncymmyq", "lbkmbpf@outlook.com", "http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/", "116.231.39.13", "2018-01-14 07:39:19", "2018-01-14 07:39:19", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/]ujwsncymmyq[/url]\r\njwsncymmyq http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/\r\n<a href=\"http://www.g5j8ss1p6o4820fqxd1nu4j3yv98812es.org/\" rel=\"nofollow\">ajwsncymmyq</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("25", "32051", "jqilmemsjd", "futseoq@outlook.com", "http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/", "218.77.80.131", "2018-01-14 07:39:27", "2018-01-14 07:39:27", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/\" rel=\"nofollow\">ajqilmemsjd</a>\r\n[url=http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/]ujqilmemsjd[/url]\r\njqilmemsjd http://www.ga1kv60x8d5l4o67f6qn3iwp8q975b58s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("26", "32051", "rzrqfgzvrq", "lgajbvx@outlook.com", "http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/", "49.71.212.163", "2018-01-14 07:39:34", "2018-01-14 07:39:34", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\nrzrqfgzvrq http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/\r\n<a href=\"http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/\" rel=\"nofollow\">arzrqfgzvrq</a>\r\n[url=http://www.gfj3vahyl3s1849950a9925a0olf3k8zs.org/]urzrqfgzvrq[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("27", "32051", "jehprzliec", "nmhoenp@outlook.com", "http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/", "116.228.200.206", "2018-01-14 07:41:07", "2018-01-14 07:41:07", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n[url=http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/]ujehprzliec[/url]\r\njehprzliec http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/\r\n<a href=\"http://www.g771es46e3j4d3kzgf32y57u6y5eah43s.org/\" rel=\"nofollow\">ajehprzliec</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("28", "32051", "vrsbzhrm", "bbhflfv@outlook.com", "http://www.g55izjsg510nomahf00381j6s4f871y0s.org/", "114.225.114.52", "2018-01-14 07:41:56", "2018-01-14 07:41:56", "Top 5 Reasons to Use Social Media in Your Business - Gregson Studios\r\n<a href=\"http://www.g55izjsg510nomahf00381j6s4f871y0s.org/\" rel=\"nofollow\">avrsbzhrm</a>\r\n[url=http://www.g55izjsg510nomahf00381j6s4f871y0s.org/]uvrsbzhrm[/url]\r\nvrsbzhrm http://www.g55izjsg510nomahf00381j6s4f871y0s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("29", "32066", "itjwnilkxo", "mbueivf@outlook.com", "http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/", "113.13.186.15", "2018-01-14 08:57:55", "2018-01-14 08:57:55", "Public Speaking Series - Part 1 - Gregson Studios\r\nitjwnilkxo http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/\r\n[url=http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/]uitjwnilkxo[/url]\r\n<a href=\"http://www.g2bvt810w6eui285w7bb7a8j07c3q25gs.org/\" rel=\"nofollow\">aitjwnilkxo</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("30", "32066", "enxzojtdw", "vebqufn@outlook.com", "http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/", "119.100.209.167", "2018-01-14 09:02:22", "2018-01-14 09:02:22", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/]uenxzojtdw[/url]\r\n<a href=\"http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/\" rel=\"nofollow\">aenxzojtdw</a>\r\nenxzojtdw http://www.gb04584ud1280ea5aq20sd26c9ec5vjas.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("31", "32066", "tgsibkmzjw", "tpjbbjz@outlook.com", "http://www.gd80l9942ztiz834geak39oiv35893hls.org/", "123.232.154.79", "2018-01-14 09:02:43", "2018-01-14 09:02:43", "Public Speaking Series - Part 1 - Gregson Studios\r\ntgsibkmzjw http://www.gd80l9942ztiz834geak39oiv35893hls.org/\r\n[url=http://www.gd80l9942ztiz834geak39oiv35893hls.org/]utgsibkmzjw[/url]\r\n<a href=\"http://www.gd80l9942ztiz834geak39oiv35893hls.org/\" rel=\"nofollow\">atgsibkmzjw</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("32", "32066", "mfzdrifqm", "kyuqrtq@outlook.com", "http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/", "58.221.121.90", "2018-01-14 09:02:49", "2018-01-14 09:02:49", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/]umfzdrifqm[/url]\r\nmfzdrifqm http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/\r\n<a href=\"http://www.gg8bz2847c4oi87ch64ok1ss318f2vx4s.org/\" rel=\"nofollow\">amfzdrifqm</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("33", "32066", "qzsbvbty", "oyombmg@outlook.com", "http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/", "111.40.116.175", "2018-01-14 09:03:17", "2018-01-14 09:03:17", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/]uqzsbvbty[/url]\r\nqzsbvbty http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/\r\n<a href=\"http://www.gbsqz18o9057fw4lv0v2u13yjl210p83s.org/\" rel=\"nofollow\">aqzsbvbty</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("34", "32066", "liityrpycy", "bmymegi@outlook.com", "http://www.gwb6k68scu091tdks460632m134tlv5ds.org/", "115.212.59.99", "2018-01-14 09:03:30", "2018-01-14 09:03:30", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gwb6k68scu091tdks460632m134tlv5ds.org/\" rel=\"nofollow\">aliityrpycy</a>\r\nliityrpycy http://www.gwb6k68scu091tdks460632m134tlv5ds.org/\r\n[url=http://www.gwb6k68scu091tdks460632m134tlv5ds.org/]uliityrpycy[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("35", "32066", "rzosrnkfi", "icdoyen@outlook.com", "http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/", "222.32.87.89", "2018-01-14 09:03:41", "2018-01-14 09:03:41", "Public Speaking Series - Part 1 - Gregson Studios\r\nrzosrnkfi http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/\r\n[url=http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/]urzosrnkfi[/url]\r\n<a href=\"http://www.gr9p178go56y5uhg24o3h1f3yy1532dss.org/\" rel=\"nofollow\">arzosrnkfi</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("36", "32066", "zhkqbmt", "dnkqvjj@outlook.com", "http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/", "220.172.48.217", "2018-01-14 09:03:48", "2018-01-14 09:03:48", "Public Speaking Series - Part 1 - Gregson Studios\r\nzhkqbmt http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/\r\n<a href=\"http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/\" rel=\"nofollow\">azhkqbmt</a>\r\n[url=http://www.g1a6322e8lgxji1qwr7i3c5981ze08e6s.org/]uzhkqbmt[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("37", "32066", "sxqrmcbizw", "ztsqedg@outlook.com", "http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/", "120.37.233.108", "2018-01-14 09:03:49", "2018-01-14 09:03:49", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/\" rel=\"nofollow\">asxqrmcbizw</a>\r\nsxqrmcbizw http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/\r\n[url=http://www.gg560j6k6vr2zf00l765c9pauk578r9xs.org/]usxqrmcbizw[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("38", "32066", "kkfjkthmpc", "ccxfnqn@outlook.com", "http://www.g988384a4tgtl87dar08n72k2iy11yths.org/", "125.95.96.46", "2018-01-14 09:04:08", "2018-01-14 09:04:08", "Public Speaking Series - Part 1 - Gregson Studios\r\nkkfjkthmpc http://www.g988384a4tgtl87dar08n72k2iy11yths.org/\r\n[url=http://www.g988384a4tgtl87dar08n72k2iy11yths.org/]ukkfjkthmpc[/url]\r\n<a href=\"http://www.g988384a4tgtl87dar08n72k2iy11yths.org/\" rel=\"nofollow\">akkfjkthmpc</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("39", "32066", "ltjrcgvdks", "thhgozh@outlook.com", "http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/", "42.224.79.39", "2018-01-14 09:04:16", "2018-01-14 09:04:16", "Public Speaking Series - Part 1 - Gregson Studios\r\nltjrcgvdks http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/\r\n[url=http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/]ultjrcgvdks[/url]\r\n<a href=\"http://www.gyjktam55082c0ea69a9gp01q19d25w7s.org/\" rel=\"nofollow\">altjrcgvdks</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("40", "32066", "kccopkhrmx", "bnondwa@outlook.com", "http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/", "218.6.244.67", "2018-01-14 09:04:17", "2018-01-14 09:04:17", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/\" rel=\"nofollow\">akccopkhrmx</a>\r\nkccopkhrmx http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/\r\n[url=http://www.g8bs682ls762aa7qm2216xqin0gn38m5s.org/]ukccopkhrmx[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("41", "32066", "htilfbzvod", "bxtmpye@outlook.com", "http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/", "110.166.197.216", "2018-01-14 09:04:27", "2018-01-14 09:04:27", "Public Speaking Series - Part 1 - Gregson Studios\r\nhtilfbzvod http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/\r\n[url=http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/]uhtilfbzvod[/url]\r\n<a href=\"http://www.gsj1x6t930oqfgh5a65520si3ux171m7s.org/\" rel=\"nofollow\">ahtilfbzvod</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("42", "32066", "rgocckrik", "anofyoh@outlook.com", "http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/", "221.234.223.190", "2018-01-14 09:04:35", "2018-01-14 09:04:35", "Public Speaking Series - Part 1 - Gregson Studios\r\nrgocckrik http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/\r\n[url=http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/]urgocckrik[/url]\r\n<a href=\"http://www.glx9t9zsl93gi0e2z5d21fct3343d118s.org/\" rel=\"nofollow\">argocckrik</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("43", "32066", "bnvxkqpkj", "wirciav@outlook.com", "http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/", "111.123.108.65", "2018-01-14 09:04:35", "2018-01-14 09:04:35", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/]ubnvxkqpkj[/url]\r\nbnvxkqpkj http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/\r\n<a href=\"http://www.g2p603v5g452n52j95ojte41p1cijc3xs.org/\" rel=\"nofollow\">abnvxkqpkj</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("44", "32066", "rzjkermtvq", "suurhzu@outlook.com", "http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/", "113.138.228.146", "2018-01-14 09:04:38", "2018-01-14 09:04:38", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/]urzjkermtvq[/url]\r\n<a href=\"http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/\" rel=\"nofollow\">arzjkermtvq</a>\r\nrzjkermtvq http://www.gwu1a29d774gmi4u9z27jr8u5s0313nss.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("45", "32066", "snocohiekf", "kubiffj@outlook.com", "http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/", "175.13.191.54", "2018-01-14 09:05:00", "2018-01-14 09:05:00", "Public Speaking Series - Part 1 - Gregson Studios\r\nsnocohiekf http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/\r\n[url=http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/]usnocohiekf[/url]\r\n<a href=\"http://www.gu42uvk5k1pysl126230mb53u412m0zqs.org/\" rel=\"nofollow\">asnocohiekf</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("46", "32066", "yxydstgx", "wvdggyb@outlook.com", "http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/", "183.158.16.116", "2018-01-14 09:05:54", "2018-01-14 09:05:54", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/\" rel=\"nofollow\">ayxydstgx</a>\r\nyxydstgx http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/\r\n[url=http://www.gd1ea0514007qyb4k8isb2x9fs04nn03s.org/]uyxydstgx[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("47", "32066", "psnkjipcfe", "vcucsdf@outlook.com", "http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/", "58.52.223.97", "2018-01-14 09:06:29", "2018-01-14 09:06:29", "Public Speaking Series - Part 1 - Gregson Studios\r\npsnkjipcfe http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/\r\n<a href=\"http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/\" rel=\"nofollow\">apsnkjipcfe</a>\r\n[url=http://www.g32n2e44zq3zdan660bs819a0t0v0xy6s.org/]upsnkjipcfe[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("48", "32066", "okhpdwg", "vdcyqfd@outlook.com", "http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/", "1.180.158.238", "2018-01-14 09:07:53", "2018-01-14 09:07:53", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/]uokhpdwg[/url]\r\n<a href=\"http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/\" rel=\"nofollow\">aokhpdwg</a>\r\nokhpdwg http://www.gfg3p2g3t7q91w8bv214i537s1sgt73ts.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("49", "32066", "rvsmcgtnqe", "mauiymw@outlook.com", "http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/", "180.127.239.108", "2018-01-14 09:09:42", "2018-01-14 09:09:42", "Public Speaking Series - Part 1 - Gregson Studios\r\n[url=http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/]urvsmcgtnqe[/url]\r\nrvsmcgtnqe http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/\r\n<a href=\"http://www.g8sj27a70r91b1se3n7527k5x9tiqoi4s.org/\" rel=\"nofollow\">arvsmcgtnqe</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("50", "32066", "wzfbmww", "ayxjjhn@outlook.com", "http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/", "218.77.80.131", "2018-01-14 09:10:09", "2018-01-14 09:10:09", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/\" rel=\"nofollow\">awzfbmww</a>\r\nwzfbmww http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/\r\n[url=http://www.g03vsb1k29qu35295mscc3635ftpn1c6s.org/]uwzfbmww[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("51", "32066", "rtpryshsfl", "kbbnlfj@outlook.com", "http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/", "118.40.228.157", "2018-01-14 09:11:57", "2018-01-14 09:11:57", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/\" rel=\"nofollow\">artpryshsfl</a>\r\nrtpryshsfl http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/\r\n[url=http://www.gbgy5fr1v798g579iu70pr8632p4c5dns.org/]urtpryshsfl[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("52", "32066", "xgvgibeei", "losijio@outlook.com", "http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/", "114.222.186.174", "2018-01-14 09:33:18", "2018-01-14 09:33:18", "Public Speaking Series - Part 1 - Gregson Studios\r\n<a href=\"http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/\" rel=\"nofollow\">axgvgibeei</a>\r\nxgvgibeei http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/\r\n[url=http://www.g605rpq4g13ilu6d26xslxc8u067j346s.org/]uxgvgibeei[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("53", "32070", "nrhbftvqjt", "gcwsnxy@outlook.com", "http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/", "123.114.206.206", "2018-01-16 01:44:47", "2018-01-16 01:44:47", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nnrhbftvqjt http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/\r\n<a href=\"http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/\" rel=\"nofollow\">anrhbftvqjt</a>\r\n[url=http://www.gpeisl1p4771e22tt86921j9as10rn9cs.org/]unrhbftvqjt[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("54", "32070", "ionribhlt", "vywkrtp@outlook.com", "http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/", "113.206.93.214", "2018-01-16 01:45:22", "2018-01-16 01:45:22", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/]uionribhlt[/url]\r\n<a href=\"http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/\" rel=\"nofollow\">aionribhlt</a>\r\nionribhlt http://www.gr3gj11cakfb773ho9009599fkg63d3bs.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("55", "32070", "cnlyzvgzq", "hwvzijk@outlook.com", "http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/", "117.25.215.12", "2018-01-16 01:45:25", "2018-01-16 01:45:25", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/]ucnlyzvgzq[/url]\r\n<a href=\"http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/\" rel=\"nofollow\">acnlyzvgzq</a>\r\ncnlyzvgzq http://www.gew05h6749u41mx24tjkq534u7je7r9gs.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("56", "32070", "njnqqsleq", "ktsdgek@outlook.com", "http://www.g99854saff3i87fe30nhmrqqm948q248s.org/", "222.80.153.132", "2018-01-16 01:45:34", "2018-01-16 01:45:34", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g99854saff3i87fe30nhmrqqm948q248s.org/]unjnqqsleq[/url]\r\nnjnqqsleq http://www.g99854saff3i87fe30nhmrqqm948q248s.org/\r\n<a href=\"http://www.g99854saff3i87fe30nhmrqqm948q248s.org/\" rel=\"nofollow\">anjnqqsleq</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("57", "32070", "eidimbyo", "thjjarc@outlook.com", "http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/", "124.42.239.117", "2018-01-16 01:45:40", "2018-01-16 01:45:40", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\neidimbyo http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/\r\n<a href=\"http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/\" rel=\"nofollow\">aeidimbyo</a>\r\n[url=http://www.g384x899x8gf6r8p8cius8729xtz0hg6s.org/]ueidimbyo[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("58", "32070", "txxmzjflm", "soxyydo@outlook.com", "http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/", "222.216.130.111", "2018-01-16 01:45:48", "2018-01-16 01:45:48", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/\" rel=\"nofollow\">atxxmzjflm</a>\r\ntxxmzjflm http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/\r\n[url=http://www.g2x0cu6el68xrb65n131521n7uzddi48s.org/]utxxmzjflm[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("59", "32070", "hswjjmxd", "chwollo@outlook.com", "http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/", "58.63.64.100", "2018-01-16 01:47:23", "2018-01-16 01:47:23", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nhswjjmxd http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/\r\n<a href=\"http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/\" rel=\"nofollow\">ahswjjmxd</a>\r\n[url=http://www.g53xa08pu8nm12yksh42h9u08kl2647ys.org/]uhswjjmxd[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("60", "32070", "kiqccsqhym", "eiracay@outlook.com", "http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/", "124.193.178.222", "2018-01-16 01:47:28", "2018-01-16 01:47:28", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nkiqccsqhym http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/\r\n<a href=\"http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/\" rel=\"nofollow\">akiqccsqhym</a>\r\n[url=http://www.g0yecx272684m58h09ju04jak1hg4oj2s.org/]ukiqccsqhym[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("61", "32070", "lztbrioqr", "ljtkvah@outlook.com", "http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/", "116.224.88.132", "2018-01-16 01:48:39", "2018-01-16 01:48:39", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/]ulztbrioqr[/url]\r\n<a href=\"http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/\" rel=\"nofollow\">alztbrioqr</a>\r\nlztbrioqr http://www.gc79q046q3st41uq6lm687omzq5d7j35s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("62", "32070", "ovztxqmhic", "enhbfrt@outlook.com", "http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/", "113.108.192.2", "2018-01-16 01:48:50", "2018-01-16 01:48:50", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/]uovztxqmhic[/url]\r\novztxqmhic http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/\r\n<a href=\"http://www.gsz8184k653zrgn34fnj12kcd3o801b2s.org/\" rel=\"nofollow\">aovztxqmhic</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("63", "32070", "tlgtfemblx", "denkfml@outlook.com", "http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/", "106.92.20.201", "2018-01-16 01:49:15", "2018-01-16 01:49:15", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/]utlgtfemblx[/url]\r\n<a href=\"http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/\" rel=\"nofollow\">atlgtfemblx</a>\r\ntlgtfemblx http://www.gfc29i49c22q2r4ndakx7989s38qlf41s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("64", "32070", "lwciootmb", "gbcweqn@outlook.com", "http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/", "1.192.240.8", "2018-01-16 01:49:36", "2018-01-16 01:49:36", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/]ulwciootmb[/url]\r\n<a href=\"http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/\" rel=\"nofollow\">alwciootmb</a>\r\nlwciootmb http://www.g58zer03tnc2c1g4z63z5u083q7yf0k4s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("65", "32070", "btywmcegi", "tbmujti@outlook.com", "http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/", "116.116.109.213", "2018-01-16 01:49:54", "2018-01-16 01:49:54", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/\" rel=\"nofollow\">abtywmcegi</a>\r\n[url=http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/]ubtywmcegi[/url]\r\nbtywmcegi http://www.g4z84x2h2km6690736p2xx2upmjgxo93s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("66", "32070", "cvtyndmkv", "ovhelvk@outlook.com", "http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/", "58.58.178.104", "2018-01-16 01:51:23", "2018-01-16 01:51:23", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/]ucvtyndmkv[/url]\r\ncvtyndmkv http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/\r\n<a href=\"http://www.gsq5d96rd760a9j80dj0c87mgb9q57u5s.org/\" rel=\"nofollow\">acvtyndmkv</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("67", "32070", "dsfomncfh", "dzbnktb@outlook.com", "http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/", "59.39.183.102", "2018-01-16 01:51:48", "2018-01-16 01:51:48", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/\" rel=\"nofollow\">adsfomncfh</a>\r\ndsfomncfh http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/\r\n[url=http://www.gcq5t653525l85nvf0dh19tt13gi86xvs.org/]udsfomncfh[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("68", "32070", "binbpknfds", "bqytnhq@outlook.com", "http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/", "183.82.123.244", "2018-01-16 01:52:13", "2018-01-16 01:52:13", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nbinbpknfds http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/\r\n[url=http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/]ubinbpknfds[/url]\r\n<a href=\"http://www.g6ps016bu8xf34v9k8lq3m73ha863n9ss.org/\" rel=\"nofollow\">abinbpknfds</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("69", "32070", "nypdymvqx", "extugvj@outlook.com", "http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/", "118.254.207.190", "2018-01-16 01:52:14", "2018-01-16 01:52:14", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nnypdymvqx http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/\r\n<a href=\"http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/\" rel=\"nofollow\">anypdymvqx</a>\r\n[url=http://www.g740tw9x51zn6o3i59epo1k4dbz4s554s.org/]unypdymvqx[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("70", "32070", "idqxbldxx", "ismhbpq@outlook.com", "http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/", "175.8.207.111", "2018-01-16 01:52:27", "2018-01-16 01:52:27", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/]uidqxbldxx[/url]\r\n<a href=\"http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/\" rel=\"nofollow\">aidqxbldxx</a>\r\nidqxbldxx http://www.g694bd0tt37mgl194ig2055mpr76poy7s.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("71", "32070", "cqzlkyqel", "seqddlw@outlook.com", "http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/", "222.244.72.38", "2018-01-16 01:52:37", "2018-01-16 01:52:37", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/\" rel=\"nofollow\">acqzlkyqel</a>\r\ncqzlkyqel http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/\r\n[url=http://www.gg3d4bb1fp88390820l8ytgr6k0q2cd1s.org/]ucqzlkyqel[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("72", "32070", "ybpxnveljo", "epxhjjq@outlook.com", "http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/", "125.211.72.125", "2018-01-16 01:52:40", "2018-01-16 01:52:40", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/]uybpxnveljo[/url]\r\nybpxnveljo http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/\r\n<a href=\"http://www.gtz7bdo5op11iz6706k0x45sd74e286bs.org/\" rel=\"nofollow\">aybpxnveljo</a>", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("73", "32070", "lxdsxgmqbe", "lkezlej@outlook.com", "http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/", "113.116.88.60", "2018-01-16 01:53:02", "2018-01-16 01:53:02", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n[url=http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/]ulxdsxgmqbe[/url]\r\n<a href=\"http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/\" rel=\"nofollow\">alxdsxgmqbe</a>\r\nlxdsxgmqbe http://www.gbc1z1wbh19p70393sl9951eb97vm9qcs.org/", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("74", "32070", "esoqfejowt", "sxhmnxi@outlook.com", "http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/", "180.105.88.32", "2018-01-16 01:54:17", "2018-01-16 01:54:17", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\nesoqfejowt http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/\r\n<a href=\"http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/\" rel=\"nofollow\">aesoqfejowt</a>\r\n[url=http://www.g016i15t0f2if4jafsm0989o5ro0u4s5s.org/]uesoqfejowt[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");
INSERT INTO `wpbd_comments` VALUES("75", "32070", "vfegxrbsxs", "peltdnj@outlook.com", "http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/", "119.144.125.136", "2018-01-16 01:57:35", "2018-01-16 01:57:35", "5 Things Every Internet Marketing Millionaire Does - Gregson Studios\r\n<a href=\"http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/\" rel=\"nofollow\">avfegxrbsxs</a>\r\nvfegxrbsxs http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/\r\n[url=http://www.g99iyd03d2t20e8z22x0t2p1qre53k7es.org/]uvfegxrbsxs[/url]", "0", "spam", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", "", "0", "0");

/* INSERT TABLE DATA: wpbd_duplicator_packages */
INSERT INTO `wpbd_duplicator_packages` VALUES("1", "20170803_gregsonstudios", "3d519cc9cad46d7b7291170803172319", "100", "2017-08-03 17:23:43", "BuddyJames", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-03 17:23:19\";s:7:\"Version\";s:6:\"1.2.16\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"7.0.21\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:23:\"20170803_gregsonstudios\";s:4:\"Hash\";s:32:\"3d519cc9cad46d7b7291170803172319\";s:8:\"NameHash\";s:56:\"20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_scan.json\";s:7:\"Runtime\";s:11:\"131.96 sec.\";s:7:\"ExeSize\";s:7:\"431.9KB\";s:7:\"ZipSize\";s:8:\"117.71MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"BuddyJames\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:123429008;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_installer.php\";s:4:\"Size\";i:442266;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7089846;s:4:\"File\";s:69:\"20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/gregso5/public_html/wp-snapshots/tmp/20170803_gregsonstudios_3d519cc9cad46d7b7291170803172319_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("2", "20170803_gregsonstudios", "795489ec5fa76dfe6876170823055231", "100", "2017-08-23 05:52:45", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-23 05:52:31\";s:7:\"Version\";s:6:\"1.2.18\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"7.0.21\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:23:\"20170803_gregsonstudios\";s:4:\"Hash\";s:32:\"795489ec5fa76dfe6876170823055231\";s:8:\"NameHash\";s:56:\"20170803_gregsonstudios_795489ec5fa76dfe6876170823055231\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_scan.json\";s:7:\"Runtime\";s:11:\"143.63 sec.\";s:7:\"ExeSize\";s:8:\"430.98KB\";s:7:\"ZipSize\";s:5:\"123MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:43:\"/home/gregso5/public_html/wp-content/cache;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"zip;rar;tar;gz;bz2;7z;avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:128970135;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_installer.php\";s:4:\"Size\";i:441320;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:9690804;s:4:\"File\";s:69:\"20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/gregso5/public_html/wp-snapshots/tmp/20170803_gregsonstudios_795489ec5fa76dfe6876170823055231_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("3", "20170803_gregsonstudios", "c5d9af174e8af88e2251171006044324", "100", "2017-10-06 04:43:56", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-06 04:43:24\";s:7:\"Version\";s:6:\"1.2.24\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:23:\"20170803_gregsonstudios\";s:4:\"Hash\";s:32:\"c5d9af174e8af88e2251171006044324\";s:8:\"NameHash\";s:56:\"20170803_gregsonstudios_c5d9af174e8af88e2251171006044324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170803_gregsonstudios_c5d9af174e8af88e2251171006044324_scan.json\";s:7:\"Runtime\";s:11:\"188.17 sec.\";s:7:\"ExeSize\";s:5:\"435KB\";s:7:\"ZipSize\";s:7:\"173.6MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:43:\"/home/gregso5/public_html/wp-content/cache;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"zip;rar;tar;gz;bz2;7z;avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20170803_gregsonstudios_c5d9af174e8af88e2251171006044324_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:182035262;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20170803_gregsonstudios_c5d9af174e8af88e2251171006044324_installer.php\";s:4:\"Size\";i:445445;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:15189491;s:4:\"File\";s:69:\"20170803_gregsonstudios_c5d9af174e8af88e2251171006044324_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/gregso5/public_html/wp-snapshots/tmp/20170803_gregsonstudios_c5d9af174e8af88e2251171006044324_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("4", "20170803_gregsonstudios", "32732d89da474db45914171008041505", "100", "2017-10-08 04:15:16", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-08 04:15:05\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:23:\"20170803_gregsonstudios\";s:4:\"Hash\";s:32:\"32732d89da474db45914171008041505\";s:8:\"NameHash\";s:56:\"20170803_gregsonstudios_32732d89da474db45914171008041505\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170803_gregsonstudios_32732d89da474db45914171008041505_scan.json\";s:7:\"Runtime\";s:11:\"279.08 sec.\";s:7:\"ExeSize\";s:8:\"438.31KB\";s:7:\"ZipSize\";s:8:\"280.24MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:43:\"/home/gregso5/public_html/wp-content/cache;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"zip;rar;tar;gz;bz2;7z;avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20170803_gregsonstudios_32732d89da474db45914171008041505_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:293851652;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20170803_gregsonstudios_32732d89da474db45914171008041505_installer.php\";s:4:\"Size\";i:448833;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:19265247;s:4:\"File\";s:69:\"20170803_gregsonstudios_32732d89da474db45914171008041505_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/gregso5/public_html/wp-snapshots/tmp/20170803_gregsonstudios_32732d89da474db45914171008041505_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("5", "gregsonstudios_Launch10_20_2017", "55c528a882f398958501171021045744", "100", "2017-10-21 04:57:56", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-21 04:57:44\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:31:\"gregsonstudios_Launch10_20_2017\";s:4:\"Hash\";s:32:\"55c528a882f398958501171021045744\";s:8:\"NameHash\";s:64:\"gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:74:\"gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744_scan.json\";s:7:\"Runtime\";s:11:\"108.69 sec.\";s:7:\"ExeSize\";s:8:\"438.33KB\";s:7:\"ZipSize\";s:7:\"52.48MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"zip;rar;tar;gz;bz2;7z;avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:76:\"gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:55024765;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:78:\"gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744_installer.php\";s:4:\"Size\";i:448848;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:23840195;s:4:\"File\";s:77:\"gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:120:\"/home/gregso5/public_html/wp-snapshots/tmp/gregsonstudios_Launch10_20_2017_55c528a882f398958501171021045744_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("6", "gregsonstudios_10_28_2017_MailingList", "20fee5e424dabc212513171029020330", "100", "2017-10-29 02:03:58", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-29 02:03:30\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:37:\"gregsonstudios_10_28_2017_MailingList\";s:4:\"Hash\";s:32:\"20fee5e424dabc212513171029020330\";s:8:\"NameHash\";s:70:\"gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:80:\"gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330_scan.json\";s:7:\"Runtime\";s:10:\"91.78 sec.\";s:7:\"ExeSize\";s:8:\"438.34KB\";s:7:\"ZipSize\";s:7:\"52.46MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"zip;rar;tar;gz;bz2;7z;avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:82:\"gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:55009854;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:84:\"gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330_installer.php\";s:4:\"Size\";i:448860;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:25546207;s:4:\"File\";s:83:\"gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/home/gregso5/public_html/wp-snapshots/tmp/gregsonstudios_10_28_2017_MailingList_20fee5e424dabc212513171029020330_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("7", "gregsonstudios_10_30_2017_PrePolicy", "176fb50367f7a0cf9597171031002714", "100", "2017-10-31 00:27:40", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-31 00:27:14\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:35:\"gregsonstudios_10_30_2017_PrePolicy\";s:4:\"Hash\";s:32:\"176fb50367f7a0cf9597171031002714\";s:8:\"NameHash\";s:68:\"gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:78:\"gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714_scan.json\";s:7:\"Runtime\";s:10:\"96.02 sec.\";s:7:\"ExeSize\";s:8:\"438.34KB\";s:7:\"ZipSize\";s:7:\"53.49MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:56084146;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:82:\"gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714_installer.php\";s:4:\"Size\";i:448856;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:27504132;s:4:\"File\";s:81:\"gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:124:\"/home/gregso5/public_html/wp-snapshots/tmp/gregsonstudios_10_30_2017_PrePolicy_176fb50367f7a0cf9597171031002714_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("8", "gregsonstudios_11_19_2017_PreWP49updates", "68e7cc837d44d2445324171119183653", "100", "2017-11-19 18:37:11", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-11-19 18:36:53\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.3\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:8;s:4:\"Name\";s:40:\"gregsonstudios_11_19_2017_PreWP49updates\";s:4:\"Hash\";s:32:\"68e7cc837d44d2445324171119183653\";s:8:\"NameHash\";s:73:\"gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:83:\"gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653_scan.json\";s:7:\"Runtime\";s:10:\"89.23 sec.\";s:7:\"ExeSize\";s:8:\"438.35KB\";s:7:\"ZipSize\";s:7:\"51.06MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:53539350;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:87:\"gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653_installer.php\";s:4:\"Size\";i:448866;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:28936710;s:4:\"File\";s:86:\"gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:129:\"/home/gregso5/public_html/wp-snapshots/tmp/gregsonstudios_11_19_2017_PreWP49updates_68e7cc837d44d2445324171119183653_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("9", "gregsonstudios_1_5_2018", "f244785a63eb10215325180116013822", "100", "2018-01-16 01:38:42", "Budman", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-16 01:38:22\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:9;s:4:\"Name\";s:23:\"gregsonstudios_1_5_2018\";s:4:\"Hash\";s:32:\"f244785a63eb10215325180116013822\";s:8:\"NameHash\";s:56:\"gregsonstudios_1_5_2018_f244785a63eb10215325180116013822\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"gregsonstudios_1_5_2018_f244785a63eb10215325180116013822_scan.json\";s:7:\"Runtime\";s:10:\"90.80 sec.\";s:7:\"ExeSize\";s:8:\"443.98KB\";s:7:\"ZipSize\";s:7:\"44.24MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:6:\"Budman\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"gregsonstudios_1_5_2018_f244785a63eb10215325180116013822_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:46393791;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"gregsonstudios_1_5_2018_f244785a63eb10215325180116013822_installer.php\";s:4:\"Size\";i:454632;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:33077303;s:4:\"File\";s:69:\"gregsonstudios_1_5_2018_f244785a63eb10215325180116013822_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:112:\"/home/gregso5/public_html/wp-snapshots/tmp/gregsonstudios_1_5_2018_f244785a63eb10215325180116013822_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wpbd_duplicator_packages` VALUES("10", "gregsonstudios_1_21_2018_deploy", "e59badb8572398db9492180121191252", "20", "2018-01-21 19:13:08", "BuddyJames", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-21 19:12:52\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:10;s:4:\"Name\";s:31:\"gregsonstudios_1_21_2018_deploy\";s:4:\"Hash\";s:32:\"e59badb8572398db9492180121191252\";s:8:\"NameHash\";s:64:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";s:74:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"BuddyJames\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:88:\"/home/gregso5/public_html/wp-content/cache;/home/gregso5/public_html/wp-content/uploads;\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:75:\"avi;mov;mp4;mpeg;mpg;swf;wmv;aac;m3u;mp3;mpa;wav;wma;zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:76:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/gregso5/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-21 19:12:52\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"7.0.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:31:\"gregsonstudios_1_21_2018_deploy\";s:4:\"Hash\";s:32:\"e59badb8572398db9492180121191252\";s:8:\"NameHash\";s:64:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/home/gregso5/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://gregsonstudios.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:78:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:77:\"gregsonstudios_1_21_2018_deploy_e59badb8572398db9492180121191252_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:34:\"/home/gregso5/public_html/wp-admin\";i:1;s:44:\"/home/gregso5/public_html/wp-content/uploads\";i:2;s:46:\"/home/gregso5/public_html/wp-content/languages\";i:3;s:44:\"/home/gregso5/public_html/wp-content/plugins\";i:4;s:43:\"/home/gregso5/public_html/wp-content/themes\";i:5;s:37:\"/home/gregso5/public_html/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wpbd_et_bloom_stats */
INSERT INTO `wpbd_et_bloom_stats` VALUES("1", "2018-01-12 22:33:16", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("2", "2018-01-12 22:33:23", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("3", "2018-01-12 22:33:50", "con", "optin_2", "mailchimp_8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("4", "2018-01-12 23:27:15", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("5", "2018-01-12 23:27:19", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("6", "2018-01-12 23:28:03", "con", "optin_2", "mailchimp_8fa8a7f696", "75.166.209.211", "31733", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("7", "2018-01-12 23:36:37", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31662", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("8", "2018-01-12 23:40:30", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31662", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("9", "2018-01-12 23:42:21", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31662", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("10", "2018-01-12 23:42:49", "con", "optin_2", "mailchimp_8fa8a7f696", "75.166.209.211", "31662", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("11", "2018-01-12 23:43:37", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("12", "2018-01-12 23:45:29", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("13", "2018-01-13 01:00:17", "imp", "optin_2", "8fa8a7f696", "67.161.131.185", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("14", "2018-01-13 01:00:31", "imp", "optin_2", "8fa8a7f696", "172.58.60.243", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("15", "2018-01-13 01:01:24", "imp", "optin_2", "8fa8a7f696", "67.166.58.208", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("16", "2018-01-13 01:02:15", "imp", "optin_2", "8fa8a7f696", "172.58.63.20", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("17", "2018-01-13 01:03:09", "imp", "optin_2", "8fa8a7f696", "172.58.63.21", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("18", "2018-01-13 01:03:31", "imp", "optin_2", "8fa8a7f696", "97.86.242.1", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("19", "2018-01-13 01:04:29", "imp", "optin_2", "8fa8a7f696", "161.97.196.10", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("20", "2018-01-13 01:04:29", "imp", "optin_2", "8fa8a7f696", "161.97.196.10", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("21", "2018-01-13 01:08:25", "imp", "optin_2", "8fa8a7f696", "174.209.68.65", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("22", "2018-01-13 01:10:52", "imp", "optin_2", "8fa8a7f696", "172.58.60.228", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("23", "2018-01-13 01:12:31", "imp", "optin_2", "8fa8a7f696", "107.242.113.3", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("24", "2018-01-13 01:13:33", "imp", "optin_2", "8fa8a7f696", "172.58.144.133", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("25", "2018-01-13 01:16:00", "imp", "optin_2", "8fa8a7f696", "65.128.6.117", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("26", "2018-01-13 01:16:45", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("27", "2018-01-13 01:16:57", "con", "optin_2", "mailchimp_8fa8a7f696", "75.166.209.211", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("28", "2018-01-13 01:18:38", "imp", "", "", "75.166.209.211", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("29", "2018-01-13 01:20:06", "imp", "optin_2", "8fa8a7f696", "174.56.71.254", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("30", "2018-01-13 01:20:31", "imp", "optin_2", "8fa8a7f696", "172.56.12.126", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("31", "2018-01-13 01:22:02", "imp", "", "", "75.166.209.211", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("32", "2018-01-13 01:22:07", "imp", "optin_2", "8fa8a7f696", "172.58.143.2", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("33", "2018-01-13 01:22:30", "imp", "optin_2", "8fa8a7f696", "172.58.143.2", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("34", "2018-01-13 01:23:52", "imp", "optin_2", "8fa8a7f696", "172.58.143.2", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("35", "2018-01-13 01:26:29", "imp", "optin_2", "8fa8a7f696", "69.254.136.36", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("36", "2018-01-13 01:27:57", "imp", "optin_2", "8fa8a7f696", "174.237.132.227", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("37", "2018-01-13 01:31:23", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("38", "2018-01-13 01:31:24", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("39", "2018-01-13 01:31:25", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("40", "2018-01-13 01:31:25", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("41", "2018-01-13 01:31:26", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("42", "2018-01-13 01:31:26", "imp", "optin_2", "8fa8a7f696", "71.211.17.252", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("43", "2018-01-13 01:35:58", "imp", "optin_2", "8fa8a7f696", "107.242.113.10", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("44", "2018-01-13 01:42:28", "imp", "optin_2", "8fa8a7f696", "172.58.56.101", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("45", "2018-01-13 01:58:06", "imp", "optin_2", "8fa8a7f696", "66.87.207.240", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("46", "2018-01-13 02:21:33", "imp", "optin_2", "8fa8a7f696", "97.122.217.195", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("47", "2018-01-13 02:41:07", "imp", "optin_2", "8fa8a7f696", "71.11.101.251", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("48", "2018-01-13 02:51:19", "imp", "optin_2", "8fa8a7f696", "108.222.127.47", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("49", "2018-01-13 03:14:24", "imp", "optin_2", "8fa8a7f696", "71.218.115.167", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("50", "2018-01-13 03:17:20", "imp", "optin_2", "8fa8a7f696", "65.128.82.52", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("51", "2018-01-13 03:19:11", "imp", "optin_2", "8fa8a7f696", "24.8.157.237", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("52", "2018-01-13 04:16:28", "imp", "optin_2", "8fa8a7f696", "71.211.9.60", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("53", "2018-01-13 05:07:03", "imp", "optin_2", "8fa8a7f696", "166.137.118.94", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("54", "2018-01-13 05:30:55", "imp", "optin_2", "8fa8a7f696", "166.137.118.94", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("55", "2018-01-13 06:06:02", "imp", "optin_2", "8fa8a7f696", "174.209.21.101", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("56", "2018-01-13 06:08:00", "imp", "optin_2", "8fa8a7f696", "174.209.21.101", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("57", "2018-01-13 06:35:25", "imp", "optin_2", "8fa8a7f696", "162.225.99.249", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("58", "2018-01-13 06:35:28", "imp", "optin_2", "8fa8a7f696", "162.225.99.249", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("59", "2018-01-13 06:59:04", "imp", "optin_2", "8fa8a7f696", "67.174.114.90", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("60", "2018-01-13 07:18:17", "imp", "optin_2", "8fa8a7f696", "68.12.124.138", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("61", "2018-01-13 07:21:23", "imp", "optin_2", "8fa8a7f696", "5.108.181.127", "31720", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("62", "2018-01-13 07:23:03", "imp", "optin_2", "8fa8a7f696", "67.190.91.164", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("63", "2018-01-13 08:21:09", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("64", "2018-01-13 08:23:33", "imp", "optin_2", "8fa8a7f696", "73.14.33.59", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("65", "2018-01-13 08:26:34", "imp", "optin_2", "8fa8a7f696", "50.80.150.57", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("66", "2018-01-13 08:53:54", "imp", "optin_2", "8fa8a7f696", "51.36.215.26", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("67", "2018-01-13 09:04:09", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("68", "2018-01-13 09:04:20", "imp", "optin_2", "8fa8a7f696", "104.63.62.11", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("69", "2018-01-13 09:04:49", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("70", "2018-01-13 09:04:56", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("71", "2018-01-13 09:05:17", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("72", "2018-01-13 09:05:23", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("73", "2018-01-13 09:05:28", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("74", "2018-01-13 09:05:36", "imp", "optin_2", "8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("75", "2018-01-13 09:05:46", "imp", "optin_2", "8fa8a7f696", "172.56.41.122", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("76", "2018-01-13 09:06:06", "con", "optin_2", "mailchimp_8fa8a7f696", "174.255.133.67", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("77", "2018-01-13 09:06:11", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("78", "2018-01-13 09:06:21", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("79", "2018-01-13 09:06:47", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("80", "2018-01-13 09:07:01", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("81", "2018-01-13 09:07:09", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("82", "2018-01-13 09:07:13", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("83", "2018-01-13 09:07:18", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("84", "2018-01-13 09:07:27", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("85", "2018-01-13 09:07:30", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("86", "2018-01-13 09:07:40", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("87", "2018-01-13 09:07:46", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("88", "2018-01-13 09:07:51", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("89", "2018-01-13 09:07:58", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("90", "2018-01-13 09:08:05", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("91", "2018-01-13 09:08:13", "imp", "optin_2", "8fa8a7f696", "107.242.113.5", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("92", "2018-01-13 09:08:15", "imp", "", "", "174.255.133.67", "0", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("93", "2018-01-13 09:25:01", "imp", "optin_2", "8fa8a7f696", "174.255.130.112", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("94", "2018-01-13 09:39:31", "imp", "optin_2", "8fa8a7f696", "70.167.45.228", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("95", "2018-01-13 09:50:00", "imp", "optin_2", "8fa8a7f696", "74.197.92.242", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("96", "2018-01-13 09:57:16", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("97", "2018-01-13 09:57:31", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("98", "2018-01-13 09:57:55", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("99", "2018-01-13 09:57:58", "imp", "optin_2", "8fa8a7f696", "172.56.12.176", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("100", "2018-01-13 09:58:19", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("101", "2018-01-13 09:58:21", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("102", "2018-01-13 09:58:52", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("103", "2018-01-13 09:59:02", "imp", "optin_2", "8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("104", "2018-01-13 10:00:15", "con", "optin_2", "mailchimp_8fa8a7f696", "73.243.42.239", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("105", "2018-01-13 10:21:26", "imp", "optin_2", "8fa8a7f696", "66.87.151.137", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("106", "2018-01-13 11:07:53", "imp", "optin_2", "8fa8a7f696", "73.91.229.14", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("107", "2018-01-13 13:25:19", "imp", "optin_2", "8fa8a7f696", "73.14.65.168", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("108", "2018-01-13 14:02:03", "imp", "optin_2", "8fa8a7f696", "73.229.79.221", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("109", "2018-01-13 14:18:04", "imp", "optin_2", "8fa8a7f696", "107.77.173.5", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("110", "2018-01-13 14:25:16", "imp", "optin_2", "8fa8a7f696", "72.161.111.205", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("111", "2018-01-13 15:59:05", "imp", "optin_2", "8fa8a7f696", "166.137.125.66", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("112", "2018-01-13 16:00:55", "imp", "optin_2", "8fa8a7f696", "166.137.125.66", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("113", "2018-01-13 16:32:22", "imp", "optin_2", "8fa8a7f696", "166.137.125.66", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("114", "2018-01-13 18:00:01", "imp", "optin_2", "8fa8a7f696", "172.58.63.86", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("115", "2018-01-13 18:46:40", "imp", "optin_2", "8fa8a7f696", "69.7.122.68", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("116", "2018-01-13 18:50:31", "imp", "optin_2", "8fa8a7f696", "69.7.122.68", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("117", "2018-01-13 19:26:35", "imp", "optin_2", "8fa8a7f696", "162.225.99.249", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("118", "2018-01-13 20:59:16", "imp", "optin_2", "8fa8a7f696", "24.9.67.192", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("119", "2018-01-13 21:01:03", "imp", "optin_2", "8fa8a7f696", "24.9.67.192", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("120", "2018-01-13 21:04:31", "imp", "optin_2", "8fa8a7f696", "97.118.127.157", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("121", "2018-01-13 21:12:34", "imp", "optin_2", "8fa8a7f696", "172.58.60.56", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("122", "2018-01-13 23:37:13", "imp", "optin_2", "8fa8a7f696", "107.242.113.2", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("123", "2018-01-14 00:26:35", "imp", "optin_2", "8fa8a7f696", "97.122.217.195", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("124", "2018-01-14 01:32:06", "imp", "optin_2", "8fa8a7f696", "174.255.130.17", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("125", "2018-01-14 01:55:35", "imp", "optin_2", "8fa8a7f696", "166.137.125.66", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("126", "2018-01-14 02:12:53", "imp", "optin_2", "8fa8a7f696", "76.113.51.67", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("127", "2018-01-14 04:04:17", "imp", "optin_2", "8fa8a7f696", "172.56.12.20", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("128", "2018-01-14 04:04:23", "imp", "optin_2", "8fa8a7f696", "172.56.12.20", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("129", "2018-01-14 04:06:49", "imp", "optin_2", "8fa8a7f696", "72.206.98.113", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("130", "2018-01-14 04:09:38", "imp", "optin_2", "8fa8a7f696", "208.98.160.71", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("131", "2018-01-14 05:40:55", "imp", "optin_2", "8fa8a7f696", "172.58.56.125", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("132", "2018-01-14 05:43:09", "imp", "optin_2", "8fa8a7f696", "172.58.56.125", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("133", "2018-01-14 05:47:53", "imp", "optin_2", "8fa8a7f696", "73.34.241.160", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("134", "2018-01-14 05:49:33", "imp", "optin_2", "8fa8a7f696", "73.34.241.160", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("135", "2018-01-14 08:47:02", "imp", "optin_2", "8fa8a7f696", "172.58.73.105", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("136", "2018-01-14 09:10:11", "imp", "optin_2", "8fa8a7f696", "73.153.18.69", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("137", "2018-01-14 09:21:58", "imp", "optin_2", "8fa8a7f696", "68.41.16.246", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("138", "2018-01-14 09:22:06", "imp", "optin_2", "8fa8a7f696", "172.58.84.23", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("139", "2018-01-14 09:24:05", "imp", "optin_2", "8fa8a7f696", "174.209.7.106", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("140", "2018-01-14 09:28:14", "imp", "optin_2", "8fa8a7f696", "66.87.151.254", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("141", "2018-01-14 09:32:08", "imp", "optin_2", "8fa8a7f696", "73.243.196.99", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("142", "2018-01-14 09:49:47", "imp", "optin_2", "8fa8a7f696", "71.218.51.222", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("143", "2018-01-14 10:15:18", "imp", "optin_2", "8fa8a7f696", "174.255.135.205", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("144", "2018-01-14 10:26:51", "imp", "optin_2", "8fa8a7f696", "172.58.56.76", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("145", "2018-01-14 11:01:27", "imp", "optin_2", "8fa8a7f696", "174.209.6.124", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("146", "2018-01-14 11:01:28", "imp", "optin_2", "8fa8a7f696", "174.209.6.124", "31735", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("147", "2018-01-14 11:13:00", "imp", "optin_2", "8fa8a7f696", "73.153.34.223", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("148", "2018-01-14 11:32:05", "imp", "optin_2", "8fa8a7f696", "172.58.63.54", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("149", "2018-01-14 11:41:19", "imp", "optin_2", "8fa8a7f696", "47.17.82.80", "31720", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("150", "2018-01-14 12:05:49", "imp", "optin_2", "8fa8a7f696", "97.44.4.41", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("151", "2018-01-14 12:44:34", "imp", "optin_2", "8fa8a7f696", "171.239.182.57", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("152", "2018-01-14 12:58:04", "imp", "optin_2", "8fa8a7f696", "66.87.150.214", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("153", "2018-01-14 14:45:32", "imp", "optin_2", "8fa8a7f696", "67.165.241.235", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("154", "2018-01-14 23:58:47", "imp", "optin_2", "8fa8a7f696", "172.58.60.235", "31760", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("155", "2018-01-15 03:27:01", "imp", "optin_2", "8fa8a7f696", "172.58.56.47", "31752", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("156", "2018-01-15 04:59:50", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("157", "2018-01-15 05:01:01", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("158", "2018-01-15 05:01:03", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("159", "2018-01-15 05:01:09", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("160", "2018-01-15 05:01:12", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("161", "2018-01-15 05:01:18", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("162", "2018-01-15 05:01:20", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("163", "2018-01-15 05:01:22", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("164", "2018-01-15 05:01:25", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("165", "2018-01-15 05:01:32", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("166", "2018-01-15 05:02:11", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("167", "2018-01-15 05:15:11", "imp", "optin_2", "8fa8a7f696", "75.166.209.211", "31744", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("168", "2018-01-15 19:32:25", "imp", "optin_2", "8fa8a7f696", "189.95.5.60", "31724", "0");
INSERT INTO `wpbd_et_bloom_stats` VALUES("169", "2018-01-17 21:37:29", "imp", "optin_2", "8fa8a7f696", "63.149.121.82", "31735", "0");

/* INSERT TABLE DATA: wpbd_et_social_stats */
INSERT INTO `wpbd_et_social_stats` VALUES("1", "2017-11-12 21:51:17", "twitter", "follow", "2", "73.243.133.68", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("2", "2017-11-21 22:02:19", "facebook", "follow", "31840", "2.55.6.172", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("3", "2017-11-21 22:02:29", "facebook", "share", "31840", "2.55.6.172", "", "sidebar");
INSERT INTO `wpbd_et_social_stats` VALUES("4", "2018-01-02 18:10:16", "facebook", "follow", "30775", "198.72.223.83", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("5", "2018-01-02 18:10:30", "linkedin", "follow", "30775", "198.72.223.83", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("6", "2018-01-09 16:54:15", "facebook", "follow", "30783", "73.247.92.162", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("7", "2018-01-10 06:55:58", "twitter", "share", "31760", "174.228.132.84", "", "sidebar");
INSERT INTO `wpbd_et_social_stats` VALUES("8", "2018-01-10 08:38:34", "googleplus", "follow", "31735", "172.58.63.119", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("9", "2018-01-10 08:38:46", "pinterest", "follow", "31735", "172.58.63.119", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("10", "2018-01-10 12:53:51", "facebook", "share", "31720", "70.184.118.71", "", "sidebar");
INSERT INTO `wpbd_et_social_stats` VALUES("11", "2018-01-11 02:17:45", "facebook", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("12", "2018-01-11 02:17:49", "twitter", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("13", "2018-01-11 02:33:19", "googleplus", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("14", "2018-01-11 02:33:23", "pinterest", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("15", "2018-01-11 02:33:30", "youtube", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("16", "2018-01-11 02:33:35", "instagram", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("17", "2018-01-11 02:33:39", "linkedin", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("18", "2018-01-11 02:33:43", "tumblr", "follow", "2", "75.166.227.175", "", "");
INSERT INTO `wpbd_et_social_stats` VALUES("19", "2018-01-11 08:07:14", "twitter", "share", "31720", "174.224.9.202", "", "sidebar");
INSERT INTO `wpbd_et_social_stats` VALUES("20", "2018-01-20 08:04:16", "linkedin", "share", "31744", "172.56.29.215", "", "sidebar");

/* INSERT TABLE DATA: wpbd_loginizer_logs */
INSERT INTO `wpbd_loginizer_logs` VALUES("Budman", "1511229844", "3", "1", "73.243.133.68");

/* INSERT TABLE DATA: wpbd_options */
INSERT INTO `wpbd_options` VALUES("1", "siteurl", "http://gregsonstudios.com", "yes");
INSERT INTO `wpbd_options` VALUES("2", "home", "http://gregsonstudios.com", "yes");
INSERT INTO `wpbd_options` VALUES("3", "blogname", "Gregson Studios", "yes");
INSERT INTO `wpbd_options` VALUES("4", "blogdescription", "Premium Video Services In Denver", "yes");
INSERT INTO `wpbd_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpbd_options` VALUES("6", "admin_email", "gregsonstudios@gmail.com", "yes");
INSERT INTO `wpbd_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpbd_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpbd_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpbd_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpbd_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpbd_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpbd_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpbd_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpbd_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpbd_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpbd_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpbd_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpbd_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wpbd_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wpbd_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wpbd_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpbd_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wpbd_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wpbd_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wpbd_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wpbd_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpbd_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wpbd_options` VALUES("29", "rewrite_rules", "a:141:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:39:\"amn_mi-lite/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"amn_mi-lite/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"amn_mi-lite/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"amn_mi-lite/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"amn_mi-lite/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"amn_mi-lite/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"amn_mi-lite/([^/]+)/embed/?$\";s:44:\"index.php?amn_mi-lite=$matches[1]&embed=true\";s:32:\"amn_mi-lite/([^/]+)/trackback/?$\";s:38:\"index.php?amn_mi-lite=$matches[1]&tb=1\";s:40:\"amn_mi-lite/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?amn_mi-lite=$matches[1]&paged=$matches[2]\";s:47:\"amn_mi-lite/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?amn_mi-lite=$matches[1]&cpage=$matches[2]\";s:36:\"amn_mi-lite/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?amn_mi-lite=$matches[1]&page=$matches[2]\";s:28:\"amn_mi-lite/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"amn_mi-lite/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"amn_mi-lite/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"amn_mi-lite/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"amn_mi-lite/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"amn_mi-lite/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wpbd_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpbd_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpbd_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpbd_options` VALUES("33", "active_plugins", "a:19:{i:0;s:19:\"akismet/akismet.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:45:\"bulletproof-security/bulletproof-security.php\";i:3;s:29:\"divi-booster/divi-booster.php\";i:4;s:29:\"divi-builder/divi-builder.php\";i:5;s:55:\"divi-disable-plugin-check/divi-disable-plugin-check.php\";i:6;s:27:\"divi-switch/divi-switch.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:50:\"dwd-aio-module-extended-plugin/load_aio_module.php\";i:9;s:71:\"dwd-custom-fullwidth-header-extended/load-fullwidth-header-extended.php\";i:10;s:39:\"glue-for-yoast-seo-amp/yoastseo-amp.php\";i:11;s:50:\"google-analytics-for-wordpress/googleanalytics.php\";i:12;s:19:\"jetpack/jetpack.php\";i:13;s:19:\"monarch/monarch.php\";i:14;s:25:\"sucuri-scanner/sucuri.php\";i:15;s:27:\"tawkto-live-chat/tawkto.php\";i:16;s:23:\"wordfence/wordfence.php\";i:18;s:24:\"wordpress-seo/wp-seo.php\";i:19;s:23:\"wp-smushit/wp-smush.php\";}", "yes");
INSERT INTO `wpbd_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpbd_options` VALUES("35", "ping_sites", "http://1470.net/api/ping\nhttp://api.feedster.com/ping\nhttp://api.moreover.com/ping\nhttp://api.moreover.com/RPC2\nhttp://api.my.yahoo.com/RPC2\nhttp://api.my.yahoo.com/rss/ping\nhttp://bblog.com/ping.php\nhttp://bing.com/webmaster/ping.aspx\nhttp://bitacoras.net/ping\nhttp://blo.gs/ping.php\nhttp://blog.goo.ne.jp/XMLRPC\nhttp://blog.with2.net/ping.php\nhttp://blogdb.jp/xmlrpc\nhttp://blogmatcher.com/u.php\nhttp://blogping.unidatum.com/RPC2\nhttp://blogpingr.de/ping/rpc2\nhttp://blogs.yandex.ru/\nhttp://blogsearch.google.ae/ping/RPC2\nhttp://blogsearch.google.at/ping/RPC2\nhttp://blogsearch.google.be/ping/RPC2\nhttp://blogsearch.google.bg/ping/RPC2\nhttp://blogsearch.google.ca/ping/RPC2\nhttp://blogsearch.google.ch/ping/RPC2\nhttp://blogsearch.google.cl/ping/RPC2\nhttp://blogsearch.google.co.cr/ping/RPC2\nhttp://blogsearch.google.co.hu/ping/RPC2\nhttp://blogsearch.google.co.id/ping/RPC2\nhttp://blogsearch.google.co.il/ping/RPC2\nhttp://blogsearch.google.co.in/ping/RPC2\nhttp://blogsearch.google.co.it/ping/RPC2\nhttp://blogsearch.google.co.jp/ping/RPC2\nhttp://blogsearch.google.co.ma/ping/RPC2\nhttp://blogsearch.google.co.nz/ping/RPC2\nhttp://blogsearch.google.co.th/ping/RPC2\nhttp://blogsearch.google.co.uk/ping/RPC2\nhttp://blogsearch.google.co.ve/ping/RPC2\nhttp://blogsearch.google.co.za/ping/RPC2\nhttp://blogsearch.google.com.ar/ping/RPC2\nhttp://blogsearch.google.com.au/ping/RPC2\nhttp://blogsearch.google.com.br/ping/RPC2\nhttp://blogsearch.google.com.co/ping/RPC2\nhttp://blogsearch.google.com.do/ping/RPC2\nhttp://blogsearch.google.com.mx/ping/RPC2\nhttp://blogsearch.google.com.my/ping/RPC2\nhttp://blogsearch.google.com.pe/ping/RPC2\nhttp://blogsearch.google.com.sa/ping/RPC2\nhttp://blogsearch.google.com.sg/ping/RPC2\nhttp://blogsearch.google.com.tr/ping/RPC2\nhttp://blogsearch.google.com.tw/ping/RPC2\nhttp://blogsearch.google.com.ua/ping/RPC2\nhttp://blogsearch.google.com.uy/ping/RPC2\nhttp://blogsearch.google.com.vn/ping/RPC2\nhttp://blogsearch.google.com/ping/RPC2\nhttp://blogsearch.google.de/ping/RPC2\nhttp://blogsearch.google.es/ping/RPC2\nhttp://blogsearch.google.fi/ping/RPC2\nhttp://blogsearch.google.fr/ping/RPC2\nhttp://blogsearch.google.gr/ping/RPC2\nhttp://blogsearch.google.hr/ping/RPC2\nhttp://blogsearch.google.ie/ping/RPC2\nhttp://blogsearch.google.in/ping/RPC2\nhttp://blogsearch.google.it/ping/RPC2\nhttp://blogsearch.google.jp/ping/RPC2\nhttp://blogsearch.google.ki/ping/RPC2\nhttp://blogsearch.google.kz/ping/RPC2\nhttp://blogsearch.google.la/ping/RPC2\nhttp://blogsearch.google.li/ping/RPC2\nhttp://blogsearch.google.lk/ping/RPC2\nhttp://blogsearch.google.lt/ping/RPC2\nhttp://blogsearch.google.lu/ping/RPC2\nhttp://blogsearch.google.md/ping/RPC2\nhttp://blogsearch.google.mn/ping/RPC2\nhttp://blogsearch.google.ms/ping/RPC2\nhttp://blogsearch.google.mu/ping/RPC2\nhttp://blogsearch.google.mv/ping/RPC2\nhttp://blogsearch.google.mw/ping/RPC2\nhttp://blogsearch.google.nl/ping/RPC2\nhttp://blogsearch.google.no/ping/RPC2\nhttp://blogsearch.google.nr/ping/RPC2\nhttp://blogsearch.google.nu/ping/RPC2\nhttp://blogsearch.google.pl/ping/RPC2\nhttp://blogsearch.google.pn/ping/RPC2\nhttp://blogsearch.google.pt/ping/RPC2\nhttp://blogsearch.google.ro/ping/RPC2\nhttp://blogsearch.google.ru/ping/RPC2\nhttp://blogsearch.google.rw/ping/RPC2\nhttp://blogsearch.google.sc/ping/RPC2\nhttp://blogsearch.google.se/ping/RPC2\nhttp://blogsearch.google.sh/ping/RPC2\nhttp://blogsearch.google.si/ping/RPC2\nhttp://blogsearch.google.sk/ping/RPC2\nhttp://blogsearch.google.sm/ping/RPC2\nhttp://blogsearch.google.sn/ping/RPC2\nhttp://blogsearch.google.st/ping/RPC2\nhttp://blogsearch.google.tk/ping/RPC2\nhttp://blogsearch.google.tl/ping/RPC2\nhttp://blogsearch.google.tm/ping/RPC2\nhttp://blogsearch.google.to/ping/RPC2\nhttp://blogsearch.google.tp/ping/RPC2\nhttp://blogsearch.google.tt/ping/RPC2\nhttp://blogsearch.google.tw/ping/RPC2\nhttp://blogsearch.google.us/ping/RPC2\nhttp://blogsearch.google.vg/ping/RPC2\nhttp://blogsearch.google.vu/ping/RPC2\nhttp://blogsearch.google.ws/ping/RPC2\nhttp://bulkfeeds.net/rpc\nhttp://coreblog.org/ping/\nhttp://feedburner.google.com/fb/a/pingSubmit?bloglink=http://gregsonstudios.com/\nhttp://geourl.org/ping\nhttp://ipings.com\nhttp://mod-pubsub.org/kn_apps/blogchatt\nhttp://news2paper.com/ping\nhttp://ping.amagle.com/\nhttp://ping.bitacoras.com\nhttp://ping.blo.gs/\nhttp://ping.bloggers.jp/rpc\nhttp://ping.blogmura.jp/rpc/\nhttp://ping.blogs.yandex.ru/RPC2\nhttp://ping.cocolog-nifty.com/xmlrpc\nhttp://ping.exblog.jp/xmlrpc\nhttp://ping.fc2.com\nhttp://ping.feedburner.com\nhttp://ping.myblog.jp\nhttp://ping.rootblog.com/rpc.php\nhttp://ping.rss.drecom.jp\nhttp://ping.syndic8.com/xmlrpc.php\nhttp://ping.weblogalot.com/rpc.php\nhttp://ping.weblogs.se/\nhttp://pingoat.com/goat/RPC2\nhttp://rcs.datashed.net/RPC2/\nhttp://rpc.blogbuzzmachine.com/RPC2\nhttp://rpc.bloggerei.de/\nhttp://rpc.bloggerei.de/ping/\nhttp://rpc.blogrolling.com/pinger/\nhttp://rpc.copygator.com/ping/\nhttp://rpc.icerocket.com:10080/\nhttp://rpc.newsgator.com/\nhttp://rpc.odiogo.com/ping/\nhttp://rpc.pingomatic.com\nhttp://rpc.technorati.com/rpc/ping\nhttp://rpc.twingly.com\nhttp://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http://gregsonstudios.com/\nhttp://rpc.weblogs.com/pingSiteForm?name=GregsonStudios&url=http%3A%2F%2Fgregsonstudios.com\nhttp://rpc.weblogs.com/RPC2\nhttp://services.newsgator.com/ngws/xmlrpcping.aspx\nhttp://topicexchange.com/RPC2\nhttp://trackback.bakeinu.jp/bakeping.php\nhttp://www.a2b.cc/setloc/bp.a2b\nhttp://www.bitacoles.net/ping.php\nhttp://www.blogdigger.com/RPC2\nhttp://www.blogoole.com/ping/\nhttp://www.blogoon.net/ping/\nhttp://www.blogpeople.net/servlet/weblogUpdates\nhttp://www.blogroots.com/tb_populi.blog?id=1\nhttp://www.blogshares.com/rpc.php\nhttp://www.blogsnow.com/ping\nhttp://www.blogstreet.com/xrbin/xmlrpc.cgi\nhttp://www.feedsubmitter.com\nhttp://www.lasermemory.com/lsrpc/\nhttp://www.mod-pubsub.org/kn_apps/blogchatter/ping.php\nhttp://www.newsisfree.com/RPCCloud\nhttp://www.newsisfree.com/xmlrpctest.php\nhttp://www.pingerati.net\nhttp://www.pingmyblog.com\nhttp://www.popdex.com/addsite.php\nhttp://www.snipsnap.org/RPC2\nhttp://www.weblogalot.com/ping\nhttp://www.weblogues.com/RPC/\nhttp://xmlrpc.blogg.de\nhttp://xping.pubsub.com/ping\nhttps://ping.blogs.yandex.ru/RPC2", "yes");
INSERT INTO `wpbd_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpbd_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpbd_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpbd_options` VALUES("39", "recently_edited", "a:2:{i:0;s:56:\"/home/gregso5/public_html/wp-content/plugins/amp/amp.php\";i:2;s:0:\"\";}", "no");
INSERT INTO `wpbd_options` VALUES("40", "template", "Divi", "yes");
INSERT INTO `wpbd_options` VALUES("41", "stylesheet", "Divi", "yes");
INSERT INTO `wpbd_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wpbd_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wpbd_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wpbd_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wpbd_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wpbd_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wpbd_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wpbd_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpbd_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wpbd_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wpbd_options` VALUES("52", "default_link_category", "0", "yes");
INSERT INTO `wpbd_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wpbd_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wpbd_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wpbd_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wpbd_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wpbd_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpbd_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpbd_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wpbd_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wpbd_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wpbd_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wpbd_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wpbd_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wpbd_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wpbd_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wpbd_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wpbd_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wpbd_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wpbd_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wpbd_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wpbd_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wpbd_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wpbd_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wpbd_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wpbd_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("79", "widget_text", "a:3:{i:1;a:0:{}i:5;a:4:{s:5:\"title\";s:6:\"DENVER\";s:4:\"text\";s:37:\"720-980-0219\r\n\r\nSkype @GregsonStudios\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("81", "uninstall_plugins", "a:3:{s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";s:50:\"google-analytics-for-wordpress/googleanalytics.php\";s:35:\"monsterinsights_lite_uninstall_hook\";s:45:\"bulletproof-security/bulletproof-security.php\";s:30:\"bulletproof_security_uninstall\";}", "no");
INSERT INTO `wpbd_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wpbd_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wpbd_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `wpbd_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wpbd_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wpbd_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpbd_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wpbd_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wpbd_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wpbd_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wpbd_options` VALUES("92", "wpbd_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wpbd_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wpbd_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("99", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";i:4;s:19:\"blog_subscription-2\";i:5;s:11:\"tag_cloud-2\";}s:9:\"sidebar-2\";a:1:{i:0;s:13:\"media_image-2\";}s:9:\"sidebar-3\";a:1:{i:0;s:6:\"text-5\";}s:9:\"sidebar-4\";a:1:{i:0;s:15:\"monarchwidget-2\";}s:9:\"sidebar-5\";a:0:{}s:19:\"ampforwp-above-loop\";a:0:{}s:19:\"ampforwp-below-loop\";a:0:{}s:21:\"ampforwp-below-header\";a:0:{}s:21:\"ampforwp-above-footer\";a:0:{}s:14:\"layout-builder\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wpbd_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("102", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("103", "widget_media_image", "a:2:{i:2;a:15:{s:13:\"attachment_id\";i:50;s:3:\"url\";s:93:\"http://gregsonstudios.com/wp-content/uploads/2017/07/GregsonVideoWebsite-White-800-300x77.png\";s:5:\"title\";s:0:\"\";s:4:\"size\";s:6:\"medium\";s:5:\"width\";i:800;s:6:\"height\";i:206;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:4:\"none\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:11:\"image_title\";s:0:\"\";s:17:\"link_target_blank\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("104", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("105", "widget_tag_cloud", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("106", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("107", "cron", "a:36:{i:1516562077;a:2:{s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1516562120;a:1:{s:40:\"jetpack_display_posts_widget_cron_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"minutes_10\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1516562362;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1516562396;a:1:{s:22:\"bpsPro_email_log_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1516562442;a:1:{s:16:\"bpsPro_HPF_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"minutes_15\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1516563217;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1516564800;a:1:{s:16:\"bpsPro_DBB_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1516576154;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516576745;a:1:{s:25:\"sucuriscan_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516577736;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516579260;a:1:{s:26:\"monsterinsights_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516583978;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516594218;a:1:{s:20:\"jp_sitemap_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"sitemap-interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1516597320;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"da100d26230268ea28834096504c70d4\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32102;}}}}i:1516598544;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1516598849;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516599346;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516600177;a:1:{s:33:\"check_plugin_updates-divi-booster\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1516600566;a:1:{s:32:\"check_plugin_updates-divi-switch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1516604470;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516636800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1516642417;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516646660;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1516693768;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"7e28c969b7c8b670c49e5a03da9fa851\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32123;}}}}i:1516770571;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"7ad17691f7dac3514158df4804590e40\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32105;}}}}i:1516794600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"43d92db92d0bc7dd7a30c8f15912e2e5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1516794600;}}}}i:1516866879;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"d1620b3d6ef40c7dbfdddf0af4c1d0fb\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32126;}}}}i:1516944174;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"611d535f6035bb8dde7d56c1e96a3682\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32108;}}}}i:1517040049;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"5993f91a7f9b5b2e9c54b9ab1f9e012f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32129;}}}}i:1517053800;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"9a99e3460a9c28a23b88c1df7ed30d01\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1517053800;}}}}i:1517117608;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"d3fad74130a977fcb8445c25510881f8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32111;}}}}i:1517213022;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"d31823f3451ec7d550f7409e7cbcc4bf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32132;}}}}i:1517291954;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"7d990732e233610eec0a5a1bf7aa0a43\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32114;}}}}i:1517472581;a:1:{s:19:\"publish_future_post\";a:1:{s:32:\"4fcf5838db0f483f63d1428c54ff8031\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:32136;}}}}i:1518673594;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpbd_options` VALUES("108", "loginizer_version", "1.3.8", "yes");
INSERT INTO `wpbd_options` VALUES("109", "loginizer_options", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("110", "loginizer_last_reset", "1511200430", "yes");
INSERT INTO `wpbd_options` VALUES("111", "loginizer_whitelist", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("112", "loginizer_blacklist", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("113", "loginizer_ins_time", "1500528145", "yes");
INSERT INTO `wpbd_options` VALUES("114", "loginizer_promo_time", "-1505102463", "yes");
INSERT INTO `wpbd_options` VALUES("37620", "jetpack_sync_settings_disable", "0", "yes");
INSERT INTO `wpbd_options` VALUES("37622", "jetpack_secrets", "a:2:{s:19:\"jetpack_authorize_2\";a:3:{s:8:\"secret_1\";s:32:\"xpo29xRCtqjwkXxSArjG6MPgA2ptCIkI\";s:8:\"secret_2\";s:32:\"4iSC7AXNJzfpPWz2KzKVkCT5ECVq8Dlq\";s:3:\"exp\";i:1515921912;}s:19:\"jetpack_authorize_1\";a:3:{s:8:\"secret_1\";s:32:\"zjyeiwXEiCMkQjtk7jWF57pMXnwcLosA\";s:8:\"secret_2\";s:32:\"9XlpCi16MurFoBYLbQ2UtHQVtfZKSEOG\";s:3:\"exp\";i:1511300928;}}", "no");
INSERT INTO `wpbd_options` VALUES("11153", "wpseo_sitemap_attachment_cache_validator", "4KBpR", "no");
INSERT INTO `wpbd_options` VALUES("829", "widget_monarchwidget", "a:2:{i:2;a:1:{s:5:\"title\";s:9:\"Follow Us\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("96858", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("123", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1500529402;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wpbd_options` VALUES("144", "recently_activated", "a:2:{s:49:\"wordpress-ping-optimizer/cbnet-ping-optimizer.php\";i:1516066960;s:53:\"accelerated-mobile-pages/accelerated-moblie-pages.php\";i:1515908717;}", "yes");
INSERT INTO `wpbd_options` VALUES("146", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("147184", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.9.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.2\";s:7:\"version\";s:5:\"4.9.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1516561836;s:15:\"version_checked\";s:5:\"4.9.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpbd_options` VALUES("149506", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1516556060;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:12:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.2.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:7:\"default\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";s:7:\"default\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:45:\"bulletproof-security/bulletproof-security.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:34:\"w.org/plugins/bulletproof-security\";s:4:\"slug\";s:20:\"bulletproof-security\";s:6:\"plugin\";s:45:\"bulletproof-security/bulletproof-security.php\";s:11:\"new_version\";s:3:\"2.8\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/bulletproof-security/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/bulletproof-security.2.8.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:73:\"https://ps.w.org/bulletproof-security/assets/icon-128x128.png?rev=1731938\";s:7:\"default\";s:73:\"https://ps.w.org/bulletproof-security/assets/icon-128x128.png?rev=1731938\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:75:\"https://ps.w.org/bulletproof-security/assets/banner-772x250.png?rev=1731938\";s:7:\"default\";s:75:\"https://ps.w.org/bulletproof-security/assets/banner-772x250.png?rev=1731938\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.32\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.32.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:7:\"default\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";s:7:\"default\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:39:\"glue-for-yoast-seo-amp/yoastseo-amp.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/glue-for-yoast-seo-amp\";s:4:\"slug\";s:22:\"glue-for-yoast-seo-amp\";s:6:\"plugin\";s:39:\"glue-for-yoast-seo-amp/yoastseo-amp.php\";s:11:\"new_version\";s:5:\"0.4.2\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/glue-for-yoast-seo-amp/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/glue-for-yoast-seo-amp.0.4.2.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:75:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/icon-128x128.png?rev=1502752\";s:2:\"2x\";s:75:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/icon-256x256.png?rev=1502752\";s:7:\"default\";s:75:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/icon-256x256.png?rev=1502752\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:78:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/banner-1544x500.png?rev=1502752\";s:2:\"1x\";s:77:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/banner-772x250.png?rev=1502752\";s:7:\"default\";s:78:\"https://ps.w.org/glue-for-yoast-seo-amp/assets/banner-1544x500.png?rev=1502752\";}s:11:\"banners_rtl\";a:0:{}}s:50:\"google-analytics-for-wordpress/googleanalytics.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:44:\"w.org/plugins/google-analytics-for-wordpress\";s:4:\"slug\";s:30:\"google-analytics-for-wordpress\";s:6:\"plugin\";s:50:\"google-analytics-for-wordpress/googleanalytics.php\";s:11:\"new_version\";s:5:\"6.2.7\";s:3:\"url\";s:61:\"https://wordpress.org/plugins/google-analytics-for-wordpress/\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.6.2.7.zip\";s:5:\"icons\";a:4:{s:2:\"1x\";s:83:\"https://ps.w.org/google-analytics-for-wordpress/assets/icon-128x128.png?rev=1598927\";s:2:\"2x\";s:83:\"https://ps.w.org/google-analytics-for-wordpress/assets/icon-256x256.png?rev=1598927\";s:3:\"svg\";s:75:\"https://ps.w.org/google-analytics-for-wordpress/assets/icon.svg?rev=1598927\";s:7:\"default\";s:75:\"https://ps.w.org/google-analytics-for-wordpress/assets/icon.svg?rev=1598927\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:86:\"https://ps.w.org/google-analytics-for-wordpress/assets/banner-1544x500.png?rev=1598927\";s:2:\"1x\";s:85:\"https://ps.w.org/google-analytics-for-wordpress/assets/banner-772x250.png?rev=1598927\";s:7:\"default\";s:86:\"https://ps.w.org/google-analytics-for-wordpress/assets/banner-1544x500.png?rev=1598927\";}s:11:\"banners_rtl\";a:0:{}}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"5.7.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.7.1.zip\";s:5:\"icons\";a:4:{s:2:\"1x\";s:60:\"https://ps.w.org/jetpack/assets/icon-128x128.png?rev=1791404\";s:2:\"2x\";s:60:\"https://ps.w.org/jetpack/assets/icon-256x256.png?rev=1791404\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";s:7:\"default\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=1791404\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=1791404\";s:7:\"default\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=1791404\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"loginizer/loginizer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/loginizer\";s:4:\"slug\";s:9:\"loginizer\";s:6:\"plugin\";s:23:\"loginizer/loginizer.php\";s:11:\"new_version\";s:5:\"1.3.8\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/loginizer/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/loginizer.1.3.8.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:62:\"https://ps.w.org/loginizer/assets/icon-128x128.png?rev=1381093\";s:2:\"2x\";s:62:\"https://ps.w.org/loginizer/assets/icon-256x256.png?rev=1381093\";s:7:\"default\";s:62:\"https://ps.w.org/loginizer/assets/icon-256x256.png?rev=1381093\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:65:\"https://ps.w.org/loginizer/assets/banner-1544x500.jpg?rev=1517954\";s:2:\"1x\";s:64:\"https://ps.w.org/loginizer/assets/banner-772x250.jpg?rev=1517954\";s:7:\"default\";s:65:\"https://ps.w.org/loginizer/assets/banner-1544x500.jpg?rev=1517954\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"sucuri-scanner/sucuri.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/sucuri-scanner\";s:4:\"slug\";s:14:\"sucuri-scanner\";s:6:\"plugin\";s:25:\"sucuri-scanner/sucuri.php\";s:11:\"new_version\";s:6:\"1.8.11\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/sucuri-scanner/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/sucuri-scanner.1.8.11.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:67:\"https://ps.w.org/sucuri-scanner/assets/icon-128x128.png?rev=1235419\";s:2:\"2x\";s:67:\"https://ps.w.org/sucuri-scanner/assets/icon-256x256.png?rev=1235419\";s:7:\"default\";s:67:\"https://ps.w.org/sucuri-scanner/assets/icon-256x256.png?rev=1235419\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:69:\"https://ps.w.org/sucuri-scanner/assets/banner-772x250.png?rev=1235419\";s:7:\"default\";s:69:\"https://ps.w.org/sucuri-scanner/assets/banner-772x250.png?rev=1235419\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"tawkto-live-chat/tawkto.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/tawkto-live-chat\";s:4:\"slug\";s:16:\"tawkto-live-chat\";s:6:\"plugin\";s:27:\"tawkto-live-chat/tawkto.php\";s:11:\"new_version\";s:5:\"0.3.4\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/tawkto-live-chat/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/tawkto-live-chat.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:69:\"https://ps.w.org/tawkto-live-chat/assets/icon-128x128.png?rev=1371919\";s:2:\"2x\";s:69:\"https://ps.w.org/tawkto-live-chat/assets/icon-256x256.png?rev=1371919\";s:7:\"default\";s:69:\"https://ps.w.org/tawkto-live-chat/assets/icon-256x256.png?rev=1371919\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:71:\"https://ps.w.org/tawkto-live-chat/assets/banner-772x250.png?rev=1370264\";s:7:\"default\";s:71:\"https://ps.w.org/tawkto-live-chat/assets/banner-772x250.png?rev=1370264\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.3.22\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.3.22.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:62:\"https://ps.w.org/wordfence/assets/icon-128x128.png?rev=1457724\";s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=1457724\";s:7:\"default\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=1457724\";}s:7:\"banners\";a:2:{s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.png?rev=1630456\";s:7:\"default\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.png?rev=1630456\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wp-smushit/wp-smush.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/wp-smushit\";s:4:\"slug\";s:10:\"wp-smushit\";s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:11:\"new_version\";s:5:\"2.7.6\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/wp-smushit/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-smushit.2.7.6.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-128x128.jpg?rev=1513049\";s:2:\"2x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-256x256.jpg?rev=1513049\";s:7:\"default\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-256x256.jpg?rev=1513049\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wp-smushit/assets/banner-1544x500.jpg?rev=1642596\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-smushit/assets/banner-772x250.jpg?rev=1642596\";s:7:\"default\";s:66:\"https://ps.w.org/wp-smushit/assets/banner-1544x500.jpg?rev=1642596\";}s:11:\"banners_rtl\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"6.1.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.6.1.1.zip\";s:5:\"icons\";a:4:{s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.png?rev=1550389\";s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=1550389\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1203032\";s:7:\"default\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1203032\";}s:7:\"banners\";a:3:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1695112\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1695112\";s:7:\"default\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1695112\";}s:11:\"banners_rtl\";a:3:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1695112\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1695112\";s:7:\"default\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1695112\";}}}}", "no");
INSERT INTO `wpbd_options` VALUES("151825", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1516601327", "no");
INSERT INTO `wpbd_options` VALUES("151826", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Tue, 16 Jan 2018 23:00:14 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-42530\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/01/wordpress-4-9-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jan 2018 23:00:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5376\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 4.9.2 is now available. This is a security and maintenance release for all versions since WordPress 3.7﻿. We strongly encourage you to update your sites immediately. An XSS vulnerability was discovered in the Flash fallback files in MediaElement, a library that is included with WordPress. Because the Flash files are no longer needed for [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Ian Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3965:\"\n<p>WordPress 4.9.2 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7﻿. We strongly encourage you to update your sites immediately.</p>\n\n\n\n<p>An XSS vulnerability was discovered in the Flash fallback files in MediaElement, a library that is included with WordPress. Because the Flash files are no longer needed for most use cases, they have been removed from WordPress.</p>\n\n\n\n<p>MediaElement has released a new version that contains a fix for the bug, and <a href=\"https://wordpress.org/plugins/mediaelement-flash-fallbacks/\">a WordPress plugin containing the fixed files</a> is available in the plugin repository.</p>\n\n\n\n<p>Thank you to the reporters of this issue for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible security disclosure</a>: <a href=\"https://opnsec.com\">Enguerran Gillier</a> and <a href=\"https://widiz.com/\">Widiz﻿</a>.</p>\n\n\n\n<p>21 other bugs were fixed in WordPress 4.9.2. Particularly of note were:</p>\n\n\n\n<ul>\n    <li>JavaScript errors that prevented saving posts in Firefox have been fixed.</li>\n    <li>The previous taxonomy-agnostic behavior of <code>get_category_link()</code> and <code>category_description()</code> was restored.</li>\n    <li>Switching themes will now attempt to restore previous widget assignments, even when there are no sidebars to map.<br /></li>\n</ul>\n\n\n\n<p>The Codex has <a href=\"https://codex.wordpress.org/Version_4.9.2\">more information about all of the issues fixed in 4.9.2</a>, if you&#x27;d like to learn more.</p>\n\n\n\n<p>﻿<a href=\"https://wordpress.org/download/\"></a><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.2</a> or venture over to Dashboard → Updates and click &quot;Update Now.&quot; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n\n\n<p>Thank you to everyone who contributed to WordPress 4.9.2:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/0x6f0/\">0x6f0</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/chasewg/\">chasewg</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/hardik-amipara/\">Hardik Amipara</a>, <a href=\"https://profiles.wordpress.org/ionvv/\">ionvv</a>, <a href=\"https://profiles.wordpress.org/jaswrks/\">Jason Caldwell</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnschulz/\">johnschulz</a>, <a href=\"https://profiles.wordpress.org/juiiee8487/\">Juhi Patel</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rinkuyadav999/\">Rinku Y</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.﻿<strong></strong><br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5376\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress: December 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/01/the-month-in-wordpress-december-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jan 2018 10:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5424\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:311:\"Activity slowed down in December in the WordPress community, particularly in the last two weeks. However, the month started off with a big event and work pushed forward in a number of key areas of the project. Read on to find out more about what transpired in the WordPress community as 2017 came to a [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4744:\"\n<p>Activity slowed down in December in the WordPress community, particularly in the last two weeks. However, the month started off with a big event and work pushed forward in a number of key areas of the project. Read on to find out more about what transpired in the WordPress community as 2017 came to a close.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordCamp US 2017 Brings the Community Together</h2>\n\n\n\n<p>The latest edition of <a href=\"https://2017.us.wordcamp.org/\">WordCamp US</a> took place last month in Nashville on December 1-3. The event brought together over 1,400 WordPress enthusiasts from around the world, fostering a deeper, more engaged global community.</p>\n\n\n\n<p>While attending a WordCamp is always a unique experience, you can catch up on <a href=\"https://wordpress.tv/event/wordcamp-us-2017/\">the sessions on WordPress.tv</a> and look through <a href=\"https://www.facebook.com/pg/WordCampUSA/photos/?tab=albums\">the event photos on Facebook</a> to get a feel for how it all happened. Of course, <a href=\"https://wordpress.tv/2017/12/04/matt-mullenweg-state-of-the-word-2017/\">Matt Mullenweg’s State of the Word</a> talk is always one of the highlights at this event.</p>\n\n\n\n<p>The next WordCamp US will be held in Nashville again in 2018, but if you would like to see it hosted in your city in 2019 and 2020, then <a href=\"https://make.wordpress.org/community/2017/12/19/apply-to-host-wordcamp-us-2019-2020/\">you have until February 2 to apply</a>.</p>\n\n\n\n<h2>WordPress User Survey Data Is Published</h2>\n\n\n\n<p>Over the last few years, tens of thousands of WordPress users all over the world have filled out the annual WordPress user survey. The results of that survey are used to improve the WordPress project, but that data has mostly remained private. This has changed now and <a href=\"https://wordpress.org/news/2017/12/wordpress-user-survey-data-for-2015-2017/\">the results from the last three surveys are now publicly available</a> for everyone to analyze.</p>\n\n\n\n<p>The data will be useful to anyone involved in WordPress since it provides a detailed look at who uses WordPress and what they do with it — information that can help inform product development decisions across the board.</p>\n\n\n\n<h2>New WordPress.org Team for the Tide Project</h2>\n\n\n\n<p>As announced at WordCamp US, <a href=\"https://make.wordpress.org/tide/2017/12/02/new-home/\">the Tide project is being brought under the WordPress.org umbrella</a> to be managed and developed by the community.</p>\n\n\n\n<p>Tide is a series of automated tests run against every plugin and theme in the directory to help WordPress users make informed decisions about the plugins and themes that they choose to install.</p>\n\n\n\n<p>To get involved in developing Tide, jump into the #tide channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>, and follow <a href=\"https://make.wordpress.org/tide/\">the Tide team blog</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul>\n    <li>If you’re following the development of Gutenberg, or if you want a primer on where it’s headed, then <a href=\"https://wordpress.tv/2017/12/10/morten-rand-hendriksen-gutenberg-and-the-wordpress-of-tomorrow/\">Morten Rand-Hendriksen’s talk from WordCamp US</a> is a must watch.</li>\n    <li>The annual surveys for WordPress <a href=\"https://wordpressdotorg.polldaddy.com/s/2017-annual-meetup-member-survey\">meetup members</a> and <a href=\"https://wordpressdotorg.polldaddy.com/s/2017-annual-meetup-organizer-survey\">meetup organizers</a> are available for people to fill out — if you’re involved in or attend your local meetup group then be sure to complete those.</li>\n    <li>10up has <a href=\"https://distributorplugin.com/\">a brand new plugin in beta</a> that will assist with powerful and flexible content publishing and syndication across WordPress sites.</li>\n    <li><a href=\"https://make.wordpress.org/community/2017/12/07/should-we-change-the-default-wordcamp-theme-to-campsite-2017/\">The Community Team is exploring a move</a> to make the recently developed CampSite theme the default theme for all new WordCamp websites. This is the theme that was developed and employed for <a href=\"https://2017.europe.wordcamp.org\">WordCamp Europe 2017</a>.</li>\n    <li>The team working on the multisite features of WordPress Core has recently published <a href=\"https://make.wordpress.org/core/2017/12/19/multisite-roadmap-published/\">their planned roadmap for development</a>.</li>\n</ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5424\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress User Survey Data for 2015-2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2017/12/wordpress-user-survey-data-for-2015-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Dec 2017 21:40:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"WrapUp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"For many years, we&#8217;ve invited folks to tell us how they use WordPress by filling out an annual survey. In the past, interesting results from this survey have been shared in the annual State of the Word address. This year, for the first time, the results of the 2017 survey are being published on WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:64131:\"<p>For many years, we&#8217;ve invited folks to tell us how they use WordPress by filling out an annual survey. In the past, interesting results from this survey have been shared in the annual <a href=\"https://ma.tt/2017/12/state-of-the-word-2017/\">State of the Word</a> address. This year, for the first time, the results of the 2017 survey are being published on WordPress News, along with the results of the 2015 and 2016 survey.</p>\n<p>So that information from the survey doesn&#8217;t reveal anything that respondents might consider private, we do not publish a full export of the raw data. We’d love to make this information as accessible as possible, though, so if you have a suggestion for an OS project or tool we can put the data into that allows people to play with it that still protects individual response privacy, please leave a comment on this post!</p>\n<h4>Major Groups</h4>\n<p>This survey features multiple groups, dividing respondents at the first question:</p>\n<blockquote><p>Which of the following best describes how you use WordPress? (<em>Mandatory</em>)</p></blockquote>\n<p>Those who selected &#8220;I&#8217;m a designer or developer, or I work for a company that designs/develops websites; I use WordPress to build websites and/or blogs for others. (This might include theme development, writing plugins, or other custom work.)&#8221; were served questions from what we&#8217;ll call the &#8220;WordPress Professionals&#8221; group.</p>\n<p>This &#8220;WordPress Professionals&#8221; group is further divided into WordPress Company and WordPress Freelancer/Hobbyist groups, based on how the respondent answered the question, &#8220;Which of the following best describes your involvement with WordPress? (2015) / Do you work for a company, or on your own? (2016-17).&#8221;</p>\n<p>Those who selected &#8220;I own, run, or contribute to a blog or website that is built with WordPress.&#8221; were served questions in what we&#8217;re calling the &#8220;WordPress Users&#8221; group.</p>\n<p>The relevant survey group is noted in each table below. In the case of questions that were served to different groups in 2015 but then served to all respondents in 2016 and 2017, the group responses from 2015 have been consolidated into one set of data for easier comparison between years.</p>\n<h4>Survey results</h4>\n<p><a href=\"#pro\">Jump to answers from WordPress Professionals</a></p>\n<p><a href=\"#user\">Jump to answers from WordPress Users</a></p>\n<p><a href=\"#all\">Jump to answers from All Respondents</a></p>\n<p><!--td {border: 1px solid #ccc;}br {mso-data-placement:same-cell;}--></p>\n<h3>Which of the following best describes how you use WordPress? (Mandatory)</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td>Number of responses (since this question was mandatory, the number of responses here is the total number for the survey)</td>\n<td>45,995</td>\n<td></td>\n<td>15,585</td>\n<td></td>\n<td>16,029</td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;m a designer or developer, or I work for a company that designs/develops websites; I use WordPress to build websites and/or blogs for others. (This might include theme development, writing plugins, other custom work.)</td>\n<td>26,662</td>\n<td>58%</td>\n<td>8,838</td>\n<td>57%</td>\n<td>9,099</td>\n<td>57%</td>\n</tr>\n<tr>\n<td>I own, run, or contribute to a blog or website that is built with WordPress.</td>\n<td>16,130</td>\n<td>35%</td>\n<td>5,293</td>\n<td>34%</td>\n<td>5,625</td>\n<td>35%</td>\n</tr>\n<tr>\n<td>Neither of the above.</td>\n<td>3,204</td>\n<td>7%</td>\n<td>1,460</td>\n<td>9%</td>\n<td>1,306</td>\n<td>8%</td>\n</tr>\n</tbody>\n</table>\n<h2 id=\"pro\">WordPress Professionals</h2>\n<h3><strong>Which of the following best describes your involvement with WordPress? (Mandatory, 2015) / Do you work for a company, or on your own? (Mandatory, 2016-17)</strong></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Professional</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>26,699</td>\n<td></td>\n<td>8,838</td>\n<td></td>\n<td>9,101</td>\n<td></td>\n</tr>\n<tr>\n<td>My primary job is working for a company or organization that uses WordPress.</td>\n<td>9,505</td>\n<td>36%</td>\n<td>3,529</td>\n<td>40%</td>\n<td>3,660</td>\n<td>40%</td>\n</tr>\n<tr>\n<td>My primary job is as a self-employed designer or developer that uses WordPress.</td>\n<td>9,310</td>\n<td>35%</td>\n<td>3,188</td>\n<td>36%</td>\n<td>3,440</td>\n<td>38%</td>\n</tr>\n<tr>\n<td>I earn money from part-time or occasional freelance work involving WordPress.</td>\n<td>5,954</td>\n<td>22%</td>\n<td>1,633</td>\n<td>18%</td>\n<td>1,590</td>\n<td>17%</td>\n</tr>\n<tr>\n<td>Work that I do involving WordPress is just a hobby, I don&#8217;t make money from it.</td>\n<td>1,930</td>\n<td>7%</td>\n<td>491</td>\n<td>6%</td>\n<td>411</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h3>How does your company or organization work with WordPress?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>9,342</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Build/design and/or maintain websites or blogs for other people, companies, or organizations.</td>\n<td>7,772</td>\n<td>27%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Develop or customize themes.</td>\n<td>5,404</td>\n<td>19%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Build/design and/or maintain websites or blogs for my own use.</td>\n<td>4,733</td>\n<td>16%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Host websites for customers.</td>\n<td>4,397</td>\n<td>15%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Develop or distribute plugins.</td>\n<td>3,181</td>\n<td>11%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Provide educational resources to help others to use WordPress.</td>\n<td>1,349</td>\n<td>5%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Sponsor and/or attend WordCamps.</td>\n<td>1,127</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Contribute bug reports and/or patches to WordPress core.</td>\n<td>914</td>\n<td>3%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>182</td>\n<td> 1%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>3,457</td>\n<td></td>\n<td>3,598</td>\n<td></td>\n</tr>\n<tr>\n<td>We make websites for others.</td>\n<td></td>\n<td></td>\n<td>2,695</td>\n<td>24%</td>\n<td>2,722</td>\n<td>23%</td>\n</tr>\n<tr>\n<td>We make websites for ourselves.</td>\n<td></td>\n<td></td>\n<td>2,355</td>\n<td>21%</td>\n<td>2,470</td>\n<td>21%</td>\n</tr>\n<tr>\n<td>We develop or customize themes.</td>\n<td></td>\n<td></td>\n<td>1,866</td>\n<td>16%</td>\n<td>1,910</td>\n<td>16%</td>\n</tr>\n<tr>\n<td>We host websites for others.</td>\n<td></td>\n<td></td>\n<td>1,564</td>\n<td>14%</td>\n<td>1,595</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>We develop or distribute plugins.</td>\n<td></td>\n<td></td>\n<td>1,283</td>\n<td>11%</td>\n<td>1,342</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>We provide educational resources to help others to use WordPress.</td>\n<td></td>\n<td></td>\n<td>581</td>\n<td>5%</td>\n<td>631</td>\n<td>5%</td>\n</tr>\n<tr>\n<td>We sponsor and/or attend WordCamps.</td>\n<td></td>\n<td></td>\n<td>561</td>\n<td>5%</td>\n<td>579</td>\n<td>5%</td>\n</tr>\n<tr>\n<td>We contribute bug reports and/or patches to WordPress core.</td>\n<td></td>\n<td></td>\n<td>444</td>\n<td>4%</td>\n<td>468</td>\n<td>4%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td></td>\n<td></td>\n<td>98</td>\n<td>1%</td>\n<td>96</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<p><strong>How would you describe the business of your typical client(s)? (2015) / How would you describe the business of your typical client/customer? (2016, 2017)</strong></p>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>9,154</td>\n<td></td>\n<td>3,317</td>\n<td></td>\n<td>3,498</td>\n<td></td>\n</tr>\n<tr>\n<td>Small business</td>\n<td>6,893</td>\n<td>32%</td>\n<td>2,398</td>\n<td>31%</td>\n<td>2,510</td>\n<td>31%</td>\n</tr>\n<tr>\n<td>Large business or Enterprise</td>\n<td>3,635</td>\n<td>17%</td>\n<td>1,361</td>\n<td>18%</td>\n<td>1,447</td>\n<td>18%</td>\n</tr>\n<tr>\n<td>Non-profit</td>\n<td>2,644</td>\n<td>12%</td>\n<td>934</td>\n<td>12%</td>\n<td>992</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>Individual</td>\n<td>2,600</td>\n<td>12%</td>\n<td>888</td>\n<td>12%</td>\n<td>1,022</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>Education</td>\n<td>2,344</td>\n<td>11%</td>\n<td>854</td>\n<td>11%</td>\n<td>966</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>Website development (sub-contracting)</td>\n<td>2,065</td>\n<td>10%</td>\n<td>637</td>\n<td>8%</td>\n<td>677</td>\n<td>8%</td>\n</tr>\n<tr>\n<td>Government</td>\n<td>1,410</td>\n<td>6%</td>\n<td>524</td>\n<td>7%</td>\n<td>552</td>\n<td>7%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>127</td>\n<td>1%</td>\n<td>66</td>\n<td>1%</td>\n<td>64</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<p><strong>How does your company or organization use WordPress when developing websites? (2015) / When making websites, how does your company or organization use WordPress? (2016, 2017)</strong></p>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>9,078</td>\n<td></td>\n<td>3,369</td>\n<td></td>\n<td>3,552</td>\n<td></td>\n</tr>\n<tr>\n<td>Mostly as a content management system (CMS)</td>\n<td>6,361</td>\n<td>70%</td>\n<td>2,482</td>\n<td>74%</td>\n<td>2,640</td>\n<td>74%</td>\n</tr>\n<tr>\n<td>About half the time as a blogging platform and half the time as a CMS</td>\n<td>1,222</td>\n<td>13%</td>\n<td>370</td>\n<td>11%</td>\n<td>383</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>Mostly as a blogging platform</td>\n<td>721</td>\n<td>8%</td>\n<td>137</td>\n<td>4%</td>\n<td>129</td>\n<td>4%</td>\n</tr>\n<tr>\n<td>Mostly as an application framework</td>\n<td>629</td>\n<td>7%</td>\n<td>303</td>\n<td>9%</td>\n<td>303</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>145</td>\n<td>2%</td>\n<td>78</td>\n<td>2%</td>\n<td>97</td>\n<td>3%</td>\n</tr>\n</tbody>\n</table>\n<h3>How much is your average WordPress site customized from the original WordPress installation?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>9,054</td>\n<td></td>\n<td>3,302</td>\n<td></td>\n<td>3,473</td>\n<td></td>\n</tr>\n<tr>\n<td>A lot of work has been done, the front end is unrecognizable, but the Dashboard still looks like the usual WordPress interface.</td>\n<td>5,651</td>\n<td>62%</td>\n<td>2,025</td>\n<td>61%</td>\n<td>2,105</td>\n<td>61%</td>\n</tr>\n<tr>\n<td>There&#8217;s a different theme and some plugins have been added.</td>\n<td>2,230</td>\n<td>25%</td>\n<td>799</td>\n<td>24%</td>\n<td>905</td>\n<td>26%</td>\n</tr>\n<tr>\n<td>Not at all, it&#8217;s still pretty much the same as the original download.</td>\n<td>756</td>\n<td>8%</td>\n<td>302</td>\n<td>9%</td>\n<td>298</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>You&#8217;d never know this was a WordPress installation, everything (including the admin) has been customized.</td>\n<td>417</td>\n<td>5%</td>\n<td>177</td>\n<td>5%</td>\n<td>165</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h3>Roughly how many currently active WordPress sites has your company or organization built?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>8,801</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>200 +</td>\n<td>1,074</td>\n<td>12%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>51 &#8211; 200</td>\n<td>1,721</td>\n<td>20%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>21 &#8211; 50</td>\n<td>1,718</td>\n<td>20%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>11 &#8211; 20</td>\n<td>1,284</td>\n<td>15%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>6 &#8211; 10</td>\n<td>1,109</td>\n<td>13%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>2 &#8211; 5</td>\n<td>1,418</td>\n<td>16%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>1</td>\n<td>390</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>0</td>\n<td>87</td>\n<td>1%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>3,358</td>\n<td></td>\n<td>3,540</td>\n<td></td>\n</tr>\n<tr>\n<td>Thousands.</td>\n<td></td>\n<td></td>\n<td>291</td>\n<td>9%</td>\n<td>331</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Hundreds.</td>\n<td></td>\n<td></td>\n<td>770</td>\n<td>23%</td>\n<td>894</td>\n<td>25%</td>\n</tr>\n<tr>\n<td>Fewer than a hundred.</td>\n<td></td>\n<td></td>\n<td>1,144</td>\n<td>34%</td>\n<td>1,177</td>\n<td>33%</td>\n</tr>\n<tr>\n<td>Just a few, but they are really great.</td>\n<td></td>\n<td></td>\n<td>926</td>\n<td>28%</td>\n<td>896</td>\n<td>25%</td>\n</tr>\n<tr>\n<td>Prefer not to answer.</td>\n<td></td>\n<td></td>\n<td>228</td>\n<td>7%</td>\n<td>242</td>\n<td>7%</td>\n</tr>\n</tbody>\n</table>\n<h3>How many person-hours (of your company&#8217;s work) does the typical site take to complete?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>9,091</td>\n<td></td>\n<td>3,353</td>\n<td></td>\n<td>3,522</td>\n<td></td>\n</tr>\n<tr>\n<td>More than 200</td>\n<td>939</td>\n<td>10%</td>\n<td>309</td>\n<td>9%</td>\n<td>325</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>100 &#8211; 200</td>\n<td>1080</td>\n<td>12%</td>\n<td>329</td>\n<td>10%</td>\n<td>367</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>60 &#8211; 100</td>\n<td>1541</td>\n<td>17%</td>\n<td>527</td>\n<td>16%</td>\n<td>513</td>\n<td>15%</td>\n</tr>\n<tr>\n<td>40 &#8211; 60</td>\n<td>1854</td>\n<td>20%</td>\n<td>583</td>\n<td>17%</td>\n<td>620</td>\n<td>18%</td>\n</tr>\n<tr>\n<td>20 &#8211; 40</td>\n<td>2066</td>\n<td>23%</td>\n<td>691</td>\n<td>21%</td>\n<td>685</td>\n<td>19%</td>\n</tr>\n<tr>\n<td>Fewer than 20</td>\n<td>1611</td>\n<td>18%</td>\n<td>479</td>\n<td>14%</td>\n<td>519</td>\n<td>15%</td>\n</tr>\n<tr>\n<td>Prefer not to answer (2016, 2017)</td>\n<td></td>\n<td></td>\n<td>436</td>\n<td>13%</td>\n<td>493</td>\n<td>14%</td>\n</tr>\n</tbody>\n</table>\n<h3>Roughly what percentage of your company or organization&#8217;s output is based around WordPress (as opposed to other platforms or software)?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Company</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>8,950</td>\n<td></td>\n<td>3,345</td>\n<td></td>\n<td>3,503</td>\n<td></td>\n</tr>\n<tr>\n<td>100 %</td>\n<td>1,089</td>\n<td>12%</td>\n<td>438</td>\n<td>13%</td>\n<td>480</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>90 %</td>\n<td>1,043</td>\n<td>12%</td>\n<td>417</td>\n<td>12%</td>\n<td>459</td>\n<td>13%</td>\n</tr>\n<tr>\n<td>80 %</td>\n<td>955</td>\n<td>11%</td>\n<td>367</td>\n<td>11%</td>\n<td>424</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>70 %</td>\n<td>831</td>\n<td>9%</td>\n<td>305</td>\n<td>9%</td>\n<td>344</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>60 %</td>\n<td>534</td>\n<td>6%</td>\n<td>246</td>\n<td>7%</td>\n<td>226</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>50 %</td>\n<td>973</td>\n<td>11%</td>\n<td>335</td>\n<td>10%</td>\n<td>338</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>40 %</td>\n<td>613</td>\n<td>7%</td>\n<td>245</td>\n<td>7%</td>\n<td>202</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>30 %</td>\n<td>877</td>\n<td>10%</td>\n<td>335</td>\n<td>10%</td>\n<td>310</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>20 %</td>\n<td>806</td>\n<td>9%</td>\n<td>242</td>\n<td>7%</td>\n<td>280</td>\n<td>8%</td>\n</tr>\n<tr>\n<td>10 %</td>\n<td>1,039</td>\n<td>12%</td>\n<td>344</td>\n<td>10%</td>\n<td>348</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>0 %</td>\n<td>190</td>\n<td>2%</td>\n<td>72</td>\n<td>2%</td>\n<td>92</td>\n<td>3%</td>\n</tr>\n</tbody>\n</table>\n<h3>In which of the following ways do you work with WordPress?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>17,009</td>\n<td></td>\n<td>5,221</td>\n<td></td>\n<td>5,425</td>\n<td></td>\n</tr>\n<tr>\n<td>Build/design and/or maintain websites or blogs for other people, companies, or organizations</td>\n<td>15,342</td>\n<td>34%</td>\n<td>4,795</td>\n<td>34%</td>\n<td>5,064</td>\n<td>34%</td>\n</tr>\n<tr>\n<td>Develop or customize themes</td>\n<td>10,549</td>\n<td>24%</td>\n<td>2,997</td>\n<td>21%</td>\n<td>3,021</td>\n<td>20%</td>\n</tr>\n<tr>\n<td>Host websites for customers</td>\n<td>8,142</td>\n<td>18%</td>\n<td>2,466</td>\n<td>17%</td>\n<td>2,728</td>\n<td>18%</td>\n</tr>\n<tr>\n<td>Develop or distribute plugins</td>\n<td>4,125</td>\n<td>9%</td>\n<td>1,395</td>\n<td>10%</td>\n<td>1,416</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Provide educational resources to help others to use WordPress</td>\n<td>3,276</td>\n<td>7%</td>\n<td>1,187</td>\n<td>8%</td>\n<td>1,308</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Sponsor and/or attend WordCamps</td>\n<td>1,559</td>\n<td>4%</td>\n<td>648</td>\n<td>5%</td>\n<td>724</td>\n<td>5%</td>\n</tr>\n<tr>\n<td>Contribute bug reports and/or patches to WordPress core</td>\n<td>1,107</td>\n<td>2%</td>\n<td>381</td>\n<td>3%</td>\n<td>393</td>\n<td>3%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>389</td>\n<td>1%</td>\n<td>243</td>\n<td>2%</td>\n<td>299</td>\n<td>2%</td>\n</tr>\n</tbody>\n</table>\n<h3>How would you describe the business of your typical client(s)?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,863</td>\n<td></td>\n<td>5,151</td>\n<td></td>\n<td>5,353</td>\n<td></td>\n</tr>\n<tr>\n<td>Small business</td>\n<td>14,185</td>\n<td>35%</td>\n<td>4,342</td>\n<td>35%</td>\n<td>4,622</td>\n<td>36%</td>\n</tr>\n<tr>\n<td>Individual</td>\n<td>8,513</td>\n<td>21%</td>\n<td>2,581</td>\n<td>21%</td>\n<td>2,583</td>\n<td>20%</td>\n</tr>\n<tr>\n<td>Non-profit</td>\n<td>6,585</td>\n<td>16%</td>\n<td>2,004</td>\n<td>16%</td>\n<td>2,113</td>\n<td>16%</td>\n</tr>\n<tr>\n<td>Website development (sub-contracting)</td>\n<td>4,301</td>\n<td>11%</td>\n<td>1,258</td>\n<td>10%</td>\n<td>1,216</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Education</td>\n<td>3,458</td>\n<td>8%</td>\n<td>1,049</td>\n<td>8%</td>\n<td>1,139</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Large business or Enterprise</td>\n<td>2,391</td>\n<td>6%</td>\n<td>805</td>\n<td>6%</td>\n<td>857</td>\n<td>7%</td>\n</tr>\n<tr>\n<td>Government</td>\n<td>1,150</td>\n<td>3%</td>\n<td>300</td>\n<td>2%</td>\n<td>329</td>\n<td>3%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>173</td>\n<td>0%</td>\n<td>101</td>\n<td>1%</td>\n<td>99</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<h3>How do you use WordPress in your development?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,768</td>\n<td></td>\n<td>5,145</td>\n<td></td>\n<td>5,372</td>\n<td></td>\n</tr>\n<tr>\n<td>Mostly as a content management system (CMS)</td>\n<td>11,754</td>\n<td>70%</td>\n<td>3,641</td>\n<td>71%</td>\n<td>3,959</td>\n<td>74%</td>\n</tr>\n<tr>\n<td>About half the time as a blogging platform and half the time as a CMS</td>\n<td>2,825</td>\n<td>17%</td>\n<td>812</td>\n<td>16%</td>\n<td>721</td>\n<td>13%</td>\n</tr>\n<tr>\n<td>Mostly as an application framework</td>\n<td>1,012</td>\n<td>6%</td>\n<td>343</td>\n<td>7%</td>\n<td>344</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>Mostly as a blogging platform</td>\n<td>992</td>\n<td>6%</td>\n<td>246</td>\n<td>5%</td>\n<td>226</td>\n<td>4%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>185</td>\n<td>1%</td>\n<td>105</td>\n<td>2%</td>\n<td>122</td>\n<td>2%</td>\n</tr>\n</tbody>\n</table>\n<h3>How much is your average WordPress site customized from the original WordPress installation?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,699</td>\n<td></td>\n<td>5,131</td>\n<td></td>\n<td>5,317</td>\n<td></td>\n</tr>\n<tr>\n<td>A lot of work has been done, the front end is unrecognizable, but the Dashboard still looks like the usual WordPress interface.</td>\n<td>9,457</td>\n<td>57%</td>\n<td>2,837</td>\n<td>55%</td>\n<td>2,998</td>\n<td>56%</td>\n</tr>\n<tr>\n<td>There&#8217;s a different theme and some plugins have been added.</td>\n<td>5,526</td>\n<td>33%</td>\n<td>1,694</td>\n<td>33%</td>\n<td>1,781</td>\n<td>34%</td>\n</tr>\n<tr>\n<td>Not at all, it&#8217;s still pretty much the same as the original download.</td>\n<td>977</td>\n<td>6%</td>\n<td>341</td>\n<td>7%</td>\n<td>310</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>You&#8217;d never know this was a WordPress installation, everything (including the admin) has been customized.</td>\n<td>739</td>\n<td>4%</td>\n<td>261</td>\n<td>5%</td>\n<td>228</td>\n<td>4%</td>\n</tr>\n</tbody>\n</table>\n<h3>How many currently active WordPress sites have you built? (2015) / Roughly how many currently active WordPress sites have you built? (2016, 2017)</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,690</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>200 +</td>\n<td>514</td>\n<td>3%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>51 &#8211; 200</td>\n<td>1,728</td>\n<td>10%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>21 &#8211; 50</td>\n<td>3,000</td>\n<td>18%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>11 &#8211; 20</td>\n<td>3,146</td>\n<td>19%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>6 &#8211; 10</td>\n<td>3,405</td>\n<td>20%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>2 &#8211; 5</td>\n<td>3,838</td>\n<td>23%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>1</td>\n<td>698</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>0</td>\n<td>361</td>\n<td>2%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>5,165</td>\n<td></td>\n<td>5367</td>\n<td></td>\n</tr>\n<tr>\n<td>Thousands.</td>\n<td></td>\n<td></td>\n<td>110</td>\n<td>2%</td>\n<td>104</td>\n<td>2%</td>\n</tr>\n<tr>\n<td>Hundreds.</td>\n<td></td>\n<td></td>\n<td>603</td>\n<td>12%</td>\n<td>713</td>\n<td>13%</td>\n</tr>\n<tr>\n<td>Fewer than a hundred.</td>\n<td></td>\n<td></td>\n<td>2,264</td>\n<td>44%</td>\n<td>2,457</td>\n<td>46%</td>\n</tr>\n<tr>\n<td>Just a few, but they are really great.</td>\n<td></td>\n<td></td>\n<td>1,871</td>\n<td>36%</td>\n<td>1,813</td>\n<td>34%</td>\n</tr>\n<tr>\n<td>Prefer not to answer.</td>\n<td></td>\n<td></td>\n<td>319</td>\n<td>6%</td>\n<td>280</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h3>Roughly what percentage of your working time is spent working with WordPress?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,658</td>\n<td></td>\n<td>5,039</td>\n<td></td>\n<td>5,241</td>\n<td></td>\n</tr>\n<tr>\n<td>100 %</td>\n<td>949</td>\n<td>6%</td>\n<td>459</td>\n<td>9%</td>\n<td>461</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>90 %</td>\n<td>1,300</td>\n<td>8%</td>\n<td>527</td>\n<td>10%</td>\n<td>540</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>80 %</td>\n<td>1,784</td>\n<td>11%</td>\n<td>637</td>\n<td>13%</td>\n<td>711</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>70 %</td>\n<td>1,850</td>\n<td>11%</td>\n<td>608</td>\n<td>12%</td>\n<td>627</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>60 %</td>\n<td>1,313</td>\n<td>8%</td>\n<td>438</td>\n<td>9%</td>\n<td>465</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>50 %</td>\n<td>2,095</td>\n<td>13%</td>\n<td>612</td>\n<td>12%</td>\n<td>639</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>40 %</td>\n<td>1,438</td>\n<td>9%</td>\n<td>391</td>\n<td>8%</td>\n<td>384</td>\n<td>7%</td>\n</tr>\n<tr>\n<td>30 %</td>\n<td>2,076</td>\n<td>12%</td>\n<td>530</td>\n<td>11%</td>\n<td>511</td>\n<td>10%</td>\n</tr>\n<tr>\n<td>20 %</td>\n<td>1,743</td>\n<td>10%</td>\n<td>445</td>\n<td>9%</td>\n<td>429</td>\n<td>8%</td>\n</tr>\n<tr>\n<td>10 %</td>\n<td>1,819</td>\n<td>11%</td>\n<td>342</td>\n<td>7%</td>\n<td>419</td>\n<td>8%</td>\n</tr>\n<tr>\n<td>0 %</td>\n<td>291</td>\n<td>2%</td>\n<td>52</td>\n<td>1%</td>\n<td>55</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<h3>How many hours of your work does the typical site take to complete? (2015) / How many hours of work does your typical WordPress project take to launch? (2016, 2017)</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Freelancer/Hobbyist</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>16,670</td>\n<td></td>\n<td>5,164</td>\n<td></td>\n<td>5,378</td>\n<td></td>\n</tr>\n<tr>\n<td>More than 200</td>\n<td>503</td>\n<td>3%</td>\n<td>222</td>\n<td>4%</td>\n<td>245</td>\n<td>5%</td>\n</tr>\n<tr>\n<td>100 &#8211; 200</td>\n<td>973</td>\n<td>6%</td>\n<td>386</td>\n<td>7%</td>\n<td>393</td>\n<td>7%</td>\n</tr>\n<tr>\n<td>60 &#8211; 100</td>\n<td>2,277</td>\n<td>14%</td>\n<td>788</td>\n<td>15%</td>\n<td>815</td>\n<td>15%</td>\n</tr>\n<tr>\n<td>40 &#8211; 60</td>\n<td>3,896</td>\n<td>23%</td>\n<td>1,153</td>\n<td>22%</td>\n<td>1,216</td>\n<td>23%</td>\n</tr>\n<tr>\n<td>20 &#8211; 40</td>\n<td>6,068</td>\n<td>36%</td>\n<td>1,487</td>\n<td>29%</td>\n<td>1,582</td>\n<td>29%</td>\n</tr>\n<tr>\n<td>Fewer than 20</td>\n<td>2,953</td>\n<td>18%</td>\n<td>712</td>\n<td>14%</td>\n<td>751</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>Prefer not to answer</td>\n<td></td>\n<td></td>\n<td>418</td>\n<td>8%</td>\n<td>376</td>\n<td>7%</td>\n</tr>\n</tbody>\n</table>\n<h3>Which of the following have you done with WordPress?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" /> </colgroup>\n</table>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Professional (Company/Freelancer/Hobbyist)</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>20,687</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I’ve written a theme from scratch.</td>\n<td>11,894</td>\n<td>25%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I’ve written a plugin.</td>\n<td>9,719</td>\n<td>21%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve answered a question in the WordPress forum.</td>\n<td>8,805</td>\n<td>19%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve attended a WordPress meetup.</td>\n<td>4,062</td>\n<td>9%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve submitted a WordPress bug report.</td>\n<td>4,062</td>\n<td>9%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve attended a WordCamp.</td>\n<td>3,571</td>\n<td>8%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve contributed to WordPress documentation.</td>\n<td>1,778</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>1,739</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;ve contributed a WordPress core patch.</td>\n<td>1,055</td>\n<td>2%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n</tbody>\n</table>\n<h3>What&#8217;s the best thing about WordPress?<a href=\"#text\">*</a></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Professional</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>22,718</td>\n<td></td>\n<td>7,891</td>\n<td></td>\n<td>8,267</td>\n<td></td>\n</tr>\n<tr>\n<td>Easy/simple/user-friendly</td>\n<td>9,450</td>\n<td>42%</td>\n<td>3,454</td>\n<td>44%</td>\n<td>3,852</td>\n<td>47%</td>\n</tr>\n<tr>\n<td>Customizable/extensible/modular/plugins/themes</td>\n<td>8,601</td>\n<td>38%</td>\n<td>3,116</td>\n<td>39%</td>\n<td>3,555</td>\n<td>43%</td>\n</tr>\n<tr>\n<td>Community/support/documentation/help</td>\n<td>3,806</td>\n<td>17%</td>\n<td>1,211</td>\n<td>15%</td>\n<td>1,340</td>\n<td>16%</td>\n</tr>\n<tr>\n<td>Free/open/open source</td>\n<td>2,291</td>\n<td>10%</td>\n<td>802</td>\n<td>10%</td>\n<td>908</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>Popular/ubiquitous</td>\n<td>249</td>\n<td>1%</td>\n<td>86</td>\n<td>1%</td>\n<td>187</td>\n<td>2%</td>\n</tr>\n</tbody>\n</table>\n<h3> What&#8217;s the most frustrating thing about WordPress?<a href=\"#text\">*</a></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Professional</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>21,144</td>\n<td></td>\n<td>7,294</td>\n<td></td>\n<td>7,691</td>\n<td></td>\n</tr>\n<tr>\n<td>Plugins &amp; themes (abandoned/conflicts/coding standards)</td>\n<td>6,122</td>\n<td>29%</td>\n<td>2,194</td>\n<td>30%</td>\n<td>2,187</td>\n<td>28%</td>\n</tr>\n<tr>\n<td>Security/vulnerabilities/hacks</td>\n<td>2,321</td>\n<td>11%</td>\n<td>712</td>\n<td>10%</td>\n<td>829</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>Updates</td>\n<td>1,544</td>\n<td>7%</td>\n<td>422</td>\n<td>6%</td>\n<td>508</td>\n<td>7%</td>\n</tr>\n<tr>\n<td>Nothing/I don&#8217;t know/can&#8217;t think of anything</td>\n<td>1,276</td>\n<td>6%</td>\n<td>344</td>\n<td>5%</td>\n<td>476</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>Speed/performance/slow/heavy</td>\n<td>1,196</td>\n<td>6%</td>\n<td>644</td>\n<td>9%</td>\n<td>516</td>\n<td>7%</td>\n</tr>\n</tbody>\n</table>\n<h3>WordPress is as good as, or better than, its main competitors.</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress Professional</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (this question was not asked in the 2015 survey)</td>\n<td></td>\n<td></td>\n<td>8,672</td>\n<td></td>\n<td>9,059</td>\n<td></td>\n</tr>\n<tr>\n<td>Agree</td>\n<td></td>\n<td></td>\n<td>7551</td>\n<td>87%</td>\n<td>7836</td>\n<td>87%</td>\n</tr>\n<tr>\n<td>Prefer not to answer</td>\n<td></td>\n<td></td>\n<td>754</td>\n<td>9%</td>\n<td>795</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Disagree</td>\n<td></td>\n<td></td>\n<td>370</td>\n<td>4%</td>\n<td>428</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h2 id=\"user\">WordPress Users</h2>\n<h3>Which of the following describes how you use WordPress?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>15,169</td>\n<td></td>\n<td>5,043</td>\n<td></td>\n<td>5,521</td>\n<td></td>\n</tr>\n<tr>\n<td>My personal blog (or blogs) uses WordPress.</td>\n<td>9,395</td>\n<td>36%</td>\n<td>3,117</td>\n<td>36%</td>\n<td>3,424</td>\n<td>36%</td>\n</tr>\n<tr>\n<td>My company or organization&#8217;s website is built with WordPress software.</td>\n<td>7,480</td>\n<td>29%</td>\n<td>2,519</td>\n<td>29%</td>\n<td>2,841</td>\n<td>30%</td>\n</tr>\n<tr>\n<td>I have a hobby or side project that has a website built with WordPress.</td>\n<td>6,112</td>\n<td>23%</td>\n<td>1,973</td>\n<td>23%</td>\n<td>2,200</td>\n<td>23%</td>\n</tr>\n<tr>\n<td>I write (or otherwise work) for an online publication that uses WordPress.</td>\n<td>2,329</td>\n<td>9%</td>\n<td>806</td>\n<td>9%</td>\n<td>821</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>872</td>\n<td>3%</td>\n<td>234</td>\n<td>3%</td>\n<td>288</td>\n<td>3%</td>\n</tr>\n</tbody>\n</table>\n<h3>Who installed your WordPress website?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>15,055</td>\n<td></td>\n<td>5,020</td>\n<td></td>\n<td>5,523</td>\n<td></td>\n</tr>\n<tr>\n<td>I did.</td>\n<td>11,216</td>\n<td>66%</td>\n<td>3,659</td>\n<td>73%</td>\n<td>4,129</td>\n<td>75%</td>\n</tr>\n<tr>\n<td>My hosting provider</td>\n<td>2,236</td>\n<td>13%</td>\n<td>667</td>\n<td>13%</td>\n<td>767</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>An external company</td>\n<td>909</td>\n<td>5%</td>\n<td>182</td>\n<td>4%</td>\n<td>178</td>\n<td>3%</td>\n</tr>\n<tr>\n<td>An internal web person/team or a colleague</td>\n<td>874</td>\n<td>5%</td>\n<td>178</td>\n<td>4%</td>\n<td>191</td>\n<td>3%</td>\n</tr>\n<tr>\n<td>A friend or family member</td>\n<td>787</td>\n<td>5%</td>\n<td>192</td>\n<td>4%</td>\n<td>172</td>\n<td>3%</td>\n</tr>\n<tr>\n<td>I don&#8217;t know</td>\n<td>502</td>\n<td>3%</td>\n<td>145</td>\n<td>3%</td>\n<td>87</td>\n<td>2%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>345</td>\n<td>2%</td>\n<td>n/a</td>\n<td>n/a</td>\n<td>n/a</td>\n<td>n/a</td>\n</tr>\n</tbody>\n</table>\n<h3>How much has the site been customized from the original WordPress installation?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>14,789</td>\n<td></td>\n<td>4,997</td>\n<td></td>\n<td>5,494</td>\n<td></td>\n</tr>\n<tr>\n<td>There&#8217;s a different theme and some plugins have been added.</td>\n<td>7,465</td>\n<td>50%</td>\n<td>2,337</td>\n<td>47%</td>\n<td>2,660</td>\n<td>48%</td>\n</tr>\n<tr>\n<td>A lot of work has been done, the site itself is unrecognizable from the original theme, but the Dashboard still looks like the usual WordPress interface.</td>\n<td>4,715</td>\n<td>32%</td>\n<td>1,707</td>\n<td>34%</td>\n<td>1,872</td>\n<td>34%</td>\n</tr>\n<tr>\n<td>Not at all, it&#8217;s still pretty much the same as it was when I started out.</td>\n<td>1,841</td>\n<td>12%</td>\n<td>635</td>\n<td>13%</td>\n<td>673</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>You&#8217;d never know this was a WordPress installation, everything has been customized.</td>\n<td>768</td>\n<td>5%</td>\n<td>321</td>\n<td>6%</td>\n<td>290</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h3>What&#8217;s the best thing about WordPress?<a href=\"#text\">*</a></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>14,328</td>\n<td></td>\n<td>4,613</td>\n<td></td>\n<td>5,076</td>\n<td></td>\n</tr>\n<tr>\n<td>Easy/simple/user-friendly</td>\n<td>7,391</td>\n<td>52%</td>\n<td>2,276</td>\n<td>49%</td>\n<td>2,511</td>\n<td>49%</td>\n</tr>\n<tr>\n<td>Customizable/extensible/modular/plugins/themes</td>\n<td>4,219</td>\n<td>29%</td>\n<td>1,569</td>\n<td>34%</td>\n<td>1,632</td>\n<td>32%</td>\n</tr>\n<tr>\n<td>Free/open/open source</td>\n<td>1,586</td>\n<td>11%</td>\n<td>493</td>\n<td>11%</td>\n<td>538</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>Community/support/documentation/help</td>\n<td>1,085</td>\n<td>8%</td>\n<td>388</td>\n<td>8%</td>\n<td>458</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Popular/ubiquitous</td>\n<td>223</td>\n<td>2%</td>\n<td>74</td>\n<td>2%</td>\n<td>48</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<h3>What&#8217;s the most frustrating thing about WordPress?<a href=\"#text\">*</a></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td>13,681</td>\n<td></td>\n<td>4,287</td>\n<td></td>\n<td>4,758</td>\n<td></td>\n</tr>\n<tr>\n<td>Plugins &amp; themes (abandoned/conflicts/coding standards)</td>\n<td>2,531</td>\n<td>19%</td>\n<td>1,183</td>\n<td>28%</td>\n<td>1,300</td>\n<td>27%</td>\n</tr>\n<tr>\n<td>Customization/design/look/template</td>\n<td>1,273</td>\n<td>9%</td>\n<td>381</td>\n<td>9%</td>\n<td>408</td>\n<td>9%</td>\n</tr>\n<tr>\n<td>Code/coding/PHP</td>\n<td>931</td>\n<td>7%</td>\n<td>306</td>\n<td>7%</td>\n<td>277</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>Updates</td>\n<td>926</td>\n<td>7%</td>\n<td>209</td>\n<td>5%</td>\n<td>296</td>\n<td>6%</td>\n</tr>\n<tr>\n<td>Security/vulnerabilites/hacks</td>\n<td>785</td>\n<td>6%</td>\n<td>255</td>\n<td>6%</td>\n<td>292</td>\n<td>6%</td>\n</tr>\n</tbody>\n</table>\n<h3>WordPress is as good as, or better than, its main competitors.</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: WordPress User</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>5,026</td>\n<td></td>\n<td>5,498</td>\n<td></td>\n</tr>\n<tr>\n<td>Agree</td>\n<td></td>\n<td></td>\n<td>4,038</td>\n<td>80%</td>\n<td>4,462</td>\n<td>81%</td>\n</tr>\n<tr>\n<td>Prefer not to answer</td>\n<td></td>\n<td></td>\n<td>737</td>\n<td>15%</td>\n<td>782</td>\n<td>14%</td>\n</tr>\n<tr>\n<td>Disagree</td>\n<td></td>\n<td></td>\n<td>254</td>\n<td>5%</td>\n<td>255</td>\n<td>5%</td>\n</tr>\n</tbody>\n</table>\n<h2 id=\"all\">All Respondents</h2>\n<h3>Can you (truthfully!) say &#8220;I make my living from WordPress&#8221;?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All Respondents</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (combination of all three groups from 2015; this question was not broken out by group in 2016-2017)</td>\n<td>42,236</td>\n<td></td>\n<td>14,906</td>\n<td></td>\n<td>15,616</td>\n<td></td>\n</tr>\n<tr>\n<td>Not really, but I do get some or all of my income as a result of working with WordPress.</td>\n<td>16,607</td>\n<td>39%</td>\n<td>5,408</td>\n<td>36%</td>\n<td>5,702</td>\n<td>37%</td>\n</tr>\n<tr>\n<td>Yes.</td>\n<td>9,635</td>\n<td>23%</td>\n<td>4,791</td>\n<td>32%</td>\n<td>5,033</td>\n<td>32%</td>\n</tr>\n<tr>\n<td>No.</td>\n<td>15,995</td>\n<td>38%</td>\n<td>4,713</td>\n<td>32%</td>\n<td>4,882</td>\n<td>31%</td>\n</tr>\n</tbody>\n</table>\n<h3>Which devices do you access WordPress on?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All Respondents</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (combination of all three groups from 2015; this question was not broken out by group in 2016-2017)</td>\n<td>42,433</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Web</td>\n<td>40,503</td>\n<td>95%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Android phone</td>\n<td>15,396</td>\n<td>36%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>iPhone</td>\n<td>12,353</td>\n<td>29%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>iPad</td>\n<td>11,748</td>\n<td>28%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Android tablet</td>\n<td>9,223</td>\n<td>22%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Desktop app, like MarsEdit</td>\n<td>6,018</td>\n<td>14%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td>1837</td>\n<td>4%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (this question was not broken out by group in 2016-2017)</td>\n<td></td>\n<td></td>\n<td>14,840</td>\n<td></td>\n<td>15,597</td>\n<td></td>\n</tr>\n<tr>\n<td>Web browser on a desktop or laptop</td>\n<td></td>\n<td></td>\n<td>14,160</td>\n<td>54%</td>\n<td>15,052</td>\n<td>55%</td>\n</tr>\n<tr>\n<td>Web browser on a mobile device (tablet or phone)</td>\n<td></td>\n<td></td>\n<td>7,952</td>\n<td>30%</td>\n<td>8,248</td>\n<td>30%</td>\n</tr>\n<tr>\n<td>An app on a mobile device (table or phone)</td>\n<td></td>\n<td></td>\n<td>3,309</td>\n<td>13%</td>\n<td>3,311</td>\n<td>12%</td>\n</tr>\n<tr>\n<td>A desktop app like MarsEdit</td>\n<td></td>\n<td></td>\n<td>517</td>\n<td>2%</td>\n<td>498</td>\n<td>2%</td>\n</tr>\n<tr>\n<td>Other Option</td>\n<td></td>\n<td></td>\n<td>282</td>\n<td>1%</td>\n<td>240</td>\n<td>1%</td>\n</tr>\n</tbody>\n</table>\n<h3>WordPress now updates minor &amp; security releases automatically for you. Check all that apply: (question not asked in 2016, 2017)</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"36\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All Respondents</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (combination of all three groups)</td>\n<td>39,726</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I love auto-updates.</td>\n<td>17,367</td>\n<td>44%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;d like to see auto-updates for plugins.</td>\n<td>12,796</td>\n<td>32%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Initially, I was nervous about auto updates.</td>\n<td>11,868</td>\n<td>30%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Auto updates still make me nervous.</td>\n<td>10,809</td>\n<td>27%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Auto updates don&#8217;t make me nervous now.</td>\n<td>10,708</td>\n<td>27%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;d like to see auto-updates for themes.</td>\n<td>10,449</td>\n<td>26%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I&#8217;d like to see auto updates for major versions of WordPress.</td>\n<td>10,225</td>\n<td>26%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>This is the first I&#8217;ve heard of auto-updates.</td>\n<td>8,660</td>\n<td>22%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>I hate auto-updates.</td>\n<td>3,293</td>\n<td>8%</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n</tbody>\n</table>\n<h3>What is your gender?<a href=\"#text\">*</a></h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All respondents (This question was not asked in the 2015 survey.)</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>13,953</td>\n<td></td>\n<td>14,680</td>\n<td></td>\n</tr>\n<tr>\n<td>Male</td>\n<td></td>\n<td></td>\n<td>10,978</td>\n<td>78.68%</td>\n<td>11,570</td>\n<td>78.81%</td>\n</tr>\n<tr>\n<td>Female</td>\n<td></td>\n<td></td>\n<td>2,340</td>\n<td>16.77%</td>\n<td>2,511</td>\n<td>21.70%</td>\n</tr>\n<tr>\n<td>Prefer not to answer</td>\n<td></td>\n<td></td>\n<td>601</td>\n<td>4.31%</td>\n<td>562</td>\n<td>3.83%</td>\n</tr>\n<tr>\n<td>Transgender</td>\n<td></td>\n<td></td>\n<td>11</td>\n<td>0.08%</td>\n<td>8</td>\n<td>0.05%</td>\n</tr>\n<tr>\n<td>Nonbinary</td>\n<td></td>\n<td></td>\n<td>8</td>\n<td>0.06%</td>\n<td>17</td>\n<td>0.12%</td>\n</tr>\n<tr>\n<td>Genderqueer</td>\n<td></td>\n<td></td>\n<td>4</td>\n<td>0.03%</td>\n<td>3</td>\n<td>0.02%</td>\n</tr>\n<tr>\n<td>Androgynous</td>\n<td></td>\n<td></td>\n<td>6</td>\n<td>0.04%</td>\n<td>5</td>\n<td>0.03%</td>\n</tr>\n<tr>\n<td>Fluid</td>\n<td></td>\n<td></td>\n<td>3</td>\n<td>0.02%</td>\n<td>4</td>\n<td>0.03%</td>\n</tr>\n<tr>\n<td>Demimale</td>\n<td></td>\n<td></td>\n<td>2</td>\n<td>0.01%</td>\n<td>0</td>\n<td>0</td>\n</tr>\n</tbody>\n</table>\n<h3>Where are you located?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All respondents (This question was not asked in the 2015 survey.)</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses</td>\n<td></td>\n<td></td>\n<td>14,562</td>\n<td></td>\n<td>15,343</td>\n<td></td>\n</tr>\n<tr>\n<td>United States</td>\n<td></td>\n<td></td>\n<td>3,770</td>\n<td>25.89%</td>\n<td>4,067</td>\n<td>26.51%</td>\n</tr>\n<tr>\n<td>India</td>\n<td></td>\n<td></td>\n<td>1,456</td>\n<td>10.00%</td>\n<td>1,424</td>\n<td>9.28%</td>\n</tr>\n<tr>\n<td>United Kingdom</td>\n<td></td>\n<td></td>\n<td>810</td>\n<td>5.56%</td>\n<td>900</td>\n<td>5.87%</td>\n</tr>\n<tr>\n<td>Germany</td>\n<td></td>\n<td></td>\n<td>555</td>\n<td>3.81%</td>\n<td>729</td>\n<td>4.75%</td>\n</tr>\n<tr>\n<td>Canada</td>\n<td></td>\n<td></td>\n<td>511</td>\n<td>3.51%</td>\n<td>599</td>\n<td>3.90%</td>\n</tr>\n<tr>\n<td>Australia</td>\n<td></td>\n<td></td>\n<td>389</td>\n<td>2.67%</td>\n<td>460</td>\n<td>3.00%</td>\n</tr>\n<tr>\n<td>Italy</td>\n<td></td>\n<td></td>\n<td>298</td>\n<td>2.05%</td>\n<td>356</td>\n<td>2.32%</td>\n</tr>\n<tr>\n<td>Netherlands</td>\n<td></td>\n<td></td>\n<td>343</td>\n<td>2.36%</td>\n<td>350</td>\n<td>2.28%</td>\n</tr>\n<tr>\n<td>France</td>\n<td></td>\n<td></td>\n<td>232</td>\n<td>1.59%</td>\n<td>283</td>\n<td>1.84%</td>\n</tr>\n<tr>\n<td>Bangladesh</td>\n<td></td>\n<td></td>\n<td>257</td>\n<td>1.76%</td>\n<td>263</td>\n<td>1.71%</td>\n</tr>\n<tr>\n<td>Spain</td>\n<td></td>\n<td></td>\n<td>271</td>\n<td>1.86%</td>\n<td>252</td>\n<td>1.64%</td>\n</tr>\n<tr>\n<td>Brazil</td>\n<td></td>\n<td></td>\n<td>239</td>\n<td>1.64%</td>\n<td>251</td>\n<td>1.64%</td>\n</tr>\n<tr>\n<td>Pakistan</td>\n<td></td>\n<td></td>\n<td>254</td>\n<td>1.74%</td>\n<td>240</td>\n<td>1.56%</td>\n</tr>\n<tr>\n<td>Indonesia</td>\n<td></td>\n<td></td>\n<td>230</td>\n<td>1.58%</td>\n<td>226</td>\n<td>1.47%</td>\n</tr>\n<tr>\n<td>Iran, Islamic Republic of</td>\n<td></td>\n<td></td>\n<td>190</td>\n<td>1.30%</td>\n<td>173</td>\n<td>1.13%</td>\n</tr>\n<tr>\n<td>Sweden</td>\n<td></td>\n<td></td>\n<td>144</td>\n<td>0.99%</td>\n<td>173</td>\n<td>1.13%</td>\n</tr>\n<tr>\n<td>Nigeria</td>\n<td></td>\n<td></td>\n<td>196</td>\n<td>1.35%</td>\n<td>172</td>\n<td>1.12%</td>\n</tr>\n<tr>\n<td>South Africa</td>\n<td></td>\n<td></td>\n<td>193</td>\n<td>1.33%</td>\n<td>172</td>\n<td>1.12%</td>\n</tr>\n<tr>\n<td>Russian Federation</td>\n<td></td>\n<td></td>\n<td>181</td>\n<td>1.24%</td>\n<td>151</td>\n<td>0.98%</td>\n</tr>\n<tr>\n<td>Poland</td>\n<td></td>\n<td></td>\n<td>129</td>\n<td>0.89%</td>\n<td>137</td>\n<td>0.89%</td>\n</tr>\n<tr>\n<td>Romania</td>\n<td></td>\n<td></td>\n<td>144</td>\n<td>0.99%</td>\n<td>132</td>\n<td>0.86%</td>\n</tr>\n<tr>\n<td>Switzerland</td>\n<td></td>\n<td></td>\n<td>122</td>\n<td>0.84%</td>\n<td>130</td>\n<td>0.85%</td>\n</tr>\n<tr>\n<td>Philippines</td>\n<td></td>\n<td></td>\n<td>92</td>\n<td>0.63%</td>\n<td>125</td>\n<td>0.81%</td>\n</tr>\n<tr>\n<td>China</td>\n<td></td>\n<td></td>\n<td>136</td>\n<td>0.93%</td>\n<td>123</td>\n<td>0.80%</td>\n</tr>\n<tr>\n<td>Austria</td>\n<td></td>\n<td></td>\n<td>89</td>\n<td>0.61%</td>\n<td>122</td>\n<td>0.80%</td>\n</tr>\n<tr>\n<td>Ukraine</td>\n<td></td>\n<td></td>\n<td>105</td>\n<td>0.72%</td>\n<td>118</td>\n<td>0.77%</td>\n</tr>\n<tr>\n<td>Denmark</td>\n<td></td>\n<td></td>\n<td>107</td>\n<td>0.73%</td>\n<td>114</td>\n<td>0.74%</td>\n</tr>\n<tr>\n<td>Greece</td>\n<td></td>\n<td></td>\n<td>120</td>\n<td>0.82%</td>\n<td>114</td>\n<td>0.74%</td>\n</tr>\n<tr>\n<td>Portugal</td>\n<td></td>\n<td></td>\n<td>94</td>\n<td>0.65%</td>\n<td>109</td>\n<td>0.71%</td>\n</tr>\n<tr>\n<td>Vietnam</td>\n<td></td>\n<td></td>\n<td>101</td>\n<td>0.69%</td>\n<td>108</td>\n<td>0.70%</td>\n</tr>\n<tr>\n<td>Mexico</td>\n<td></td>\n<td></td>\n<td>94</td>\n<td>0.65%</td>\n<td>105</td>\n<td>0.68%</td>\n</tr>\n<tr>\n<td>Nepal</td>\n<td></td>\n<td></td>\n<td>76</td>\n<td>0.52%</td>\n<td>97</td>\n<td>0.63%</td>\n</tr>\n<tr>\n<td>Ireland</td>\n<td></td>\n<td></td>\n<td>72</td>\n<td>0.49%</td>\n<td>94</td>\n<td>0.61%</td>\n</tr>\n<tr>\n<td>Israel</td>\n<td></td>\n<td></td>\n<td>78</td>\n<td>0.54%</td>\n<td>94</td>\n<td>0.61%</td>\n</tr>\n<tr>\n<td>New Zealand</td>\n<td></td>\n<td></td>\n<td>77</td>\n<td>0.53%</td>\n<td>91</td>\n<td>0.59%</td>\n</tr>\n<tr>\n<td>Finland</td>\n<td></td>\n<td></td>\n<td>63</td>\n<td>0.43%</td>\n<td>90</td>\n<td>0.59%</td>\n</tr>\n<tr>\n<td>Turkey</td>\n<td></td>\n<td></td>\n<td>91</td>\n<td>0.62%</td>\n<td>86</td>\n<td>0.56%</td>\n</tr>\n<tr>\n<td>Malaysia</td>\n<td></td>\n<td></td>\n<td>91</td>\n<td>0.62%</td>\n<td>81</td>\n<td>0.53%</td>\n</tr>\n<tr>\n<td>Belgium</td>\n<td></td>\n<td></td>\n<td>84</td>\n<td>0.58%</td>\n<td>79</td>\n<td>0.51%</td>\n</tr>\n<tr>\n<td>Norway</td>\n<td></td>\n<td></td>\n<td>66</td>\n<td>0.45%</td>\n<td>79</td>\n<td>0.51%</td>\n</tr>\n<tr>\n<td>Argentina</td>\n<td></td>\n<td></td>\n<td>65</td>\n<td>0.45%</td>\n<td>76</td>\n<td>0.50%</td>\n</tr>\n<tr>\n<td>Bulgaria</td>\n<td></td>\n<td></td>\n<td>74</td>\n<td>0.51%</td>\n<td>72</td>\n<td>0.47%</td>\n</tr>\n<tr>\n<td>Japan</td>\n<td></td>\n<td></td>\n<td>61</td>\n<td>0.42%</td>\n<td>68</td>\n<td>0.44%</td>\n</tr>\n<tr>\n<td>Thailand</td>\n<td></td>\n<td></td>\n<td>69</td>\n<td>0.47%</td>\n<td>67</td>\n<td>0.44%</td>\n</tr>\n<tr>\n<td>Czech Republic</td>\n<td></td>\n<td></td>\n<td>76</td>\n<td>0.52%</td>\n<td>66</td>\n<td>0.43%</td>\n</tr>\n<tr>\n<td>Serbia</td>\n<td></td>\n<td></td>\n<td>89</td>\n<td>0.61%</td>\n<td>63</td>\n<td>0.41%</td>\n</tr>\n<tr>\n<td>Kenya</td>\n<td></td>\n<td></td>\n<td>58</td>\n<td>0.40%</td>\n<td>62</td>\n<td>0.40%</td>\n</tr>\n<tr>\n<td>Colombia</td>\n<td></td>\n<td></td>\n<td>39</td>\n<td>0.27%</td>\n<td>59</td>\n<td>0.38%</td>\n</tr>\n<tr>\n<td>Egypt</td>\n<td></td>\n<td></td>\n<td>40</td>\n<td>0.27%</td>\n<td>52</td>\n<td>0.34%</td>\n</tr>\n</tbody>\n</table>\n<h3>What is your age?</h3>\n<table dir=\"ltr\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<colgroup>\n<col width=\"554\" />\n<col width=\"47\" />\n<col width=\"36\" />\n<col width=\"47\" />\n<col width=\"51\" />\n<col width=\"47\" />\n<col width=\"51\" /></colgroup>\n<tbody>\n<tr>\n<td></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2015</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2016</strong></td>\n<td style=\"text-align: center\" colspan=\"2\" rowspan=\"1\"><strong>2017</strong></td>\n</tr>\n<tr>\n<td><em>Group: All Respondents</em></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n<tr>\n<td>Number of responses (This question was not asked in 2015.)</td>\n<td></td>\n<td></td>\n<td>14,944</td>\n<td></td>\n<td>15,636</td>\n<td></td>\n</tr>\n<tr>\n<td>60 and over</td>\n<td></td>\n<td></td>\n<td>1,139</td>\n<td>8%</td>\n<td>1,641</td>\n<td>11%</td>\n</tr>\n<tr>\n<td>50-59</td>\n<td></td>\n<td></td>\n<td>1,537</td>\n<td>10%</td>\n<td>1,996</td>\n<td>13%</td>\n</tr>\n<tr>\n<td>40-49</td>\n<td></td>\n<td></td>\n<td>2,205</td>\n<td>15%</td>\n<td>2,643</td>\n<td>17%</td>\n</tr>\n<tr>\n<td>30-39</td>\n<td></td>\n<td></td>\n<td>3,914</td>\n<td>26%</td>\n<td>3,972</td>\n<td>25%</td>\n</tr>\n<tr>\n<td>20-29</td>\n<td></td>\n<td></td>\n<td>5,013</td>\n<td>34%</td>\n<td>4,444</td>\n<td>28%</td>\n</tr>\n<tr>\n<td>Under 20</td>\n<td></td>\n<td></td>\n<td>1142</td>\n<td>8%</td>\n<td>941</td>\n<td>6%</td>\n</tr>\n</tbody>\n</table>\n<p>Thank you to everyone who made time to fill out the survey &#8212; we&#8217;re so happy you use WordPress, and we&#8217;re very grateful that you&#8217;re willing to share your experiences with us! Thanks also to everyone who spread the word about this survey, and to those of you who read all the way to the bottom of this post. <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<p><small><a id=\"text\"></a>*Text Field Questions: Each survey included some questions that could be answered only by filling out a text field. In the case of the questions &#8220;What is the best thing about WordPress?&#8221; and &#8220;What is the most frustrating thing about WordPress?&#8221; we listed the five most common responses, aggregated when applicable. In the case of the question “What is your gender?” in the 2016 and 2017 surveys, we aggregated responses as best we could. Responses meant to obscure respondents’ gender entirely are aggregated in “prefer not to answer.”</small></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress: November 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2017/12/the-month-in-wordpress-november-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Dec 2017 11:00:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5290\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"The WordPress project recently released WordPress 4.9, “Tipton” — a new major release named in honor of musician and band leader Billy Tipton. Read on to find out more about this and other interesting news from around the WordPress world in November. WordPress 4.9 “Tipton” On November 16, WordPress 4.9 was released with new features [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4234:\"\n<p>The WordPress project recently released WordPress 4.9, “Tipton” — a new major release named in honor of musician and band leader Billy Tipton. Read on to find out more about this and other interesting news from around the WordPress world in November.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 4.9 “Tipton”</h2>\n\n\n\n<p>On November 16, <a href=\"https://wordpress.org/news/2017/11/tipton/\">WordPress 4.9 was released</a> with new features for publishers and developers alike. Release highlights include design locking, scheduling, and previews in the Customizer, an even more secure and usable code editing experience, a new gallery widget, and text widget improvements.</p>\n\n\n\n<p>The follow up security and maintenance, v4.9.1, <a href=\"https://wordpress.org/news/2017/11/wordpress-4-9-1-security-and-maintenance-release/\">has now been released</a> to tighten up the security of WordPress as a whole.</p>\n\n\n\n<p>To get involved in building WordPress Core, jump into the #core channel in the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>, and follow<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>.</p>\n\n\n\n<h2>Apply to Speak At WordCamp Europe 2018</h2>\n\n\n\n<p>The next edition of WordCamp Europe takes place in June, 2018. While the organizing team is still in the early stages of planning, <a href=\"https://2018.europe.wordcamp.org/2017/11/15/are-you-ready-to-speak-at-the-largest-wordpress-event-in-europe/\">they are accepting speaker applications</a>.</p>\n\n\n\n<p>WordCamp Europe is the largest WordCamp in the world and, along with WordCamp US, one of the flagship events of the WordCamp program — speaking at this event is a great way to give back to the global WordPress community by sharing your knowledge and expertise with thousands of WordPress enthusiasts.</p>\n\n\n\n<h2>Diversity Outreach Speaker Training Initiative</h2>\n\n\n\n<p>To help WordPress community organizers offer diverse speaker lineups, <a href=\"https://make.wordpress.org/community/2017/11/13/call-for-volunteers-diversity-outreach-speaker-training/\">a new community initiative has kicked off</a> to use existing <a href=\"https://make.wordpress.org/training/handbook/speaker-training/\">speaker training workshops</a> to demystify speaking requirements and help participants gain confidence in their ability to share their WordPress knowledge in a WordCamp session.</p>\n\n\n\n<p>The working group behind this initiative will be meeting regularly to discuss and plan how they can help local communities to train speakers for WordCamps and other events.</p>\n\n\n\n<p>To get involved in this initiative, you can join the meetings at 5pm UTC every other Wednesday in the #community-team channel of the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul>\n    <li><a href=\"https://2017.us.wordcamp.org/\">WordCamp US 2017</a> is happening on December 1-3 in Nashville, with the annual State of the Word talk happening on Saturday afternoon — <a href=\"https://2017.us.wordcamp.org/live-stream/\">the live stream of the entire event is available to view for free</a>.</li>\n    <li><a href=\"https://xwp.co/tide-a-path-to-better-code-across-the-wordpress-ecosystem/\">Tide</a>, a new service from XWP designed to help users make informed plugin choices, is due to launch at WordCamp US.</li>\n    <li>Gutenberg development is continuing rapidly, with <a href=\"https://make.wordpress.org/core/2017/11/28/whats-new-in-gutenberg-28th-november/\">a packed new release</a> and a focus on <a href=\"https://make.wordpress.org/test/2017/11/22/testing-flow-in-gutenberg/\">usability testing</a>.</li>\n    <li>After some discussion among the community, <a href=\"https://make.wordpress.org/community/2017/11/10/discussion-micro-regional-wordcamps/\">a new type of micro-regional WordCamp</a> is going to be introduced into the global WordCamp program.</li>\n</ul>\n\n\n\n<p><em></em></p>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\n\n\n<p><em></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/11/wordpress-4-9-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Nov 2017 20:33:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5215\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 4.9.1 is now available. This is a security and maintenance release for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately. WordPress versions 4.9 and earlier are affected by four security issues which could potentially be exploited as part of a multi-vector attack. As part of the core team&#x27;s [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4287:\"\n<p>WordPress 4.9.1 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n\n\n<p>WordPress versions 4.9 and earlier are affected by four security issues which could potentially be exploited as part of a multi-vector attack. As part of the core team&#x27;s ongoing commitment to security hardening, the following fixes have been implemented in 4.9.1:</p>\n\n\n\n<ol>\n    <li>Use a properly generated hash for the <code>newbloguser</code> key instead of a determinate substring.</li>\n    <li>Add escaping to the language attributes used on <code>html</code> elements.</li>\n    <li>Ensure the attributes of enclosures are correctly escaped in RSS and Atom feeds.</li>\n    <li>Remove the ability to upload JavaScript files for users who do not have the <code>unfiltered_html</code> capability.</li>\n</ol>\n\n\n\n<p>Thank you to the reporters of these issues for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible security disclosure</a>: <a href=\"https://twitter.com/0x62626262\">Rahul Pratap Singh</a> and John Blackbourn.</p>\n\n\n\n<p>Eleven other bugs were fixed in WordPress 4.9.1. Particularly of note were:</p>\n\n\n\n<ul>\n    <li>Issues relating to the caching of theme template files.</li>\n    <li>A MediaElement JavaScript error preventing users of certain languages from being able to upload media files.</li>\n    <li>The inability to edit theme and plugin files on Windows based servers.</li>\n</ul>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2017/11/28/wordpress-4-9-1-scheduled-for-november-29th/\">This post has more information about all of the issues fixed in 4.9.1 if you&#x27;d like to learn more</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.1</a> or venture over to Dashboard → Updates and click &quot;Update Now.&quot; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n\n\n<p>Thank you to everyone who contributed to WordPress 4.9.1:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/edo888/\">edo888</a>, <a href=\"https://profiles.wordpress.org/erich_k4wp/\">Erich Munz</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/ibenic/\">Igor Benic</a>, <a href=\"https://profiles.wordpress.org/jfarthing84/\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyescott/\">jeremyescott</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnpgreen/\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mariovalney/\">Mário Valney</a>, <a href=\"https://profiles.wordpress.org/natacado/\">natacado</a>, <a href=\"https://profiles.wordpress.org/odysseygate/\">odyssey</a>, <a href=\"https://profiles.wordpress.org/precies/\">precies</a>, <a href=\"https://profiles.wordpress.org/stodorovic/\">Saša</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5215\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 4.9 “Tipton”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2017/11/tipton/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Nov 2017 01:16:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4968\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"Announcing version 4.9 of WordPress, named “Tipton” in honor of jazz pianist and band leader Billy Tipton. New features in 4.9 will smooth your design workflow and keep you safe from coding errors. Download or update today!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Mel Choyce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40652:\"<h2 style=\"text-align: center\">Major Customizer Improvements, Code Error Checking, and More!&nbsp;🎉</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2017/11/banner.png?fit=2400%2C1200&amp;ssl=1\" alt=\"\" /></figure>\n\n\n\n<p>Version 4.9 of WordPress, named “Tipton” in honor of jazz musician and band leader Billy Tipton, is available for download or update in your WordPress dashboard. New features in 4.9 will smooth your design workflow and keep you safe from coding errors.</p>\n\n\n\n<p>Featuring design drafts, scheduling, and locking, along with preview links, the Customizer workflow improves collaboration for content creators. What’s more, code syntax highlighting and error checking will make for a clean and smooth site building experience. Finally, if all that wasn’t pretty great, we’ve got an awesome new Gallery widget and improvements to theme browsing and switching.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Customizer Workflow Improved </h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2017/11/customizer-workflow-improved-small.png?w=632&#038;ssl=1\" alt=\"\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>Draft and Schedule Site Design Customizations</h3>\n\n\n\n<p>Yes, you read that right. Just like you can draft and revise posts and schedule them to go live on the date and time you choose, you can now tinker with your site’s design and schedule those design changes to go live as you please.</p>\n\n\n\n<h3>Collaborate with Design Preview Links</h3>\n\n\n\n<p>Need to get some feedback on proposed site design changes? WordPress 4.9 gives you a preview link you can send to colleagues and customers so that you can collect and integrate feedback before you schedule the changes to go live. Can we say collaboration++?</p>\n\n\n\n<h3>Design Locking Guards Your Changes</h3>\n\n\n\n<p>Ever encounter a scenario where two designers walk into a project and designer A overrides designer B’s beautiful changes? WordPress 4.9’s design lock feature (similar to post locking) secures your draft design so that no one can make changes to it or erase all your hard work.</p>\n\n\n\n<h3>A Prompt to Protect Your Work</h3>\n\n\n\n<p>Were you lured away from your desk before you saved your new draft design? Fear not, when you return, WordPress 4.9 will politely ask whether or not you’d like to save your unsaved changes.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Coding Enhancements</h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2017/11/coding-enhancements-small.png?w=632&#038;ssl=1\" alt=\"\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>Syntax Highlighting and Error Checking? Yes, Please!</h3>\n\n\n\n<p>You’ve got a display problem but can’t quite figure out exactly what went wrong in the CSS you lovingly wrote. With syntax highlighting and error checking for CSS editing and the Custom HTML widget introduced in WordPress 4.8.1, you’ll pinpoint coding errors quickly. Practically guaranteed to help you scan code more easily, and suss out &amp; fix code errors quickly.</p>\n\n\n\n<h3>Sandbox for Safety</h3>\n\n\n\n<p>The dreaded white screen. You’ll avoid it when working on themes and plugin code because WordPress 4.9 will warn you about saving an error. You’ll sleep better at night.</p>\n\n\n\n<h3>Warning: Potential Danger Ahead!</h3>\n\n\n\n<p>When you edit themes and plugins directly, WordPress 4.9 will politely warn you that this is a dangerous practice and will recommend that you draft and test changes before updating your file. Take the safe route: You’ll thank you. Your team and customers will thank you.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Even More Widget Updates </h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2017/11/even-more-widget-updates-small.png?w=632&#038;ssl=1\" alt=\"\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>The New Gallery Widget</h3>\n\n\n\n<p>An incremental improvement to the media changes hatched in WordPress 4.8, you can now add a gallery via this new widget. Yes!</p>\n\n\n\n<h3>Press a Button, Add Media</h3>\n\n\n\n<p>Want to add media to your text widget? Embed images, video, and audio directly into the widget along with your text, with our simple but useful Add Media button. Woo!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Site Building Improvements </h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2017/11/site-building-improvements-small.png?w=632&#038;ssl=1\" alt=\"\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>More Reliable Theme Switching</h3>\n\n\n\n<p>When you switch themes, widgets sometimes think they can just move location. Improvements in WordPress 4.9 offer more persistent menu and widget placement when you decide it’s time for a new theme. </p>\n\n\n\n<h3>Find and Preview the Perfect Theme</h3>\n\n\n\n<p>Looking for a new theme for your site? Now, from within the Customizer, you can search, browse, and preview over 2600 themes before deploying changes to your site. What’s more, you can speed your search with filters for subject, features, and layout.</p>\n\n\n\n<h3>Better Menu Instructions = Less Confusion</h3>\n\n\n\n<p>Were you confused by the steps to create a new menu? Perhaps no longer! We’ve ironed out the UX for a smoother menu creation process. Newly updated copy will guide you.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Lend a Hand with Gutenberg 🤝</h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2017/11/gutenberg-1.png?w=632&#038;ssl=1\" alt=\"\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>WordPress is working on a new way to create and control your content and we’d love to have your help. Interested in being an <a href=\"https://wordpress.org/plugins/gutenberg/\">early tester</a> or getting involved with the Gutenberg project? <a href=\"https://github.com/WordPress/gutenberg\">Contribute on GitHub</a>.</p>\n\n\n\n<p>(PS: this post was written in Gutenberg!)</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Developer Happiness 😊</h2>\n\n\n\n<h3><a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Customizer JS API Improvements</a></h3>\n\n\n\n<p>We’ve made numerous improvements to the Customizer JS API in WordPress 4.9, eliminating many pain points. (Hello, default parameters for constructs! Goodbye repeated ID for constructs!) There are also new base control templates, a date/time control, and section/panel/global notifications to name a few. <a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Check out the full list.</a></p>\n\n\n\n<h3><a href=\"https://make.wordpress.org/core/2017/10/22/code-editing-improvements-in-wordpress-4-9/\">CodeMirror available for use in your themes and plugins</a></h3>\n\n\n\n<p>We’ve introduced a new code editing library, CodeMirror, for use within core. CodeMirror allows for syntax highlighting, error checking, and validation when creating code writing or editing experiences within your plugins, like CSS or JavaScript include fields.</p>\n\n\n\n<h3><a href=\"https://make.wordpress.org/core/2017/10/30/mediaelement-upgrades-in-wordpress-4-9/\">MediaElement.js upgraded to 4.2.6</a></h3>\n\n\n\n<p>WordPress 4.9 includes an upgraded version of MediaElement.js, which removes dependencies on jQuery, improves accessibility, modernizes the UI, and fixes many bugs.</p>\n\n\n\n<h3><a href=\"https://make.wordpress.org/core/2017/10/15/improvements-for-roles-and-capabilities-in-4-9/\">Roles and Capabilities Improvements</a></h3>\n\n\n\n<p>New capabilities have been introduced that allow granular management of plugins and translation files. In addition, the site switching process in multisite has been fine-tuned to update the available roles and capabilities in a more reliable and coherent way.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The Squad</h2>\n\n\n\n<p>This release was led by <a href=\"https://choycedesign.com/\">Mel Choyce</a> and <a href=\"https://weston.ruter.net/\">Weston Ruter</a>, with the help of the following fabulous folks. There are 443 contributors with props in this release, with 185 of them contributing for the first time. Pull up some Billy Tipton on your music service of choice, and check out some of their profiles:</p>\n\n\n\n<a href=\"https://profiles.wordpress.org/0x6f0\">0x6f0</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrutley\">Aaron Rutley</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/kawauso\">Adam Harley (Kawauso)</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adamwills\">AdamWills</a>, <a href=\"https://profiles.wordpress.org/adhun\">Adhun Anand</a>, <a href=\"https://profiles.wordpress.org/aegis123\">aegis123</a>, <a href=\"https://profiles.wordpress.org/afzalmultani\">Afzal Multani</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ajayghaghretiya1\">Ajay Ghaghretiya</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/soniakash\">Akash Soni</a>, <a href=\"https://profiles.wordpress.org/akbarhusen\">akbarhusen</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/alpipego\">Alex Goller</a>, <a href=\"https://profiles.wordpress.org/alexvorn2\">Alexandru Vornicescu</a>, <a href=\"https://profiles.wordpress.org/alibasheer\">alibasheer</a>, <a href=\"https://profiles.wordpress.org/alxndr\">alxndr</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreagobetti\">andreagobetti</a>, <a href=\"https://profiles.wordpress.org/euthelup\">Andrei Lupu</a>, <a href=\"https://profiles.wordpress.org/aduth\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/norcross\">Andrew Norcross</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/la-geek\">Angelika Reisiger</a>, <a href=\"https://profiles.wordpress.org/anhskohbo\">anhskohbo</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/antonrinas\">antonrinas</a>, <a href=\"https://profiles.wordpress.org/appchecker\">appchecker</a>, <a href=\"https://profiles.wordpress.org/arena94\">arena94</a>, <a href=\"https://profiles.wordpress.org/bsop\">Arnaud Coolsaet</a>, <a href=\"https://profiles.wordpress.org/arnaudban\">ArnaudBan</a>, <a href=\"https://profiles.wordpress.org/aryamaaru\">Arun</a>, <a href=\"https://profiles.wordpress.org/mrasharirfan\">Ashar Irfan</a>, <a href=\"https://profiles.wordpress.org/atachibana\">atachibana</a>, <a href=\"https://profiles.wordpress.org/atanasangelovdev\">Atanas Angelov</a>, <a href=\"https://profiles.wordpress.org/avinapatel\">Avina Patel</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/barryceelen\">Barry Ceelen</a>, <a href=\"https://profiles.wordpress.org/bduclos\">bduclos</a>, <a href=\"https://profiles.wordpress.org/pixolin\">Bego Mario Garde</a>, <a href=\"https://profiles.wordpress.org/behzod\">Behzod Saidov</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/benoitchantre\">Benoit Chantre</a>, <a href=\"https://profiles.wordpress.org/bnap00\">Bharat Parsiya</a>, <a href=\"https://profiles.wordpress.org/bhaveshkhadodara\">bhavesh khadodara</a>, <a href=\"https://profiles.wordpress.org/bplv\">Biplav</a>, <a href=\"https://profiles.wordpress.org/biranit\">Biranit</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/biskobe\">biskobe</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/blackbam\">Blackbam</a>, <a href=\"https://profiles.wordpress.org/blobfolio\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bor0\">Boro Sitnikovski</a>, <a href=\"https://profiles.wordpress.org/bradparbs\">Brad Parbs</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brentjettgmailcom\">Brent Jett</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/monopine\">Brian Meyer</a>, <a href=\"https://profiles.wordpress.org/borgesbruno\">Bruno Borges</a>, <a href=\"https://profiles.wordpress.org/bseddon\">bseddon</a>, <a href=\"https://profiles.wordpress.org/bhargavbhandari90\">Bunty</a>, <a href=\"https://profiles.wordpress.org/icaleb\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/carldanley\">Carl Danley</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/carolinegeven\">carolinegeven</a>, <a href=\"https://profiles.wordpress.org/caercam\">Charlie Merland</a>, <a href=\"https://profiles.wordpress.org/chasewg\">chasewg</a>, <a href=\"https://profiles.wordpress.org/chetanchauhan\">Chetan Chauhan</a>, <a href=\"https://profiles.wordpress.org/chetan200891\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrishardie\">Chris Hardie</a>, <a href=\"https://profiles.wordpress.org/crunnells\">Chris Runnells</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/chsxf\">chsxf</a>, <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom\">cjhaas</a>, <a href=\"https://profiles.wordpress.org/cliffseal\">Cliff Seal</a>, <a href=\"https://profiles.wordpress.org/code-monkey\">code-monkey</a>, <a href=\"https://profiles.wordpress.org/collizo4sky\">Collins Agbonghama</a>, <a href=\"https://profiles.wordpress.org/corvidism\">corvidism</a>, <a href=\"https://profiles.wordpress.org/csloisel\">csloisel</a>, <a href=\"https://profiles.wordpress.org/daedalon\">Daedalon</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danieltj\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dany2217\">dany2217</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/davefx\">DaveFX</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/davilera\">David Aguilera</a>, <a href=\"https://profiles.wordpress.org/davidanderson\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbinda\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/straussd\">David Strauss</a>, <a href=\"https://profiles.wordpress.org/jdtrower\">David Trower</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/daymobrew\">daymobrew</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/designsimply\">designsimply</a>, <a href=\"https://profiles.wordpress.org/diedeexterkate\">DiedeExterkate</a>, <a href=\"https://profiles.wordpress.org/dingo_bastard\">dingo-d</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/div33\">Divyesh Ladani</a>, <a href=\"https://profiles.wordpress.org/dency\">Dixita Dusara</a>, <a href=\"https://profiles.wordpress.org/dixitadusara\">dixitadusara</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dominikschwind-1\">Dominik Schwind</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dsawardekar\">dsawardekar</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eatonz\">Eaton</a>, <a href=\"https://profiles.wordpress.org/eclev91\">eclev91</a>, <a href=\"https://profiles.wordpress.org/eddhurst\">Edd Hurst</a>, <a href=\"https://profiles.wordpress.org/edo888\">edo888</a>, <a href=\"https://profiles.wordpress.org/egregor\">EGregor</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elvishp2006\">elvishp2006</a>, <a href=\"https://profiles.wordpress.org/enricosorcinelli\">enrico.sorcinelli</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/erich_k4wp\">Erich Munz</a>, <a href=\"https://profiles.wordpress.org/circlecube\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/eventualo\">eventualo</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/psiico\">FancyThought</a>, <a href=\"https://profiles.wordpress.org/felipeelia\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fergbrain\">fergbrain</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/gmariani405\">Gabriel Mariani</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/girishpanchal\">Girish Lohar</a>, <a href=\"https://profiles.wordpress.org/gkloveweb\">Govind Kumar</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/gregross\">Greg Ross</a>, <a href=\"https://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"https://profiles.wordpress.org/grosbouff\">grosbouff</a>, <a href=\"https://profiles.wordpress.org/wido\">Guido Scialfa</a>, <a href=\"https://profiles.wordpress.org/ghosttoast\">Gustave F. Gerhardt</a>, <a href=\"https://profiles.wordpress.org/guzzilar\">guzzilar</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/hardik-amipara\">Hardik Amipara</a>, <a href=\"https://profiles.wordpress.org/hazemnoor\">Hazem Noor</a>, <a href=\"https://profiles.wordpress.org/hazimayesh\">hazimayesh</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrywright-1\">Henry</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/herregroen\">herregroen</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/howdy_mcgee\">Howdy_McGee</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/jcc9873\">Iacopo C</a>, <a href=\"https://profiles.wordpress.org/ibenic\">Igor Benic</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ionvv\">ionvv</a>, <a href=\"https://profiles.wordpress.org/ippei-sumida\">Ippei Sumida</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ireneyoast\">Irene Strikkers</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/ixmati\">ixmati</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jhoffmann\">j.hoffmann</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jankimoradiya\">Janki Moradiya</a>, <a href=\"https://profiles.wordpress.org/jaswrks\">Jason Caldwell</a>, <a href=\"https://profiles.wordpress.org/octalmage\">Jason Stallings</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jeremyescott\">Jeremy Scott</a>, <a href=\"https://profiles.wordpress.org/jjcomack\">Jimmy Comack</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jkhongusc\">jkhongusc</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johneckman\">John Eckman</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/johnroper100\">johnroper100</a>, <a href=\"https://profiles.wordpress.org/johnschulz\">johnschulz</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/chanthaboune\">Josepha</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jsepia\">jsepia</a>, <a href=\"https://profiles.wordpress.org/jsonfry\">jsonfry</a>, <a href=\"https://profiles.wordpress.org/juiiee8487\">Juhi Patel</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/jlambe\">Julien</a>, <a href=\"https://profiles.wordpress.org/kopepasah\">Justin Kopepasah</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/thekt12\">Karthik Thayyil</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/captainn\">Kevin Newman</a>, <a href=\"https://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"https://profiles.wordpress.org/kiranpotphode\">Kiran Potphode</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kmgalanakis\">Konstantinos Galanakis</a>, <a href=\"https://profiles.wordpress.org/koopersmith\">koopersmith</a>, <a href=\"https://profiles.wordpress.org/kekkakokkers\">Kristin Kokkersvold</a>, <a href=\"https://profiles.wordpress.org/lalitpendhare\">lalitpendhare</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/lemacarl\">lemacarl</a>, <a href=\"https://profiles.wordpress.org/lenasterg\">lenasterg</a>, <a href=\"https://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"https://profiles.wordpress.org/llemurya\">llemurya</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">M&#225;rio Valney</a>, <a href=\"https://profiles.wordpress.org/m1tk00\">m1tk00</a>, <a href=\"https://profiles.wordpress.org/maedahbatool\">Maedah Batool</a>, <a href=\"https://profiles.wordpress.org/mp518\">Mahesh Prajapati</a>, <a href=\"https://profiles.wordpress.org/mahvash-fatima\">Mahvash Fatima</a>, <a href=\"https://profiles.wordpress.org/travel_girl\">Maja Benke</a>, <a href=\"https://profiles.wordpress.org/mako09\">Mako</a>, <a href=\"https://profiles.wordpress.org/manolis09\">manolis09</a>, <a href=\"https://profiles.wordpress.org/manuelaugustin\">Manuel Augustin</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mariusvetrici\">Marius Vetrici</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/markcallen\">markcallen</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/matheusgimenez\">MatheusGimenez</a>, <a href=\"https://profiles.wordpress.org/mgibbs189\">Matt Gibbs</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/matthiasthiel\">matthias.thiel</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mdifelice\">mdifelice</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/menakas\">Menaka S.</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/mizejewski\">Michele Mizejewski</a>, <a href=\"https://profiles.wordpress.org/stubgo\">Miina Sikk</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikeschinkel\">Mike Schinkel</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/milindmore22\">Milind More</a>, <a href=\"https://profiles.wordpress.org/mirucon\">Mirucon</a>, <a href=\"https://profiles.wordpress.org/studionashvegas\">Mitch Canter</a>, <a href=\"https://profiles.wordpress.org/mitraval192\">Mithun Raval</a>, <a href=\"https://profiles.wordpress.org/mkomar\">mkomar</a>, <a href=\"https://profiles.wordpress.org/monikarao\">Monika Rao</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/msebel\">msebel</a>, <a href=\"https://profiles.wordpress.org/munyagu\">munyagu</a>, <a href=\"https://profiles.wordpress.org/mythemeshop\">MyThemeShop</a>, <a href=\"https://profiles.wordpress.org/ndoublehwp\">N\'DoubleH</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/nenad\">nenad</a>, <a href=\"https://profiles.wordpress.org/nicbertino\">nic.bertino</a>, <a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nicollle\">nicollle</a>, <a href=\"https://profiles.wordpress.org/jainnidhi\">Nidhi Jain</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/nileshdudakiya94\">Nileshdudakiya94</a>, <a href=\"https://profiles.wordpress.org/nishitlangaliya\">Nishit Langaliya</a>, <a href=\"https://profiles.wordpress.org/justnorris\">Norris</a>, <a href=\"https://profiles.wordpress.org/obradovic\">obradovic</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/ov3rfly\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/paaljoachim\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/palmiak\">palmiak</a>, <a href=\"https://profiles.wordpress.org/parthsanghvi\">Parth Sanghvi</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/obrienlabs\">Pat O\'Brien</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pauldechov\">Paul Dechov</a>, <a href=\"https://profiles.wordpress.org/natacado\">Paul Paradise</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pcarvalho\">pcarvalho</a>, <a href=\"https://profiles.wordpress.org/pedromendonca\">Pedro Mendon&#231;a</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/pessoft\">Peter \"Pessoft\" Kol&#237;nek</a>, <a href=\"https://profiles.wordpress.org/donutz\">Peter J. Herrel</a>, <a href=\"https://profiles.wordpress.org/petertoi\">Peter Toi</a>, <a href=\"https://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/philipjohn\">Philip John</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/plastikschnitzer\">Plastikschnitzer</a>, <a href=\"https://profiles.wordpress.org/powerzilly\">powerzilly</a>, <a href=\"https://profiles.wordpress.org/pratikgandhi\">Pratik Gandhi</a>, <a href=\"https://profiles.wordpress.org/precies\">precies</a>, <a href=\"https://profiles.wordpress.org/presslabs\">Presslabs</a>, <a href=\"https://profiles.wordpress.org/punit5658\">Punit Patel</a>, <a href=\"https://profiles.wordpress.org/purnendu\">Purnendu Dash</a>, <a href=\"https://profiles.wordpress.org/r-a-y\">r-a-y</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rafa8626\">Rafael Miranda</a>, <a href=\"https://profiles.wordpress.org/rahmohn\">Rahmohn</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramon-fincken\">ramon fincken</a>, <a href=\"https://profiles.wordpress.org/jontyravi\">Ravi Vaghela</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/redrambles\">redrambles</a>, <a href=\"https://profiles.wordpress.org/arena\">RENAUT</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rfair404\">rfair404</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/riddhiehta02\">Riddhi Mehta</a>, <a href=\"https://profiles.wordpress.org/rinkuyadav999\">Rinku Y</a>, <a href=\"https://profiles.wordpress.org/rcutmore\">Rob Cutmore</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/ronakganatra\">Ronak Ganatra</a>, <a href=\"https://profiles.wordpress.org/rugved\">rugved</a>, <a href=\"https://profiles.wordpress.org/rushabh4486\">Rushabh Shah</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryanduff\">Ryan Duff</a>, <a href=\"https://profiles.wordpress.org/stunnedbeast\">Ryan Holmes</a>, <a href=\"https://profiles.wordpress.org/rmarks\">Ryan Marks</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ohryan\">Ryan Neudorf</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/ryanrolds\">ryanrolds</a>, <a href=\"https://profiles.wordpress.org/ryotsun\">ryotsun</a>, <a href=\"https://profiles.wordpress.org/stodorovic\">Sa&#353;a</a>, <a href=\"https://profiles.wordpress.org/manchumahara\">Sabuj Kundu</a>, <a href=\"https://profiles.wordpress.org/sagarprajapati\">Sagar Prajapati</a>, <a href=\"https://profiles.wordpress.org/sagarladani\">sagarladani</a>, <a href=\"https://profiles.wordpress.org/sa3idho\">Said El Bakkali</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/viralsampat\">Sampat Viral</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/tinkerbelly\">sarah semark</a>, <a href=\"https://profiles.wordpress.org/sathyapulse\">sathyapulse</a>, <a href=\"https://profiles.wordpress.org/sboisvert\">sboisvert</a>, <a href=\"https://profiles.wordpress.org/scottdeluzio\">Scott DeLuzio</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/scottlee\">Scott Lee</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sebsz\">SeBsZ</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/shamim51\">Shamim Hasan</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/shital-patel\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/shramee\">shramee</a>, <a href=\"https://profiles.wordpress.org/nomnom99\">Siddharth Thevaril</a>, <a href=\"https://profiles.wordpress.org/pross\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/slaffik\">Slava Abakumov</a>, <a href=\"https://profiles.wordpress.org/someecards\">someecards</a>, <a href=\"https://profiles.wordpress.org/soean\">Soren Wrede</a>, <a href=\"https://profiles.wordpress.org/spencerfinnell\">spencerfinnell</a>, <a href=\"https://profiles.wordpress.org/spocke\">spocke</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevepuddick\">Steve Puddick</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/skostadinov\">Stoyan Kostadinov</a>, <a href=\"https://profiles.wordpress.org/dualcube_subrata\">Subrata Mal</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/musus\">Susumu Seino</a>, <a href=\"https://profiles.wordpress.org/svrooij\">svrooij</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/buley\">Taylor</a>, <a href=\"https://profiles.wordpress.org/tejas5989\">tejas5989</a>, <a href=\"https://profiles.wordpress.org/terwdan\">terwdan</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thulshof\">Thijs Hulshof</a>, <a href=\"https://profiles.wordpress.org/thingsym\">thingsym</a>, <a href=\"https://profiles.wordpress.org/tfirdaus\">Thoriq Firdaus</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobi823\">tobi823</a>, <a href=\"https://profiles.wordpress.org/toddnestor\">Todd Nestor</a>, <a href=\"https://profiles.wordpress.org/tobifjellner\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/toru\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/toscho\">toscho</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/truongwp\">truongwp</a>, <a href=\"https://profiles.wordpress.org/tuanmh\">tuanmh</a>, <a href=\"https://profiles.wordpress.org/tv-productions\">TV productions</a>, <a href=\"https://profiles.wordpress.org/uicestone\">uicestone</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/umangvaghela123\">Umang Vaghela</a>, <a href=\"https://profiles.wordpress.org/umeshnevase\">Umesh Nevase</a>, <a href=\"https://profiles.wordpress.org/upadalavipul\">upadalavipul</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/vhauri\">vhauri</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/withinboredom\">withinboredom</a>, <a href=\"https://profiles.wordpress.org/wojtekszkutnik\">Wojtek Szkutnik</a>, <a href=\"https://profiles.wordpress.org/xkon\">Xenos (xkon) Konstantinos</a>, <a href=\"https://profiles.wordpress.org/yahil\">Yahil Madakiya</a>, <a href=\"https://profiles.wordpress.org/yonivh\">yonivh</a>, <a href=\"https://profiles.wordpress.org/yrpwayne\">yrpwayne</a>, <a href=\"https://profiles.wordpress.org/zachwtx\">zachwtx</a>, and <a href=\"https://profiles.wordpress.org/zanematthew\">Zane Matthew</a>.\n\n\n\n<p>Finally, thanks to all the community translators who worked on WordPress 4.9. Their efforts bring WordPress 4.9 fully translated to 43 languages at release time, with more on the way.</p>\n\n\n\n<p>Do you want to report on WordPress 4.9? <a href=\"https://s.w.org/images/core/4.9/wp-4-9_press-kit.zip\">We&#x27;ve compiled a press kit featuring information about the release features, and some media assets to help you along</a>.</p>\n\n\n\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\n\n\n<p>Thanks for choosing WordPress!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4968\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.9 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2017/11/wordpress-4-9-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Nov 2017 06:53:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5184\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"The third release candidate for WordPress 4.9 is now available. A release candidate (RC) means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. In fact, we did miss some things in RC1 and RC2. This third release candidate was not originally scheduled, but [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Weston Ruter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4169:\"<p>The third release candidate for WordPress 4.9 is now available.</p>\n<p>A release candidate (RC) means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. In fact, we did miss some things in RC1 and RC2. This third release candidate was not originally scheduled, but due a number of defects uncovered through your testing of RC2 (thank you!), we are putting out another 4.9 release candidate.</p>\n<p>We hope to ship WordPress 4.9 on <strong>Tuesday, November 14</strong> (that&#8217;s <em>tomorrow</em>) at 23:00 UTC, but we still need your help to get there. If you haven’t tested 4.9 yet, now is the time! If there are additional defects uncovered through testing between now and the release time, we may delay the 4.9 release to the following day.</p>\n<p>To test WordPress 4.9, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.9-RC3.zip\">download the release candidate here</a> (zip).</p>\n<p>We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/branches/4.9?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=42178&amp;stop_rev=42133\">just over 20 changes</a> since releasing RC2 last week (as we did between RC1 and RC2). For more details about what’s new in version 4.9, check out the <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-3/\">Beta 3</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-4/\">Beta 4</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-release-candidate/\">RC1</a>, and <a href=\"https://wordpress.org/news/2017/11/wordpress-4-9-release-candidate-2/\">RC2</a> blog posts. A few specific areas to test in RC3:</p>\n<ul>\n<li>Switching between the Visual and Text tabs of the editor, and the syncing of the cursor between those two tabs.</li>\n<li>Overriding linting errors in the Customizer&#8217;s Additional CSS editor.</li>\n<li>Adding nav menu items for Custom Links in the Customizer.</li>\n<li>Scheduling customization drafts (stubbed posts/pages) for publishing in the Customizer.</li>\n<li>Autosave revisions for changes in the Customizer.</li>\n<li>About page styling.</li>\n</ul>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.9 and update your plugin’s <em>Tested up to</em> version in the readme to 4.9. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release — we work hard to avoid breaking things. Please see the summative <a href=\"https://make.wordpress.org/core/2017/11/07/wordpress-4-9-field-guide/\">field guide</a> to the 4.9 <a href=\"https://make.wordpress.org/core/tag/4.9+dev-notes/\">developer notes</a> on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Didn&#8217;t squash them all <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f41b.png\" alt=\"🐛\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></em><br />\n<em>We want to release Tuesday</em><br />\n<em>New features not bugs <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></em></p>\n<p>Thanks for your continued help testing out the latest versions of WordPress.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5184\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.9 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2017/11/wordpress-4-9-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2017 05:33:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5047\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:342:\"The second release candidate for WordPress 4.9 is now available. A release candidate (RC) means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.9 on Tuesday, November 14 (just over one week from now), but we need your help [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Weston Ruter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3424:\"<p>The second release candidate for WordPress 4.9 is now available.</p>\n<p>A release candidate (RC) means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.9 on <strong>Tuesday, November 14</strong> (just over <em>one week</em> from now), but we need your help to get there. If you haven’t tested 4.9 yet, now is the time!</p>\n<p>To test WordPress 4.9, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.9-RC2.zip\">download the release candidate here</a> (zip).</p>\n<p>We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=42124&amp;stop_rev=42049&amp;limit=100&amp;sfp_email=&amp;sfph_mail=\">just over 20 changes</a> since releasing RC 1 last week. For more details about what’s new in version 4.9, check out the <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-3/\">Beta 3</a>, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-beta-4/\">Beta 4</a>, and <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-release-candidate/\">RC1</a> blog posts. Specific areas to test in RC2:</p>\n<ul>\n<li>Theme installation in the Customizer.</li>\n<li>Scheduling changes for publishing in the Customizer.</li>\n<li>Switching themes with live preview in the Customizer.</li>\n</ul>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.9 and update your plugin’s <em>Tested up to</em> version in the readme to 4.9. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release — we work hard to avoid breaking things. Please see the summative <a href=\"https://make.wordpress.org/core/2017/11/07/wordpress-4-9-field-guide/\">field guide</a> to the 4.9 <a href=\"https://make.wordpress.org/core/tag/4.9+dev-notes/\">developer notes</a> on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>This week&#8217;s haiku is courtesy of <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>:</p>\n<p><em>We squashed all the bugs <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f41b.png\" alt=\"🐛\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></em><br />\n<em>But uh, if not, let us know</em><br />\n<em>Also, test your stuff</em></p>\n<p>Thanks for your continued help testing out the latest versions of WordPress.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"The Month in WordPress: October 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2017/11/the-month-in-wordpress-october-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Nov 2017 12:02:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5044\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"While this month we focused on building new features for WordPress core, we advanced other areas of the project too. Read on to learn more about what the WordPress project accomplished during the month of October. Take the 2017 Annual WordPress User Survey The annual WordPress User Survey is a great opportunity for you to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6180:\"\n<p>While this month we focused on building new features for WordPress core, we advanced other areas of the project too. Read on to learn more about what the WordPress project accomplished during the month of October.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Take the 2017 Annual WordPress User Survey</h2>\n\n\n\n<p>The annual WordPress User Survey is a great opportunity for you to provide your feedback about how you use WordPress. This year is no exception, as <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2017-survey\">the 2017 WordPress User Survey</a> is out now.</p>\n\n\n\n<p>The information collected in the survey is used to make informed decisions about improvements across the WordPress project, so your answers are incredibly valuable and help shape the future of the platform.</p>\n\n\n\n<h2>WordPress 4.8.3 Security Release</h2>\n\n\n\n<p>At the end of October, <a href=\"https://wordpress.org/news/2017/10/wordpress-4-8-3-security-release/\">WordPress 4.8.3 was released</a> containing an important security fix for all previous versions of WordPress. If your WordPress installation has not updated automatically, please update it now to protect your site.</p>\n\n\n\n<p>This security issue was brought to light by a community member, so if you ever discover a security vulnerability in WordPress core, please do the same and <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">disclose it responsibly</a>.</p>\n\n\n\n<h2>WordPress 4.9 Nearly Ready for Release</h2>\n\n\n\n<p>WordPress 4.9 was in rapid development this month. We released four beta versions and published a <a href=\"https://wordpress.org/news/2017/10/wordpress-4-9-release-candidate/\">release candidate</a>. The target for shipping WordPress 4.9 is November 14 — just two short weeks away. With many new features, this is a hugely exciting release that improves WordPress’ user experience considerably. Notably, you’ll see <a href=\"https://make.wordpress.org/core/2017/10/24/a-new-themes-experience-in-the-customizer/\">improvements to the theme selection experience</a>, plenty of <a href=\"https://make.wordpress.org/core/2017/10/24/widget-improvements-in-wordpress-4-9/\">widget enhancements</a>, drastically improved <a href=\"https://make.wordpress.org/core/2017/10/22/code-editing-improvements-in-wordpress-4-9/\">code editing</a>, and much better <a href=\"https://make.wordpress.org/core/2017/10/15/improvements-for-roles-and-capabilities-in-4-9/\">user role management</a>.</p>\n\n\n\n<p>To get involved in building WordPress Core, jump into the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>, and follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>.</p>\n\n\n\n<h2>WordPress Charity Hackathons are Growing</h2>\n\n\n\n<p>For the last few years, the number of <a href=\"https://doaction.org/\">do_action series of WordPress charity hackathons</a> has grown around the world. What started as a community event to assist local nonprofit organizations, has become something many WordPress communities are replicating in an increasing number of cities.</p>\n\n\n\n<p>As of this month, do_action events have been hosted in Cape Town and Johannesburg, South Africa, Beirut, Lebanon, Austin, Texas, and Montréal, Canada. In addition, events are now scheduled for <a href=\"https://doaction.org/event/bristol-2018/\">Bristol, England</a> and <a href=\"https://doaction.org/event/zurich-2018/\">Zurich, Switzerland</a> in 2018.</p>\n\n\n\n<p>To get involved in organizing a do_action event locally, read <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/do_action-charity-hackathon/\">the do_action organizer’s handbook</a> and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Gutenberg Development Advances</h2>\n\n\n\n<p>While work steadily continues on Gutenberg — the new editor for WordPress core — one update from this month addresses one of the primary concerns that some people shared about the project.</p>\n\n\n\n<p>Up until <a href=\"https://make.wordpress.org/core/2017/10/24/whats-new-in-gutenberg-24th-october/\">the release on October 24</a>, Gutenberg did not support the meta boxes that so many WordPress content creators rely on. The new editor now has initial support for meta boxes as well as a host of other critical features for content creation in WordPress.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/handbook/call-for-testing/gutenberg-testing/\">Test out Gutenberg</a> right now and help develop it by joining the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a> and following the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul>\n    <li>DonateWC, a new initiative that assists people in attending WordCamps, <a href=\"https://donatewc.org/wordcamp-stories/wordcamp-cape-town-experience/\">sponsored Trust Nhokovedzo from Harare, Zimbabwe</a> to speak at WordCamp Cape Town, South Africa this month.</li>\n    <li><a href=\"https://woocommerce.com/2017/10/saying-goodbye-to-canvas/\">The popular Canvas theme was retired</a> this month to allow WooCommerce to focus on moving their products forward more effectively.</li>\n    <li>The next installment of Camp Press, the WordPress community retreat event, will take place <a href=\"https://camp.press/event/iceland2018/\">in Iceland</a>.</li>\n    <li>If you run a WordPress meetup group, but are struggling to find content for your events, the WordPress Marketing team <a href=\"https://make.wordpress.org/community/2017/10/04/supporting-for-meetups-with-low-content/\">has put together some ideas</a> to help.</li>\n    <li><a href=\"https://2017.us.wordcamp.org/\">WordCamp US 2017</a> is just around the corner — there’s still time to grab your tickets.</li>\n</ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5044\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.8.3 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/10/wordpress-4-8-3-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Oct 2017 14:20:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5035\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"WordPress 4.8.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.8.2 and earlier are affected by an issue where $wpdb-&#62;prepare() can create unexpected and unsafe queries leading to potential SQL injection (SQLi). WordPress core is not directly vulnerable to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1337:\"<p>WordPress 4.8.3 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.8.2 and earlier are affected by an issue where <code>$wpdb-&gt;prepare()</code> can create unexpected and unsafe queries leading to potential SQL injection (SQLi). WordPress core is not directly vulnerable to this issue, but we’ve added hardening to prevent plugins and themes from accidentally causing a vulnerability. Reported by <a href=\"https://twitter.com/ircmaxell\">Anthony Ferrara</a>.</p>\n<p>This release includes a change in behaviour for the <code>esc_sql()</code> function. Most developers will not be affected by this change, you can read more details in the <a href=\"https://make.wordpress.org/core/2017/10/31/changed-behaviour-of-esc_sql-in-wordpress-4-8-3/\">developer note</a>.</p>\n<p>Thank you to the reporter of this issue for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.8.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.8.3.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5035\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 21 Jan 2018 18:08:47 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 16 Jan 2018 23:00:14 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20130911163210\";}", "no");
INSERT INTO `wpbd_options` VALUES("151821", "_site_transient_timeout_community-events-87077387a24a6e2fa3fd299a378e3e4b", "1516601327", "no");
INSERT INTO `wpbd_options` VALUES("151822", "_site_transient_community-events-87077387a24a6e2fa3fd299a378e3e4b", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"75.166.209.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:34:\"Freelancing - COS WordPress Meetup\";s:3:\"url\";s:65:\"https://www.meetup.com/ColoradoSpringsWordPress/events/244547836/\";s:6:\"meetup\";s:33:\"Colorado Springs WordPress Meetup\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/ColoradoSpringsWordPress/\";s:4:\"date\";s:19:\"2018-01-24 18:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:25:\"Colorado Springs, CO, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:38.95315599999999989222487783990800380706787109375;s:9:\"longitude\";d:-104.792923000000001820808392949402332305908203125;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:27:\"WordPress as a headless CMS\";s:3:\"url\";s:56:\"https://www.meetup.com/DenverWordPress/events/246920302/\";s:6:\"meetup\";s:23:\"Denver WordPress Meetup\";s:10:\"meetup_url\";s:39:\"https://www.meetup.com/DenverWordPress/\";s:4:\"date\";s:19:\"2018-01-31 18:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Denver, CO, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:39.75783899999999704277797718532383441925048828125;s:9:\"longitude\";d:-105.0070950000000067348082666285336017608642578125;}}i:2;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:21:\"SEO discussion + demo\";s:3:\"url\";s:63:\"https://www.meetup.com/Aspen-WordPress-Meetup/events/246935080/\";s:6:\"meetup\";s:22:\"Aspen WordPress Meetup\";s:10:\"meetup_url\";s:46:\"https://www.meetup.com/Aspen-WordPress-Meetup/\";s:4:\"date\";s:19:\"2018-02-13 17:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Aspen, CO, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:39.1912650000000013505996321327984333038330078125;s:9:\"longitude\";d:-106.8185959999999994352037901990115642547607421875;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:46:\"WordPress Happiness Hour at the Denver Library\";s:3:\"url\";s:56:\"https://www.meetup.com/DenverWordPress/events/246331226/\";s:6:\"meetup\";s:23:\"Denver WordPress Meetup\";s:10:\"meetup_url\";s:39:\"https://www.meetup.com/DenverWordPress/\";s:4:\"date\";s:19:\"2018-02-13 18:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Denver, CO, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:39.73844900000000279760570265352725982666015625;s:9:\"longitude\";d:-104.987540999999993118763086386024951934814453125;}}i:4;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:3:\"TBD\";s:3:\"url\";s:50:\"https://www.meetup.com/BoulderWP/events/245262261/\";s:6:\"meetup\";s:24:\"Boulder WordPress Meetup\";s:10:\"meetup_url\";s:33:\"https://www.meetup.com/BoulderWP/\";s:4:\"date\";s:19:\"2018-02-19 18:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:16:\"Boulder, CO, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.01512199999999808142092661000788211822509765625;s:9:\"longitude\";d:-105.2296010000000023865140974521636962890625;}}}}", "no");
INSERT INTO `wpbd_options` VALUES("151847", "_transient_timeout_wpcom_subscribers_total", "1516562728", "no");
INSERT INTO `wpbd_options` VALUES("151848", "_transient_wpcom_subscribers_total", "a:2:{s:6:\"status\";s:7:\"success\";s:5:\"value\";i:340;}", "no");
INSERT INTO `wpbd_options` VALUES("151103", "_transient_timeout_jetpack_https_test", "1516588993", "no");
INSERT INTO `wpbd_options` VALUES("151104", "_transient_jetpack_https_test", "1", "no");
INSERT INTO `wpbd_options` VALUES("147716", "_transient_timeout_jetpack_https_test_message", "1516588993", "no");
INSERT INTO `wpbd_options` VALUES("147717", "_transient_jetpack_https_test_message", "", "no");
INSERT INTO `wpbd_options` VALUES("145461", "wpseo_sitemap_32076_cache_validator", "4nnM", "no");
INSERT INTO `wpbd_options` VALUES("151679", "_transient_timeout_jetpack_news_sitemap_xml", "1516579967", "no");
INSERT INTO `wpbd_options` VALUES("151680", "_transient_jetpack_news_sitemap_xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--generator=\'jetpack-5.7.1\'-->\n<?xml-stylesheet type=\"text/xsl\" href=\"http://gregsonstudios.com/news-sitemap.xsl\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns:news=\"http://www.google.com/schemas/sitemap-news/0.9\"><url><loc>http://gregsonstudios.com/using-video-viral-marketing/</loc><lastmod>2018-01-19T21:02:03Z</lastmod><news:news><news:publication><news:name>Gregson Studios</news:name><news:language>en</news:language></news:publication><news:title>Using Video in Viral Marketing</news:title><news:publication_date>2018-01-21T06:30:35Z</news:publication_date><news:genres>Blog</news:genres></news:news></url><url><loc>http://gregsonstudios.com/foundation-online-marketing-part-4/</loc><lastmod>2018-01-19T21:02:03Z</lastmod><news:news><news:publication><news:name>Gregson Studios</news:name><news:language>en</news:language></news:publication><news:title>The Foundation Of Online Marketing – Part 4</news:title><news:publication_date>2018-01-20T04:52:49Z</news:publication_date><news:genres>Blog</news:genres></news:news></url><url><loc>http://gregsonstudios.com/solid-advice-help-video-marketing-efforts/</loc><lastmod>2018-01-19T21:02:04Z</lastmod><news:news><news:publication><news:name>Gregson Studios</news:name><news:language>en</news:language></news:publication><news:title>Solid Advice To Help Your Video Marketing Efforts</news:title><news:publication_date>2018-01-19T06:19:14Z</news:publication_date><news:genres>Blog</news:genres></news:news></url></urlset>\n", "no");
INSERT INTO `wpbd_options` VALUES("137563", "_transient_timeout_amp_img_581af9e49abfa9d2c53d504cd95b7116", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137564", "_transient_amp_img_581af9e49abfa9d2c53d504cd95b7116", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137565", "_transient_timeout_amp_img_cb8b7a8321ef7c104d4eb6f504f7b601", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137566", "_transient_amp_img_cb8b7a8321ef7c104d4eb6f504f7b601", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137567", "_transient_timeout_amp_img_d42d41e59a77636e53f6a68b5534aec1", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137568", "_transient_amp_img_d42d41e59a77636e53f6a68b5534aec1", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137569", "_transient_timeout_amp_img_e27f8c73ced7f95f0fe0e75c546df0d2", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137570", "_transient_amp_img_e27f8c73ced7f95f0fe0e75c546df0d2", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137553", "_transient_timeout_amp_img_fdc101cc53d1d5820ea55115cdf10e2d", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137554", "_transient_amp_img_fdc101cc53d1d5820ea55115cdf10e2d", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137557", "_transient_timeout_amp_img_6c3c686cd64892ff40e62c51485a6795", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137558", "_transient_amp_img_6c3c686cd64892ff40e62c51485a6795", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("137555", "_transient_timeout_amp_img_02c555aff3a7cff18b754c5728668d65", "1517904172", "no");
INSERT INTO `wpbd_options` VALUES("137556", "_transient_amp_img_02c555aff3a7cff18b754c5728668d65", "a:2:{i:0;i:1080;i:1;i:607;}", "no");
INSERT INTO `wpbd_options` VALUES("73593", "wpseo_license_server_version", "2", "yes");
INSERT INTO `wpbd_options` VALUES("88736", "cbnetpo_ping_optimizer", "1", "no");
INSERT INTO `wpbd_options` VALUES("137974", "_transient_timeout_amp_img_a3b1b375a90ae8bfab8a86cba108c73d", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137975", "_transient_amp_img_a3b1b375a90ae8bfab8a86cba108c73d", "a:2:{i:0;i:1024;i:1;i:1024;}", "no");
INSERT INTO `wpbd_options` VALUES("137976", "_transient_timeout_amp_img_3f802a0a6e30780ec1bc5ef1b1e31ec3", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("139667", "_transient_timeout_jetpack_file_data_5.7", "1518420312", "no");
INSERT INTO `wpbd_options` VALUES("139668", "_transient_jetpack_file_data_5.7", "a:57:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:39:\"Check your spelling, style, and grammar\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:75:\"Display images and galleries in a gorgeous, full-screen browsing experience\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"e1c539d5b392f5a1709dada3da5793cc\";a:14:{s:4:\"name\";s:13:\"Comment Likes\";s:11:\"description\";s:64:\"Increase visitor engagement by adding a Like button to comments.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"39\";s:20:\"recommendation_order\";s:2:\"17\";s:10:\"introduced\";s:3:\"5.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:37:\"like widget, like button, like, likes\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:80:\"Let readers use WordPress.com, Twitter, Facebook, or Google+ accounts to comment\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:57:\"Insert a customizable contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:18:\"Writing, Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom content types\";s:11:\"description\";s:74:\"Display different types of content on your site with custom content types.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:53:\"Tweak your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"e1f1f6e3689fc31c477e64b06e2f8fbf\";a:14:{s:4:\"name\";s:16:\"Google Analytics\";s:11:\"description\";s:56:\"Set up Google Analytics without touching a line of code.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"37\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"4.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:37:\"webmaster, google, analytics, console\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:53:\"Automatically load new content when a visitor scrolls\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:57:\"Use LaTeX markup for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"f868c97c313f21b23fa6d6c64505fab6\";a:14:{s:4:\"name\";s:11:\"Lazy Images\";s:11:\"description\";s:71:\"Improve performance by loading images just before they scroll into view\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:5:\"5.6.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:23:\"Appearance, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:26:\"mobile, theme, performance\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:14:\"jumpstart_desc\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:54:\"Manage all of your sites from a centralized dashboard.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:50:\"Write posts or pages in plain-text Markdown syntax\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"614679778a7db6d8129c9f69ac8e10a5\";a:14:{s:4:\"name\";s:21:\"WordPress.com Toolbar\";s:11:\"description\";s:91:\"Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"16\";s:10:\"introduced\";s:3:\"4.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"General\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:19:\"adminbar, masterbar\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:31:\"Enable the Jetpack Mobile theme\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:14:\"jumpstart_desc\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:26:\"Speed up images and photos\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:34:\"Recommended, Jumpstart, Appearance\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by email\";s:11:\"description\";s:33:\"Publish posts by sending an email\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:41:\"Block suspicious-looking sign in activity\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:27:\"Automated social marketing.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"83622cd43b5e31bb82e59a9d52e9bb10\";a:14:{s:4:\"name\";s:20:\"Progressive Web Apps\";s:11:\"description\";s:85:\"Speed up and improve the reliability of your site using the latest in web technology.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"18\";s:10:\"introduced\";s:5:\"5.6.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:26:\"manifest, pwa, progressive\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related posts\";s:11:\"description\";s:64:\"Increase page views by showing related content to your visitors.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"fe7a38addc9275dcbe6c4ff6c44a9350\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:41:\"Enhanced search, powered by Elasticsearch\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:6:\"Search\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"68b0d01689803c0ea7e4e60a86de2519\";a:14:{s:4:\"name\";s:9:\"SEO Tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:14:\"jumpstart_desc\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:18:\"Traffic, Jumpstart\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:37:\"Allow visitors to share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:50:\"Embed media from popular sites without any coding.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:54:\"Create short and simple links for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:62:\"Allow users to log into this site using WordPress.com accounts\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:87:\"Allow users to subscribe to your posts and comments and receive notifications via email\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:14:\"jumpstart_desc\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:54:\"Off-site backups, security scans, and automatic fixes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:27:\"Fast, ad-free video hosting\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:54:\"Add images, Twitter streams, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"a668bc9418d6de87409f867892fcdd7f\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}", "no");
INSERT INTO `wpbd_options` VALUES("139673", "_transient_timeout_wpseo_link_table_inaccessible", "1547173369", "no");
INSERT INTO `wpbd_options` VALUES("139674", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO `wpbd_options` VALUES("139675", "_transient_timeout_wpseo_meta_table_inaccessible", "1547173369", "no");
INSERT INTO `wpbd_options` VALUES("139676", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO `wpbd_options` VALUES("100488", "post_by_email_address1", "NULL", "yes");
INSERT INTO `wpbd_options` VALUES("100489", "jetpack_last_connect_url_check", "1515914712", "no");
INSERT INTO `wpbd_options` VALUES("145173", "wpseo_sitemap_32070_cache_validator", "oGCu", "no");
INSERT INTO `wpbd_options` VALUES("142523", "disabled_likes", "0", "yes");
INSERT INTO `wpbd_options` VALUES("62252", "bulletproof_security_options_customcode_WPA", "a:4:{s:29:\"bps_customcode_deny_files_wpa\";s:0:\"\";s:22:\"bps_customcode_one_wpa\";s:0:\"\";s:22:\"bps_customcode_two_wpa\";s:127:\"# Yoast SEO Query String skip/bypass rule\nRewriteCond %{QUERY_STRING} page=wpseo_social&amp;key=(.*) [NC]\nRewriteRule . - [S=2]\";s:25:\"bps_customcode_bpsqse_wpa\";s:3007:\"# BEGIN BPSQSE-check BPS QUERY STRING EXPLOITS AND FILTERS\n# WORDPRESS WILL BREAK IF ALL THE BPSQSE FILTERS ARE DELETED\n# Use BPS wp-admin Custom Code to modify/edit/change this code and to save it permanently.\nRewriteCond %{HTTP_USER_AGENT} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_USER_AGENT} (;|&lt;|&gt;|&#039;|&quot;|\\)|\\(|%0A|%0D|%22|%27|%28|%3C|%3E|%00).*(libwww-perl|wget|python|nikto|curl|scan|java|winhttp|HTTrack|clshttp|archiver|loader|email|harvest|extract|grab|miner) [NC,OR]\nRewriteCond %{THE_REQUEST} (\\?|\\*|%2a)+(%20+|\\\\s+|%20+\\\\s+|\\\\s+%20+|\\\\s+%20+\\\\s+)(http|https)(:/|/) [NC,OR]\nRewriteCond %{THE_REQUEST} etc/passwd [NC,OR]\nRewriteCond %{THE_REQUEST} cgi-bin [NC,OR]\nRewriteCond %{THE_REQUEST} (%0A|%0D) [NC,OR]\nRewriteCond %{REQUEST_URI} owssvr\\.dll [NC,OR]\nRewriteCond %{HTTP_REFERER} (%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{HTTP_REFERER} \\.opendirviewer\\. [NC,OR]\nRewriteCond %{HTTP_REFERER} users\\.skynet\\.be.* [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(http|https):// [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=(\\.\\.//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} [a-zA-Z0-9_]=/([a-z0-9_.]//?)+ [NC,OR]\nRewriteCond %{QUERY_STRING} \\=PHP[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12} [NC,OR]\nRewriteCond %{QUERY_STRING} (\\.\\./|%2e%2e%2f|%2e%2e/|\\.\\.%2f|%2e\\.%2f|%2e\\./|\\.%2e%2f|\\.%2e/) [NC,OR]\nRewriteCond %{QUERY_STRING} ftp\\: [NC,OR]\nRewriteCond %{QUERY_STRING} (http|https)\\: [NC,OR] \nRewriteCond %{QUERY_STRING} \\=\\|w\\| [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)/self/(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} ^(.*)cPath=(http|https)://(.*)$ [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*script.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^s]*s)+cript.*(&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (\\&lt;|%3C).*iframe.*(\\&gt;|%3E) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|%3C)([^i]*i)+frame.*(&gt;|%3E) [NC,OR] \nRewriteCond %{QUERY_STRING} base64_encode.*\\(.*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} base64_(en|de)code[^(]*\\([^)]*\\) [NC,OR]\nRewriteCond %{QUERY_STRING} GLOBALS(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} _REQUEST(=|\\[|\\%[0-9A-Z]{0,2}) [OR]\nRewriteCond %{QUERY_STRING} ^.*(\\(|\\)|&lt;|&gt;).* [NC,OR]\nRewriteCond %{QUERY_STRING} (NULL|OUTFILE|LOAD_FILE) [OR]\nRewriteCond %{QUERY_STRING} (\\.{1,}/)+(motd|etc|bin) [NC,OR]\nRewriteCond %{QUERY_STRING} (localhost|loopback|127\\.0\\.0\\.1) [NC,OR]\nRewriteCond %{QUERY_STRING} (&lt;|&gt;|&#039;|%0A|%0D|%27|%3C|%3E|%00) [NC,OR]\nRewriteCond %{QUERY_STRING} concat[^\\(]*\\( [NC,OR]\nRewriteCond %{QUERY_STRING} union([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} union([^a]*a)+ll([^s]*s)+elect [NC,OR]\nRewriteCond %{QUERY_STRING} (;|&lt;|&gt;|&#039;|&quot;|\\)|%0A|%0D|%22|%27|%3C|%3E|%00).*(/\\*|union|select|insert|drop|delete|update|cast|create|char|convert|alter|declare|order|script|set|md5|benchmark|encode) [NC,OR]\nRewriteCond %{QUERY_STRING} (sp_executesql) [NC]\nRewriteRule ^(.*)$ - [F]\n# END BPSQSE-check BPS QUERY STRING EXPLOITS AND FILTERS\n\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62270", "bulletproof_security_options_MScan_status", "a:17:{s:20:\"bps_mscan_time_start\";s:10:\"1506814310\";s:19:\"bps_mscan_time_stop\";s:0:\"\";s:18:\"bps_mscan_time_end\";s:10:\"1506814334\";s:24:\"bps_mscan_time_remaining\";s:10:\"1506814503\";s:16:\"bps_mscan_status\";s:1:\"4\";s:29:\"bps_mscan_last_scan_timestamp\";s:27:\"September 30, 2017 11:31 pm\";s:20:\"bps_mscan_total_time\";s:2:\"24\";s:29:\"bps_mscan_total_website_files\";s:4:\"8851\";s:29:\"bps_mscan_total_wp_core_files\";s:4:\"1321\";s:31:\"bps_mscan_total_non_image_files\";s:4:\"3332\";s:27:\"bps_mscan_total_image_files\";s:4:\"2170\";s:35:\"bps_mscan_total_all_scannable_files\";s:4:\"6823\";s:29:\"bps_mscan_total_skipped_files\";s:2:\"67\";s:29:\"bps_mscan_total_suspect_files\";s:1:\"3\";s:31:\"bps_mscan_suspect_skipped_files\";s:1:\"0\";s:26:\"bps_mscan_total_suspect_db\";s:2:\"12\";s:29:\"bps_mscan_total_ignored_files\";s:2:\"35\";}", "yes");
INSERT INTO `wpbd_options` VALUES("16720", "wpcom_publish_posts_with_markdown", "1", "yes");
INSERT INTO `wpbd_options` VALUES("140", "can_compress_scripts", "0", "no");
INSERT INTO `wpbd_options` VALUES("153", "jetpack_activated", "4", "yes");
INSERT INTO `wpbd_options` VALUES("166", "jetpack_log", "a:14:{i:0;a:4:{s:4:\"time\";i:1500528910;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}i:1;a:5:{s:4:\"time\";i:1500528930;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:65976492;s:4:\"code\";s:24:\"custom_css_4.7_migration\";s:4:\"data\";s:5:\"start\";}i:2;a:4:{s:4:\"time\";i:1503364744;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:65976492;s:4:\"code\";s:8:\"register\";}i:3;a:5:{s:4:\"time\";i:1505707690;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:8:\"carousel\";}i:4;a:5:{s:4:\"time\";i:1505707690;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:12:\"contact-form\";}i:5;a:5:{s:4:\"time\";i:1505707690;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:19:\"gravatar-hovercards\";}i:6;a:5:{s:4:\"time\";i:1505707690;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:5:\"likes\";}i:7;a:5:{s:4:\"time\";i:1505707690;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:7:\"monitor\";}i:8;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:6:\"photon\";}i:9;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"related-posts\";}i:10;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:10:\"sharedaddy\";}i:11;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:3:\"sso\";}i:12;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"subscriptions\";}i:13;a:5:{s:4:\"time\";i:1505707691;s:7:\"user_id\";i:2;s:7:\"blog_id\";i:134435670;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"tiled-gallery\";}}", "no");
INSERT INTO `wpbd_options` VALUES("157", "jetpack_file_data", "a:2:{s:3:\"5.4\";a:55:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:39:\"Check your spelling, style, and grammar\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:75:\"Display images and galleries in a gorgeous, full-screen browsing experience\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"e1c539d5b392f5a1709dada3da5793cc\";a:14:{s:4:\"name\";s:13:\"Comment Likes\";s:11:\"description\";s:64:\"Increase visitor engagement by adding a Like button to comments.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"39\";s:20:\"recommendation_order\";s:2:\"17\";s:10:\"introduced\";s:3:\"5.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:37:\"like widget, like button, like, likes\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:80:\"Let readers use WordPress.com, Twitter, Facebook, or Google+ accounts to comment\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:57:\"Insert a customizable contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:18:\"Writing, Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom content types\";s:11:\"description\";s:74:\"Display different types of content on your site with custom content types.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:53:\"Tweak your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"e1f1f6e3689fc31c477e64b06e2f8fbf\";a:14:{s:4:\"name\";s:16:\"Google Analytics\";s:11:\"description\";s:56:\"Set up Google Analytics without touching a line of code.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"37\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"4.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:37:\"webmaster, google, analytics, console\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:53:\"Automatically load new content when a visitor scrolls\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:57:\"Use LaTeX markup for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:14:\"jumpstart_desc\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:54:\"Manage all of your sites from a centralized dashboard.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:50:\"Write posts or pages in plain-text Markdown syntax\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"614679778a7db6d8129c9f69ac8e10a5\";a:14:{s:4:\"name\";s:21:\"WordPress.com Toolbar\";s:11:\"description\";s:91:\"Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"16\";s:10:\"introduced\";s:3:\"4.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"General\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:19:\"adminbar, masterbar\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:31:\"Enable the Jetpack Mobile theme\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:14:\"jumpstart_desc\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:26:\"Speed up images and photos\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:34:\"Recommended, Jumpstart, Appearance\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by email\";s:11:\"description\";s:33:\"Publish posts by sending an email\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:41:\"Block suspicious-looking sign in activity\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:27:\"Automated social marketing.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related posts\";s:11:\"description\";s:64:\"Increase page views by showing related content to your visitors.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"fe7a38addc9275dcbe6c4ff6c44a9350\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:41:\"Enhanced search, powered by Elasticsearch\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:6:\"Search\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"68b0d01689803c0ea7e4e60a86de2519\";a:14:{s:4:\"name\";s:9:\"SEO Tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:14:\"jumpstart_desc\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:18:\"Traffic, Jumpstart\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:37:\"Allow visitors to share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:50:\"Embed media from popular sites without any coding.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:54:\"Create short and simple links for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:62:\"Allow users to log into this site using WordPress.com accounts\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:87:\"Allow users to subscribe to your posts and comments and receive notifications via email\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:14:\"jumpstart_desc\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:54:\"Off-site backups, security scans, and automatic fixes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:27:\"Fast, ad-free video hosting\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:54:\"Add images, Twitter streams, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"a668bc9418d6de87409f867892fcdd7f\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}s:3:\"5.3\";a:55:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:39:\"Check your spelling, style, and grammar\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:75:\"Display images and galleries in a gorgeous, full-screen browsing experience\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"e1c539d5b392f5a1709dada3da5793cc\";a:14:{s:4:\"name\";s:13:\"Comment Likes\";s:11:\"description\";s:64:\"Increase visitor engagement by adding a Like button to comments.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"39\";s:20:\"recommendation_order\";s:2:\"17\";s:10:\"introduced\";s:3:\"5.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:37:\"like widget, like button, like, likes\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:80:\"Let readers use WordPress.com, Twitter, Facebook, or Google+ accounts to comment\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:57:\"Insert a customizable contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:18:\"Writing, Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom content types\";s:11:\"description\";s:74:\"Display different types of content on your site with custom content types.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:53:\"Tweak your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"e1f1f6e3689fc31c477e64b06e2f8fbf\";a:14:{s:4:\"name\";s:16:\"Google Analytics\";s:11:\"description\";s:56:\"Set up Google Analytics without touching a line of code.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"37\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"4.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:37:\"webmaster, google, analytics, console\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:53:\"Automatically load new content when a visitor scrolls\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:57:\"Use LaTeX markup for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:14:\"jumpstart_desc\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:54:\"Manage all of your sites from a centralized dashboard.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:50:\"Write posts or pages in plain-text Markdown syntax\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"614679778a7db6d8129c9f69ac8e10a5\";a:14:{s:4:\"name\";s:21:\"WordPress.com Toolbar\";s:11:\"description\";s:91:\"Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"16\";s:10:\"introduced\";s:3:\"4.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"General\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:19:\"adminbar, masterbar\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:31:\"Enable the Jetpack Mobile theme\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:14:\"jumpstart_desc\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:26:\"Speed up images and photos\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:34:\"Recommended, Jumpstart, Appearance\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by email\";s:11:\"description\";s:33:\"Publish posts by sending an email\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:41:\"Block suspicious-looking sign in activity\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:27:\"Automated social marketing.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related posts\";s:11:\"description\";s:64:\"Increase page views by showing related content to your visitors.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"fe7a38addc9275dcbe6c4ff6c44a9350\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:41:\"Enhanced search, powered by Elasticsearch\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:6:\"Search\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"68b0d01689803c0ea7e4e60a86de2519\";a:14:{s:4:\"name\";s:9:\"SEO Tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:14:\"jumpstart_desc\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:18:\"Traffic, Jumpstart\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:37:\"Allow visitors to share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:50:\"Embed media from popular sites without any coding.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:54:\"Create short and simple links for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:62:\"Allow users to log into this site using WordPress.com accounts\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:87:\"Allow users to subscribe to your posts and comments and receive notifications via email\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:14:\"jumpstart_desc\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:54:\"Off-site backups, security scans, and automatic fixes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:27:\"Fast, ad-free video hosting\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:54:\"Add images, Twitter streams, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"a668bc9418d6de87409f867892fcdd7f\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}", "yes");
INSERT INTO `wpbd_options` VALUES("352", "gravatar_disable_hovercards", "0", "yes");
INSERT INTO `wpbd_options` VALUES("354", "verification_services_codes", "0", "yes");
INSERT INTO `wpbd_options` VALUES("341", "wf_plugin_act_error", "", "yes");
INSERT INTO `wpbd_options` VALUES("326", "jetpack_updates_sync_checksum", "a:3:{s:11:\"update_core\";i:1544561712;s:14:\"update_plugins\";i:825955618;s:13:\"update_themes\";i:1646454566;}", "yes");
INSERT INTO `wpbd_options` VALUES("158", "jetpack_available_modules", "a:1:{s:5:\"5.7.1\";a:43:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:16:\"google-analytics\";s:3:\"4.5\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:11:\"lazy-images\";s:5:\"5.6.0\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"masterbar\";s:3:\"4.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:3:\"pwa\";s:5:\"5.6.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "yes");
INSERT INTO `wpbd_options` VALUES("159", "jetpack_options", "a:13:{s:7:\"version\";s:16:\"5.7.1:1516319188\";s:11:\"old_version\";s:14:\"5.7:1515637370\";s:2:\"id\";i:134435670;s:6:\"public\";i:0;s:9:\"jumpstart\";s:19:\"jumpstart_activated\";s:24:\"custom_css_4.7_migration\";b:1;s:14:\"last_heartbeat\";i:1516497866;s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:11:\"master_user\";i:2;s:22:\"image_widget_migration\";b:1;s:24:\"gallery_widget_migration\";b:1;s:21:\"publicize_connections\";a:5:{s:8:\"facebook\";a:1:{i:19351747;a:9:{s:7:\"user_id\";i:2;s:8:\"provider\";s:21:\"facebook:249643311490\";s:6:\"issued\";s:19:\"2016-04-28 13:34:18\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:17:\"10154246411389427\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:11:\"Buddy James\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"19351747\";s:8:\"token_id\";s:8:\"14313836\";s:7:\"blog_id\";s:9:\"134435670\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:5:{s:16:\"external_user_id\";i:2;s:13:\"facebook_page\";i:631800840249513;s:14:\"follower_count\";i:255;s:4:\"link\";s:40:\"https://www.facebook.com/gregsonstudios/\";s:12:\"display_name\";s:15:\"Gregson Studios\";}}}}s:7:\"twitter\";a:1:{i:19351750;a:9:{s:7:\"user_id\";i:2;s:8:\"provider\";s:13:\"twitter:38869\";s:6:\"issued\";s:19:\"2018-01-14 04:32:00\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:10:\"2551787120\";s:13:\"external_name\";s:14:\"GregsonStudios\";s:16:\"external_display\";s:15:\"@GregsonStudios\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"19351750\";s:8:\"token_id\";s:8:\"19253323\";s:7:\"blog_id\";s:9:\"134435670\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:1:{s:16:\"external_user_id\";i:2;}}}}s:6:\"tumblr\";a:1:{i:19351751;a:9:{s:7:\"user_id\";i:2;s:8:\"provider\";s:12:\"tumblr:10313\";s:6:\"issued\";s:19:\"2018-01-14 04:32:25\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:14:\"gregsonstudios\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:14:\"gregsonstudios\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"19351751\";s:8:\"token_id\";s:8:\"19253325\";s:7:\"blog_id\";s:9:\"134435670\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:2:{s:16:\"external_user_id\";i:2;s:20:\"tumblr_base_hostname\";s:25:\"gregsonstudios.tumblr.com\";}}}}s:11:\"google_plus\";a:1:{i:19351753;a:9:{s:7:\"user_id\";i:2;s:8:\"provider\";s:20:\"google_plus:20130624\";s:6:\"issued\";s:19:\"2018-01-14 04:33:02\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:21:\"116832102334899292070\";s:13:\"external_name\";s:15:\"Gregson Studios\";s:16:\"external_display\";s:15:\"Gregson Studios\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"19351753\";s:8:\"token_id\";s:8:\"19253328\";s:7:\"blog_id\";s:9:\"134435670\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:1:{s:16:\"external_user_id\";i:2;}}}}s:8:\"linkedin\";a:1:{i:19351758;a:9:{s:7:\"user_id\";i:2;s:8:\"provider\";s:15:\"linkedin:131428\";s:6:\"issued\";s:19:\"2018-01-14 04:33:24\";s:7:\"expires\";s:19:\"2018-03-15 04:33:23\";s:11:\"external_id\";s:10:\"qBZs3NaXen\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:19:\"Buddy James Gregson\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"19351758\";s:8:\"token_id\";s:8:\"19253335\";s:7:\"blog_id\";s:9:\"134435670\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:2:{s:16:\"external_user_id\";i:2;s:11:\"profile_url\";s:134:\"https://www.linkedin.com/profile/view?id=AAoAAAMbepcBN15Auqw98FexzLRmMlhGYbggP3o&authType=name&authToken=KN4U&trk=api*a131428*s139819*\";}}}}}}", "yes");
INSERT INTO `wpbd_options` VALUES("161", "do_activate", "0", "yes");
INSERT INTO `wpbd_options` VALUES("168", "jetpack_private_options", "a:2:{s:10:\"blog_token\";s:65:\"c5@!k4zqmztFa4BHhGHAliIm^shXWTLr.r$E7OAt)F$tprPqUyW#%jjDjCuxAu)y8\";s:11:\"user_tokens\";a:1:{i:2;s:67:\"sOcOJfxIoj%63v9iikIB)3jP!QF@(L^x.KH3@7ooTgR%fl2XSLq0UQW%upWbg2r#@.2\";}}", "yes");
INSERT INTO `wpbd_options` VALUES("169", "jetpack_unique_connection", "a:3:{s:9:\"connected\";i:2;s:12:\"disconnected\";i:1;s:7:\"version\";s:5:\"3.6.1\";}", "yes");
INSERT INTO `wpbd_options` VALUES("170", "jetpack_active_modules", "a:27:{i:0;s:18:\"after-the-deadline\";i:1;s:12:\"contact-form\";i:2;s:20:\"custom-content-types\";i:3;s:10:\"custom-css\";i:4;s:19:\"gravatar-hovercards\";i:5;s:5:\"latex\";i:6;s:6:\"manage\";i:7;s:5:\"notes\";i:9;s:13:\"post-by-email\";i:10;s:7:\"protect\";i:11;s:9:\"publicize\";i:12;s:10:\"sharedaddy\";i:13;s:10:\"shortcodes\";i:14;s:10:\"shortlinks\";i:15;s:5:\"stats\";i:16;s:13:\"subscriptions\";i:18;s:18:\"verification-tools\";i:19;s:17:\"widget-visibility\";i:20;s:7:\"widgets\";i:21;s:8:\"carousel\";i:22;s:5:\"likes\";i:23;s:7:\"monitor\";i:24;s:6:\"photon\";i:25;s:13:\"related-posts\";i:26;s:3:\"sso\";i:27;s:13:\"tiled-gallery\";i:28;s:8:\"sitemaps\";}", "yes");
INSERT INTO `wpbd_options` VALUES("173", "jetpack_protect_blocked_attempts", "28852", "no");
INSERT INTO `wpbd_options` VALUES("172", "jetpack_protect_key", "94880a40f73593d5557f47cff93f55b12bb0fb0b", "no");
INSERT INTO `wpbd_options` VALUES("37623", "jetpack_protect_activating", "activating", "no");
INSERT INTO `wpbd_options` VALUES("37626", "jetpack_sync_settings_sync_via_cron", "1", "yes");
INSERT INTO `wpbd_options` VALUES("651", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:11:\"Cheryl-Huff\";s:7:\"api_key\";s:40:\"185e7dc8a90df83149886fcda4b41a5d374bbd15\";}", "yes");
INSERT INTO `wpbd_options` VALUES("607", "et_account_status", "active", "yes");
INSERT INTO `wpbd_options` VALUES("608", "_site_transient_et_update_themes", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1516319238;}", "no");
INSERT INTO `wpbd_options` VALUES("37627", "jetpack_sync_settings_max_queue_size", "1000", "yes");
INSERT INTO `wpbd_options` VALUES("37629", "jetpack_sync_settings_post_types_blacklist", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("197", "widget_blog_subscription", "a:2:{i:2;a:6:{s:5:\"title\";s:27:\"Subscribe to Blog via Email\";s:14:\"subscribe_text\";s:99:\"Enter your email address to subscribe to this blog and receive notifications of new posts by email.\";s:21:\"subscribe_placeholder\";s:13:\"Email Address\";s:16:\"subscribe_button\";s:9:\"Subscribe\";s:15:\"success_message\";s:136:\"Success! An email was just sent to confirm your subscription. Please find the email now and click \'Confirm Follow\' to start subscribing.\";s:22:\"show_subscribers_total\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("198", "widget_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("199", "widget_eu_cookie_law_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("200", "widget_facebook-likebox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("201", "widget_flickr", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("202", "widget_wpcom-goodreads", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("203", "widget_google_translate_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("204", "widget_googleplus-badge", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("205", "widget_grofile", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("206", "widget_internet_defense_league_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("207", "widget_widget_mailchimp_subscriber_popup", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("208", "widget_milestone_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("209", "widget_jetpack_my_community", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("210", "widget_rss_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("211", "widget_wpcom_social_media_icons_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("212", "widget_twitter_timeline", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("213", "widget_upcoming_events_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("214", "widget_jetpack_display_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("217", "jetpack_portfolio", "0", "yes");
INSERT INTO `wpbd_options` VALUES("219", "sharedaddy_disable_resources", "0", "yes");
INSERT INTO `wpbd_options` VALUES("220", "jetpack_testimonial", "0", "yes");
INSERT INTO `wpbd_options` VALUES("228", "trusted_ip_header", "O:8:\"stdClass\":3:{s:14:\"trusted_header\";s:11:\"REMOTE_ADDR\";s:8:\"segments\";i:1;s:7:\"reverse\";b:0;}", "no");
INSERT INTO `wpbd_options` VALUES("229", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";i:65976492;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO `wpbd_options` VALUES("151833", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1516601327", "no");
INSERT INTO `wpbd_options` VALUES("37643", "jetpack_sync_settings_max_enqueue_full_sync", "100", "yes");
INSERT INTO `wpbd_options` VALUES("37644", "jetpack_sync_settings_max_queue_size_full_sync", "1000", "yes");
INSERT INTO `wpbd_options` VALUES("37645", "jetpack_sync_settings_cron_sync_time_limit", "30", "yes");
INSERT INTO `wpbd_options` VALUES("5233", "wpseo_sitemap_lbmn_project_cache_validator", "3A7ua", "no");
INSERT INTO `wpbd_options` VALUES("142588", "wpseo_sitemap_32019_cache_validator", "2dkkR", "no");
INSERT INTO `wpbd_options` VALUES("151846", "_transient_jetpack_idc_allowed", "1", "no");
INSERT INTO `wpbd_options` VALUES("151845", "_transient_timeout_jetpack_idc_allowed", "1516562726", "no");
INSERT INTO `wpbd_options` VALUES("137878", "_transient_timeout_amp_img_13ee9fba7ec8f648d0b443a4463a07f6", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137880", "_transient_timeout_amp_img_9aa13042935432d6e21ed4ed0a5318a9", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137881", "_transient_amp_img_9aa13042935432d6e21ed4ed0a5318a9", "a:2:{i:0;i:1024;i:1;i:1024;}", "no");
INSERT INTO `wpbd_options` VALUES("137882", "_transient_timeout_amp_img_d731baa0171e62a99042a5aa3fa99a33", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137883", "_transient_amp_img_d731baa0171e62a99042a5aa3fa99a33", "a:2:{i:0;i:1024;i:1;i:1024;}", "no");
INSERT INTO `wpbd_options` VALUES("137884", "_transient_timeout_amp_img_d01c32663cdb2b4b0a442a30640f69c0", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137885", "_transient_amp_img_d01c32663cdb2b4b0a442a30640f69c0", "a:2:{i:0;i:1024;i:1;i:1024;}", "no");
INSERT INTO `wpbd_options` VALUES("137886", "_transient_timeout_amp_img_aa2f61f074c3a5c4c3af08025c46df37", "1517946406", "no");
INSERT INTO `wpbd_options` VALUES("137887", "_transient_amp_img_aa2f61f074c3a5c4c3af08025c46df37", "a:2:{i:0;i:1024;i:1;i:1024;}", "no");
INSERT INTO `wpbd_options` VALUES("151900", "_transient_timeout_jetpack_jitm_0c5af2caebf2c64b7a425f5edc98d2f", "1516562274", "no");
INSERT INTO `wpbd_options` VALUES("143443", "jetpack_relatedposts", "a:2:{i:0;b:0;s:15:\"show_thumbnails\";b:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("53877", "social_notifications_like", "on", "yes");
INSERT INTO `wpbd_options` VALUES("151882", "_transient_timeout_brute_use_math", "1516562430", "no");
INSERT INTO `wpbd_options` VALUES("151883", "_transient_brute_use_math", "1", "no");
INSERT INTO `wpbd_options` VALUES("151884", "jetpack_protect_error", "Invalid Action Specified", "no");
INSERT INTO `wpbd_options` VALUES("11236", "wpseo_sitemap_category_cache_validator", "2Hqwy", "no");
INSERT INTO `wpbd_options` VALUES("13914", "wpseo_sitemap_post_tag_cache_validator", "2Hqwz", "no");
INSERT INTO `wpbd_options` VALUES("4181", "wpseo_sitemap_layout_category_cache_validator", "24i7z", "no");
INSERT INTO `wpbd_options` VALUES("65913", "layout_category_children", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("2885", "wpseo_sitemap_cache_validator_global", "CRmW", "no");
INSERT INTO `wpbd_options` VALUES("146786", "category_children", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("307", "wordpress_api_key", "4092c28ad3aa", "yes");
INSERT INTO `wpbd_options` VALUES("308", "akismet_spam_count", "80", "yes");
INSERT INTO `wpbd_options` VALUES("518", "et_images_temp_folder", "/home/gregso5/public_html/wp-content/uploads/et_temp", "yes");
INSERT INTO `wpbd_options` VALUES("512", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("513", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("514", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wpbd_options` VALUES("515", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("516", "et_divi", "a:157:{s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:25:\"3_0_flush_rewrite_rules_2\";s:4:\"done\";s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:15:\"divi_1_3_images\";s:7:\"checked\";s:9:\"divi_logo\";s:68:\"http://gregsonstudios.com/wp-content/uploads/2017/08/GS_Logo_600.png\";s:12:\"divi_favicon\";s:64:\"http://gregsonstudios.com/wp-content/uploads/2017/08/favicon.ico\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_mailchimp_api_key\";s:0:\"\";s:31:\"divi_regenerate_mailchimp_lists\";s:5:\"false\";s:28:\"divi_regenerate_aweber_lists\";s:5:\"false\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:21:\"divi_show_google_icon\";s:2:\"on\";s:18:\"divi_show_rss_icon\";s:5:\"false\";s:17:\"divi_facebook_url\";s:39:\"https://www.facebook.com/gregsonstudios\";s:16:\"divi_twitter_url\";s:34:\"https://twitter.com/GregsonStudios\";s:15:\"divi_google_url\";s:39:\"https://plus.google.com/+Gregsonstudios\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:2:\"on\";s:16:\"divi_back_to_top\";s:2:\"on\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:15:\"divi_custom_css\";s:0:\"\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:25:\"divi_scroll_to_anchor_fix\";s:5:\"false\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:40:\"divi_email_provider_credentials_migrated\";b:1;s:19:\"product_tour_status\";a:3:{i:1;s:3:\"off\";i:2;s:3:\"off\";i:3;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:30:\"et_fb_pref_modal_snap_location\";s:5:\"false\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:495;s:33:\"et_fb_pref_modal_dimension_height\";i:546;s:27:\"et_fb_pref_modal_position_x\";i:1087;s:27:\"et_fb_pref_modal_position_y\";i:232;s:9:\"footer_bg\";s:7:\"#3f3f3f\";s:24:\"show_footer_social_icons\";b:0;s:29:\"disable_custom_footer_credits\";b:0;s:21:\"custom_footer_credits\";s:33:\"Copyright © 2018 Gregson Studios\";s:21:\"bottom_bar_text_color\";s:7:\"#b2b2b2\";s:14:\"footer_columns\";s:1:\"3\";s:39:\"static_css_custom_css_safety_check_done\";b:1;s:27:\"divi_minify_combine_scripts\";s:2:\"on\";s:26:\"divi_minify_combine_styles\";s:2:\"on\";s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:16:\"body_header_size\";i:30;s:12:\"accent_color\";s:7:\"#25a51c\";s:12:\"heading_font\";s:6:\"Oswald\";s:12:\"header_style\";s:4:\"left\";s:12:\"vertical_nav\";b:0;s:13:\"nav_fullwidth\";b:1;s:11:\"menu_height\";i:58;s:21:\"primary_nav_font_size\";i:14;s:16:\"menu_link_active\";s:7:\"#25a51c\";s:23:\"secondary_nav_fullwidth\";b:1;s:31:\"primary_nav_dropdown_line_color\";s:7:\"#25a51c\";s:16:\"secondary_nav_bg\";s:7:\"#3f3f3f\";s:24:\"show_header_social_icons\";b:1;s:22:\"fixed_secondary_nav_bg\";s:7:\"#0c71c3\";s:22:\"fixed_menu_link_active\";s:7:\"#25a51c\";s:12:\"phone_number\";s:12:\"720-980-0219\";s:26:\"footer_widget_header_color\";s:7:\"#ffffff\";s:26:\"footer_widget_bullet_color\";s:7:\"#ffffff\";s:9:\"menu_link\";s:7:\"#3f3f3f\";s:22:\"primary_nav_font_style\";s:9:\"uppercase\";s:24:\"primary_nav_font_spacing\";i:-1;s:27:\"fixed_primary_nav_font_size\";i:14;s:12:\"header_email\";s:0:\"\";s:16:\"show_search_icon\";b:1;s:31:\"primary_nav_dropdown_link_color\";s:7:\"#25a51c\";s:27:\"divi_skip_font_subset_force\";b:1;s:11:\"logo_height\";i:52;s:8:\"hide_nav\";b:0;s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:27:\"et_pb_clear_templates_cache\";b:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("646", "et_google_api_settings", "a:2:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";}", "yes");
INSERT INTO `wpbd_options` VALUES("510", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("511", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("507", "et_pb_cache_notice", "a:1:{s:6:\"3.0.26\";s:6:\"ignore\";}", "yes");
INSERT INTO `wpbd_options` VALUES("148250", "jetpack_sync_full__send_started", "1516319213", "no");
INSERT INTO `wpbd_options` VALUES("148251", "jetpack_sync_full__constants_sent", "1", "no");
INSERT INTO `wpbd_options` VALUES("148252", "jetpack_sync_full__functions_sent", "1", "no");
INSERT INTO `wpbd_options` VALUES("148253", "jetpack_sync_full__options_sent", "1", "no");
INSERT INTO `wpbd_options` VALUES("148254", "jetpack_sync_full__users_sent", "1", "no");
INSERT INTO `wpbd_options` VALUES("148255", "jetpack_sync_full__finished", "1516319213", "no");
INSERT INTO `wpbd_options` VALUES("337", "wordfence_version", "6.3.22", "yes");
INSERT INTO `wpbd_options` VALUES("97346", "cbnetpo_last_ping_time", "2018-01-16 01:36:49", "yes");
INSERT INTO `wpbd_options` VALUES("338", "wordfenceActivated", "1", "yes");
INSERT INTO `wpbd_options` VALUES("519", "et_schedule_clean_images_last_time", "1516265934", "yes");
INSERT INTO `wpbd_options` VALUES("2581", "redux_builder_amp", "a:260:{s:8:\"last_tab\";s:1:\"8\";s:9:\"opt-media\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:31:\"ampforwp-custom-logo-dimensions\";s:1:\"0\";s:15:\"opt-media-width\";s:3:\"190\";s:16:\"opt-media-height\";s:2:\"36\";s:24:\"amp-on-off-for-all-posts\";s:1:\"1\";s:24:\"amp-on-off-for-all-pages\";s:1:\"1\";s:32:\"ampforwp-homepage-on-off-support\";s:1:\"1\";s:27:\"amp-frontpage-select-option\";s:1:\"0\";s:33:\"amp-frontpage-select-option-pages\";s:1:\"2\";s:28:\"ampforwp-title-on-front-page\";s:1:\"0\";s:24:\"ampforwp-archive-support\";s:1:\"0\";s:24:\"ampforwp-content-builder\";s:1:\"1\";s:34:\"ampforwp-ads-data-loading-strategy\";s:1:\"0\";s:16:\"enable-amp-ads-1\";s:1:\"0\";s:23:\"enable-amp-ads-select-1\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-1\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-1\";s:0:\"\";s:16:\"enable-amp-ads-2\";s:1:\"0\";s:23:\"enable-amp-ads-select-2\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-2\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-2\";s:0:\"\";s:16:\"enable-amp-ads-3\";s:1:\"0\";s:23:\"enable-amp-ads-select-3\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-3\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-3\";s:0:\"\";s:16:\"enable-amp-ads-4\";s:1:\"0\";s:23:\"enable-amp-ads-select-4\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-4\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-4\";s:0:\"\";s:16:\"enable-amp-ads-5\";s:1:\"0\";s:23:\"enable-amp-ads-select-5\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-5\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-5\";s:0:\"\";s:16:\"enable-amp-ads-6\";s:1:\"0\";s:23:\"enable-amp-ads-select-6\";s:1:\"2\";s:34:\"enable-amp-ads-text-feild-client-6\";s:0:\"\";s:32:\"enable-amp-ads-text-feild-slot-6\";s:0:\"\";s:29:\"ampforwp-seo-meta-description\";s:1:\"0\";s:35:\"ampforwp-seo-custom-additional-meta\";s:0:\"\";s:23:\"ampforwp-seo-yoast-meta\";s:1:\"1\";s:30:\"ampforwp-seo-yoast-description\";s:1:\"0\";s:42:\"ampforwp-robots-archive-sub-pages-sitewide\";s:1:\"0\";s:36:\"ampforwp-robots-archive-author-pages\";s:1:\"1\";s:34:\"ampforwp-robots-archive-date-pages\";s:1:\"1\";s:38:\"ampforwp-robots-archive-category-pages\";s:1:\"1\";s:33:\"ampforwp-robots-archive-tag-pages\";s:1:\"1\";s:28:\"ampforwp_cache_minimize_mode\";s:1:\"1\";s:27:\"amp-analytics-select-option\";s:1:\"1\";s:8:\"ga-feild\";s:13:\"UA-53431710-1\";s:32:\"ampforwp-ga-field-advance-switch\";s:1:\"0\";s:25:\"ampforwp-ga-field-advance\";s:0:\"\";s:8:\"sa-feild\";s:17:\"SEGMENT-WRITE-KEY\";s:8:\"pa-feild\";s:1:\"#\";s:9:\"eam-feild\";s:1:\"#\";s:8:\"sc-feild\";s:1:\"#\";s:28:\"amp-quantcast-analytics-code\";s:0:\"\";s:30:\"amp-comscore-analytics-code-c1\";s:1:\"1\";s:30:\"amp-comscore-analytics-code-c2\";s:0:\"\";s:13:\"histats-feild\";s:0:\"\";s:33:\"amp-Yandex-Metrika-analytics-code\";s:0:\"\";s:28:\"amp-Chartbeat-analytics-code\";s:0:\"\";s:18:\"amp-use-gtm-option\";s:1:\"0\";s:10:\"amp-gtm-id\";s:0:\"\";s:22:\"amp-gtm-analytics-type\";s:0:\"\";s:22:\"amp-gtm-analytics-code\";s:0:\"\";s:12:\"amp-fb-pixel\";s:1:\"0\";s:15:\"amp-fb-pixel-id\";s:0:\"\";s:22:\"ampforwp-sd-type-posts\";s:11:\"BlogPosting\";s:22:\"ampforwp-sd-type-pages\";s:11:\"BlogPosting\";s:24:\"ampforwp-sd-type-project\";s:11:\"BlogPosting\";s:24:\"amp-structured-data-logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"ampforwp-sd-logo-dimensions\";s:1:\"0\";s:22:\"ampforwp-sd-logo-width\";s:3:\"600\";s:23:\"ampforwp-sd-logo-height\";s:2:\"60\";s:37:\"amp-structured-data-placeholder-image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:43:\"amp-structured-data-placeholder-image-width\";s:3:\"700\";s:44:\"amp-structured-data-placeholder-image-height\";s:3:\"550\";s:39:\"amporwp-structured-data-video-thumb-url\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:24:\"amp-enable-notifications\";s:0:\"\";s:21:\"amp-notification-text\";s:26:\"This website uses cookies.\";s:22:\"amp-accept-button-text\";s:6:\"Accept\";s:27:\"ampforwp-web-push-onesignal\";s:1:\"0\";s:26:\"ampforwp-one-signal-app-id\";s:0:\"\";s:28:\"ampforwp-onesignal-http-site\";s:1:\"0\";s:28:\"ampforwp-onesignal-subdomain\";s:0:\"\";s:39:\"ampforwp-onesignal-translator-subscribe\";s:20:\"Subscribe to updates\";s:41:\"ampforwp-onesignal-translator-unsubscribe\";s:24:\"Unsubscribe from updates\";s:22:\"amp-enable-contactform\";s:0:\"\";s:31:\"amp-enable-gravityforms_support\";s:0:\"\";s:26:\"wordpress-comments-support\";s:0:\"\";s:27:\"ampforwp-number-of-comments\";s:2:\"10\";s:32:\"ampforwp-disqus-comments-support\";s:1:\"0\";s:29:\"ampforwp-disqus-comments-name\";s:0:\"\";s:29:\"ampforwp-disqus-host-position\";s:1:\"1\";s:25:\"ampforwp-disqus-host-file\";s:0:\"\";s:34:\"ampforwp-facebook-comments-support\";s:1:\"0\";s:36:\"ampforwp-number-of-fb-no-of-comments\";s:2:\"10\";s:25:\"fb-instant-article-switch\";s:1:\"0\";s:33:\"ampforwp-fb-instant-article-posts\";s:2:\"50\";s:22:\"fb-instant-article-ads\";s:1:\"0\";s:24:\"fb-instant-article-ad-id\";s:0:\"\";s:29:\"fb-instant-article-ad-density\";s:7:\"defualt\";s:28:\"fb-instant-article-analytics\";s:1:\"0\";s:33:\"fb-instant-article-analytics-code\";s:0:\"\";s:22:\"amp-pages-meta-default\";s:4:\"show\";s:19:\"hide-amp-categories\";a:1:{i:1;s:0:\"\";}s:22:\"amp-mobile-redirection\";s:1:\"0\";s:20:\"amp-meta-permissions\";s:3:\"all\";s:29:\"amp-header-text-area-for-html\";s:0:\"\";s:18:\"amp-body-text-area\";s:0:\"\";s:29:\"amp-footer-text-area-for-html\";s:0:\"\";s:27:\"ampforwp-auto-amp-menu-link\";s:1:\"0\";s:35:\"ampforwp-category-base-removel-link\";s:1:\"0\";s:30:\"ampforwp-tag-base-removal-link\";s:1:\"0\";s:44:\"ampforwp-custom-fields-featured-image-switch\";s:1:\"0\";s:37:\"ampforwp-custom-fields-featured-image\";s:0:\"\";s:36:\"ampforwp-featured-image-from-content\";s:1:\"0\";s:33:\"ampforwp-duplicate-featured-image\";s:1:\"0\";s:25:\"ampforwp-development-mode\";s:1:\"0\";s:32:\"ampforwp-update-notification-bar\";s:1:\"1\";s:11:\"amp-use-pot\";s:1:\"0\";s:35:\"amp-translator-show-more-posts-text\";s:15:\"Show more Posts\";s:39:\"amp-translator-show-previous-posts-text\";s:19:\"Show previous Posts\";s:23:\"amp-translator-top-text\";s:3:\"Top\";s:32:\"amp-translator-non-amp-page-text\";s:20:\"View Non-AMP Version\";s:27:\"amp-translator-related-text\";s:12:\"Related Post\";s:28:\"amp-translator-navigate-text\";s:8:\"Navigate\";s:22:\"amp-translator-on-text\";s:2:\"On\";s:24:\"amp-translator-next-text\";s:4:\"Next\";s:28:\"amp-translator-previous-text\";s:8:\"Previous\";s:26:\"amp-translator-footer-text\";s:19:\"All Rights Reserved\";s:30:\"amp-translator-categories-text\";s:12:\"Categories: \";s:24:\"amp-translator-tags-text\";s:6:\"Tags: \";s:22:\"amp-translator-by-text\";s:2:\"By\";s:27:\"amp-translator-published-by\";s:12:\"Published by\";s:29:\"amp-translator-in-designthree\";s:2:\"in\";s:33:\"amp-translator-view-comments-text\";s:13:\"View Comments\";s:35:\"amp-translator-leave-a-comment-text\";s:15:\"Leave a Comment\";s:22:\"amp-translator-at-text\";s:2:\"at\";s:24:\"amp-translator-says-text\";s:4:\"says\";s:24:\"amp-translator-Edit-text\";s:4:\"Edit\";s:28:\"amp-translator-ago-date-text\";s:3:\"ago\";s:33:\"amp-translator-modified-date-text\";s:31:\"This post was last modified on \";s:31:\"amp-translator-archive-cat-text\";s:10:\"Category: \";s:31:\"amp-translator-archive-tag-text\";s:5:\"Tag: \";s:29:\"amp-translator-show-more-text\";s:15:\"View More Posts\";s:29:\"amp-translator-next-read-text\";s:11:\"Next Read: \";s:23:\"amp-translator-via-text\";s:3:\"via\";s:26:\"amp-translator-search-text\";s:19:\" You searched for: \";s:30:\"amp-translator-search-no-found\";s:49:\" It seems we can\'t find what you\'re looking for. \";s:27:\"ampforwp-search-placeholder\";s:9:\"Type Here\";s:19:\"amp-design-selector\";s:1:\"2\";s:30:\"amp-opt-color-rgba-colorscheme\";a:3:{s:5:\"color\";s:7:\"#F42F42\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(244,47,66,1)\";}s:23:\"amp-opt-color-rgba-font\";a:3:{s:5:\"color\";s:4:\"#fff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:23:\"amp-opt-color-rgba-link\";a:3:{s:5:\"color\";s:7:\"#f42f42\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(244,47,66,1)\";}s:31:\"amp-opt-color-rgba-link-design2\";a:3:{s:5:\"color\";s:7:\"#0a89c0\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:18:\"rgba(10,137,192,1)\";}s:31:\"amp-opt-color-rgba-link-design1\";a:3:{s:5:\"color\";s:7:\"#0a89c0\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:18:\"rgba(10,137,192,1)\";}s:27:\"enable-amp-call-numberfield\";s:0:\"\";s:35:\"amp-opt-color-rgba-colorscheme-call\";a:3:{s:5:\"color\";s:7:\"#0a89c0\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:18:\"rgba(10,137,192,1)\";}s:10:\"css_editor\";s:54:\"/******* Paste your Custom CSS in this Editor *******/\";s:17:\"ampforwp-amp-menu\";s:1:\"1\";s:27:\"amp-design-3-search-feature\";s:1:\"0\";s:27:\"amp-design-2-search-feature\";s:1:\"0\";s:27:\"amp-design-1-search-feature\";s:1:\"0\";s:23:\"ampforwp-callnow-button\";s:1:\"0\";s:30:\"amp-opt-color-rgba-headercolor\";a:3:{s:5:\"color\";s:7:\"#FFFFFF\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:33:\"amp-opt-color-rgba-headerelements\";a:3:{s:5:\"color\";s:4:\"#333\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(51,51,51,1)\";}s:40:\"amp-on-off-support-for-non-amp-home-page\";s:1:\"0\";s:19:\"amp-opt-sticky-head\";s:1:\"0\";s:28:\"amp-design-3-featured-slider\";s:1:\"1\";s:30:\"amp-design-3-category-selector\";s:0:\"\";s:23:\"excerpt-option-design-1\";s:1:\"1\";s:20:\"amp-design-1-excerpt\";s:2:\"20\";s:26:\"ampforwp-design1-cats-home\";s:1:\"0\";s:23:\"excerpt-option-design-2\";s:1:\"0\";s:20:\"amp-design-2-excerpt\";s:2:\"20\";s:23:\"excerpt-option-design-3\";s:1:\"0\";s:20:\"amp-design-3-excerpt\";s:2:\"20\";s:26:\"amp-design-1-featured-time\";s:1:\"1\";s:26:\"amp-design-3-featured-time\";s:1:\"1\";s:23:\"ampforwp-full-post-date\";s:1:\"0\";s:41:\"ampforwp-homepage-posts-image-modify-size\";s:1:\"0\";s:40:\"ampforwp-homepage-posts-design-1-2-width\";s:3:\"100\";s:41:\"ampforwp-homepage-posts-design-1-2-height\";s:2:\"75\";s:38:\"ampforwp-homepage-posts-design-3-width\";s:3:\"330\";s:39:\"ampforwp-homepage-posts-design-3-height\";s:3:\"198\";s:20:\"ampforwp-bread-crumb\";s:1:\"1\";s:20:\"ampforwp-cats-single\";s:1:\"1\";s:20:\"ampforwp-tags-single\";s:1:\"1\";s:31:\"ampforwp-cats-tags-links-single\";s:1:\"1\";s:26:\"enable-single-social-icons\";s:1:\"1\";s:21:\"enable-excerpt-single\";s:1:\"0\";s:23:\"enable-single-next-prev\";s:1:\"1\";s:18:\"post-modified-date\";s:1:\"0\";s:22:\"amp-author-description\";s:1:\"1\";s:24:\"ampforwp-author-page-url\";s:1:\"0\";s:25:\"amp-design-3-date-feature\";s:1:\"0\";s:14:\"amp-pagination\";s:1:\"0\";s:38:\"ampforwp-single-select-type-of-related\";s:1:\"2\";s:38:\"ampforwp-single-order-of-related-posts\";s:1:\"0\";s:32:\"ampforwp-number-of-related-posts\";s:1:\"3\";s:29:\"ampforwp-inline-related-posts\";s:1:\"0\";s:28:\"amp-footer-link-non-amp-page\";s:1:\"1\";s:19:\"ampforwp-footer-top\";s:1:\"1\";s:27:\"ampforwp-footer-top-design3\";s:1:\"0\";s:24:\"amp-design-3-credit-link\";s:1:\"1\";s:9:\"meta_page\";s:1:\"0\";s:29:\"ampforwp-facebook-like-button\";s:1:\"0\";s:26:\"ampforwp-facebook-like-url\";s:0:\"\";s:28:\"enable-single-facebook-share\";s:1:\"0\";s:19:\"amp-facebook-app-id\";s:0:\"\";s:27:\"enable-single-twitter-share\";s:1:\"1\";s:34:\"enable-single-twitter-share-handle\";s:0:\"\";s:32:\"enable-single-twitter-share-link\";s:1:\"0\";s:25:\"enable-single-gplus-share\";s:1:\"1\";s:25:\"enable-single-email-share\";s:1:\"1\";s:29:\"enable-single-pinterest-share\";s:1:\"1\";s:28:\"enable-single-linkedin-share\";s:1:\"1\";s:28:\"enable-single-whatsapp-share\";s:1:\"1\";s:24:\"enable-single-line-share\";s:1:\"1\";s:22:\"enable-single-vk-share\";s:1:\"0\";s:33:\"enable-single-odnoklassniki-share\";s:1:\"0\";s:30:\"enable-single-twittter-profile\";s:1:\"1\";s:34:\"enable-single-twittter-profile-url\";s:1:\"#\";s:30:\"enable-single-facebook-profile\";s:1:\"1\";s:34:\"enable-single-facebook-profile-url\";s:1:\"#\";s:30:\"enable-single-pintrest-profile\";s:1:\"1\";s:34:\"enable-single-pintrest-profile-url\";s:1:\"#\";s:33:\"enable-single-google-plus-profile\";s:1:\"0\";s:37:\"enable-single-google-plus-profile-url\";s:0:\"\";s:29:\"enable-single-linkdin-profile\";s:1:\"0\";s:33:\"enable-single-linkdin-profile-url\";s:0:\"\";s:29:\"enable-single-youtube-profile\";s:1:\"1\";s:33:\"enable-single-youtube-profile-url\";s:1:\"#\";s:31:\"enable-single-instagram-profile\";s:1:\"0\";s:35:\"enable-single-instagram-profile-url\";s:0:\"\";s:31:\"enable-single-VKontakte-profile\";s:1:\"0\";s:35:\"enable-single-VKontakte-profile-url\";s:0:\"\";s:28:\"enable-single-reddit-profile\";s:1:\"0\";s:32:\"enable-single-reddit-profile-url\";s:0:\"\";s:30:\"enable-single-snapchat-profile\";s:1:\"0\";s:34:\"enable-single-snapchat-profile-url\";s:0:\"\";s:28:\"enable-single-Tumblr-profile\";s:1:\"0\";s:32:\"enable-single-Tumblr-profile-url\";s:0:\"\";s:21:\"amp-rtl-select-option\";s:1:\"0\";s:28:\"ampforwp-plugin-manager-core\";s:1:\"0\";s:31:\"ampforwp-sub-categories-support\";s:1:\"0\";s:40:\"amp-translator-breadcrumbs-homepage-text\";s:8:\"Homepage\";s:25:\"ampforwp-post-date-format\";s:1:\"1\";s:30:\"ampforwp-post-date-format-text\";s:10:\"% days ago\";s:35:\"fb-instant-article-ad-density-setup\";s:7:\"default\";s:39:\"ampforwp-number-of-inline-related-posts\";s:1:\"3\";s:22:\"ampforwp-alexa-account\";s:0:\"\";s:21:\"ampforwp-alexa-domain\";s:0:\"\";s:41:\"ampforwp-web-push-onesignal-below-content\";i:1;s:41:\"ampforwp-web-push-onesignal-above-content\";i:0;s:35:\"ampforwp-instant-article-author-bio\";i:0;s:34:\"ampforwp-inline-related-posts-type\";s:1:\"2\";s:35:\"ampforwp-inline-related-posts-order\";i:0;}", "yes");
INSERT INTO `wpbd_options` VALUES("68912", "carousel_display_exif", "1", "yes");
INSERT INTO `wpbd_options` VALUES("356", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:4:\"icon\";s:13:\"sharing_label\";b:0;s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:0:{}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO `wpbd_options` VALUES("502", "current_theme", "Divi", "yes");
INSERT INTO `wpbd_options` VALUES("503", "theme_mods_Divi", "a:10:{i:0;b:0;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:21:\"et_pb_layouts_updated\";s:3:\"yes\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"et_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"et_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"custom_css_post_id\";i:40;s:34:\"et_pb_predefined_layouts_version_6\";s:2:\"on\";s:21:\"et_pb_replace_content\";s:2:\"on\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:8;}}", "yes");
INSERT INTO `wpbd_options` VALUES("505", "theme_switched", "", "yes");
INSERT INTO `wpbd_options` VALUES("9294", "wpseo_sitemap_lbmn_project_attribute_cache_validator", "3I9fJ", "no");
INSERT INTO `wpbd_options` VALUES("143287", "wpseo_sitemap_32047_cache_validator", "aTmu", "no");
INSERT INTO `wpbd_options` VALUES("299", "akismet_strictness", "0", "yes");
INSERT INTO `wpbd_options` VALUES("300", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wpbd_options` VALUES("37633", "jetpack_sync_settings_dequeue_max_bytes", "500000", "yes");
INSERT INTO `wpbd_options` VALUES("37634", "jetpack_sync_settings_upload_max_bytes", "600000", "yes");
INSERT INTO `wpbd_options` VALUES("37635", "jetpack_sync_settings_upload_max_rows", "500", "yes");
INSERT INTO `wpbd_options` VALUES("37636", "jetpack_sync_settings_sync_wait_time", "10", "yes");
INSERT INTO `wpbd_options` VALUES("37637", "jetpack_sync_settings_sync_wait_threshold", "5", "yes");
INSERT INTO `wpbd_options` VALUES("37638", "jetpack_sync_settings_enqueue_wait_time", "10", "yes");
INSERT INTO `wpbd_options` VALUES("37639", "jetpack_sync_settings_queue_max_writes_sec", "100", "yes");
INSERT INTO `wpbd_options` VALUES("37640", "jetpack_sync_settings_render_filtered_content", "0", "yes");
INSERT INTO `wpbd_options` VALUES("37641", "jetpack_sync_settings_post_meta_whitelist", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("37642", "jetpack_sync_settings_comment_meta_whitelist", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("278", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO `wpbd_options` VALUES("37628", "jetpack_sync_settings_max_queue_lag", "900", "yes");
INSERT INTO `wpbd_options` VALUES("281", "jetpack_next_sync_time_full-sync-enqueue", "1516561995", "yes");
INSERT INTO `wpbd_options` VALUES("282", "jetpack_active_plan", "a:7:{s:10:\"product_id\";i:2002;s:12:\"product_slug\";s:12:\"jetpack_free\";s:18:\"product_name_short\";s:4:\"Free\";s:10:\"free_trial\";b:0;s:7:\"expired\";b:0;s:13:\"user_is_owner\";b:0;s:7:\"is_free\";b:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("52075", "wpseo_sitemap_30807_cache_validator", "a2VN", "no");
INSERT INTO `wpbd_options` VALUES("9239", "wpseo_sitemap_lbmn_project_type_cache_validator", "bVJf", "no");
INSERT INTO `wpbd_options` VALUES("37664", "jetpack_sync_https_history_main_network_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wpbd_options` VALUES("37661", "jetpack_constants_sync_checksum", "a:19:{s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:17:\"WP_POST_REVISIONS\";i:4261170317;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:7:\"ABSPATH\";i:1469522856;s:14:\"WP_CONTENT_DIR\";i:1625606290;s:9:\"FS_METHOD\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:4261170317;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:16:\"JETPACK__VERSION\";i:2736397588;s:12:\"IS_PRESSABLE\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:11:\"PHP_VERSION\";i:1881145656;s:15:\"WP_MEMORY_LIMIT\";i:3065409971;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1839787262;}", "yes");
INSERT INTO `wpbd_options` VALUES("65651", "feedback_unread_count", "0", "yes");
INSERT INTO `wpbd_options` VALUES("16067", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"gregsonstudios@gmail.com\";s:7:\"version\";s:5:\"4.9.2\";s:9:\"timestamp\";i:1516146560;}", "no");
INSERT INTO `wpbd_options` VALUES("16059", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("146562", "wpseo_sitemap_32123_cache_validator", "33MRR", "no");
INSERT INTO `wpbd_options` VALUES("5553", "wpseo_sitemap_author_cache_validator", "61aRH", "no");
INSERT INTO `wpbd_options` VALUES("8940", "widget_blog-stats", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("8943", "widget_widget_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("8944", "widget_top-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpbd_options` VALUES("151827", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1516601327", "no");
INSERT INTO `wpbd_options` VALUES("151828", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1516558127", "no");
INSERT INTO `wpbd_options` VALUES("89174", "wpseo_gsc_last_fetch", "1509593036", "no");
INSERT INTO `wpbd_options` VALUES("89031", "pys_free_activation_time", "1509591077", "yes");
INSERT INTO `wpbd_options` VALUES("89032", "pys_free_notices_version", "5.0.0", "yes");
INSERT INTO `wpbd_options` VALUES("89033", "pys_free_dismissed_options", "a:0:{}", "yes");
INSERT INTO `wpbd_options` VALUES("2640", "wpseo_amp", "a:20:{s:7:\"version\";i:1;s:13:\"amp_site_icon\";s:0:\"\";s:13:\"default_image\";s:0:\"\";s:12:\"header-color\";s:0:\"\";s:14:\"headings-color\";s:0:\"\";s:10:\"text-color\";s:0:\"\";s:10:\"meta-color\";s:0:\"\";s:10:\"link-color\";s:0:\"\";s:16:\"link-color-hover\";s:0:\"\";s:9:\"underline\";s:9:\"underline\";s:21:\"blockquote-text-color\";s:0:\"\";s:19:\"blockquote-bg-color\";s:0:\"\";s:23:\"blockquote-border-color\";s:0:\"\";s:9:\"extra-css\";s:0:\"\";s:10:\"extra-head\";s:0:\"\";s:15:\"analytics-extra\";s:0:\"\";s:19:\"post_types-post-amp\";s:2:\"on\";s:19:\"post_types-page-amp\";s:3:\"off\";s:25:\"post_types-attachment-amp\";s:3:\"off\";s:22:\"post_types-project-amp\";s:3:\"off\";}", "yes");
INSERT INTO `wpbd_options` VALUES("2642", "ampforwp_default_pages_to", "show", "yes");
INSERT INTO `wpbd_options` VALUES("2745", "wpseo_sitemap_1_cache_validator", "2Hqwx", "no");
INSERT INTO `wpbd_options` VALUES("2746", "wpseo_sitemap_page_cache_validator", "yC9U", "no");
INSERT INTO `wpbd_options` VALUES("146722", "wpseo_sitemap_32132_cache_validator", "37yFQ", "no");
INSERT INTO `wpbd_options` VALUES("142452", "wpseo_sitemap_32015_cache_validator", "2aB33", "no");
INSERT INTO `wpbd_options` VALUES("97032", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wpbd_options` VALUES("97033", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wpbd_options` VALUES("593", "_site_transient_et_update_all_plugins", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1516535767;}", "no");
INSERT INTO `wpbd_options` VALUES("62263", "bulletproof_security_options_login_security_jtc", "a:20:{s:23:\"bps_tooltip_captcha_key\";s:3:\"jtc\";s:30:\"bps_tooltip_captcha_hover_text\";s:16:\"Type/Enter:  jtc\";s:25:\"bps_tooltip_captcha_title\";s:33:\"Hover or click the text box below\";s:27:\"bps_tooltip_captcha_logging\";s:3:\"Off\";s:18:\"bps_jtc_login_form\";s:1:\"1\";s:21:\"bps_jtc_register_form\";s:0:\"\";s:25:\"bps_jtc_lostpassword_form\";s:0:\"\";s:20:\"bps_jtc_comment_form\";s:0:\"\";s:32:\"bps_jtc_buddypress_register_form\";s:0:\"\";s:31:\"bps_jtc_buddypress_sidebar_form\";s:0:\"\";s:21:\"bps_jtc_administrator\";s:0:\"\";s:14:\"bps_jtc_editor\";s:0:\"\";s:14:\"bps_jtc_author\";s:0:\"\";s:19:\"bps_jtc_contributor\";s:0:\"\";s:18:\"bps_jtc_subscriber\";s:0:\"\";s:26:\"bps_jtc_comment_form_error\";s:0:\"\";s:26:\"bps_jtc_comment_form_label\";s:0:\"\";s:26:\"bps_jtc_comment_form_input\";s:0:\"\";s:20:\"bps_jtc_custom_roles\";a:2:{i:0;s:3:\"bps\";i:1;s:0:\"\";}s:26:\"bps_enable_jtc_woocommerce\";s:0:\"\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62262", "bulletproof_security_options_MU_tools_free", "a:3:{s:22:\"bps_mu_tools_timestamp\";s:10:\"1509160761\";s:38:\"bps_mu_tools_enable_disable_autoupdate\";s:7:\"disable\";s:40:\"bps_mu_tools_enable_disable_deactivation\";s:6:\"enable\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62258", "bulletproof_security_options_hidden_plugins", "a:1:{s:24:\"bps_hidden_plugins_check\";s:0:\"\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62259", "bulletproof_security_options_sec_log_post_limit", "a:3:{s:27:\"bps_security_log_post_limit\";s:0:\"\";s:26:\"bps_security_log_post_none\";s:1:\"1\";s:25:\"bps_security_log_post_max\";s:0:\"\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62260", "bulletproof_security_options_email", "a:11:{s:17:\"bps_send_email_to\";s:24:\"gregsonstudios@gmail.com\";s:19:\"bps_send_email_from\";s:24:\"gregsonstudios@gmail.com\";s:17:\"bps_send_email_cc\";s:0:\"\";s:18:\"bps_send_email_bcc\";s:0:\"\";s:24:\"bps_login_security_email\";s:11:\"lockoutOnly\";s:21:\"bps_security_log_size\";s:5:\"500KB\";s:23:\"bps_security_log_emailL\";s:5:\"email\";s:17:\"bps_dbb_log_email\";s:5:\"email\";s:16:\"bps_dbb_log_size\";s:5:\"500KB\";s:18:\"bps_mscan_log_size\";s:5:\"500KB\";s:19:\"bps_mscan_log_email\";s:5:\"email\";}", "yes");
INSERT INTO `wpbd_options` VALUES("62261", "bulletproof_security_options_login_security", "a:11:{s:14:\"bps_max_logins\";s:1:\"3\";s:20:\"bps_lockout_duration\";s:2:\"15\";s:27:\"bps_manual_lockout_duration\";s:2:\"60\";s:23:\"bps_max_db_rows_display\";s:0:\"\";s:24:\"bps_login_security_OnOff\";s:2:\"On\";s:26:\"bps_login_security_logging\";s:11:\"logLockouts\";s:25:\"bps_login_security_errors\";s:8:\"wpErrors\";s:28:\"bps_login_security_remaining\";s:2:\"On\";s:27:\"bps_login_security_pw_reset\";s:6:\"enable\";s:23:\"bps_login_security_sort\";s:9:\"ascending\";s:26:\"bps_enable_lsm_woocommerce\";s:0:\"\";}", "yes");
INSERT INTO `wpbd_options` VALUES("3129", "wpseo_sitemap_layout_type_cache_validator", "24i7x", "no");
INSERT INTO `wpbd_options` VALUES("3130", "wpseo_sitemap_scope_cache_validator", "24i7w", "no");
INSERT INTO `wpbd_options` VALUES("3131", "wpseo_sitemap_module_width_cache_validator", "24i7y", "no");
INSERT INTO `wpbd_options` VALUES("151829", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1516601327", "no");
INSERT INTO `wpbd_options` VALUES("151830", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: R.I.P Dean\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47840\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2018/01/r-i-p-dean/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3493:\"<p>Dean Allen, a web pioneer and good man, has passed away. I&#x27;ve been processing the news for a few days and still don&#x27;t know where to begin. Dean was a writer, who wrote the software he wrote on. His websites were crafted, designed, and typeset so well you would have visited them even if they were filled with Lorem Ipsum, and paired with his writing you were drawn into an impossibly rich world. His blog was called Textism, and among many other things it introduced me to the art of typography.</p>\n\n\n\n<p>Later, he created Textpattern, without which WordPress wouldn&#x27;t exist. Later, he created Textdrive with Jason Hoffman, without which WordPress wouldn&#x27;t have found an early business model or had a home on the web. He brought a care and craft to everything he touched that inspires me to this day. As <a href=\"https://daringfireball.net/2018/01/dean_allen\">John Gruber said</a>, \"Dean strove for perfection and often achieved it.\" (Aside: Making typography better on the web led John Gruber to release Smarty Pants, Dean a tool called Textile, and myself something called Texturize all within a few months of each other; John continued his work and created Markdown, I put Texturize into WP, and Dean released Textile in Textpattern.)</p>\n\n\n\n<p>Years later, we became friends and shared many trips, walks, drinks, and meals together, often with Hanni and <a href=\"https://om.co/2018/01/18/dean-allen-rest-in-peace/\">Om</a>. (When we overlapped in Vancouver he immediately texted \"I&#x27;ll show you some butt-kicking food and drink.\") His zest for life was matched with an encyclopedic knowledge of culture and voracious reading (and later podcast listening) habits. I learned so much in our time together, a web inspiration who turned for me into a real-life mensch. He was endlessly generous with his time and counsel in design, prose, and fashion. I learned the impossibly clever sentences he wrote, that you assumed were the product of a small writing crew or at least a few revisions, came annoyingly easily to him, an extension of how he actually thought and wrote and the culmination of a lifetime of telling stories and connecting to the human psyche.</p>\n\n\n\n<p>Dean, who (of course) was also a great photographer, didn&#x27;t love having his own photo taken but would occasionally tolerate me when I pointed a camera at him <a href=\"https://om.co/2018/01/18/dean-allen-rest-in-peace/\">and Om has a number of the photos on his post</a>. There&#x27;s one that haunts me: before getting BBQ we were at his friend&#x27;s apartment in Vancouver, listening to Mingus and enjoying hand-crafted old fashioneds with <a href=\"https://ma.tt/files/2018/01/IMG_7147.jpg\">antique bitters</a>, and despite the rain we went on the roof to see the art that was visible from there. He obliged to a photo this time though and we took photos of each other individually in front of a sign that said \"EVERYTHING IS GOING TO BE ALRIGHT.\" It wasn&#x27;t, but it&#x27;s what I imagine Dean would say right now if he could.</p>\n\n\n\n<div class=\"wp-block-gallery alignnone columns-2 is-cropped\">\n    <img src=\"https://i2.wp.com/ma.tt/files/2018/01/IMG_7151.jpg?w=604&ssl=1\" />\n    <img src=\"https://i0.wp.com/ma.tt/files/2018/01/IMG_7158.jpg?w=604&ssl=1\" />\n</div>\n\n\n\n<img src=\"https://i1.wp.com/ma.tt/files/2018/01/104050690_ce98a95092_o.jpg?w=604&ssl=1\" />\n    When we first met, in 2006, <a href=\"https://www.flickr.com/photos/textdriveinc/104050690/in/photostream/\">from Jason</a>.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Jan 2018 05:21:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: WPWeekly Episode 301 – WordPress in HigherEd, Accessibility, and More With Rachel Cherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=77497&preview=true&preview_id=77497\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/wpweekly-episode-301-wordpress-in-highered-accessibility-and-more-with-rachel-cherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2840:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://bamadesigner.com/\">Rachel Cherry</a>, Senior Software Engineer for <a href=\"http://www.disneyinteractive.com/\">Disney Interactive</a> and Director of <a href=\"https://wpcampus.org/\">WPCampus</a>. Cherry describes how she got involved with WordPress, its use in higher education, the inspiration behind WPCampus, and her thoughts on accessibility both in WordPress and across the web. She also assigned everyone the following homework assignment.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Per my interview on <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> Weekly, I’ve assigned everyone <a href=\"https://twitter.com/hashtag/accessibility?src=hash&ref_src=twsrc%5Etfw\">#accessibility</a> homework: open your website and navigate using ONLY THE KEYBOARD. Can you access all content and functionality? Can you open AND close popups? Let me know what you learned.</p>\n<p>&mdash; Rachel Cherry (@bamadesigner) <a href=\"https://twitter.com/bamadesigner/status/953742847831818240?ref_src=twsrc%5Etfw\">January 17, 2018</a></p></blockquote>\n<p></p>\n<p>If you want to learn how WordPress is being used in higher education, tune in to<a href=\"https://online.wpcampus.org/\"> WPCampus Online</a> Tuesday, January 30, 2018. Viewers will be able to watch sessions and interact with the speakers for free. Near the end of the show, Jacoby provides a review of the Nintendo Switch he received for Christmas.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://make.wordpress.org/core/2018/01/12/whats-new-in-gutenberg-12th-january/\">Gutenberg 2.0 Released</a><br />\n<a href=\"https://wptavern.com/wordpress-4-9-2-patches-xss-vulnerability\">WordPress 4.9.2 Patches XSS Vulnerability</a><br />\n<a href=\"https://wptavern.com/zac-gordon-launches-gutenberg-development-course-includes-more-than-30-videos\">Zac Gordon Launches Gutenberg Development Course, Includes More Than 30 Videos</a></p>\n<h2>Picks of the Week:</h2>\n<p><a href=\"https://pippinsplugins.com/2017-in-review/\">Pippin Williamson&#8217;s 2017 Year in Review</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 24th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #301:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Jan 2018 02:42:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: DesktopServer 3.8.4 Includes A Gift to the Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=77259\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/desktopserver-3-8-4-includes-a-gift-to-the-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2204:\"<p>DesktopServer <a href=\"https://serverpress.com/announcing-desktopserver-v3-8-4/\">has released</a> version 3.8.4 of its local development software. This version includes a lot of refactored code, setting the foundation for faster updates in the future along with design-time plugins.</p>\n\n\n\n<p>One of the major changes in 3.8.4 is the use of the .dev.cc top level domain.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n    <p>Due to the latest changes with the .dev Top Level Domain and the fact that many browsers now force SSL on anything with the .dev extension, DesktopServer will now use .dev.cc as its TLD extension. This is a legitimate top level domain owned by ServerPress, LLC and will ONLY be used for local development purposes.</p><cite><a href=\"https://serverpress.com/announcing-desktopserver-v3-8-4/\">Release Announcement Post</a></cite></blockquote>\n\n\n\n<p>Marc Benzakein says the domain will work no matter which local development solution is being used and that it&#x27;s a gift to the community. Other domains such as .test will continue to work as expected. </p>\n\n\n\n<p>Other improvements include speed optimizations for Windows installs, a Windows compatibility plugin to fix long filename problems when updating from third-party plugin repositories such as Easy Digital Downloads, and a WordPress 4.9.1 Blueprint.</p>\n\n\n\n<p>If you use an Apple device with a Retina screen or Hi-DPI in Windows, you&#x27;ll likely appreciate the user-interface changes that are vastly improved on high resolution screens. Josh Eby does!</p>\n\n\n\n\n    <blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Love the new scaling fix on <a href=\"https://twitter.com/DesktopServer?ref_src=twsrc%5Etfw\">@DesktopServer</a> 3.8.4!  Looks great on my 4K display now. Can\'t wait for 3.9 to get released!</p>&mdash; Josh Eby (@josheby) <a href=\"https://twitter.com/josheby/status/953089139439751168?ref_src=twsrc%5Etfw\">January 16, 2018</a></blockquote>\n\n\n\n\n<p>DesktopServer 3.8.4 also includes a number of enhancements for premium service customers. To view these and other notes related to the release, check out <a href=\"https://serverpress.com/announcing-desktopserver-v3-8-4/\">the announcement post</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Jan 2018 19:12:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: WordPress 4.9.2 Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=77438\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/wordpress-4-9-2-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1106:\"<p>WordPress 4.9.2 has been released and patches a cross-site scripting vulnerability in the Flash fallback files in the MediaElement library. <a href=\"https://wordpress.org/news/2018/01/wordpress-4-9-2-security-and-maintenance-release/\">According to Ian Dunn</a>, the Flash files are rarely needed and have been removed from WordPress.</p>\n\n\n\n<p>If you need access to the Flash fallback files, they can be obtained using the <a href=\"https://wordpress.org/plugins/mediaelement-flash-fallbacks/\">MediaElement Flash Fallback</a> plugin. <a href=\"https://opnsec.com\">Enguerran Gillier</a> and <a href=\"https://widiz.com/\">Widiz</a> are credited with responsibly disclosing the vulnerability. ﻿</p>\n\n\n\n<p>In addition to the patch, this releases fixes 21 bugs. JavaScript errors that prevented saving posts in Firefox has been fixed and switching themes will attempt to restore previous widget assignments, even if no sidebars exist.</p>\n\n\n\n<p>You can view detailed information about the changes in 4.9.2 by <a href=\"https://codex.wordpress.org/Version_4.9.2\">reading the following Codex article</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Jan 2018 09:19:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"HeroPress: Growing WordPress in India\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2406\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://heropress.com/essays/growing-wordpress-india/#utm_source=rss&utm_medium=rss&utm_campaign=growing-wordpress-india\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18327:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/011718-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The world will know you for the path you have chosen.\" /><h3>Preface</h3>\n<p>I was one of the first batch of participants in the initial version of HeroPress, which was video stories but I backed out due to multiple reasons. But, I’m glad HeroPress has survived in this current avatar, telling some really interesting stories of some real wonderful people. Few of whom I’ve had the pleasure of calling friends.</p>\n<p><a href=\"https://heropress.com/about/\">Topher</a> has umpteen number of times asked me to write my HeroPress story and I have always either given excuses or deadlines that I never planned on meeting. The few times that I did start writing this article I went into too much of a deep dive into my life story (that I never finished it&#8230;) which is quite the rollercoaster from having failed Std.10th (high School) in English or dropping out in College to having guest lectured(teaching WordPress, of course) in one of the biggest B-schools in India OR my work experience which includes Film, TV, dealing cards to even working as an assistant to the Union Minister of India for Youth Affairs and sports… There I go again!! While that does make for a good story I should save it for when you buy me a beer.</p>\n<p>I wanted my HeroPress article to tell a story of how our WordPress Community is truly open source and always open for everyone’s participation. I think this version does the Job. Also would like to thank <a href=\"https://profiles.wordpress.org/andreamiddleton\">Andrea Middleton </a>and <a href=\"https://twitter.com/adityakane?lang=en\">Aditya Kane</a> who have been the most supportive of my efforts all these years. Last but not the least I’d like to thank Topher for this great space he has created and being a true friend with whom I could share some of my troubles.</p>\n<p>I am <a href=\"https://twitter.com/gounder?lang=en\">Alexander Gounder</a>, somewhat of a nobody who become somebody not only because I tried but also because WordPress is open enough to allow it and this is my story!</p>\n<h3>Background</h3>\n<p>I was born in a lower middle class household in Mumbai, India. I am the middle kid among three siblings. My Father works as a tailor in Saudi Arabia and visits every few years. My Mother is a strong willed woman, who would fight the world for her kids which was evident when she refused to listen to doctors that my sister who suffers from Cerebral Palsy be sent to Special school and instead went pillar to post to get her to study in her normal school, even if it meant that she had to wait outside class during school hours (in case my sister had to go to the restroom) or carry my sister (who then was about 8 yrs old) around.</p>\n<blockquote><p>I live where 70%, if not more, of Mumbai’s population lives the slum or <a href=\"https://en.wikipedia.org/wiki/Chawl\">chawls</a> in the suburbs.</p></blockquote>\n<p>So I’ve lived through the hunger for a day when I lost <u title=\"15 cents USD\">Rs.10</u> on my way to buy bread, this was during the Gulf war when my father couldn’t send us any money for months; I’ve lived through the darkness of when there our frequent power cuts and still the power companies claim that there isn’t any load shedding in this city; I’ve lived through the annual ritual of walking in knee deep water to school, then college and now work as Monsoon water, thanks to clogged drains finds its way to the empty plot between our chawl and the main road.</p>\n<p>In terms of education I was an above average student but somehow managed to fail my Std. 10 board exams (this is a very important milestones in the Indian education system). Failure has been my stepping stone to success. I learnt computers as I had free time because I had to wait six months for joining college. I got a job at a local cyber cafe which was run by a linux enthusiast, this was my introduction to Free and Open Source. Post that I attended college (but didn’t graduate) and had many jobs (I’ve been working since I was 17, almost 50% of my lifetime).</p>\n<p>To conclude, the point I’m trying to make here is, I don’t come from a lot of money or have a lot in terms of education qualifications in spite of which I was able to do everything I did in the WordPress Community here in Mumbai and India at large.</p>\n<h3>My first WordCamp</h3>\n<p>I was an attendee at the first WordCamp in Mumbai in 2012. I was pretty excited about attending it, because only a few days before I saw a video from WordCamp San Francisco. I thought the idea of having a conference about WordPress was super cool. Though the tickets seemed a little expensive, I had just started freelancing and wasn’t attending events yet, so didn’t really have any benchmarks and thought it was worth it as this was an International/official event.</p>\n<p>My excitement was short lived when talks were sponsor pitches or mostly not about WordPress. The arrangements too weren’t as expected. During a session that was delayed by over 45 mins because the speaker and his connectivity problems (which could have been resolved by just using another machine), I lost my cool and walked out, one of the volunteers struck a conversation with me where I began by complaining about the arrangements and wanted to speak with the organizers to complain, but anger turned to sympathy when I realized that these student volunteers were in fact the event organizers, with that fact in mind even putting together this event was a great achievement. I probed further trying to understand where things were going wrong, checked what they paid for the t-shirts, it was about 30-40% higher than market price, asked if everyone paid the sponsor amount listed on the site, they said &#8211; many had bargained for upto 50% less than the published sponsor slab and some agreed with speaker slots thrown in. I asked how many tickets they sold and was informed free tickets were distributed in their colleges and to some of their partners. Partners? These were a few individuals who in the guise of helping these kids organize WordCamp had brokered deals that got sponsors discounts and/or speaker slots, free tickets (over 50) for friends / colleagues / employees, speaker slots for themselves and even their companies or brands as in kind sponsors.</p>\n<p>On the second day, things went to a confrontational stage with many (who paid to attend the event) questioning the Non-WordPress talks and long twitter threads ensued. While it is easy to blame the organizers of the WC Mumbai 2012, I think it was those few selfish individuals who weren’t part of the organizing team but tried to influence them while offering to help.</p>\n<p>This showed there was a need for the Indian WordPress Community to come together so we started a small buddypress website which was inundated with spam registrations hence replaced it with a <a href=\"https://www.facebook.com/groups/JaiWP/\">FB group</a>.</p>\n<p>This WordPress India FB group helped us co-ordinate our first meetup in Jan 2013.</p>\n<h3>Visiting Other WordCamps</h3>\n<p>While talking to others about bringing WordPress enthusiasts from all over India, I got a sense there&#8217;s mostly mistrust among people involved in WordCamps and those attending or speaking at it. That&#8217;s when something I read on plan.wordcamp.org struck me, it said that sponsoring a WordCamp is a great way to contribute and give back. So I sponsored the next WordCamp in India, WC Baroda. When asked what is the sponsoring brand, I named our BuddyPress website. Little did I realise that this helped others see I was genuinely interested in bringing people together than make a quick buck or get publicity for myself.</p>\n<p>While the next few WordCamps were better than my experience at WC Mumbai 2012, but they shared some common threads, in terms of the people who spoke there, or how there was no clarity in terms of how speakers were selected. I had even applied to speak at a WordCamp through FB chat, because that&#8217;s how the organiser was handling it. To my disappointment I sat through a session at that WordCamp with someone from automattic presenting exactly what I had proposed, later to be told by the speaker that he didn&#8217;t intend to speak and this was a topic proposed by the organisers.</p>\n<blockquote><p>I was disgusted by how these WordCamps were filled with shady underhand deals and zero transparency. While WordCamps had some set of guidelines and expectations, these organizers knowingly or unknowingly followed none of them.</p></blockquote>\n<p>At that point of time, the idea of organising a WordCamp in Mumbai came to mind too, but then what if I would end up doing the same as what was already happening was the only thing that stopped me from applying for a WordCamp.</p>\n<h3>Moment of truth</h3>\n<p>WordPress turned 10, and there were meetups organised everywhere and with a little confusion we too managed to organise a meet-up at a coffee shop, here the attendees weren&#8217;t people who we normally meet at WordCamps but regular WordPress users who discovered the meetup through WordPress.org. They had some amazing stories to tell about their association with the software &#8211; I met Manish who 80k downloads for his theme on WordPress.org or Sachin who had been blogging since ‘98 even before WordPress.</p>\n<p>So I realised the Meetups and WordCamps weren&#8217;t really reaching most WordPress users within our own neighborhood, these users were equally passionate about WordPress and they too wanted to have real world meetups to meet others like them.</p>\n<h3>Then how did we do it</h3>\n<h4>We not I</h4>\n<p>While “I” claim to have broken WordCamps in India, I couldn’t have done it alone. Right from the beginning I started asking other to join and help out, because we were at the end of the day trying to build a community and that couldn’t be done alone. At first it was Aditya, then we had other regular members like Sahil and Vachan join in to help us organize regular meetups.</p>\n<p>Getting more stock holders allowed us to bring a different perspective to everything that we were doing. Till then people blocked others from participating as organizers or volunteers because of their own insecurities and used the line that “meetups don’t work in India”. Maybe even peddling that lie to even WordPress Foundation which was then allowing these WordCamps in the hope they would kickstart local. We went the opposite way.</p>\n<h4>Persevere</h4>\n<p>When we started off with meetups we were told “Meetups don’t work in India”, but this wasn’t true because I was already attending Startup Saturday, a monthly Meetup for startups, Quora had a meetup, Many Bloggers had meetups. So we got started. A few meetups had 10-20 people showing up while others had 2-3 but we didn’t give up on meetups because we were meeting new people which was our end goal. Aditya once remarked that even if he met one new person and discussed WordPress that would be a successful, and has resulted in us having a fairly active meetup with so many different people speaking and attending it.</p>\n<h4>Put a little thought</h4>\n<p>I became very close friends with Aditya and we spent a lot of time discussing what we were doing here. We were a good cop / bad cop team many times. From our discussion we set up some guidelines for what we stood for inclusiveness and transparency. This was before we had a WordCamp Handbook which guides you through most of the challenges you would face.</p>\n<p>We were the first WordCamp in India to publish the code of conduct and make sure it was accessible to everyone, we made repeated announcements on the run-up to the WordCamp and during the WordCamp about this Code of Conduct and how serious we were about following it. We even discussed thing amongst ourselves about handling any complaints about violations of the code of conduct, for e.g. as per Indian law you can’t disclose the identity of a person who is victim of Sexual Harassment and therefore we took care and had a system in place to take complaints and maintain the complainants privacy.</p>\n<p>When we did our first WordCamp we tried to have ticket cost as low as possible (<u title=\"\">INR 300</u> or pay more if you’d like) to allow anyone to afford it. ( Fun fact &#8211; WC Mumbai to date has the lowest Avg. ticket price per day among WordCamps in India ).</p>\n<blockquote><p>At the first WordCamp Mumbai (2014) organized by our meetup group, I had someone come to me and tell me that he was glad to have attended and missed the last Mumbai WordCamp because the tickets were too expensive and his parents wouldn’t give him that kind of money.</p></blockquote>\n<p>This reinforced my view of never making WordCamp tickets too expensive, in fact we picked up what WC Pune 2015 did and started offering Student Discounts among other discounts to aid inclusivity.</p>\n<p>During the WordCamp preparation time all vendor information, speaker selection and accounts data was available to all organizers, post WordCamp Mumbai 2014, we published this account on our WordCamp website for everyone to review.</p>\n<h4>Focus on Basics</h4>\n<p>We want to build a community that shared information and talked about WordPress, So we focused on the basics that included having regular meetups. Even our first WordCamp was very low key in terms of the menu or swag at the event or international speakers or host of sponsors… the things that other used to say if they organized a successful WordCamp. We focused instead on getting good speakers, affordable tickets, reaching out and spreading the message about our WordCamp. Putting in a Processes / Guidelines for speakers selection and so on. We wanted to get the WordCamp right rather than find something that we could brag about, we knew if we delivered on the first we could then brag all we want. Some simple ideas helped us cut cost as we didn’t really have many sponsors For e.g. we had packed lunch packets which bought catering cost to <u title=\"$2.36\">INR 150/day</u> from INR 350 &#8211; 450/day if we would have a simple buffet spread. We did mugs instead of tshirts because the quality ones costed us INR 80 instead of INR 150 for decent quality t-shirts.</p>\n<h4>Keeping it open</h4>\n<p>We didn’t discriminate amongst attendees or treat someone as more important than others, everyone from the organizing team was approachable and we wanted to help. The meetups too became a welcoming space, we tried to keep a check on behaviour that could harmful or make the space unwelcoming to other. We didn’t shy away from calling out sexist behaviour. We didn’t discriminate amongst people who wanted to volunteer, we have freelancers and students in our team and they are as important as someone who owns an IT firm employing several people.</p>\n<h4>What the future holds for us</h4>\n<p>Even before WordCamp Central had a rule for allowing a person to be lead organizer only for two consecutive years we had started on planning of grooming the next set of leaders so that, if we decide to become a little inactive meetups and WordCamps would continue as usual.</p>\n<p>WordCamp Mumbai in a gist:</p>\n<p>As a result of the above I can proudly say that WordCamp Mumbai is oldest actively running WordCamp/meetup group in India having had twice as many WordCamps than any other city.</p>\n<p>I would like to leave you with this song which everyone here at our meetup group can Identify with.</p>\n<div class=\"jetpack-video-wrapper\"></div>\n<p>हमारी ही मुठ्ठी में आकाश सारा (Humari hi mutthi mein akash sara)<br />\nजब भी खुलेगी चमकेगा तारा (Jab bhi khulenga chamkenga tara)<br />\nकभी ना ढले जो, वो ही सितारा (Kabhi na dale jo, woh hi sitara)<br />\nदिशा जिस से पहचाने संसार सारा (Disha jis se pehchane sansaar sara)</p>\n<p>These lyrics roughly translate to</p>\n<p>We have the skies in our fist. Whenever it opens, a star will shine.</p>\n<p>One that never sets will be a Superstar and the world will know you for the path you have chosen.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Growing WordPress in India\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Growing%20WordPress%20in%20India&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fgrowing-wordpress-india%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Growing WordPress in India\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fgrowing-wordpress-india%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fgrowing-wordpress-india%2F&title=Growing+WordPress+in+India\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Growing WordPress in India\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/growing-wordpress-india/&media=https://heropress.com/wp-content/uploads/2018/01/011718-150x150.jpg&description=Growing WordPress in India\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Growing WordPress in India\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/growing-wordpress-india/\" title=\"Growing WordPress in India\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/growing-wordpress-india/\">Growing WordPress in India</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Jan 2018 02:30:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Alexander Gounder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Dev Blog: WordPress 4.9.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5376\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/01/wordpress-4-9-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3953:\"<p>WordPress 4.9.2 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7﻿. We strongly encourage you to update your sites immediately.</p>\n\n\n\n<p>An XSS vulnerability was discovered in the Flash fallback files in MediaElement, a library that is included with WordPress. Because the Flash files are no longer needed for most use cases, they have been removed from WordPress.</p>\n\n\n\n<p>MediaElement has released a new version that contains a fix for the bug, and <a href=\"https://wordpress.org/plugins/mediaelement-flash-fallbacks/\">a WordPress plugin containing the fixed files</a> is available in the plugin repository.</p>\n\n\n\n<p>Thank you to the reporters of this issue for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible security disclosure</a>: <a href=\"https://opnsec.com\">Enguerran Gillier</a> and <a href=\"https://widiz.com/\">Widiz﻿</a>.</p>\n\n\n\n<p>21 other bugs were fixed in WordPress 4.9.2. Particularly of note were:</p>\n\n\n\n<ul>\n    <li>JavaScript errors that prevented saving posts in Firefox have been fixed.</li>\n    <li>The previous taxonomy-agnostic behavior of <code>get_category_link()</code> and <code>category_description()</code> was restored.</li>\n    <li>Switching themes will now attempt to restore previous widget assignments, even when there are no sidebars to map.<br /></li>\n</ul>\n\n\n\n<p>The Codex has <a href=\"https://codex.wordpress.org/Version_4.9.2\">more information about all of the issues fixed in 4.9.2</a>, if you&#x27;d like to learn more.</p>\n\n\n\n<p>﻿<a href=\"https://wordpress.org/download/\"></a><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.2</a> or venture over to Dashboard → Updates and click \"Update Now.\" Sites that support automatic background updates are already beginning to update automatically.</p>\n\n\n\n<p>Thank you to everyone who contributed to WordPress 4.9.2:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/0x6f0/\">0x6f0</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/chasewg/\">chasewg</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/hardik-amipara/\">Hardik Amipara</a>, <a href=\"https://profiles.wordpress.org/ionvv/\">ionvv</a>, <a href=\"https://profiles.wordpress.org/jaswrks/\">Jason Caldwell</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnschulz/\">johnschulz</a>, <a href=\"https://profiles.wordpress.org/juiiee8487/\">Juhi Patel</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rinkuyadav999/\">Rinku Y</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.﻿<strong></strong><br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jan 2018 23:00:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Ian Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Gutenberg 2.0 Released With Numerous Accessibility and Keyboard Navigation Improvements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=77370\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://wptavern.com/gutenberg-2-0-released-with-numerous-accessibility-and-keyboard-navigation-improvements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1337:\"<p><a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg 2.0</a> is available for testing and includes a <a href=\"https://wordpress.org/plugins/gutenberg/#developers\">changelog</a> that&#x27;s a mile long. Accessibility, keyboard navigation, and the ability to drag-and-drop multiple images to the Gallery block are among the improvements listed.</p>\n\n\n\n<p>Clicking the Publish button displays options in the sidebar rather than a drop-down menu to add polish to the publishing flow.<br /></p>\n\n\n\n<img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/01/PublishButtonSidebarOptions.png?w=627&ssl=1\" />\n    Publish Button Options In The Sidebar\n\n\n\n\n<p>The Table of Contents has <a href=\"https://github.com/WordPress/gutenberg/pull/4288\">been redesigned</a> to increase readability and copying and pasting has also significantly improved. </p>\n\n\n\n<p>Gutenberg 2.0 covers a lot of ground and the changes are too numerous to list here. However, Matias Ventura does a great job <a href=\"https://make.wordpress.org/core/2018/01/12/whats-new-in-gutenberg-12th-january/\">listing the changes</a> with links to Pull Requests on GitHub where people can see how they were made.</p>\n\n\n\n<p>If you haven&#x27;t tried or tested <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg</a>, now is a great time to check it out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jan 2018 22:48:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Thirty-Four\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47801\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2018/01/thirty-four/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2257:\"<p>I am very thankful and grateful to have made it through the past year, which was a really special one personally and professionally. I learned to open myself up more to relationships, continued aspiring to be clear and direct with <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">yellow arrows</a>, and worked alongside some incredible people to tackle the biggest and hardest problems, whether it was getting plugin and theme support on WP.com or the start and growth of <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg</a>.</p>\n\n\n\n<p>I read a <a href=\"https://ma.tt/2017/12/books-in-2017/\">lot more books</a>, traveled 337k miles between 91 cities, spent more time in Texas, kept my health in a good balance with weight training, running, and a better diet including several months of 16/8 intermittent fasting, while still getting in some excellent meals with friends and loved ones (up to 58% of top 50 list). As I&#x27;m solidly in my mid-thirties now, and I want to continue to live by: all things in moderation. I consider what I do with WordPress and Automattic my life&#x27;s work, and hope to continue it as long as I&#x27;m useful. Some days I pinch myself.</p>\n\n\n\n<p>Thank you to all of you on this journey with me. I am imperfect but trying my darndest, and I&#x27;m lucky to have friends and colleagues doing the same.</p>\n\n\n\n<img src=\"https://i1.wp.com/ma.tt/files/2018/01/IMG_1232.jpg?w=604&ssl=1\" />\n\n\n\n<p>Previously: <a href=\"https://ma.tt/2003/01/bday/\">19</a>, <a href=\"https://ma.tt/2004/01/so-im-20/\">20</a>, <a href=\"https://ma.tt/2005/01/hot-barely-legal-matt/\">21</a>, <a href=\"https://ma.tt/2006/01/matt-22/\">22</a>, <a href=\"https://ma.tt/2007/01/twenty-three/\">23</a>, <a href=\"https://ma.tt/2008/01/twenty-four/\">24</a>, <a href=\"https://ma.tt/2009/01/twenty-five/\">25</a>, <a href=\"https://ma.tt/2010/01/twenty-six/\">26</a>, <a href=\"https://ma.tt/2011/01/twenty-seven/\">27</a>, <a href=\"https://ma.tt/2012/01/twenty-eight/\">28</a>, <a href=\"https://ma.tt/2013/01/twenty-nine/\">29</a>, <a href=\"https://ma.tt/2014/01/matt-3-0/\">30</a>, <a href=\"https://ma.tt/2015/01/thirty-one/\">31</a>, <a href=\"https://ma.tt/2016/01/thirty-two/\">32</a>, and <a href=\"https://ma.tt/2017/01/thirty-three/\">33</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Jan 2018 01:55:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"HeroPress: Make It Better, Give It Back\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2396\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://heropress.com/essays/make-better-give-back/#utm_source=rss&utm_medium=rss&utm_campaign=make-better-give-back\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13545:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/011017-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Giving back makes me a better person and allows me to help others become better people.\" /><p>Recently, technology entrepreneur Anil Dash <a href=\"https://twitter.com/anildash/status/939137973240696832\">tweeted the following question</a>:</p>\n<blockquote><p>Who is a person (not counting family) that opened doors for you in your career when they didn&#8217;t have to? Anytime is a good time to show gratitude!</p></blockquote>\n<p>If you need a pick-me-up, go and read through the replies and threads that start with Anil&#8217;s question. There are replies from many people who are grateful to others for an unending variety of reasons, some large and immediate, some small and indirect, some that were only realised months or years later.</p>\n<p>One commonality between many of the replies is that of selflessness. People who help others without expecting something in return. This prompted me to think about those people who&#8217;ve helped me in my career through their own selflessness, without my prompting, and without their expecting anything in return.</p>\n<p>I&#8217;m lucky that several people have helped me in this way. My WordPress story started in around 1998 when, as a fourteen year old living in a house that was one among just sixteen in a forest in the English countryside, my divorced parents saved up and bought me a Windows 98 PC for Christmas. A personal computer was a big expenditure for my parents. We weren&#8217;t able to afford an Internet connection, and at that time I don&#8217;t recall being particularly aware of the Internet. As a result, I took an interesting route into web development.</p>\n<p>Windows PCs at the time came bundled with Internet Explorer and promotional material from Internet service providers in HTML files. I wanted to find out how these pages were built, and I discovered Frontpage Express could edit the files, although often with many errors (which years later I attributed to the lack of HTML standards in use).</p>\n<blockquote><p>One day my curiosity lead me to the View Source menu in Internet Explorer. <strong>Boom</strong>. What is all this code? What do all these angle brackets do? Is this how web pages are built? Can I change this?</p></blockquote>\n<p>Naturally, everything I changed initially broke pages completely. The Undo command was my version control system. I figured out that text wrapped in <code>&lt;b&gt;</code> produced bold text. I hadn&#8217;t a clue how a <code>&lt;table&gt;</code> worked without breaking it. <code>&lt;marquee&gt;</code> ended up everywhere. Poor support for much of the markup in these files made Frontpage redundant. Looking back, I could say that the View Source menu in Internet Explorer was an important part of the progression of my career. Maybe also that of thousands of other web developers. If the inventor and early adopters of the web hadn&#8217;t been strong proponents of open data and information sharing, it&#8217;s possible that the View Source menu would never have existed and the open web would not have flourished to the extent that it has.</p>\n<p>(The topic of open access to technology, both software and hardware, can be discussed all day. Consider if Adobe Photoshop would have had the same great commercial success that it did without its widespread piracy leading to an abundance of students leaving school with years of Photoshop experience. But I digress.)</p>\n<p>I spent evenings after school hacking on HTML. My older brother Adam gave me a book titled &#8220;How to Create pages for the Web using HTML&#8221; which introduced me to the world of HTML 2.0. I learned about the available tags. I learned about inline CSS, which set me up for learning React twenty years later. And I learned that you can see the source behind any web page, hack on it, and learn from it.</p>\n<h3>Getting Online</h3>\n<p>I don&#8217;t remember the first web page that I put online when we eventually got Internet access. I doubt it was any good, but what the whole experience did do was help my curiosity grow, to which I&#8217;ve attributed much of my success so far. Being curious about a topic helps enormously when learning, self-teaching, and staying motivated.</p>\n<p>I didn&#8217;t attend university, partly due to my excellent high school grades not being followed up by any good college grades (in the UK, there’s two years of sixth form college between high school and university). In hindsight I see that I got bored of state education, and two short years flew by with no time for me to to fix that attitude. Stay in school, kids.</p>\n<p>The years after school saw me working barely above minimum wage in a supermarket by day and hacking on web projects at night. I was first introduced to WordPress by <a href=\"https://profiles.wordpress.org/lumpysimon/\">my brother Simon</a> who built websites for customers of his printing business. After a brief period of building my own CMS (everyone&#8217;s done it, right?), I realised there were many advantages to using a free and community built CMS maintained by a relatively large number of people. I started building simple WordPress sites for myself. Along with Simon and his friend Tom, we played around with the idea of a hosted web service to make it even easier for people to publish online using WordPress. The project never went anywhere (hello wordpress.com), but the ideas we explored helped me learn a lot about WordPress.</p>\n<blockquote><p>Who is a person (not counting family) that opened doors for you in your career when they didn&#8217;t have to? Anytime is a good time to show gratitude!</p></blockquote>\n<p>I can pinpoint the start of my career with WordPress when Tom recommended me to someone who was looking for a WordPress plugin developer. That person, Conor O&#8217;Neill, became one of the people that opened a door for me in my career when they didn&#8217;t have to. Conor was pleased with the plugin work that I did for him, and selflessly passed my name onto several of his friends and acquaintances. He didn&#8217;t need to do that, it didn&#8217;t directly benefit him, but he did it because he knew it would help out his acquaintances and help me to get work.</p>\n<h3>Becoming A WordPress Consultant</h3>\n<p>I started building WordPress themes and plugins for people that Conor gave my name to. I didn&#8217;t have much experience at the time, but I had the advantage of personal recommendations. It&#8217;s difficult to overstate how valuable a personal recommendation is. All the advertising in the world can be useless when competing against a personal recommendation. If you&#8217;re looking to start or change a career, I recommend asking people to pass your name on to friends and colleagues whenever they can.</p>\n<blockquote><p>I&#8217;m one of the lucky ones that got a good start through personal recommendations, and if you can do that too then it&#8217;ll set you up well.</p></blockquote>\n<p>Conor passed my name onto a chap named Damien Mulley who was also instrumental in advancing my career by passing my name on when he didn&#8217;t need to. I owe a lot to the selflessness of Conor and Damien.</p>\n<p>Around this time I started finding bugs in WordPress (a practice that I continue to this day). Another key point in my career came when I reported a bug on the WordPress bug tracking system, and was greeted with a pleasant welcome. One of the contributors, Lloyd Budd, was kind enough to take the time to explain to me that I could fix the bug myself and submit the fix to the WordPress project. He pointed me to resources for learning Subversion and creating patches. That small act of help lead to me becoming a regular WordPress contributor, and ultimately one of the core developers. Lloyd didn&#8217;t have to use his free time to help others out, but he did, and it had long-reaching impact on my career and on the WordPress project.</p>\n<p>After a year of freelancing, I was able to get enough work that I could drop down to part time work at my supermarket job. I worked and self-taught for seventy hours a week for six months. I was afraid of leaving a stable job despite earning three times as much working as a freelance developer, but making that jump felt very scary before I made it. A combination of personal recommendations and working to get a name for myself in the WordPress sphere lead me to leave my supermarket job, freelance for a few years, become the first employee at WordPress agency <a href=\"https://codeforthepeople.com/\">Code for the People</a>, and ultimately to join <a href=\"https://humanmade.com/\">Human Made</a> as a senior WordPress engineer.</p>\n<h3>Giving Back</h3>\n<p>I’m lucky that I’m able to spend some of my time contributing back to WordPress, and I&#8217;ve been thinking a lot about how the principles of open source apply outside of software. I gave <a href=\"https://wordpress.tv/2016/05/31/john-blackbourn-rachel-mccollin-and-taco-verdonschot-lightning-sessions/\">a short talk at WordCamp London in 2016</a> where I coined the phrase &#8220;<em>Make it better, give it back</em>&#8220;, which is how I interpret the fundamental principles of open source. It’s the idea of improving upon an existing process and giving it back to the community in order to embetter everyone, whether it’s through an open data project such as OpenStreetMap, a community initiative in your local area, or shared learning.</p>\n<blockquote><p>Recently I came to realise that the &#8220;<em>it</em>&#8221; in &#8220;<em>Make it better, give it back</em>&#8221; doesn&#8217;t have to refer to the primary aspect of what you&#8217;re contributing to.</p></blockquote>\n<p>Lloyd made WordPress better by writing code and giving it back, but he also made WordPress better by improving the knowledge and skills of its community members, many of whom in turn give back in a variety of ways.</p>\n<p>Giving back allows me to improve many of my own skills. It allows me to challenge myself, not only technically but also in areas such as communication, compassion, critical thinking, and time management. Giving back makes me a better person and allows me to help others become better people.</p>\n<a href=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/dsc_3097.jpg\"><img class=\"wp-image-2398\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/dsc_3097-768x1024.jpg\" alt=\"John and Francesca\" width=\"350\" height=\"467\" /></a>John and Francesca\n<p>Giving back has advanced my professional career thanks to the technical and people skills that I learn from it and the recognition gained by my contributions. In turn this has lead to many new friends, a career in a field that I enjoy very much, and it also lead to me finding the love of my life at a WordPress contributor day.</p>\n<p>I hope that in one way or another I&#8217;ve given back to many people in the open source community. I&#8217;ve been involved with WordPress for twelve years now, and over those years I&#8217;ve given advice, pointers, and encouragement to others that might seem small or inconsequential at the time but can be just the sort of encouragement that somebody needs. The difference between not receiving a reply to a query, and receiving one which says &#8220;Thanks! That&#8217;s a good start&#8221; might mean the difference between never contributing again versus becoming a decade long community member.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Make It Better, Give It Back\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Make%20It%20Better%2C%20Give%20It%20Back&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fmake-better-give-back%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Make It Better, Give It Back\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fmake-better-give-back%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fmake-better-give-back%2F&title=Make+It+Better%2C+Give+It+Back\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Make It Better, Give It Back\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/make-better-give-back/&media=https://heropress.com/wp-content/uploads/2018/01/011017-150x150.jpg&description=Make It Better, Give It Back\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Make It Better, Give It Back\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/make-better-give-back/\" title=\"Make It Better, Give It Back\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/make-better-give-back/\">Make It Better, Give It Back</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Jan 2018 08:00:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: Ariel Levy in Longreads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://ma.tt/2018/01/ariel-levy-in-longreads/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:769:\"<p>I had originally planned last year to write <a href=\"https://ma.tt/2017/12/books-in-2017/\">a review of each book as I read it</a>, but The Rules Do Not Apply threw a spanner in the works. I had no idea how to write about it, much less review it. The author, <a href=\"https://longreads.com/2017/03/14/ariel-levy-interview/\">Ariel Levy, has a great interview in Longreads from when the book came out</a>.</p>\n\n\n\n<p>Speaking of Longreads, <a href=\"https://longreads.com/2017/12/29/the-25-most-popular-longreads-exclusives-of-2017/\">don&#x27;t forget to check out their top 25 exclusives from 2017</a>, and <a href=\"https://longreads.com/2017/12/11/longreads-best-of-2017-all-of-our-no-1-story-picks/\">their number 1 picks overall</a>. Some amazing writing in there.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Jan 2018 00:44:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Lorelle on WP: Vulnerability in phpMyAdmin Requires Immediate Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://lorelle.wordpress.com/?p=14409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://lorelle.wordpress.com/2018/01/06/vulnerability-in-phpmyadmin-requires-immediate-patch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4273:\"<p>A <a href=\"http://www.itprotoday.com/patch-management/critical-csrf-security-vulnerability-phpmyadmin-database-tool-patched\" title=\"Critical CSRF Vulnerability in phpMyAdmin Database Tool Patched | IT Pro\">critical CSRF Vulnerability in phpMyAdmin Database administration tool</a> has been found and a <a href=\"https://www.phpmyadmin.net/security/PMASA-2017-9/\" title=\"phpMyAdmin - Security - PMASA-2017-9\">patch is available</a> for all computers and servers running the MySQL database. </p>\n<p>Does this include you?</p>\n<p>If you are using WordPress, yes it does. </p>\n<p>Contact your web host to ensure phpMyAdmin is updated immediately. </p>\n<p>If you are self-hosted and manage your own server, update phpMyAdmin immediately. </p>\n<p>If you are using WordPress or phpMyAdmin and MySQL on your computer through <a href=\"http://www.wampserver.com/en/\" title=\"WAMP\">WAMP</a>, <a href=\"http://www.mamp.info/en/index.html\" title=\"MAMP\">MAMP</a>, <a href=\"http://www.apachefriends.org/en/xampp.html\" title=\"XAMPP\">XAMPP</a>, <a href=\"http://www.instantwp.com/\" title=\"Instant WordPress\">Instant WordPress</a>, <a href=\"http://serverpress.com/products/desktopserver/\" title=\"DesktopServer\">DesktopServer</a>, <a href=\"http://bitnami.org/stack/wordpress\" title=\"BitNami\">BitNami</a> or any of the other ways you can install WordPress on your computer or a stick (USB), update phpMyAdmin by using the patch or check the install technique&#8217;s site for updates. </p>\n<p><strong>If you are using WordPress.com, don&#8217;t worry.</strong> This does not apply to you or your site. </p>\n<p>The flaw affects phpMyAdmin versions 4.7.x prior to 4.7.7. Hopefully, your server/web host company has been updating phpMyAdmin all along and you don&#8217;t need to worry, but even though this is a medium security vulnerability, it is your responsibility as a site owner and administrator to ensure that your site is safe. Don&#8217;t just rely on GoDaddy, Dreamhost, or whatever hosting service you use to take care of these things for you. Sometimes they are on top of these before an announcement is made public. Other times, they are clueless and require customer intervention and nagging. </p>\n<p>Now, what is phpMyAdmin?</p>\n<p>MySQL is an open source database program, and <a href=\"https://www.phpmyadmin.net/\" title=\"phpMyAdmin\">phpMyAdmin</a> is the free, open source tool that makes the administration and use of MySQL easier to manage. <em>It is not a database. It is a database manager.</em> You can <a href=\"https://lorelle.wordpress.com/2014/08/10/find-search-replace-and-delete-in-the-wordpress-database/\" title=\"Find, Search, Replace, and Delete in the WordPress Database « Lorelle on WordPress\">easily search and replace data</a> in the database, make changes, and do other maintenance and utility tasks in the database.</p>\n<p>Every installation of WordPress requires PHP and MySQL along with a variety of other web-based programming packages and software. Most installations by web hosts and portable versions of WordPress add phpMyAdmin to manage the WordPress site. It is not required for WordPress to work, but don&#8217;t assume that it is or isn&#8217;t installed. CHECK. </p>\n<p>To find out if phpMyAdmin is installed on your site:</p>\n<ol>\n<li>Check with your web host and ask. Don&#8217;t expect their customer service staff to know for sure. Make them check your account and verify whether or not it is installed, and if they&#8217;ve updated. Push them for a specific answer.</li>\n<li>Check the site admin interface (cPanel, Plesk, etc.) to see if it is installed.</li>\n<li>Log into your site through secure FTP into the root (if you have access) and look for the installation at <em>/usr/share/phpmyadmin</code> or <code>localhost/phpmyadmin</code>. Unfortunately, it could be anywhere depending upon the installation as these are virtual folders, not folders found on your computer, so it must be assigned to a location.</li>\n<li>If running a portable installation of MySQL and/or WordPress, follow the instructions for that tool and download and install all patches to ensure phpMyAdmin is updated to the latest secure version.</li>\n</ol>\n<div class=\"sig\">\n<p><img src=\"https://lorelle.files.wordpress.com/2006/08/sig.gif\" alt=\"\" /></p>\n<hr /> </div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Jan 2018 16:55:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Lorelle VanFossen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: Zac Gordon Launches Gutenberg Development Course, Includes More Than 30 Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=77285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/zac-gordon-launches-gutenberg-development-course-includes-more-than-30-videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2756:\"<p><a href=\"https://zacgordon.com/\">Zac Gordon</a>, a technology educator, has released his <a href=\"http://gutenberg.courses/\">Gutenberg Development course</a>. The course is $79 but is available for $49 using the coupon code <strong>earlyadopter</strong>.</p>\n\n\n\n<p>Gordon says the course is aimed at developers who want to update their themes, plugins, shortcodes, etc. to work with Gutenberg and take advantage of blocks. <br /></p>\n\n\n\n<p>\"There is also some content I am adding geared towards theme developers, but honestly there is not much to that,\" Gordon said. \"I think plugin developers will fill a lot of the needs of theme developers and help prevent them from having to build too many custom blocks. </p>\n\n\n\n<p>\"Also, in my opinion, blocks belong in plugins, so maybe some theme developers will migrate into plugin development through working with blocks.\"</p>\n\n\n\n<p>The course includes more than 30 videos, a dozen example blocks, access to support forums, and the community run Slack channel. It covers how Gutenberg works, how to extend and customize it, and using a modern JavaScript development approach.</p>\n\n\n\n<p>Gordon learned quite a few things about Gutenberg while creating the course. \"Specifically, I learned Gutenberg is really just React under the hood, and then the more traditional WordPress PHP under that,\" he said.</p>\n\n\n\n<p>\"Digging deeper into the source attributes system that Gutenberg has to keep track of dynamic data was interesting. Also, there are far more possibilities with server-side code hooking into blocks than I thought ahead of time. I also came to the opinion that I&#x27;m not sure why someone would build a block in anything other than React, so I&#x27;m interested to see what common practices evolve.\"</p>\n\n\n\n<p>Creating the course has allowed Gordon to dive deep into Gutenberg. So does he think it&#x27;s a suitable replacement for the editor? <br /></p>\n\n\n\n<p>\"I think most users will feel Gutenberg is an improvement of the editing experience,\" he responded. \"We are definitely moving in the right direction. Ironically perhaps, I still like site and page builder plugins when editing or creating content in WordPress.\"</p>\n\n\n\n<p>Gutenberg is still in a high state of flux with rapid development. According to Gordon, if there is one thing developers should know about Gutenberg, it&#x27;s that learning JavaScript deeply will pay off.<br /></p>\n\n\n\n<p>\"Matt Mullenweg was right when he said &#x27;<a href=\"https://www.youtube.com/watch?v=KrZx4IY1IgU\">Learn JavaScript Deeply</a>&#x27;,\" Gordon said. \"In terms of Gutenberg, that means a foundation with ES+, JSX/React, and webpack/babel/etc. You can learn as you go, but we are definitely moving from the time of learning to a time of doing.\"</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Jan 2018 23:32:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Xerox Alto Zero-Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47788\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2018/01/xerox-alto-zero-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2208:\"<p>Next to the <a href=\"https://www.schneier.com/blog/archives/2018/01/spectre_and_mel.html\">very real news of the Spectre and Meltdown CPU issues</a>, it was lovely to come across <a href=\"http://www.righto.com/2018/01/xerox-alto-zero-day-cracking-disk.html\">Ken Shirriff&#x27;s story of getting past password protection on some old Xerox Alta disk packs from the 1970s</a>.</p>\n\n\n\n<p>As further proof for why 2018 is going to be the year of blogging, two of the comments are from people who actually know about the old disks!</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n    <p>\"I designed chips at PARC as a summer intern. You have a couple of disks from Doug Fairbairn, who was also in Lynn Conway&#x27;s group.\"</p>\n</blockquote>\n\n\n\n<p>and</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n    <p>I&#x27;m flabbergasted. That&#x27;s <em>my</em> Alto disk you broke into!<br />><br /><br /><br /><br /><br />The APL stuff is surely related to some work I did with Leo Guibas, showing why lazy evaluation would be a really good idea for implementing APL: see <a href=\"https://dl.acm.org/citation.cfm?id=512761\">Compilation and delayed evaluation in APL</a>, published January 1978. (That paper gives me an enviable Erdős number of 3, since Leo is a 2.) I&#x27;m sure it&#x27;s not a complete APL implementation, just a proof of concept. It happens that my very first part-time job at PARC, in 1973, involved writing decision analysis software <em>in</em> APL &#8212; on a timesharing system!<br />><br /><br /><br /><br /><br />Given the AATFDAFD hint, I&#x27;d guess the real password is ADDATADFAD. This derives from a project I did with Jef Raskin at UCSD in 1974. (He mentioned it in <a href=\"https://web.stanford.edu/dept/SUL/sites/mac/primary/interviews/raskin/trans.html\">this interview</a>.) The Data General Nova we were working with produced some garbled message with ADDATADFAD where it should have said ADDITIONAL, and it was a running joke ever after. Strange, the things that occupy some brain cells for over 40 years.<br />><br /><br /><br /><br /><br />Thanks for an amusing blast from the past.<br />><br /><br /><br /><br /><br />&#8212; Doug Wyatt (Xerox PARC 1973-1994)</p>\n</blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Jan 2018 15:37:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Morten on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2018/01/morten-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"<p>Morten Rand-Hendriksen&#x27;s talk and demo on Gutenberg from WordCamp US is an excellent overview of where it is, where it could go, and some VR stuff thrown in there for fun. Definitely worth the watch.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Jan 2018 20:54:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: WPWeekly Episode 300 – Interview with Matt ‘Gutenbeard’ Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=77276&preview=true&preview_id=77276\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/wpweekly-episode-300-interview-with-matt-gutenbeard-mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1492:\"<p>In this the 300th episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I interview <a href=\"https://ma.tt/\">Matt &#8216;Gutenbeard&#8217; Mullenweg</a>, co-creator of the WordPress project. We discuss a range of topics including, the somewhat controversial poetry reading that included a curse word prior to the State of the Word, the WordPress Foundation increasing its range of funding, and of course, Gutenberg.</p>\n<p>One of the big takeaways from this interview is learning that Gutenberg will not arrive at the flick of a switch. There will be a transition period and a considerable amount of effort to make it as smooth as possible. Unlike episode 296, Mullenweg&#8217;s internet is fantastic and we didn&#8217;t experience any audio issues. A transcription of this interview will be published in a few days.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 10th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #300:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Jan 2018 03:55:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: A Collection of Gutenberg Conversations, Resources, and Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=77141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/a-collection-of-gutenberg-conversations-resources-and-videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8714:\"<p>Since the conclusion of WordCamp US in early December, there have been a number of Gutenberg related items published to the web.</p>\n\n\n\n<p>The following is a collection of items related to Gutenberg that I came across throughout December. Feel free to add to this list in the comments below.</p>\n\n\n\n<h2>Resources</h2>\n\n\n\n<p><a href=\"https://gettingreadyforgutenberg.com/\">Getting Ready for Gutenberg</a> is a community-run initiative to help users and developers prepare for Gutenberg&#x27;s inclusion in core. </p>\n\n\n\n<p>GitHub repo filled with <a href=\"https://github.com/WordPress/gutenberg-examples\">Gutenberg example blocks.</a></p>\n\n\n\n<p>Although it was published in August of last year, WordImpress has a good guide on <a href=\"https://wordimpress.com/a-pot-stirrer-amongst-chefs-contributing-to-gutenberg-without-code/\">how to contribute to Gutenberg without code</a>.</p>\n\n\n\n<p>Rich Tabor explains <a href=\"https://richtabor.com/add-wordpress-theme-styles-to-gutenberg/\">how to add WordPress theme styles</a> to Gutenberg. He&#x27;s also created a <a href=\"https://wordpress.org/plugins/social-sharing-block-gutenberg/\">Gutenberg Social Sharing Block</a> plugin. <br /></p>\n\n\n\n<p>Human Made <a href=\"https://hmn.md/white-papers/gutenberg-the-new-wordpress-editor/\">published a Gutenberg White Paper</a> that introduces people to the project, goes over a number of blocks, and provides advice on how agencies can prepare for the transition. </p>\n\n\n\n<p><a href=\"https://frontenberg.tomjn.com/\">Frontenberg</a> is a new project by <a href=\"https://twitter.com/Tarendai/status/943531422861660169\">Tom Nowell </a>that brings Gutenberg to the front end. This allows people to try Gutenberg without logging into a site or installing a plugin.</p>\n\n\n\n<p>Ben Gilbanks has <a href=\"https://github.com/BinaryMoon/granule/commit/777cd2903c1e4a8ebfc6060e86a7f7a4ef2387da\">added basic support</a> for Gutenberg to his Granule starter theme.</p>\n\n\n\n<p>Andrew Taylor <a href=\"https://github.com/ataylorme/gutenberg-codepen-embed\">created a Gutenberg block</a> that enables embedding Pens from CodePen.</p>\n\n\n\n<p>Advanced Custom Fields <a href=\"https://www.advancedcustomfields.com/blog/acf-year-review-2017/\">announced</a> it will focus on making ACF compatible with Gutenberg in 2018. </p>\n\n\n\n<p>Meta Box has <a href=\"https://metabox.io/meta-box-2017-year-review-whats-next-2018/\">also announced</a> its Gutenberg compatibility plans. </p>\n\n\n\n<p>John Hawkins published a good post on the WebDevStudios blog on <a href=\"https://webdevstudios.com/2018/01/02/existing-content-affected-wordpress-gutenberg/\">how existing content will be affected by Gutenberg</a>.﻿ </p>\n\n\n\n<h2>Conversations</h2>\n\n\n\n<p>Kevin Hoffman <a href=\"https://github.com/WordPress/gutenberg/issues/3902\">started a conversation</a> on how plugin conflicts can be handled and communicated.</p>\n\n\n\n<p>Bridget Willard shared her concerns with the <a href=\"https://bridgetwillard.com/economic-impact-timeline-gutenberg-rollout/\">economic impact and timeline</a> of Gutenberg&#x27;s roll out. She also <a href=\"https://github.com/WordPress/gutenberg/issues/3926\">created an issue</a> on GitHub.</p>\n\n\n\n<p>Amanda Rush <a href=\"https://www.customerservant.com/thoughts-gutenberg-wordpress-tomorrow/\">published her thoughts and concerns</a> related to Gutenberg&#x27;s Accessibility. </p>\n\n\n\n<p>Morten Rand-Hendrisken published a series of articles on LinkedIn covering <a href=\"https://www.linkedin.com/pulse/wordpress-changing-here-3-things-you-need-know-morten-rand-hendriksen/\">things you need to know</a> about Gutenberg and the <a href=\"https://www.linkedin.com/pulse/gutenberg-future-wordpress-conditions-success-morten-rand-hendriksen/?published=t\">conditions for its success.</a></p>\n\n\n\n<p>Scott Kingsley Clark, of the PODS framework plugin, announced they&#x27;re doing some cool things in the next release specifically for Gutenberg. </p>\n\n\n\n\n    <blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">We’re doing some cool stuff in this next <a href=\"https://twitter.com/podsframework?ref_src=twsrc%5Etfw\">@podsframework</a> release for Gutenberg specifically. Lots to do, but I feel like there will be cases for meta boxes and cases for blocks. We’ll have a template editor too, which will be powered by Gutenberg itself <a href=\"https://twitter.com/hashtag/gutenception?src=hash&ref_src=twsrc%5Etfw\">#gutenception</a></p>&mdash; Scott Kingsley Clark (@scottkclark) <a href=\"https://twitter.com/scottkclark/status/940348072151977984?ref_src=twsrc%5Etfw\">December 11, 2017</a></blockquote>\n\n\n\n\n<p>Freemius takes a look at <a href=\"https://freemius.com/blog/gutenberg-commercial-wordpress-products/\">what Gutenberg means</a> for the future of commercial WordPress products. The post includes quotes from Beaver Builder, Elementor, and Visual Composer. </p>\n\n\n\n<p>In <a href=\"https://wptavern.com/wpweekly-episode-297-wordcamp-us-2017-recap\">episode 297 of WordPress Weekly</a>, Morten Rand-Hendriksen joined John James Jacoby and I in a detailed conversation about Gutenberg, its potential impacts, and the idea of forking WordPress.</p>\n\n\n\n<p>GiveWP is <a href=\"https://github.com/WordImpress/Give/issues/2456#issuecomment-351317017\">opening up its design process</a> for how its product will interface with Gutenberg. </p>\n\n\n\n<p>Beaver Builder<a href=\"https://www.wpbeaverbuilder.com/page-builders-gutenberg-world/?utm_content=buffer12b34&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer\"> takes a look</a> at Page Builders in a Gutenberg World, the future of WordPress, and how its product will embrace compatibility with Gutenberg. </p>\n\n\n\n<p>Eric Mann on <a href=\"https://ttmm.io/tech/gutenberg-and-the-road-ahead/\">Gutenberg and the road ahead</a>. Mann supports the idea of soft-forking WordPress to provide time and help for those who can&#x27;t immediately update to 5.0. </p>\n\n\n\n<p>Help contribute to Gutenberg by <a href=\"https://make.wordpress.org/test/2017/12/15/help-us-analyse-the-wcus-gutenberg-usability-videos/\">processing the usability tests</a> from WordCamp US 2017. </p>\n\n\n\n<p>Michael Hebenstreit <a href=\"https://arrayinternet.com/blog/cost-gutenberg-transition-small-wordpress-businesses/\">details the potential costs</a> for small WordPress businesses and independent developers to transition to Gutenberg. </p>\n\n\n\n<p>WordCamp Miami 2018 is having a <a href=\"https://2018.miami.wordcamp.org/2017/12/19/developer-workshop-announcement-future-of-wordpress/\">developer workshop</a> focused on Gutenberg.</p>\n\n\n\n\n    <blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I\'m seeing talk of how clients will be lost and users will leave <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> when <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a> drops. As a former freelancer, in-house developer, agency designer, custom theme developer, and now plugin developer, here\'s a practical look at how Gutenberg affects each.</p>&mdash; Kevin W. Hoffman (@kevinwhoffman) <a href=\"https://twitter.com/kevinwhoffman/status/943871967349886977?ref_src=twsrc%5Etfw\">December 21, 2017</a></blockquote>\n\n\n\n\n\n    <blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I think we will look back at 2017 and see it as the year the <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> project started to fracture. As much as the community desperately wants to see WordPress as an enterprise CMS, projects like <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a> show it is anything but.</p>&mdash; Ben Furfie (@frontendben) <a href=\"https://twitter.com/frontendben/status/946296693926047744?ref_src=twsrc%5Etfw\">December 28, 2017</a></blockquote>\n\n\n\n\n<p>Tammie Lister <a href=\"https://tam.blog/2017/12/gutenberg-inspired-redesign/\">shared her experience</a> redesigning her site using the <a href=\"https://github.com/WordPress/gutenberg-theme\">Gutenberg theme</a> as a base. </p>\n\n\n\n<p>WP4Good explains how they&#x27;re <a href=\"https://wp4good.org/getting-ready-for-gutenberg/\">preparing for Gutenberg</a>. </p>\n\n\n\n<h2>Videos</h2>\n\n\n\n<p>Riad Benguella <a href=\"https://riad.blog/2017/12/11/with-gutenberg-what-happens-to-my-custom-fields/\">published a visual example</a> that shows Meta Boxes mostly work in Gutenberg. Benguella created a sample plugin called Gutenberg Custom Fields that provides a similar user experience to existing Custom Fields plugins.</p>\n\n\n\n<p>A live demo of Gutenberg during the 2017 State of the Word. </p>\n\n\n\n\n    \n\n\n\n\n<p>Gutenberg and the WordPress of Tomorrow by Morten Rand-Hendriksen</p>\n\n\n\n\n    <div class=\"embed-wrap\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jan 2018 21:04:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"HeroPress: A Review Of HeroPress in 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2387\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://heropress.com/a-review-of-heropress-2017/#utm_source=rss&utm_medium=rss&utm_campaign=a-review-of-heropress-2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9508:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/010318-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: HeroPress is something WordPress people do for themselves. The world simply gets to watch.\" /><p><strong>FIRST</strong>: please leave a comment if HeroPress has inspired or impacted you this year. I&#8217;ve love for you to be a part of this post.</p>\n<p>With that out of the way, another year of HeroPress has come and gone. HeroPress is still young enough that we can&#8217;t really see multi-year trends, but I still find it interesting to look at them and try to guess things.  In this post we&#8217;ll look at some stats, some things I tried that didn&#8217;t work, some things that did work, and some dreams for the future.</p>\n<h3>Statistics</h3>\n<h4>Diversity</h4>\n<p>Diversity has always been important to me.  In 2015 and 2016 I had more men than women, by a pretty wide margin, and that bothered me.  In 2017 I&#8217;m happy to say we had 32 women and 21 men. I didn&#8217;t work SUPER hard at that, it was just something I kind of kept in my head when I was looking for new folks.</p>\n<p>We also had great geographical diversity in our contributors, representing 26 different countries.</p>\n<table>\n<tbody>\n<tr>\n<th>Country</th>\n<th>No. of Essays</th>\n</tr>\n<tr>\n<td>Bangladesh</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Cameroon</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Croatia</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Finland</td>\n<td>2</td>\n</tr>\n<tr>\n<td>France</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Germany</td>\n<td>2</td>\n</tr>\n<tr>\n<td>India</td>\n<td>7</td>\n</tr>\n<tr>\n<td>Italy</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Jamaica</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Nepal</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Netherlands</td>\n<td>2</td>\n</tr>\n<tr>\n<td>Nigeria</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Norway</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Poland</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Romania</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Russia</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Scotland</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Serbia</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Somalia</td>\n<td>1</td>\n</tr>\n<tr>\n<td>South Africa</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Spain</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Sweden</td>\n<td>1</td>\n</tr>\n<tr>\n<td>Turkey</td>\n<td>1</td>\n</tr>\n<tr>\n<td>United Kingdom</td>\n<td>1</td>\n</tr>\n<tr>\n<td>United States</td>\n<td>13</td>\n</tr>\n<tr>\n<td>Yemen</td>\n<td>1</td>\n</tr>\n</tbody>\n</table>\n<p>The US and India had far more than any other country, which has been the trend since we started, but the US has far fewer in 2017 than 2016.</p>\n<h4>Readers</h4>\n<p>We had traffic from 175 countries this year.</p>\n<p><img class=\"aligncenter size-full wp-image-2388\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/country_traffic.png\" alt=\"World map showing HeroPress visitors\" width=\"951\" height=\"547\" /></p>\n<p>That said, HeroPress saw less traffic overall in 2017 than in 2016.</p>\n<p><img class=\"aligncenter size-full wp-image-2389\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/01/heropress_stats.png\" alt=\"Bar chart showing HeroPress stats\" width=\"692\" height=\"282\" /></p>\n<h4>The Important Stuff</h4>\n<p>As fun as stats are, it&#8217;s been pointed out to me many times that they&#8217;re meaningless. Someone asked me recently how I define success for HeroPress, and the answer was that at least one person is impacted for the better. The interesting twist to that is the hierarchy of people impacted positively by HeroPress.  It goes like this:</p>\n<p><strong>Topher</strong>: Because he gets to see them all, AND behind the scenes. It&#8217;s heady stuff.</p>\n<p><strong>Contributors themselves</strong>: MANY people have told me that writing their story changed their life. The simple act of processing things from the past, and getting them out there, and being vulnerable is powerful.</p>\n<p><strong>Readers</strong>: Lot&#8217;s of people tell me it&#8217;s inspiring.</p>\n<p>What we learn from the above information is that HeroPress would be a success if we had zero readers. HeroPress is something WordPress people do for themselves. The world simply gets to watch.</p>\n<h3>Experiments</h3>\n<h4>The Scholarship</h4>\n<p>Last spring the folks from WPShout approached me about working together to offer a scholarship.  They would offer the actual scholarship, and we would manage getting applicants and deciding who won.</p>\n<p>It was a huge success.  We had tons of traffic, many great applicants, and the winners did great things with their scholarships.  We&#8217;d love to do something like that again, so if you&#8217;re interested, drop us a note.</p>\n<h4>Commercial Support</h4>\n<p>This changed a bit in 2017. Most of the year was sponsored by Gravity Forms, which was great. That ended with only a few weeks left in the year, and I was surprised to find that there were a number of organizations that were interested in sponsoring a single week. That worked quite well, and I&#8217;m interested in looking into that more.</p>\n<p>At WordCamp US I spoke to an organization that was interested in sponsoring an entire quarter, which would be a first.  It hasn&#8217;t happened yet, but I&#8217;m also looking into that some more.</p>\n<h4>Donations</h4>\n<p>This didn&#8217;t really work out. I put up the donation form at the request of a few people that wanted to give. Those people gave, and a few more, but after the third day or so there were no more. There could be many reasons, but I&#8217;m not too concerned. I&#8217;ll probably take the form down, and if I ask for donations again it&#8217;ll be a Public Radio style press-a-thon for a week or something. Lots of flash, and then it&#8217;s gone for a year.</p>\n<h3>Thanks</h3>\n<p>As always happens, I got some great advice this year and lots of donated services and software.</p>\n<p>Many thanks to Tine Haugen from XWP for her ongoing input from a Larger Company perspective.</p>\n<p>Thanks to <a href=\"https://pagely.com/\">Pagely</a> for hosting HeroPress.</p>\n<p>Thanks to these commercial plugin folk that donated licenses:</p>\n<ul>\n<li>Analytify &#8211; Google Analytics Dashboard</li>\n<li>Give &#8211; Donation Plugin</li>\n<li>Make Plus</li>\n<li>Maps Builder Pro</li>\n<li>Ninja Forms</li>\n<li>Postmatic &amp; Postmatic Labs</li>\n</ul>\n<p>Thanks to these wonderful software developers who&#8217;ve released there work to the world for free:</p>\n<ul>\n<li>Akismet Anti-Spam</li>\n<li>Blog Time</li>\n<li>Jetpack by WordPress.com</li>\n<li>Post Type Archive Descriptions</li>\n<li>Public Post Preview</li>\n<li>Really Simple Series</li>\n<li>rtSocial</li>\n<li>Simple 301 Redirects</li>\n<li>Simply Exclude</li>\n<li>Widget Logic</li>\n<li>WP Custom Login Page Logo</li>\n<li>WP Retina 2x</li>\n<li>Yoast SEO</li>\n</ul>\n<p>Thanks to 2017&#8217;s commercial supporters:</p>\n<ul>\n<li><a href=\"https://eventespresso.com/\">Event Espresso</a></li>\n<li><a href=\"https://www.gowp.com/\">GoWP</a></li>\n<li><a href=\"https://www.gravityforms.com/\">Gravity Forms</a></li>\n<li><a href=\"https://rtcamp.com/\">rtCamp</a></li>\n</ul>\n<p><strong>MOST IMPORTANTLY</strong></p>\n<p>Thanks to our contributors.  Without people willing to share of themselves, tell us their stories, make themselves vulnerable, HeroPress would not exist. Thank you SO SO much, all of you who&#8217;ve written.</p>\n<h3>Your Turn</h3>\n<p>As I mentioned at the top of the post, the rest of the post is to be written by you.  How has HeroPress impacted you this year? What value is there besides numbers and charts and graphs?</p>\n<p>Please leave a comment.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: A Review Of HeroPress in 2017\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=A%20Review%20Of%20HeroPress%20in%202017&via=heropress&url=https%3A%2F%2Fheropress.com%2Fa-review-of-heropress-2017%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: A Review Of HeroPress in 2017\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fa-review-of-heropress-2017%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fa-review-of-heropress-2017%2F&title=A+Review+Of+HeroPress+in+2017\" rel=\"nofollow\" target=\"_blank\" title=\"Share: A Review Of HeroPress in 2017\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/a-review-of-heropress-2017/&media=https://heropress.com/wp-content/uploads/2018/01/010318-150x150.jpg&description=A Review Of HeroPress in 2017\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: A Review Of HeroPress in 2017\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/a-review-of-heropress-2017/\" title=\"A Review Of HeroPress in 2017\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/a-review-of-heropress-2017/\">A Review Of HeroPress in 2017</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jan 2018 17:49:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Dev Blog: The Month in WordPress: December 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5424\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/01/the-month-in-wordpress-december-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4742:\"<p>Activity slowed down in December in the WordPress community, particularly in the last two weeks. However, the month started off with a big event and work pushed forward in a number of key areas of the project. Read on to find out more about what transpired in the WordPress community as 2017 came to a close.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordCamp US 2017 Brings the Community Together</h2>\n\n\n\n<p>The latest edition of <a href=\"https://2017.us.wordcamp.org/\">WordCamp US</a> took place last month in Nashville on December 1-3. The event brought together over 1,400 WordPress enthusiasts from around the world, fostering a deeper, more engaged global community.</p>\n\n\n\n<p>While attending a WordCamp is always a unique experience, you can catch up on <a href=\"https://wordpress.tv/event/wordcamp-us-2017/\">the sessions on WordPress.tv</a> and look through <a href=\"https://www.facebook.com/pg/WordCampUSA/photos/?tab=albums\">the event photos on Facebook</a> to get a feel for how it all happened. Of course, <a href=\"https://wordpress.tv/2017/12/04/matt-mullenweg-state-of-the-word-2017/\">Matt Mullenweg’s State of the Word</a> talk is always one of the highlights at this event.</p>\n\n\n\n<p>The next WordCamp US will be held in Nashville again in 2018, but if you would like to see it hosted in your city in 2019 and 2020, then <a href=\"https://make.wordpress.org/community/2017/12/19/apply-to-host-wordcamp-us-2019-2020/\">you have until February 2 to apply</a>.</p>\n\n\n\n<h2>WordPress User Survey Data Is Published</h2>\n\n\n\n<p>Over the last few years, tens of thousands of WordPress users all over the world have filled out the annual WordPress user survey. The results of that survey are used to improve the WordPress project, but that data has mostly remained private. This has changed now and <a href=\"https://wordpress.org/news/2017/12/wordpress-user-survey-data-for-2015-2017/\">the results from the last three surveys are now publicly available</a> for everyone to analyze.</p>\n\n\n\n<p>The data will be useful to anyone involved in WordPress since it provides a detailed look at who uses WordPress and what they do with it — information that can help inform product development decisions across the board.</p>\n\n\n\n<h2>New WordPress.org Team for the Tide Project</h2>\n\n\n\n<p>As announced at WordCamp US, <a href=\"https://make.wordpress.org/tide/2017/12/02/new-home/\">the Tide project is being brought under the WordPress.org umbrella</a> to be managed and developed by the community.</p>\n\n\n\n<p>Tide is a series of automated tests run against every plugin and theme in the directory to help WordPress users make informed decisions about the plugins and themes that they choose to install.</p>\n\n\n\n<p>To get involved in developing Tide, jump into the #tide channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>, and follow <a href=\"https://make.wordpress.org/tide/\">the Tide team blog</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul>\n    <li>If you’re following the development of Gutenberg, or if you want a primer on where it’s headed, then <a href=\"https://wordpress.tv/2017/12/10/morten-rand-hendriksen-gutenberg-and-the-wordpress-of-tomorrow/\">Morten Rand-Hendriksen’s talk from WordCamp US</a> is a must watch.</li>\n    <li>The annual surveys for WordPress <a href=\"https://wordpressdotorg.polldaddy.com/s/2017-annual-meetup-member-survey\">meetup members</a> and <a href=\"https://wordpressdotorg.polldaddy.com/s/2017-annual-meetup-organizer-survey\">meetup organizers</a> are available for people to fill out — if you’re involved in or attend your local meetup group then be sure to complete those.</li>\n    <li>10up has <a href=\"https://distributorplugin.com/\">a brand new plugin in beta</a> that will assist with powerful and flexible content publishing and syndication across WordPress sites.</li>\n    <li><a href=\"https://make.wordpress.org/community/2017/12/07/should-we-change-the-default-wordcamp-theme-to-campsite-2017/\">The Community Team is exploring a move</a> to make the recently developed CampSite theme the default theme for all new WordCamp websites. This is the theme that was developed and employed for <a href=\"https://2017.europe.wordcamp.org\">WordCamp Europe 2017</a>.</li>\n    <li>The team working on the multisite features of WordPress Core has recently published <a href=\"https://make.wordpress.org/core/2017/12/19/multisite-roadmap-published/\">their planned roadmap for development</a>.</li>\n</ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jan 2018 10:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Books in 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47744\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2017/12/books-in-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4679:\"<p>Here&#x27;s what I ended up reading this year, in roughly chronological finishing order. (I usually have 3-4 books going on at once.)</p>\n\n\n\n<ul>\n    <li><a href=\"https://www.amazon.com/dp/B01HSMRWNU/?tag=photomatt08-20\">Tools of Titans</a> by Tim Ferriss.</li>\n    <li><a href=\"https://www.amazon.com/dp/B00JSRQSJS/?tag=photomatt08-20\">The Art of Stillness</a> by Pico Ayer.</li>\n    <li><a href=\"https://www.amazon.com/dp/B0162WIRKY/?tag=photomatt08-20\">Out of Your Mind</a> by Alan Watts (audiobook, really a series of lectures).</li>\n    <li><a href=\"https://www.amazon.com/dp/B007V3FHRU/?tag=photomatt08-20\">Book of Five Rings</a> by Miyamoto Mushashi (audiobook).</li>\n    <li><a href=\"https://smile.amazon.com/dp/B01KKNM8UQ/?tag=photomatt08-20\">Do Not Say We Have Nothing</a> by Madeleine Thien.</li>\n    <li><a href=\"https://www.amazon.com/dp/B01912QC5Y/?tag=photomatt08-20\">The Best American Short Stories 2016</a> edited by Junot Diaz.</li>\n    <li><a href=\"https://www.amazon.com/dp/B00CVNLK3K/?tag=photomatt08-20\">Feynman</a> by Jim Ottaviani.</li>\n    <li><a href=\"https://www.amazon.com/dp/8129137704/?tag=photomatt08-20\">My Gita</a> by Devdutt Pattanaik.</li>\n    <li><a href=\"https://www.amazon.com/dp/B00DTO6LZ2/?tag=photomatt08-20\">From Plato to Post-modernism: Understanding the Essence of Literature and the Role of the Author</a> by Louis Markos (another lecture series).</li>\n    <li><a href=\"https://www.amazon.com/dp/B01LZOV6R3/?tag=photomatt08-20\">The Rules Do Not Apply</a> by Ariel Levy.</li>\n    <li><a href=\"https://www.amazon.com/dp/B01BSNQJDY/?tag=photomatt08-20\">The Story of a Brief Marriage</a> by Anuk Arudpragasam.</li>\n    <li><a href=\"https://www.amazon.com/dp/B00DPM7TIG/?tag=photomatt08-20\">All the Light We Cannot See</a> by Anthony Doerr.</li>\n    <li><a href=\"https://www.amazon.com/dp/B01NAG34EH/?tag=photomatt08-20\">Ikigai: The Japanese Secret to a Long and Happy Life</a> by Héctor García and Francesc Miralles.</li>\n    <li><a href=\"https://www.amazon.com/dp/B00V3CE1M2/?tag=photomatt08-20\">When Hitler Took Cocaine and Lenin Lost His Brain: History&#x27;s Unknown Chapters</a> by Giles Milton.</li>\n    <li><a href=\"https://www.amazon.com/dp/184861098X/?tag=photomatt08-20\">Widow Basquiat: A Love Story</a> by Jennifer Clement.</li>\n    <li><a href=\"https://www.amazon.com/dp/0812983068/?tag=photomatt08-20\">32 Yolks: From My Mother&#x27;s Table to Working the Line</a> by Eric Ripert.</li>\n    <li><a href=\"https://www.amazon.com/dp/B005LH08M2/?tag=photomatt08-20\">Identify: Basic Principles of Identity Design in the Iconic Trademarks</a> by Chermayeff &amp; Geismar.</li>\n    <li><a href=\"https://www.amazon.com/dp/B0024NP55G/?tag=photomatt08-20\">Catching the Big Fish: Meditation, Consciousness, and Creativity</a> by David Lynch (audiobook).</li>\n    <li><a href=\"https://www.amazon.com/dp/B01HZFB3X0/?tag=photomatt08-20\">The Upstarts: How