<?php
/*
 * Plugin Name: Divi Disable Plugin Check
 * Version: 1.0
 * Plugin URI: http://jonathanbossenger.com
 * Description: Disable the Divi plugin check
 * Author: Jonathan Bossenger
 * Author URI: http://jonathanbossenger.com
 *
 */

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('plugins_loaded', 'jb_setup_et_builder_get_warnings');

function jb_setup_et_builder_get_warnings(){

    function et_builder_get_warnings() {
        if ( ! current_user_can( 'manage_options' ) ) {
            return false;
        }

        $warnings = array();


        // WP_DEBUG check
        if ( defined( 'WP_DEBUG' ) && true === WP_DEBUG ) {
            $warnings[] = sprintf(
                '%1$s. <a href="https://codex.wordpress.org/Debugging_in_WordPress" class="et_builder_modal_action_button" target="_blank">%2$s</a>',
                esc_html__( 'You have WP_DEBUG enabled. Please disable this setting in wp-config.php', 'et_builder' ),
                esc_html__( 'Disable Debug Mode', 'et_builder' )
            );
        }


        // Plugins check
        $third_party_plugins_active = false;

        /*
        $excluded_plugins = array(
            'wordpress-importer/wordpress-importer.php',
            'divi-builder/divi-builder.php',
            'elegant-themes-updater/elegant-themes-updater.php',
            'et-security-patcher/et-security-patcher.php',
        );

        $active_plugins = get_option( 'active_plugins' );

        if ( is_array( $active_plugins ) && ! empty( $active_plugins ) ) {
            foreach ( $active_plugins as $plugin ) {
                if ( in_array( $plugin, $excluded_plugins ) ) {
                    continue;
                }

                $third_party_plugins_active = true;

                break;
            }
        }

        if ( $third_party_plugins_active ) {
            $warnings[] = sprintf(
                '%1$s <a href="%3$s" class="et_builder_modal_action_button" target="_blank">%2$s</a>',
                esc_html__( 'You are using third party plugins. Try disabling each plugin to see if one is causing a conflict.', 'et_builder' ),
                esc_html__( 'Manage Your Plugins', 'et_builder' ),
                esc_url( admin_url( 'plugins.php' ) )
            );
        }
        */

        // WordPress update check
        require_once( ABSPATH . 'wp-admin/includes/update.php' );

        $updates = get_core_updates();

        if ( isset( $updates[0]->response ) && 'latest' != $updates[0]->response ) {
            $warnings[] = sprintf(
                '%1$s <a href="%3$s" class="et_builder_modal_action_button" target="_blank">%2$s</a>',
                esc_html__( 'You are using an outdated version of WordPress. Please upgrade.', 'et_builder' ),
                esc_html__( 'Upgrade WordPress', 'et_builder' ),
                esc_url( admin_url( 'update-core.php' ) )
            );
        }


        // Memory check
        global $et_current_memory_limit;

        if ( ! empty( $et_current_memory_limit ) && intval( $et_current_memory_limit ) < 128 ) {
            $class = ' et_builder_increase_memory';

            if ( true === strpos( ini_get( 'disable_functions' ), 'ini_set' ) ) {
                $class = '';
            }

            $warnings[] = sprintf(
                '%1$s. <a href="http://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP" class="et_builder_modal_action_button%3$s" target="_blank">%2$s</a>',
                esc_html__( 'Please increase your PHP Memory Limit to 128M. You can return the value to default via the Divi Theme Options in the future', 'et_builder' ),
                esc_html__( 'Increase Your Memory Limit Now', 'et_builder' ),
                esc_attr( $class )
            );
        }


        // Version check
        $et_update_themes = get_site_transient( 'et_update_themes' );

        if ( is_object( $et_update_themes ) && isset( $et_update_themes->response ) ) {
            $theme_info = wp_get_theme();

            if ( is_child_theme() ) {
                $theme_info = wp_get_theme( $theme_info->parent_theme );
            }

            $name    = $theme_info->get( 'Name' );
            $version = $theme_info->get( 'Version' );

            if ( isset( $et_update_themes->response[ $name ] ) && isset( $et_update_themes->response[ $name ]['new_version'] ) && version_compare( $version, $et_update_themes->response[ $name ]['new_version'], '<' ) ) {
                $warnings[] = sprintf(
                    '%1$s <a href="%3$s" class="et_builder_modal_action_button" target="_blank">%2$s</a>',
                    sprintf(
                        esc_html__( 'You are using an outdated version of the theme. The latest version is %1$s', 'et_builder' ),
                        esc_html( $et_update_themes->response[ $name ]['new_version'] )
                    ),
                    esc_html__( 'Upgrade', 'et_builder' ),
                    esc_url( admin_url( 'themes.php' ) )
                );
            }
        }

        if ( empty( $warnings ) ) {
            return false;
        }

        return $warnings;
    }

}


