<?php
/**
 * @package DWD_AIO_MODULE
 * @version 1.1.8
 */
/*
Plugin Name: Divi All In One
Plugin URI: https://diviwebdesign.com/
Description: Divi All-In-One Module - A custom module you will always need for your Divi sites! CTA - Blurb - Image and all features from Fullwidth Header Extended Module into one. 
Author: Divi Web Design
Version: 1.1.8
Author URI: https://diviwebdesign.com/
*/

function dwd_aio_scripts(){
	//css
	wp_enqueue_style('dwd-all-in-one', plugin_dir_url( __FILE__ ) . 'css/dwd-all-in-one.css');
	wp_register_style('dwd-lightcase-style', plugin_dir_url( __FILE__ ) . 'css/lightcase.css');
    wp_register_style('dwd-animate-s', plugin_dir_url( __FILE__ ) . 'css/animate.css');
    wp_register_style('dwd-hover-button-s', plugin_dir_url( __FILE__ ) . 'css/hover.css' );
	//js
	wp_enqueue_script('dwd-animation-load-s', plugin_dir_url( __FILE__ ) . 'js/animation-load.js', array('jquery'), '1.0', true);
	wp_register_script('dwd-typed-s', plugin_dir_url( __FILE__ ) . 'js/typed.js', array('jquery'), null, false);
    wp_register_script('dwd-typed-load-s', plugin_dir_url( __FILE__ ) . 'js/aiotypingeffect.js', array('jquery'), null, false);
    wp_register_script('dwd-morptext-s', plugin_dir_url( __FILE__ ) . 'js/morphext.min.js', array('jquery'), null, false);
    wp_register_script('dwd-textrotator-s', plugin_dir_url( __FILE__ ) . 'js/textrotator.js', array('dwd-morptext-s'), '1.0', false);
    wp_register_script('dwd-lettering-s', plugin_dir_url( __FILE__ ) . 'js/jquery.lettering.js', array('jquery'), null, true);
    wp_register_script('dwd-textillate-s', plugin_dir_url( __FILE__ ) . 'js/jquery.textillate.js', array('dwd-lettering-s'), null, true);
    wp_register_script('dwd-textillate-start-s', plugin_dir_url( __FILE__ ) . 'js/textillate-start.js', array('dwd-textillate-s'), null, true);
    wp_register_script('dwd-textgif-s', plugin_dir_url( __FILE__ ) . 'js/textHoler.js', array('jquery'), null, true);
    wp_register_script('dwd-textgif-start-s', plugin_dir_url( __FILE__ ) . 'js/textgif-start.js', array('dwd-textgif-s'), null, true);
	wp_register_script('dwd-lightcase-s', plugin_dir_url( __FILE__ ) . 'js/lightcase.js', array('jquery'), '2.3.4', true);
    wp_register_script('dwd-lightcase-start', plugin_dir_url( __FILE__ ) . 'js/lightcase-start.js', array('dwd-lightcase-s'), null, true);
    wp_register_script('dwd-whole-link-s', plugin_dir_url( __FILE__ ) . 'js/whole-link.js', array('jquery'), null, true);
    wp_register_script('dwd-hover-button-s-js', plugin_dir_url( __FILE__ ) . 'js/hover-btn.js', array('jquery'), null, true);
    //wp_register_script('dwd-animated-bg-s', plugin_dir_url( __FILE__ ) . 'js/animated-bg.js', array('jquery'), null, true);
    //wp_register_script('dwd-animated-transparent-bg-s', plugin_dir_url( __FILE__ ) . 'js/animated-transparent-bg.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'dwd_aio_scripts');

function dwd_aio_admin() {
    wp_enqueue_style('dwd-aio-admin', plugin_dir_url( __FILE__ ) . 'css/dwd-admin-aio.css');
}
add_action('admin_enqueue_scripts', 'dwd_aio_admin');

function DWD_ALL_IN_ONE_MODULE(){
	if ( class_exists( 'ET_Builder_Module' ) ) {
		include('dwd-allinone-module.php');
	}
}
add_action('et_builder_ready', 'DWD_ALL_IN_ONE_MODULE');