<?php
class ET_Builder_Module_Fullwidth_Header_Extended extends ET_Builder_Module {
	function init() {
		$this->name             = esc_html__( 'Fullwidth Header Extended', 'et_builder' );
		$this->slug             = 'et_pb_fullwidth_header_extended';
		$this->fb_support       = true;
		$this->fullwidth        = true;
		$this->main_css_element = '%%order_class%%';

		$this->whitelisted_fields = array(
			'title',
			'subhead',
			'background_layout',
			'text_orientation',
			'header_fullscreen',
			'header_scroll_down',
			'scroll_down_icon',
			'scroll_down_icon_color',
			'scroll_down_icon_size',
			'scroll_down_icon_size_tablet',
			'scroll_down_icon_size_phone',
			'title_font_color',
			'subhead_font_color',
			'content_font_color',
			'max_width',
			'max_width_tablet',
			'max_width_phone',
			'button_one_text',
			'button_one_url',
			'button_two_text',
			'button_two_url',
			'background_url',
			'background_color',
			'background_overlay_color',
			'parallax',
			'parallax_method',
			'logo_image_url',
			'logo_title',
			'logo_alt_text',
			'content_orientation',
			'header_image_url',
			'image_orientation',
			'content_new',
			'admin_label',
			'module_id',
			'module_class',
			//added
			'typing_effect',
			'typing_static_on_off',
			'typing_static_text',
			'typing_static_break',
			'typing_speed',
			'typing_delay',
			'typing_backdelay',
			'typing_loop',
			'typing_effect_color',
			'typing_cursor',
			'rotator_effect',
			'rotator_static_on_off',
			'rotator_static_text',
			'rotator_static_break',
			'rotator_type',
			'rotator_speed',
			'rotator_effect_color',
			'textillate_effect',
			'textillate_in_effect',
			'textillate_in_type',
			'textillate_out_effect',
			'textillate_out_type',
			'textgif_on_off',
			'textgif_bg',
			'title_fancyline',
			'title_before_after',
			'title_fancy_orientation',
			'fancyline_styles_on_off',
			'fancyline_color',
			'fancyline_width',
			'fancyline_height',
			'fancyline_margin_top',
			'fancyline_margin_top_tablet',
			'fancyline_margin_top_phone',
			'fancyline_margin_bottom',
			'fancyline_margin_bottom_tablet',
			'fancyline_margin_bottom_phone',
			'fancyline_width_tablet',
			'fancyline_width_phone',
			'fancyline_height_tablet',
			'fancyline_height_phone',
			'subhead_before_after',		
			'whole_header_animation_on_off',
			'whole_animation',
			'whole_animation_reveal',
			'whole_animation_speed',
			'title_animation_on_off',
			'title_animation',
			'title_animation_reveal',
			'title_animation_speed',
			'subheading_animation_on_off',
			'subheading_animation',
			'subheading_animation_reveal',
			'subheading_animation_speed',
			'content_animation_on_off',
			'content_animation',
			'content_animation_reveal',
			'content_animation_speed',
			'button_one_animation_on_off',
			'button_two_animation_on_off',
			'button_one_animation',
			'button_two_animation',
			'button_one_animation_reveal',
			'button_two_animation_reveal',
			'button_one_animation_speed',
			'button_two_animation_speed',
			'logo_image_animation_on_off',
			'logo_image_animation',
			'logo_image_animation_reveal',
			'logo_image_animation_speed',
			'header_image_animation_on_off',
			'header_image_animation',
			'header_image_animation_reveal',
			'header_image_animation_speed',
			'header_scroll_down_effect_on_off',
			'header_scroll_down_effect',
			'animated_gradient',
			'animated_gradient_style',
			'animated_gradient_speed',
			'background_gradient',
			'background_gradient_type',
			'background_gradient_color_one',
			'background_gradient_color_two',
			'particles_effect',
			'custom_scroll_down_icon_on_off',
			'custom_scroll_down_icon_src',
			'icon_max_width',
			'icon_max_width_tablet',
			'icon_max_width_phone',
			'search_on_off',
			's_background_layout',
			's_text_orientation',
			'include_categories',
			'exclude_posts',
			'exclude_pages',
			'hide_button',
			'search_field_bg',
			'search_button_color',
			'search_icon_button',
			'search_icon_color',
			'hide_search_txt',
			'search_button_align_on_off',
			'search_button_align',
			'placeholder',
			'placeholder_color',
			'search_max_width_on_off',
			'search_max_width',
			'search_max_width_tablet',
			'search_max_width_phone',
			'woocommerce_search_on_off',
			'popup_video_on_off_one',
			'popup_video_on_off_two',
			'url_new_window_one',
			'url_new_window_two',
			//button mobile full
			'button_mobile_fullwidth',
			'header_image_custom_url_on_off',
			'header_image_custom_url',
			'header_image_custom_url_new_window',
			//end
		);

		$this->fields_defaults = array(
			'background_layout'   => array( 'light' ),
			'text_orientation'    => array( 'left' ),
			'header_fullscreen'   => array( 'off' ),
			'header_scroll_down'  => array( 'off' ),
			'scroll_down_icon'    => array( '%%3%%', 'add_default_setting' ),
			'parallax'            => array( 'off' ),
			'parallax_method'     => array( 'off' ),
			'content_orientation' => array( 'center' ),
			'image_orientation'   => array( 'center' ),
			//added
			'typing_effect'       => array( 'off' ),
			'typing_static_on_off'       => array( 'off' ),
			'typing_static_break'       => array( 'off' ),
			'typing_speed'        => array( '10' ),
			'typing_delay'        => array( '0' ),
			'typing_backdelay'        => array( '500' ),
			'typing_loop'       => array( 'on' ),
			'rotator_effect'      => array( 'off' ),
			'rotator_static_on_off'       => array( 'off' ),
			'rotator_static_break'       => array( 'off' ),
			'rotator_type'      => array( 'fadeIn' ),
			'rotator_speed'       => array( '2000' ),
			'title_fancyline' => array('off'),
			'title_fancy_orientation' => array('left'),
			'fancyline_styles_on_off' => array('off'),
			'fancyline_width' => array('40px'),
			'fancyline_height' => array('2px'),
			'fancyline_margin_top' => array('20px'),
			'fancyline_margin_bottom' => array('20px'),
			'subhead_before_after' => array('after'),
			'textillate_effect'		=> array('off'),
			'textillate_in_effect'		=> array('flipInX'),
			'textillate_in_type'		=> array('sequence'),
			'textillate_out_effect'		=> array('flipInY'),
			'textillate_out_type'		=> array('reverse'),
			'textgif_on_off'      => array( 'off' ),
			'whole_header_animation_on_off'   => array( 'off' ),
			'whole_animation'               => array( 'fadeIn' ),
			'whole_animation_reveal'               => array( 'off' ),
			'whole_animation_speed'               => array( '0' ),
			'title_animation_on_off'   => array( 'off' ),
			'title_animation'               => array( 'fadeIn' ),
			'title_animation_reveal'               => array( 'off' ),
			'title_animation_speed'               => array( '0' ),
			'subheading_animation_on_off'   => array( 'off' ),
			'subheading_animation'               => array( 'fadeIn' ),
			'subheading_animation_reveal'               => array( 'off' ),
			'subheading_animation_speed'               => array( '0' ),
			'content_animation_on_off'   => array( 'off' ),
			'content_animation'               => array( 'fadeInUp' ),
			'content_animation_reveal'               => array( 'off' ),
			'content_animation_speed'               => array( '0' ),
			'button_one_animation_on_off'   => array( 'off' ),
			'button_two_animation_on_off'   => array( 'off' ),
			'button_one_animation'               => array( 'fadeInUp' ),
			'button_one_animation_reveal'               => array( 'off' ),
			'button_one_animation_speed'               => array( '0' ),
			'button_two_animation'               => array( 'fadeInUp' ),
			'button_two_animation_reveal'               => array( 'off' ),
			'button_two_animation_speed'               => array( '0' ),
			'logo_image_animation_on_off' =>array('off'),
			'logo_image_animation'        =>array( 'fadeInUp' ),
			'logo_image_animation_reveal' =>array('off'),
			'logo_image_animation_speed' =>array('0'),
			'header_image_animation_on_off' =>array('off'),
			'header_image_animation' =>array( 'fadeInUp' ),
			'header_image_animation_reveal' => array('off'),
			'header_image_animation_speed' => array('0'),
			'header_scroll_down_effect_on_off'  => array( 'off' ),
			'header_scroll_down_effect'  => array( 'bounce' ),
			'animated_gradient'   => array( 'off' ),
			'animated_gradient_style'   => array( 'off' ),
			'animated_gradient_speed'   => array( '0.001' ),
			'background_gradient'   => array( 'off' ),
			'background_gradient_type'   => array( 'top-to-bottom' ),
			'particles_effect'    => array( 'off' ),
			'custom_scroll_down_icon_on_off'	=> array( 'off' ),
			'search_on_off'	=> array( 'off' ),
			's_text_orientation'  => array( 'left' ),
			's_background_layout' => array( 'light' ),
			'placeholder'	=> array( 'Type some keyword to start searching..' ),
			'search_icon_button'	=> array( 'off' ),
			'hide_search_txt'	=> array( 'off' ),
			'search_button_align_on_off'	=> array( 'off' ),
			'woocommerce_search_on_off'	=> array( 'off' ),
			//'search_max_width'	=> array( '500px' ),
			'popup_video_on_off_one' => array( 'off' ),
			'popup_video_on_off_two' => array( 'off' ),
			//new window
			'url_new_window_one'	=> array( 'off' ),
			'url_new_window_two'	=> array( 'off' ),
			//button mobile full
			'button_mobile_fullwidth' => array( 'off' ),
			'header_image_custom_url_on_off' => array( 'off' ),
			'header_image_custom_url_new_window'  => array( 'off' ),
			//end
		);

		$this->options_toggles = array(
			'advanced' => array(
				'settings' => array(
					'toggles_disabled' => true,
				),
				'toggles' => array(
					'title_styles'   => esc_html__( 'Title Styling', 'et_builder' ),
					'subhead_styles' => esc_html__( 'Subhead Styling', 'et_builder' ),
					'content_styles' => esc_html__( 'Content Styling', 'et_builder' ),
					'fancyline_styles' => esc_html__( 'Fancy Line Styling', 'et_builder' ),
					'search_styles' => esc_html__( 'Search Styling', 'et_builder' ),
				),
			),
		);
		$this->advanced_options = array(
			'fonts' => array(
				'title' => array(
					'label'    => esc_html__( 'Title', 'et_builder' ),
					'css'      => array(
						'main' => "%%order_class%%.et_pb_fullwidth_header .header-content h1",
					),
					'font_size' => array(
						'toggle_slug'  => 'title_styles',
						'default'      => '30px',
					),
					'font' => array(
						'toggle_slug'  => 'title_styles',
					),
					'line_height' => array(
						'toggle_slug'  => 'title_styles',
						'default' => '1em',
					),
					'letter_spacing' => array(
						'toggle_slug'  => 'title_styles',
						'default' => '0px',
					),
					'hide_line_height'    => false,
					'hide_text_color'     => true,
					'hide_letter_spacing' => false,
				),
				'subhead' => array(
					'label'    => esc_html__( 'Subhead', 'et_builder' ),
					'css'      => array(
						'main' => "%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_subhead",
					),
					'font_size' => array(
						'toggle_slug'  => 'subhead_styles',
						'default'	   => '18px',
					),
					'font' => array(
						'toggle_slug'  => 'subhead_styles',
					),
					'line_height' => array(
						'toggle_slug'  => 'subhead_styles',
						'default' => '1.7em',
					),
					'letter_spacing' => array(
						'toggle_slug'  => 'subhead_styles',
						'default' => '0px',
					),
					'hide_line_height'    => false,
					'hide_text_color'     => true,
					'hide_letter_spacing' => false,
				),
				'content' => array(
					'label'    => esc_html__( 'Content', 'et_builder' ),
					'css'      => array(
						'main' => "%%order_class%%.et_pb_fullwidth_header p",
					),
					'font_size' => array(
						'toggle_slug'  => 'content_styles',
						'default'      => '14px',
					),
					'font' => array(
						'toggle_slug'  => 'content_styles',
					),
					'line_height' => array(
						'toggle_slug'  => 'content_styles',
						'default' => '1.7em',
					),
					'letter_spacing' => array(
						'toggle_slug'  => 'content_styles',
						'default' => '0px',
					),
					'hide_line_height'    => false,
					'hide_text_color'     => true,
					'hide_letter_spacing' => false,
				),
				'input' => array(
					'label'    => esc_html__( 'Input', 'et_builder' ),
					'css'      => array(
						'main' => "{$this->main_css_element} input.et_pb_s",
						'placeholder' => true,
					),
					'font' => array(
						'toggle_slug'  => 'search_styles',
					),
					'line_height'    => array(
						'default' => '1em',
						'toggle_slug'  => 'search_styles',
					),
					'font_size'      => array(
						'default' => '14px',
						'toggle_slug'  => 'search_styles',
					),
					'letter_spacing' => array(
						'default' => '0px',
						'toggle_slug'  => 'search_styles',
					),
				),
				'search_button' => array(
					'label'          => esc_html__( 'Search Button', 'et_builder' ),
					'css'            => array(
						'main' => "{$this->main_css_element} button.et_pb_searchsubmit",
					),
					'font' => array(
						'toggle_slug'  => 'search_styles',
					),
					'line_height'    => array(
						'default' => '1em',
						'toggle_slug'  => 'search_styles',
					),
					'font_size'      => array(
						'default' => '14px',
						'toggle_slug'  => 'search_styles',
					),
					'letter_spacing' => array(
						'default' => '0px',
						'toggle_slug'  => 'search_styles',	
					),
				),
			),
			'button' => array(
				'button_one' => array(
					'label' => esc_html__( 'Button One', 'et_builder' ),
					'css'      => array(
						'main' => "{$this->main_css_element} .et_pb_button_one.et_pb_button",
					),
				),
				'button_two' => array(
					'label' => esc_html__( 'Button Two', 'et_builder' ),
					'css'      => array(
						'main' => "{$this->main_css_element} .et_pb_button_two.et_pb_button",
					),
				),
			),
			'scroll_down_icon_size' => array(
				'font_size' => array(
					'default'      => '42px',
				),
				'hide_line_height'    => true,
				'hide_text_color'     => true,
				'hide_letter_spacing' => true,
			),
		);

		$this->custom_css_options = array(
			'header_container' => array(
				'label'    => esc_html__( 'Header Container', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container',
			),
			'header_content' => array(
				'label'    => esc_html__( 'Header Content', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .header-content',
			),
			'header_image' => array(
				'label'    => esc_html__( 'Header Image', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .header-image img',
			),
			'logo' => array(
				'label'    => esc_html__( 'Logo', 'et_builder' ),
				'selector' => '.header-content img',
			),
			'title' => array(
				'label'    => esc_html__( 'Title', 'et_builder' ),
				'selector' => '.header-content h1',
			),
			'subtitle' => array(
				'label'    => esc_html__( 'Subtitle', 'et_builder' ),
				'selector' => '.header-content .et_pb_fullwidth_header_subhead',
			),
			'button_1' => array(
				'label'    => esc_html__( 'Button One', 'et_builder' ),
				'selector' => '.header-content-container .header-content .et_pb_button_one.et_pb_button',
			),
			'button_2' => array(
				'label'    => esc_html__( 'Button Two', 'et_builder' ),
				'selector' => '.header-content-container .header-content .et_pb_button_two.et_pb_button',
			),
			'scroll_button' => array(
				'label'    => esc_html__( 'Scroll Down Button', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_scroll a .et-pb-icon',
			),
			//added
			'typing_custom' => array(
				'label'    => esc_html__( 'Typing Effect', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .dwd-typing',
			),
			'rotator_custom' => array(
				'label'    => esc_html__( 'Rotator Effect', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .dwd-rotator',
			),
			'input_field' => array(
				'label'    => esc_html__( 'Input Field', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container input.et_pb_s',
			),
			'search_button'      => array(
				'label'    => esc_html__( 'Search Button', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .et_pb_search_extended button.et_pb_searchsubmit',
			),
			'search_icon'      => array(
				'label'    => esc_html__( 'Search Icon', 'et_builder' ),
				'selector' => '.et_pb_fullwidth_header_container .et_pb_search_extended button.et_pb_searchsubmit .dwd_search_icon:before',
			),
		);
	}

	function get_fields() {
		// List of animation options
		//added
		$animation_type_list = array(
			'fadeIn' => esc_html__( 'fadeIn', 'et_builder' ),
			'bounce'    => esc_html__( 'bounce', 'et_builder' ),
			'flash'   => esc_html__( 'flash', 'et_builder' ),
			'pulse'     => esc_html__( 'pulse', 'et_builder' ),
			'rubberBand'  => esc_html__( 'rubberBand', 'et_builder' ),
			'shake' => esc_html__( 'shake', 'et_builder' ),
			'swing'    => esc_html__( 'swing', 'et_builder' ),
			'tada'   => esc_html__( 'tada', 'et_builder' ),
			'wobble'     => esc_html__( 'wobble', 'et_builder' ),
			'jello'     => esc_html__( 'jello', 'et_builder' ),
			'bounceIn'  => esc_html__( 'bounceIn', 'et_builder' ),
			'bounceInDown' => esc_html__( 'bounceInDown', 'et_builder' ),
			'bounceInLeft' => esc_html__( 'bounceInLeft', 'et_builder' ),
			'bounceInRight'    => esc_html__( 'bounceInRight', 'et_builder' ),
			'bounceInUp'   => esc_html__( 'bounceInUp', 'et_builder' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'et_builder' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'et_builder' ),
			'fadeInLeft' => esc_html__( 'fadeInLeft', 'et_builder' ),
			'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'et_builder' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'et_builder' ),
			'fadeInRightBig'   => esc_html__( 'fadeInRightBig', 'et_builder' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'et_builder' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'et_builder' ),
			'fadeInUp' => esc_html__( 'fadeInUp', 'et_builder' ),
			'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'et_builder' ),
			'slideInUp' => esc_html__( 'slideInUp', 'et_builder' ),
			'slideInDown' => esc_html__( 'slideInDown', 'et_builder' ),
			'slideInLeft' => esc_html__( 'slideInLeft', 'et_builder' ),
			'slideInRight' => esc_html__( 'slideInRight', 'et_builder' ),
			'flip' => esc_html__( 'flip', 'et_builder' ),
			'flipInX' => esc_html__( 'flipInX', 'et_builder' ),
			'flipInY'    => esc_html__( 'flipInY', 'et_builder' ),
			'flipOutX' => esc_html__( 'flipOutX', 'et_builder' ),
			'flipOutY'    => esc_html__( 'flipOutY', 'et_builder' ),
			'rotateIn'   => esc_html__( 'rotateIn', 'et_builder' ),
			'rotateInDownLeft'     => esc_html__( 'rotateInDownLeft', 'et_builder' ),
			'rotateInDownRight'  => esc_html__( 'rotateInDownRight', 'et_builder' ),
			'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'et_builder' ),
			'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'et_builder' ),
			'zoomIn'    => esc_html__( 'zoomIn', 'et_builder' ),
			'zoomInDown'   => esc_html__( 'zoomInDown', 'et_builder' ),
			'zoomInLeft'     => esc_html__( 'zoomInLeft', 'et_builder' ),
			'zoomInRight'  => esc_html__( 'zoomInRight', 'et_builder' ),
			'zoomInUp' => esc_html__( 'zoomInUp', 'et_builder' ),
			'lightSpeedIn' => esc_html__( 'lightSpeedIn', 'et_builder' ),
			'lightSpeedOut' => esc_html__( 'lightSpeedOut', 'et_builder' ),
			'rollIn' => esc_html__( 'rollIn', 'et_builder' ),
			'rollOut' => esc_html__( 'rollOut', 'et_builder' ),
			'hinge' => esc_html__( 'hinge', 'et_builder' ),
		);
		//end
		$fields = array(
			'title' => array(
				'label'           => esc_html__( 'Title', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter your page title here.', 'et_builder' ),
			),
			// added new effect
			'typing_effect' => array(
				'label'           => esc_html__( 'Use Typing Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_typing_static_on_off, #et_pb_typing_speed, #et_pb_typing_delay, #et_pb_typing_backdelay, #et_pb_typing_loop, #et_pb_typing_effect_color, #et_pb_typing_cursor, #et_pb_rotator_effect, #et_pb_textillate_effect, #et_pb_textgif_on_off',
				),
				'description'        => esc_html__( 'If enabled, you can choose whether if you want your title to have typing or rotator effect. Use | to separate e.g text1|text2|text3', 'et_builder' ),
			),
			'typing_loop' => array(
				'label'           => esc_html__( 'Disable Typing Loop', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'depends_default'   => true,
				'default'           => 'on',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'        => esc_html__( 'If disabled, typing effect will not loop infinite. It will stop after completed.
				', 'et_builder' ),
			),
			'typing_static_on_off' => array(
				'label'           => esc_html__( 'Static + Typing Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_typing_static_text, #et_pb_typing_static_break',
				),
				'description'        => esc_html__( 'If enabled, you can have static text and typing
				effect on the title at the same time.For the static text input , type in the "title" input field above.
				', 'et_builder' ),
			),
			'typing_static_text' => array(
				'label'           => esc_html__( 'Input for Typing Effect', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'For the typing effect, enter the input by using | to separate e.g text1|text2|text3.', 'et_builder' ),
			),
			'typing_static_break' => array(
				'label'           => esc_html__( 'Typing Effect on a new line', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'        => esc_html__( 'If enabled, you can have static text on the first line and typing
				effect on the other line.
				', 'et_builder' ),
			),
			'typing_speed' => array(
				'label'             => esc_html__( 'Animation Speed (in ms)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '10',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '200',
						'step' => '5',						
				),
				'description'       => esc_html__( 'Here you can designate the speed of the typing effect, 
				if typing effect option is enabled above,enter the value from 10 onwards
				', 'et_builder' ),
			),
			'typing_delay' => array(
				'label'             => esc_html__( 'Start Delay Speed (in ms)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '500',
						'step' => '10',						
				),
				'description'       => esc_html__( 'Time before typing starts 
				', 'et_builder' ),
			),
			'typing_backdelay' => array(
				'label'             => esc_html__( 'Delay Time Before Backspacing (in ms)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '500',
				'range_settings'  => array(
						'min'  => '500',
						'max'  => '2000',
						'step' => '100',						
				),
				'description'       => esc_html__( 'Time before typing starts 
				', 'et_builder' ),
			),
			'typing_effect_color' => array(
				'label'             => esc_html__( 'Typing Font Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'custom_color'      => true,
				'description'       => esc_html__( "This will be apply to the typing text effect only
				", 'et_builder' ),
			),
			'typing_cursor' => array(
				'label'             => esc_html__( 'Typing Cursor Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'custom_color'      => true,
			),
			'rotator_effect' => array(
				'label'           => esc_html__( 'Use Rotator Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_rotator_static_on_off,#et_pb_rotator_speed, #et_pb_rotator_type, #et_pb_rotator_effect_color, #et_pb_textillate_effect, #et_pb_textgif_on_off',
				),
				'depends_show_if'   => 'off',
				'description'        => esc_html__( 'If enabled, you can choose whether if you want your title to have rotator effect. Use | to separate e.g text1|text2|text3', 'et_builder' ),
			),
			'rotator_static_on_off' => array(
				'label'           => esc_html__( 'Static + Rotator Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_rotator_static_text, #et_pb_rotator_static_break',
				),
				'description'        => esc_html__( 'If enabled, you can have static text and rotator
				effect on the title at the same time.For the static text input , type in the "title" input field above.
				', 'et_builder' ),
			),
			'rotator_static_text' => array(
				'label'           => esc_html__( 'Input for Rotator Effect', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'For the rotator effect, enter the input by using | to separate e.g text1|text2|text3.', 'et_builder' ),
			),
			'rotator_static_break' => array(
				'label'           => esc_html__( 'Rotator Effect on a new line', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'        => esc_html__( 'If enabled, you can have static text on the first line and rotator
				effect on the other line.
				', 'et_builder' ),
			),
			'rotator_type' => array(
				'label'             => esc_html__( 'Animation Type', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'         => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the effect animation of the text rotator.', 'et_builder' ),
			),
			'rotator_speed' => array(
				'label'             => esc_html__( 'Animation Speed (in ms)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '2000',
				'range_settings'  => array(
						'min'  => '2000',
						'max'  => '3000',
						'step' => '50',						
				),
				'description'       => esc_html__( "Here you can designate the speed of the typing effect, option is enabled above, enter the value from 2000 onwards. 
				", 'et_builder' ),
			),
			'rotator_effect_color' => array(
				'label'             => esc_html__( 'Rotator Font Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'custom_color'      => true,
				'description'       => esc_html__( "This will be apply to the rotator text effect only
				", 'et_builder' ),
			),
			'textillate_effect' => array(
				'label'           => esc_html__( 'Use Textillate Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_textillate_in_type, #et_pb_textillate_in_effect, #et_pb_textillate_out_type, #et_pb_textillate_out_effect, #et_pb_textgif_on_off',
				),
				'depends_show_if'   => 'off',
				'description'        => esc_html__( 'If enabled, you can choose whether if you want your title to have Textillate effect.', 'et_builder' ),
			),
			'textillate_in_type' => array(
				'label'             => esc_html__( 'In Animation Type', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'         => array(
					'sequence'          => esc_html__( 'Sequence', 'et_builder' ),
					'reverse' => esc_html__( 'Reverse', 'et_builder' ),
					'sync'        => esc_html__( 'Sync', 'et_builder' ),
					'shuffle'        => esc_html__( 'Shuffle', 'et_builder' ),
				),
				'description'       => esc_html__( 'Choose the animation type. Shuffle will reverse the character sequence. ', 'et_builder' ),
			),
			'textillate_in_effect' => array(
				'label'             => esc_html__( 'In Animation Effect', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'default'           => 'flipInX',
				'options'         => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the effect starting animation of the textillate.', 'et_builder' ),
			),
			'textillate_out_type' => array(
				'label'             => esc_html__( 'Out Animation Type', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'         => array(
					'sequence'          => esc_html__( 'Sequence', 'et_builder' ),
					'reverse' => esc_html__( 'Reverse', 'et_builder' ),
					'sync'        => esc_html__( 'Sync', 'et_builder' ),
					'shuffle'        => esc_html__( 'Shuffle', 'et_builder' ),
				),
				'description'       => esc_html__( 'Choose the animation type. Shuffle will reverse the character sequence. ', 'et_builder' ),
			),
			'textillate_out_effect' => array(
				'label'             => esc_html__( 'Out Animation Effect', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'default'           => 'flipInY',
				'options'         => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the effect exit animation of the textillate.', 'et_builder' ),
			),
			'textgif_on_off' => array(
				'label'           => esc_html__( 'Use TextGIF Background', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_textgif_bg'
				),
				'depends_show_if'   => 'off',
				'description'        => esc_html__( 'If enabled, you can have gif on the text background text animation.', 'et_builder' ),
			),
			'textgif_bg' => array(
				'label'              => esc_html__( 'TextGIF Background Image URL', 'et_builder' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an background', 'et_builder' ),
				'choose_text'        => esc_attr__( 'Choose an background', 'et_builder' ),
				'update_text'        => esc_attr__( 'Set As Background', 'et_builder' ),
				'description'        => esc_html__( 'Upload your desired GIF image, or type in the URL to the image you would like to display.', 'et_builder' ),
			),
			//end
			'title_fancyline' => array(
				'label'           => esc_html__( 'Use Fancy line on Title', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_title_before_after, #et_pb_title_fancy_orientation',
				),
				'description'       => esc_html__( 'Here you can choose to have fancy line on title (Underline)', 'et_builder' ),
			),
			'title_before_after' => array(
				'label'           => esc_html__( 'Fancy line before or after Title', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'before' => esc_html__( 'Before', 'et_builder' ),
					'after'  => esc_html__( 'After', 'et_builder' ),
				),				
				'description'       => esc_html__( 'This controls whether this title should have the fancy line appears before or after the Title depending if you use Subheading or not', 'et_builder' ),
			),
			'title_fancy_orientation' => array(
				'label'             => esc_html__( 'Fancy Line Orientation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'layout',
				'options'         => array(
					'left' => esc_html__( 'Left', 'et_builder' ),
					'center'  => esc_html__( 'Center', 'et_builder' ),
					'right'  => esc_html__( 'Right', 'et_builder' ),
				),		
				'description'       => esc_html__( 'This controls the how your fancy line is aligned', 'et_builder' ),
			),
			'subhead' => array(
				'label'           => esc_html__( 'Subheading Text', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'If you would like to use a subhead, add it here. Your subhead will appear below your title in a small font.', 'et_builder' ),
			),
			//added
			'subhead_before_after' => array(
				'label'           => esc_html__( 'Subheading Before or After Title', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'before' => esc_html__( 'Before', 'et_builder' ),
					'after'  => esc_html__( 'After', 'et_builder' ),
				),				
				'description'       => esc_html__( 'This controls whether this text appears before or after the Title text. ', 'et_builder' ),
			),
			'whole_header_animation_on_off' => array(
				'label'           => esc_html__( 'Use Header Animation', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_whole_animation, 
					#et_pb_whole_animation_reveal,
					#et_pb_title_animation_on_off, 
					#et_pb_title_animation_reveal,
					#et_pb_subheading_animation_on_off,
					#et_pb_subheading_animation_reveal,			
					#et_pb_content_animation_on_off, 
					#et_pb_content_animation_reveal,
					#et_pb_button_one_animation_on_off,
					#et_pb_button_one_animation_reveal,
					#et_pb_button_two_animation_on_off,
					#et_pb_button_two_animation_reveal'
				),
				'description'        => esc_html__( 'If enabled, you can define the animation of the whole header section. However you are not able to use animation on Title, Subhead, Content and Button if this is enabled. ', 'et_builder' ),
			),
			'whole_animation' => array(
				'label'             => esc_html__( 'Whole Header Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
				'depends_show_if'     => 'on',
			),
			'whole_animation_reveal' => array(
				'label'           => esc_html__( 'Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_whole_animation_speed',
				),
				'description'        => esc_html__( 'Reveal CSS animation as you scroll down a page.', 'et_builder' ),
				
			),
			'whole_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'depends_show_if'     => 'on',
			),
			//end of added codes
			'background_layout' => array(
				'label'           => esc_html__( 'Text Color', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'color_option',
				'options'         => array(
					'light' => esc_html__( 'Dark', 'et_builder' ),
					'dark'  => esc_html__( 'Light', 'et_builder' ),
				),
				'description'       => esc_html__( 'Here you can choose the value of your text. If you are working with a dark background, then your text should be set to light. If you are working with a light background, then your text should be dark.', 'et_builder' ),
			),
			'text_orientation' => array(
				'label'             => esc_html__( 'Text & Logo Orientation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'layout',
				'options'           => et_builder_get_text_orientation_options(),
				'description'       => esc_html__( 'This controls the how your text is aligned within the module.', 'et_builder' ),
			),

			'header_fullscreen' => array(
				'label'           => esc_html__( 'Make Fullscreen', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_content_orientation',
				),
				'description'       => esc_html__( 'Here you can choose whether the header is expanded to fullscreen size.', 'et_builder' ),
			),
			'header_scroll_down' => array(
				'label'           => esc_html__( 'Show Scroll Down Button', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_header_scroll_down_effect_on_off, #et_pb_custom_scroll_down_icon_on_off',
				),
				'description'       => esc_html__( 'Here you can choose whether the scroll down button is shown.', 'et_builder' ),
			),
			'scroll_down_icon' => array(
				'label'               => esc_html__( 'Icon', 'et_builder' ),
				'type'                => 'text',
				'option_category'     => 'configuration',
				'class'               => array( 'et-pb-font-icon' ),
				'renderer'            => 'et_pb_get_font_down_icon_list',
				'renderer_with_field' => true,
				'description'         => esc_html__( 'Choose an icon to display for the scroll down button.', 'et_builder' ),
				//depends on custom icon
				'depends_show_if'     => 'off',
			),
			//added
			'custom_scroll_down_icon_on_off' => array(
				'label'           => esc_html__( 'Custom Scroll Image/Icon', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_scroll_down_icon, #et_pb_custom_scroll_down_icon_src, #et_pb_icon_max_width, #et_pb_scroll_down_icon_color, #et_pb_scroll_down_icon_size',
				),
				'description'       => esc_html__( 'Here you can choose to upload your own scroll down image/icon.', 'et_builder' ),
				'depends_show_if'     => 'on',
			),
			'custom_scroll_down_icon_src' => array(
				'label'              => esc_html__( 'Scroll Image/Icon URL', 'et_builder' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'        => esc_attr__( 'Set As Scroll Image', 'et_builder' ),
				//added depends to show
				'depends_show_if'   => 'on',
				//end
				'description'        => esc_html__( 'Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder' ),
			),
			'icon_max_width' => array(
				'label'           => esc_html__( 'Scroll Icon Width (in px)', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'layout',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
				'validate_unit'   => true,
				//added depends to show
				'depends_show_if'   => 'on',
				//end
			),
			'icon_max_width_tablet' => array(
				'type' => 'skip',
			),
			'icon_max_width_phone' => array(
				'type' => 'skip',
			),
			'header_scroll_down_effect_on_off' => array(
				'label'           => esc_html__( 'Animation on Scroll Icon', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_header_scroll_down_effect',
				),
				'description'       => esc_html__( 'Here you can choose whether the apply animation on scroll down icon.', 'et_builder' ),
				'depends_show_if'     => 'on',
			),
			'header_scroll_down_effect' => array(
				'label'             => esc_html__( 'Animation Type', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'         => $animation_type_list,
				'description'       => esc_html__( 'This set a infinite effect animation of the scroll down icon.', 'et_builder' ),
				'depends_show_if'     => 'on',
			),
			//end
			//search added
			'search_on_off' => array(
				'label'           => esc_html__( 'Include Search Form', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_woocommerce_search_on_off, #et_pb_s_background_layout, #et_pb_s_text_orientation, #et_pb_hide_search_txt, #et_pb_search_icon_button, #et_pb_hide_button, #et_pb_placeholder, #et_pb_search_button_align_on_off, #et_pb_search_button_align',
				),
				'description'       => esc_html__( 'Here you can choose whether to show search bar on the header.', 'et_builder' ),
			),
			'woocommerce_search_on_off' => array(
				'label'           => esc_html__( 'WooCommerce Search', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'Off', 'et_builder' ),
					'on'  => esc_html__( 'On', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_exclude_pages, #et_pb_exclude_posts, include_categories',
				),
				'description'       => esc_html__( 'Turning this on will search for WooCommerce Products from search results instead of posts/pages', 'et_builder' ),
			),
			's_background_layout' => array(
				'label'           => esc_html__( 'Text Color', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'light' => esc_html__( 'Dark', 'et_builder' ),
					'dark'  => esc_html__( 'Light', 'et_builder' ),
				),
				'description'     => esc_html__( 'Here you can choose the value of your text. If you are working with a dark background, then your text should be set to light. If you are working with a light background, then your text should be dark.', 'et_builder' ),
			),
			's_text_orientation' => array(
				'label'           => esc_html__( 'Text Orientation', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'left'   => esc_html__( 'Left', 'et_builder' ),
					'right'  => esc_html__( 'Right', 'et_builder' ),
					'center' => esc_html__( 'Center', 'et_builder' ),
				),
				'description'     => esc_html__( 'This controls the how your text is aligned within the module.', 'et_builder' ),
			),
			'exclude_pages' => array(
				'label'           => esc_html__( 'Exclude Pages', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'depends_show_if'  => 'off',
				'description'     => esc_html__( 'Turning this on will exclude Pages from search results', 'et_builder' ),
			),
			'exclude_posts' => array(
				'label'           => esc_html__( 'Exclude Posts', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'         => array(
					'include_categories',
				),
				'depends_show_if'  => 'off',
				'description'     => esc_html__( 'Turning this on will exclude Posts from search results', 'et_builder' ),
			),
			'include_categories' => array(
				'label'            => esc_html__( 'Exclude Categories', 'et_builder' ),
				'renderer'         => 'et_builder_include_categories_option',
				'option_category'  => 'basic_option',
				'renderer_options' => array(
					'use_terms' => false,
				),
				'depends_show_if'  => 'off',
				'description'      => esc_html__( 'Choose which categories you would like to exclude from the search results.', 'et_builder' ),
			),
			'search_icon_button' => array(
				'label'           => esc_html__( 'Show Search Icon', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'     => esc_html__( 'Turning this on will show the Search Icon on the button before text', 'et_builder' ),
			),
			'hide_search_txt' => array(
				'label'           => esc_html__( 'Hide Search Text', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'     => esc_html__( 'Turning this on will hide the Search Text', 'et_builder' ),
			),
			'hide_button' => array(
				'label'           => esc_html__( 'Hide Button', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'     => esc_html__( 'Turning this on will hide the Search button', 'et_builder' ),
			),
			'search_button_align_on_off' => array(
				'label'           => esc_html__( 'Align Button', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'No', 'et_builder' ),
					'on'  => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_search_button_align',
				),
				'description'     => esc_html__( 'Turning this on will align the Search button placement', 'et_builder' ),
			),
			'search_button_align' => array(
				'label'           => esc_html__( 'Search Button Orientation', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'left'   => esc_html__( 'Left', 'et_builder' ),
					'right'  => esc_html__( 'Right', 'et_builder' ),
				),
				'description'     => esc_html__( 'This controls the how your Button is aligned within the search input.', 'et_builder' ),
			),
			'placeholder' => array(
				'label'       => esc_html__( 'Placeholder Text', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'Type the text you want to use as placeholder for the search field.', 'et_builder' ),
			),
			//search ended
			'scroll_down_icon_color' => array(
				'label'             => esc_html__( 'Scroll Down Icon Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'custom_color'      => true,
				'tab_slug'          => 'advanced',
				//added depends to show
				'depends_show_if'   => 'off',
				//end
			),
			'scroll_down_icon_size' => array(
				'label'           => esc_html__( 'Scroll Down Icon Size', 'et_builder' ),
				'type'            => 'range',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'default'           => '42px',
				'tab_slug'        => 'advanced',
				//added depends to show
				'depends_show_if'   => 'off',
				//end
			),
			'scroll_down_icon_size_tablet' => array(
				'type' => 'skip',
			),
			'scroll_down_icon_size_phone' => array(
				'type' => 'skip',
			),
			//animation for title, subheadin & content
			//added
			'title_animation_on_off' => array(
				'label'           => esc_html__( 'Title Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_title_animation, #et_pb_title_animation_reveal',
				),
				'depends_show_if'     => 'off',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'title_styles',
			),
			'title_animation' => array(
				'label'             => esc_html__( 'Title Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),	
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'title_styles',	
				'depends_show_if'     => 'on',				
			),
			'title_animation_reveal' => array(
				'label'           => esc_html__( 'Title Animation Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_title_animation_speed',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'title_styles',
				'depends_show_if'     => 'on',	
			),
			'title_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'title_styles',
				'depends_show_if'     => 'on',
			),
			'subheading_animation_on_off' => array(
				'label'           => esc_html__( 'Subheading Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_subheading_animation, #et_pb_subheading_animation_reveal',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'subhead_styles',
				'depends_show_if'     => 'off',
			),
			'subheading_animation' => array(
				'label'             => esc_html__( 'Subheading Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'subhead_styles',
				'depends_show_if'     => 'on',
			),
			'subheading_animation_reveal' => array(
				'label'           => esc_html__( 'Subheading Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_subheading_animation_speed',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'subhead_styles',
				'depends_show_if'     => 'on',
			),
			'subheading_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'subhead_styles',
				'depends_show_if'     => 'on',
			),
			'content_animation_on_off' => array(
				'label'           => esc_html__( 'Content Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_content_animation,#et_pb_content_animation_reveal',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'content_styles',
				'depends_show_if'     => 'off',
			),
			'content_animation' => array(
				'label'             => esc_html__( 'Content Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'content_styles',
				'depends_show_if'     => 'on',
			),
			'content_animation_reveal' => array(
				'label'           => esc_html__( 'Content Animation Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_content_animation_speed',
				),
				'depends_show_if'     => 'on',	
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'content_styles',
			),
			'content_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'content_styles',
				'depends_show_if'     => 'on',
			),
			//search max width
			'search_max_width_on_off' => array(
				'label'           => esc_html__( 'Use Custom Styles for Search', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_search_max_width, #et_pb_search_max_width_tablet, #et_pb_search_max_width_phone, #et_pb_search_button_color, #et_pb_search_icon_color, #et_pb_search_field_bg, #et_pb_placeholder_color',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'search_styles',
			),
			'search_max_width' => array(
				'label'           => esc_html__( 'Search Max Width', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'layout',
				'tab_slug'        => 'advanced',
				'toggle_slug'       => 'search_styles',
				'mobile_options'  => true,
				'validate_unit'   => true,
			),
			'search_max_width_tablet' => array(
				'type' => 'skip',
				'tab_slug' => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			'search_max_width_phone' => array(
				'type' => 'skip',
				'tab_slug' => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			'search_icon_color' => array(
				'label'        => esc_html__( 'Search Icon Color', 'et_builder' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'tab_slug'     => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			'search_button_color' => array(
				'label'        => esc_html__( 'Button and Border Color', 'et_builder' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'tab_slug'     => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			'search_field_bg' => array(
				'label'        => esc_html__( 'Input Field Background Color', 'et_builder' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'tab_slug'     => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			'placeholder_color' => array(
				'label'        => esc_html__( 'Placeholder Color', 'et_builder' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'tab_slug'     => 'advanced',
				'toggle_slug' => 'search_styles',
			),
			//end
			'title_font_color' => array(
				'label'             => esc_html__( 'Title Font Color', 'et_builder' ),
				'type'              => 'color',
				'custom_color'      => true,
				'tab_slug'          => 'advanced',
				'toggle_slug'       => 'title_styles',
			),
			'subhead_font_color' => array(
				'label'             => esc_html__( 'Subhead Font Color', 'et_builder' ),
				'type'              => 'color',
				'custom_color'      => true,
				'tab_slug'          => 'advanced',
				'toggle_slug'       => 'subhead_styles',
			),
			'content_font_color' => array(
				'label'             => esc_html__( 'Content Font Color', 'et_builder' ),
				'type'              => 'color',
				'custom_color'      => true,
				'tab_slug'          => 'advanced',
				'toggle_slug'       => 'content_styles',
			),
			'max_width' => array(
				'label'           => esc_html__( 'Container Max Width', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'layout',
				'tab_slug'        => 'advanced',
				'mobile_options'  => true,
				'validate_unit'   => true,
				'description'        => esc_html__( 'You can have custom width on the header. By default, Divi set a max-width of 800px on .header-content', 'et_builder' ),
			),
			'max_width_tablet' => array(
				'type' => 'skip',
			),
			'max_width_phone' => array(
				'type' => 'skip',
			),
			//animations for buttons
			//added
			'fancyline_styles_on_off' => array(
				'label'           => esc_html__( 'Use Custom Styles for Fancy Line', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_fancyline_color, #et_pb_fancyline_width, #et_pb_fancyline_height, #et_pb_fancyline_margin_top, #et_pb_fancyline_margin_bottom',
				),
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
			),
			'fancyline_color' => array(
				'label'             => esc_html__( 'Line Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
			),
			'fancyline_width' => array(
				'label'             => esc_html__( 'Line Width', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'mobile_options'  => true,
				'depends_default'   => true,
				'default'           => '40px',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
			),
			'fancyline_height' => array(
				'label'             => esc_html__( 'Line Height', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'mobile_options'  => true,
				'depends_default'   => true,
				'default'           => '2px',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
			),
			'fancyline_margin_top' => array(
				'label'       => esc_html__( 'Line Top Spacing', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'mobile_options'  => true,
				'depends_default'   => true,
				'default'           => '20px',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
				'description' => esc_html__( 'Enter the top margin you want to use in PX', 'et_builder' ),
			),
			'fancyline_margin_bottom' => array(
				'label'       => esc_html__( 'Line Bottom Spacing', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'mobile_options'  => true,
				'depends_default'   => true,
				'default'           => '20px',
				'tab_slug'    => 'advanced',
				'toggle_slug'       => 'fancyline_styles',
				'description' => esc_html__( 'Enter the bottom margin you want to use in PX', 'et_builder' ),
			),
			'button_one_animation_on_off' => array(
				'label'           => esc_html__( 'Button One Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_button_one_animation,#et_pb_button_one_animation_reveal',
				),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'off',
			),
			'button_one_animation' => array(
				'label'             => esc_html__( 'Button One Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_one_animation_reveal' => array(
				'label'           => esc_html__( 'Button One Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_button_one_animation_speed',
				),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_one_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_two_animation_on_off' => array(
				'label'           => esc_html__( 'Button Two Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_button_two_animation,#et_pb_button_two_animation_reveal',
				),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'off',
			),
			'button_two_animation' => array(
				'label'             => esc_html__( 'Button Two Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_two_animation_reveal' => array(
				'label'           => esc_html__( 'Button Two Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_button_two_animation_speed',
				),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_two_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),
				'tab_slug'    => 'advanced',
				'depends_show_if'     => 'on',
			),
			'button_mobile_fullwidth' => array(
				'label'           => esc_html__( 'Make Button Fullwidth on Mobile', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'tab_slug'    => 'advanced',
				'description'        => esc_html__( 'If enabled, single or both buttons will be full width at 100% width.', 'et_builder' ),
			),
			//end
			'button_one_text' => array(
				'label'           => sprintf( esc_html__( 'Button %1$s Text', 'et_builder' ), '#1' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the text for the Button.', 'et_builder' ),
			),
			'button_one_url' => array(
				'label'           => sprintf( esc_html__( 'Button %1$s URL', 'et_builder' ), '#1' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the URL for the Button.', 'et_builder' ),
			),
			//added popup for button one
			'popup_video_on_off_one' => array(
				'label'           => esc_html__( 'Video Popup on Button One', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_url_new_window_one',
				),
				'description'     => esc_html__( 'Video URL on Button One URL. If using YouTube as video, use the link that as /embed/ eg https://www.youtube.com/embed/FkQuawiGWUw', 'et_builder' ),
			),
			'url_new_window_one' => array(
				'label'           => esc_html__( 'Url Opens (Button One)', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'In The Same Window', 'et_builder' ),
					'on'  => esc_html__( 'In The New Tab', 'et_builder' ),
				),
				'depends_show_if'     => 'off',
				'description' => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'et_builder' ),
			),
			'button_two_text' => array(
				'label'           => sprintf( esc_html__( 'Button %1$s Text', 'et_builder' ), '#2' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the text for the Button.', 'et_builder' ),
			),
			'button_two_url' => array(
				'label'           => sprintf( esc_html__( 'Button %1$s URL', 'et_builder' ), '#2' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the URL for the Button.', 'et_builder' ),
			),
			'popup_video_on_off_two' => array(
				'label'           => esc_html__( 'Video Popup on Button Two', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_url_new_window_two',
				),
				'description'     => esc_html__( 'Video URL on Button Two URL. If using YouTube as video, use the link that as /embed/ eg https://www.youtube.com/embed/FkQuawiGWUw', 'et_builder' ),
			),
			'url_new_window_two' => array(
				'label'           => esc_html__( 'Url Opens (Button Two)', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'In The Same Window', 'et_builder' ),
					'on'  => esc_html__( 'In The New Tab', 'et_builder' ),
				),
				'depends_show_if'     => 'off',
				'description' => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'et_builder' ),
			),
			'background_url' => array(
				'label'              => esc_html__( 'Background Image URL', 'et_builder' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'        => esc_attr__( 'Set As Image', 'et_builder' ),
				//added depends to show
				'depends_show_if'   => 'off',
				//end
				'description'        => esc_html__( 'Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder' ),
			),
			'background_color' => array(
				'label'             => esc_html__( 'Background Color', 'et_builder' ),
				'type'              => 'color-alpha',
				//added depends to show
				'depends_show_if'   => 'off',
				//end
			),
			'background_overlay_color' => array(
				'label'             => esc_html__( 'Background Overlay Color', 'et_builder' ),
				'type'              => 'color-alpha',
				//added depends to show
				'depends_show_if'   => 'off',
				//end
			),
			//added for animated gradient and particles effect
			'animated_gradient' => array(
				'label'           => esc_html__( 'Animated Gradient Background', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on'   => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_animated_gradient_style, #et_pb_animated_gradient_speed, #et_pb_background_url, #et_pb_background_color, #et_pb_background_overlay_color, #et_pb_parallax',
				),
				'depends_show_if'   => 'off',
				'description'        => esc_html__( 'If enabled, your background will have animated gradient effect', 'et_builder' ),
			),
			'animated_gradient_style' => array(
				'label'           => esc_html__( 'Animated Gradient Style', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'Solid', 'et_builder' ),
					'on'  => esc_html__( 'Transparent', 'et_builder' ),
				),
				'depends_show_if'   => 'on',
				'description'       => esc_html__( 'Define the style, used for the animated gradient effect. If you wish to use background image or parallax, please set it on the fullwidth settings instead of this.', 'et_builder' ),
			),
			'animated_gradient_speed' => array(
				'label'             => esc_html__( 'Animated Gradient Speed', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0.001',
				'range_settings'  => array(
						'min'  => '0.001',
						'max'  => '0.050',
						'step' => '0.001',						
				),
				'description'       => esc_html__( "Change the speed of the animated gradient background.
				", 'et_builder' ),
			),
			'background_gradient' => array(
				'label'             => esc_html__( 'Background Gradient', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on'   => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_animated_gradient, #et_pb_background_gradient_type, #et_pb_background_gradient_color_one, #et_pb_background_gradient_color_two',
				),
				'description'       => esc_html__( 'Set a background gradient color', 'et_builder' ),
			),
			'background_gradient_type' => array(
				'label'           => esc_html__( 'Gradient Type', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'left-to-right' => esc_html__( 'Left to Right →', 'et_builder' ),
					'top-to-bottom'  => esc_html__( 'Top to Bottom ↓', 'et_builder' ),
					'radial'  => esc_html__( 'Radial ○', 'et_builder' ),
					'diagonal-top'  => esc_html__( 'Diagonal ↘', 'et_builder' ),
					'diagonal-bottom'  => esc_html__( 'Diagonal ↗', 'et_builder' ),
				),
				'depends_show_if'   => 'on',
				'description'       => esc_html__( 'Define the gradient type. Top to Bottom, Left to Right, Radial and Diagonal.', 'et_builder' ),
			),
			'background_gradient_color_one' => array(
				'label'             => esc_html__( 'First Gradient Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'depends_show_if'   => 'on',
			),
			'background_gradient_color_two' => array(
				'label'             => esc_html__( '2nd Gradient Color', 'et_builder' ),
				'type'              => 'color-alpha',
				'depends_show_if'   => 'on',
			),
			'particles_effect' => array(
				'label'           => esc_html__( 'Use Particles Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on'   => esc_html__( 'Yes', 'et_builder' ),
				),
				'description'        => esc_html__( 'If enabled, you can have particles background effect on the header.This effect can only be used in one section.', 'et_builder' ),
			),
			//end 
			'parallax' => array(
				'label'           => esc_html__( 'Use Parallax effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_parallax_method',
				),
				//added depends to show
				'depends_show_if'   => 'off',
				//end
				'description'        => esc_html__( 'If enabled, your background images will have a fixed position as your scroll, creating a fun parallax-like effect.', 'et_builder' ),
			),
			'parallax_method' => array(
				'label'           => esc_html__( 'Parallax method', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'CSS', 'et_builder' ),
					'on'  => esc_html__( 'True Parallax', 'et_builder' ),
				),
				'depends_show_if'   => 'on',
				'description'       => esc_html__( 'Define the method, used for the parallax effect.', 'et_builder' ),
			),

			'logo_image_url' => array(
				'label'              => esc_html__( 'Logo Image URL', 'et_builder' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'        => esc_attr__( 'Set As Image', 'et_builder' ),
				'description'        => esc_html__( 'Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder' ),
			),
			//animation for logo image
			//added 
			'logo_image_animation_on_off' => array(
				'label'           => esc_html__( 'Logo Image Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on'   => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_logo_image_animation,#et_pb_logo_image_animation_reveal',
				),
				'description'        => esc_html__( 'If enabled, you can have animation on the logo image.', 'et_builder' ),
			),
			'logo_image_animation' => array(
				'label'             => esc_html__( 'Logo Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),				
				'depends_show_if'     => 'on',				
			),
			'logo_image_animation_reveal' => array(
				'label'           => esc_html__( 'Logo Image Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_logo_image_animation_speed',
				),			
			),
			'logo_image_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),			
				'depends_show_if'     => 'on',
			),
			//end
			'logo_alt_text' => array(
				'label'           => esc_html__( 'Logo Image Alternative Text', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'This defines the HTML ALT text. A short description of your image can be placed here.', 'et_builder' ),
			),
			'logo_title' => array(
				'label'           => esc_html__( 'Logo Title', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'This defines the HTML Title text.', 'et_builder' ),
			),
			'content_orientation' => array(
				'label'           => esc_html__( 'Text Vertical Alignment', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'center'  => esc_html__( 'Center', 'et_builder' ),
					'bottom' => esc_html__( 'Bottom', 'et_builder' ),
				),
				'description'        => esc_html__( 'This setting determines the vertical alignment of your content. Your content can either be vertically centered, or aligned to the bottom.', 'et_builder' ),
				'depends_show_if'    => 'on',
			),

			'header_image_url' => array(
				'label'              => esc_html__( 'Header Image URL', 'et_builder' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'        => esc_attr__( 'Set As Image', 'et_builder' ),
				'description'        => esc_html__( 'Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder' ),
			),
			'header_image_custom_url_on_off' => array(
				'label'           => esc_html__( 'Use Custom Link for Header Image', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on' => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_header_image_custom_url, #et_pb_header_image_custom_url_new_window'
				),
				'description'        => esc_html__( 'If enabled, you can have a custom link for your header image.', 'et_builder' ),
			),
			'header_image_custom_url' => array(
				'label'           => esc_html__( 'Header Image URL', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the URL for the Header Image', 'et_builder' ),
			),
			'header_image_custom_url_new_window' => array(
				'label'           => esc_html__( 'Url Opens', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'In The Same Window', 'et_builder' ),
					'on'  => esc_html__( 'In The New Tab', 'et_builder' ),
				),
				'description' => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'et_builder' ),
			),
			//animation for header image
			'header_image_animation_on_off' => array(
				'label'           => esc_html__( 'Header Image Animation Effect', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'No', 'et_builder' ),
					'on'   => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_header_image_animation, #et_pb_header_image_animation_reveal',
				),
				'description'        => esc_html__( 'If enabled, you can have animation on the header image.', 'et_builder' ),
			),
			'header_image_animation' => array(
				'label'             => esc_html__( 'Header Animation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => $animation_type_list,
				'description'       => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),				
				'depends_show_if'     => 'on',				
			),
			'header_image_animation_reveal' => array(
				'label'           => esc_html__( 'Header Image Show/Hide on Scroll', 'et_builder' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off'  => esc_html__( 'off', 'et_builder' ),
					'on'   => esc_html__( 'on', 'et_builder' ),
				),
				'affects'           => array(
					'#et_pb_header_image_animation_speed',
				),			
			),
			'header_image_animation_speed' => array(
				'label'             => esc_html__( 'Delay Speed (in s)', 'et_builder' ),
				'type'              => 'range',
				'option_category'   => 'configuration',
				'depends_default'   => true,
				'default'           => '0',
				'range_settings'  => array(
						'min'  => '0',
						'max'  => '10',
						'step' => '0.1',						
				),
				'description'       => esc_html__( "This will delay the animation time eg 0.5", 'et_builder' ),			
				'depends_show_if'     => 'on',
			),
			//end
			'image_orientation' => array(
				'label'           => esc_html__( 'Image Vertical Alignment', 'et_builder' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'center'  => esc_html__( 'Vertically Centered', 'et_builder' ),
					'bottom' => esc_html__( 'Bottom', 'et_builder' ),
				),
				'description'        => esc_html__( 'This controls the orientation of the image within the module.', 'et_builder' ),
			),
			'content_new' => array(
				'label'           => esc_html__( 'Content', 'et_builder' ),
				'type'            => 'tiny_mce',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Here you can define the content that will be placed within the infobox for the pin.', 'et_builder' ),
			),
			'disabled_on' => array(
				'label'           => esc_html__( 'Disable on', 'et_builder' ),
				'type'            => 'multiple_checkboxes',
				'options'         => array(
					'phone'   => esc_html__( 'Phone', 'et_builder' ),
					'tablet'  => esc_html__( 'Tablet', 'et_builder' ),
					'desktop' => esc_html__( 'Desktop', 'et_builder' ),
				),
				'additional_att'  => 'disable_on',
				'option_category' => 'configuration',
				'description'     => esc_html__( 'This will disable the module on selected devices', 'et_builder' ),
			),
			'admin_label' => array(
				'label'       => esc_html__( 'Admin Label', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
			),
			'module_id' => array(
				'label'           => esc_html__( 'CSS ID', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
			'module_class' => array(
				'label'           => esc_html__( 'CSS Class', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
		);
		
		return $fields;
	}

	function shortcode_callback( $atts, $content = null, $function_name ) {
		$module_id                    = $this->shortcode_atts['module_id'];
		$module_class                 = $this->shortcode_atts['module_class'];
		$title                        = $this->shortcode_atts['title'];
		$subhead                      = $this->shortcode_atts['subhead'];
		$background_layout            = $this->shortcode_atts['background_layout'];
		$text_orientation             = $this->shortcode_atts['text_orientation'];
		$title_font_color             = $this->shortcode_atts['title_font_color'];
		$subhead_font_color           = $this->shortcode_atts['subhead_font_color'];
		$content_font_color           = $this->shortcode_atts['content_font_color'];
		$button_one_text              = $this->shortcode_atts['button_one_text'];
		$button_one_url               = $this->shortcode_atts['button_one_url'];
		$button_two_text              = $this->shortcode_atts['button_two_text'];
		$button_two_url               = $this->shortcode_atts['button_two_url'];
		$header_fullscreen            = $this->shortcode_atts['header_fullscreen'];
		$header_scroll_down           = $this->shortcode_atts['header_scroll_down'];
		$scroll_down_icon             = $this->shortcode_atts['scroll_down_icon'];
		$scroll_down_icon_color       = $this->shortcode_atts['scroll_down_icon_color'];
		$scroll_down_icon_size        = $this->shortcode_atts['scroll_down_icon_size'];
		$scroll_down_icon_size_tablet = $this->shortcode_atts['scroll_down_icon_size_tablet'];
		$scroll_down_icon_size_phone  = $this->shortcode_atts['scroll_down_icon_size_phone'];
		$background_url               = $this->shortcode_atts['background_url'];
		$background_color             = $this->shortcode_atts['background_color'];
		$background_overlay_color     = $this->shortcode_atts['background_overlay_color'];
		$parallax                     = $this->shortcode_atts['parallax'];
		$parallax_method              = $this->shortcode_atts['parallax_method'];
		$logo_image_url               = $this->shortcode_atts['logo_image_url'];
		$header_image_url             = $this->shortcode_atts['header_image_url'];
		$content_orientation          = $this->shortcode_atts['content_orientation'];
		$image_orientation            = $this->shortcode_atts['image_orientation'];
		$custom_icon_1                = $this->shortcode_atts['button_one_icon'];
		$button_custom_1              = $this->shortcode_atts['custom_button_one'];
		$custom_icon_2                = $this->shortcode_atts['button_two_icon'];
		$button_custom_2              = $this->shortcode_atts['custom_button_two'];
		$max_width                    = $this->shortcode_atts['max_width'];
		$max_width_tablet             = $this->shortcode_atts['max_width_tablet'];
		$max_width_phone              = $this->shortcode_atts['max_width_phone'];
		$logo_title                   = $this->shortcode_atts['logo_title'];
		$logo_alt_text                = $this->shortcode_atts['logo_alt_text'];
		//added
		$typing_effect          	  = $this->shortcode_atts['typing_effect'];
		$typing_static_on_off          	  = $this->shortcode_atts['typing_static_on_off'];
		$typing_static_text          	  = $this->shortcode_atts['typing_static_text'];
		$typing_static_break          	  = $this->shortcode_atts['typing_static_break'];
		$typing_speed          		  = $this->shortcode_atts['typing_speed'];
		$typing_delay          		  = $this->shortcode_atts['typing_delay'];
		$typing_backdelay          		  = $this->shortcode_atts['typing_backdelay'];
		$typing_loop          		  = $this->shortcode_atts['typing_loop'];
		$typing_effect_color          		  = $this->shortcode_atts['typing_effect_color'];
		$typing_cursor          		  = $this->shortcode_atts['typing_cursor'];
		$rotator_effect          	  = $this->shortcode_atts['rotator_effect'];
		$rotator_static_on_off          	  = $this->shortcode_atts['rotator_static_on_off'];
		$rotator_static_text          	  = $this->shortcode_atts['rotator_static_text'];
		$rotator_static_break          	  = $this->shortcode_atts['rotator_static_break'];
		$rotator_type          	  = $this->shortcode_atts['rotator_type'];
		$rotator_speed          	  = $this->shortcode_atts['rotator_speed'];
		$rotator_effect_color         	  = $this->shortcode_atts['rotator_effect_color'];
		$textillate_effect         	  = $this->shortcode_atts['textillate_effect'];
		$textillate_in_effect         	  = $this->shortcode_atts['textillate_in_effect'];
		$textillate_in_type         	  = $this->shortcode_atts['textillate_in_type'];
		$textillate_out_effect         	  = $this->shortcode_atts['textillate_out_effect'];
		$textillate_out_type         	  = $this->shortcode_atts['textillate_out_type'];
		$textgif_on_off          	  = $this->shortcode_atts['textgif_on_off'];
		$textgif_bg          	  = $this->shortcode_atts['textgif_bg'];
		$title_fancyline         = $this->shortcode_atts['title_fancyline'];
		$title_before_after         = $this->shortcode_atts['title_before_after'];
		$title_fancy_orientation         = $this->shortcode_atts['title_fancy_orientation'];
		$fancyline_styles_on_off         = $this->shortcode_atts['fancyline_styles_on_off'];
		$fancyline_width         = $this->shortcode_atts['fancyline_width'];
		$fancyline_height        = $this->shortcode_atts['fancyline_height'];
		$fancyline_color         = $this->shortcode_atts['fancyline_color'];
		$fancyline_margin_top         = $this->shortcode_atts['fancyline_margin_top'];
		$fancyline_margin_top_tablet         = $this->shortcode_atts['fancyline_margin_top_tablet'];
		$fancyline_margin_top_phone         = $this->shortcode_atts['fancyline_margin_top_phone'];
		$fancyline_margin_bottom         = $this->shortcode_atts['fancyline_margin_bottom'];
		$fancyline_margin_bottom_tablet         = $this->shortcode_atts['fancyline_margin_bottom_tablet'];
		$fancyline_margin_bottom_phone         = $this->shortcode_atts['fancyline_margin_bottom_phone'];
		$fancyline_width_tablet             = $this->shortcode_atts['fancyline_width_tablet'];
		$fancyline_width_phone             = $this->shortcode_atts['fancyline_width_phone'];
		$fancyline_height_tablet             = $this->shortcode_atts['fancyline_height_tablet'];
		$fancyline_height_phone             = $this->shortcode_atts['fancyline_height_phone'];
		$subhead_before_after         = $this->shortcode_atts['subhead_before_after'];
		$whole_header_animation_on_off = $this->shortcode_atts['whole_header_animation_on_off'];
		$whole_animation              = $this->shortcode_atts['whole_animation'];
		$whole_animation_reveal              = $this->shortcode_atts['whole_animation_reveal'];
		$whole_animation_speed              = $this->shortcode_atts['whole_animation_speed'];
		$title_animation_on_off = $this->shortcode_atts['title_animation_on_off'];
		$title_animation               = $this->shortcode_atts['title_animation'];
		$title_animation_reveal             = $this->shortcode_atts['title_animation_reveal'];
		$title_animation_speed               = $this->shortcode_atts['title_animation_speed'];
		$subheading_animation_on_off = $this->shortcode_atts['subheading_animation_on_off'];
		$subheading_animation               = $this->shortcode_atts['subheading_animation'];
		$subheading_animation_reveal               = $this->shortcode_atts['subheading_animation_reveal'];
		$subheading_animation_speed               = $this->shortcode_atts['subheading_animation_speed'];
		$content_animation_on_off = $this->shortcode_atts['content_animation_on_off'];
		$content_animation               = $this->shortcode_atts['content_animation'];
		$content_animation_reveal               = $this->shortcode_atts['content_animation_reveal'];
		$content_animation_speed               = $this->shortcode_atts['content_animation_speed'];
		$button_one_animation_on_off = $this->shortcode_atts['button_one_animation_on_off'];
		$button_one_animation               = $this->shortcode_atts['button_one_animation'];
		$button_one_animation_reveal               = $this->shortcode_atts['button_one_animation_reveal'];
		$button_one_animation_speed               = $this->shortcode_atts['button_one_animation_speed'];
		$button_two_animation_on_off = $this->shortcode_atts['button_two_animation_on_off'];
		$button_two_animation               = $this->shortcode_atts['button_two_animation'];
		$button_two_animation_reveal               = $this->shortcode_atts['button_two_animation_reveal'];
		$button_two_animation_speed               = $this->shortcode_atts['button_two_animation_speed'];
		$logo_image_animation_on_off = $this->shortcode_atts['logo_image_animation_on_off'];
		$logo_image_animation               = $this->shortcode_atts['logo_image_animation'];
		$logo_image_animation_reveal               = $this->shortcode_atts['logo_image_animation_reveal'];
		$logo_image_animation_speed               = $this->shortcode_atts['logo_image_animation_speed'];
		$header_image_animation_on_off = $this->shortcode_atts['header_image_animation_on_off'];
		$header_image_animation               = $this->shortcode_atts['header_image_animation'];
		$header_image_animation_reveal               = $this->shortcode_atts['header_image_animation_reveal'];
		$header_image_animation_speed               = $this->shortcode_atts['header_image_animation_speed'];
		$header_scroll_down_effect_on_off           = $this->shortcode_atts['header_scroll_down_effect_on_off'];
		$header_scroll_down_effect           = $this->shortcode_atts['header_scroll_down_effect'];
		$exclude_categories = $this->shortcode_atts['include_categories'];
		$search_on_off          = $this->shortcode_atts['search_on_off'];
		$s_background_layout  = $this->shortcode_atts['s_background_layout'];
		$s_text_orientation   = $this->shortcode_atts['s_text_orientation'];
		$exclude_posts      = $this->shortcode_atts['exclude_posts'];
		$exclude_pages      = $this->shortcode_atts['exclude_pages'];
		$hide_button        = $this->shortcode_atts['hide_button'];
		$placeholder        = $this->shortcode_atts['placeholder'];
		$search_button_color       = $this->shortcode_atts['search_button_color'];
		$search_field_bg           = $this->shortcode_atts['search_field_bg'];
		$search_icon_button       = $this->shortcode_atts['search_icon_button'];
		$search_icon_color 		  = $this->shortcode_atts['search_icon_color'];
		$hide_search_txt 		  = $this->shortcode_atts['hide_search_txt'];
		$search_button_align_on_off 		  = $this->shortcode_atts['search_button_align_on_off'];
		$search_button_align 		  = $this->shortcode_atts['search_button_align'];
		$placeholder_color  = $this->shortcode_atts['placeholder_color'];
		$search_max_width_on_off        = $this->shortcode_atts['search_max_width_on_off'];
		$search_max_width        = $this->shortcode_atts['search_max_width'];
		$search_max_width_tablet        = $this->shortcode_atts['search_max_width_tablet'];
		$search_max_width_phone       = $this->shortcode_atts['search_max_width_phone'];
		$woocommerce_search_on_off          = $this->shortcode_atts['woocommerce_search_on_off'];
		$popup_video_on_off_one				= $this->shortcode_atts['popup_video_on_off_one'];
		$popup_video_on_off_two				= $this->shortcode_atts['popup_video_on_off_two'];
		$url_new_window_one        = $this->shortcode_atts['url_new_window_one'];
		$url_new_window_two        = $this->shortcode_atts['url_new_window_two'];
		//end
		$custom_scroll_down_icon_on_off          	  = $this->shortcode_atts['custom_scroll_down_icon_on_off'];
		$custom_scroll_down_icon_src          	  = $this->shortcode_atts['custom_scroll_down_icon_src'];
		$icon_max_width                    = $this->shortcode_atts['icon_max_width'];
		$icon_max_width_tablet             = $this->shortcode_atts['icon_max_width_tablet'];
		$icon_max_width_phone              = $this->shortcode_atts['icon_max_width_phone'];
		$header_scroll_down           = $this->shortcode_atts['header_scroll_down'];
		$scroll_down_icon             = $this->shortcode_atts['scroll_down_icon'];
		$scroll_down_icon_color       = $this->shortcode_atts['scroll_down_icon_color'];
		$scroll_down_icon_size        = $this->shortcode_atts['scroll_down_icon_size'];
		$scroll_down_icon_size_tablet = $this->shortcode_atts['scroll_down_icon_size_tablet'];
		$scroll_down_icon_size_phone  = $this->shortcode_atts['scroll_down_icon_size_phone'];
		$background_url               = $this->shortcode_atts['background_url'];
		$background_color             = $this->shortcode_atts['background_color'];
		$background_overlay_color     = $this->shortcode_atts['background_overlay_color'];		
		$animated_gradient            = $this->shortcode_atts['animated_gradient'];	
		$animated_gradient_style      = $this->shortcode_atts['animated_gradient_style'];
		$animated_gradient_speed      = $this->shortcode_atts['animated_gradient_speed'];
		$background_gradient            = $this->shortcode_atts['background_gradient'];
		$background_gradient_type            = $this->shortcode_atts['background_gradient_type'];	
		$background_gradient_color_one            = $this->shortcode_atts['background_gradient_color_one'];
		$background_gradient_color_two            = $this->shortcode_atts['background_gradient_color_two'];	
		$particles_effect          	  = $this->shortcode_atts['particles_effect'];	
		//button mobile fullwidth
		$button_mobile_fullwidth =	$this->shortcode_atts['button_mobile_fullwidth'];
		$header_image_custom_url_on_off          	  = $this->shortcode_atts['header_image_custom_url_on_off'];	
		$header_image_custom_url       	  = $this->shortcode_atts['header_image_custom_url'];	
		$header_image_custom_url_new_window  = $this->shortcode_atts['header_image_custom_url_new_window'];
		//end
		if ( is_rtl() && 'left' === $text_orientation) {
			$text_orientation = 'right';
		}

		//added for search
		if ( is_rtl() && 'left' === $s_text_orientation) {
			$s_text_orientation = 'right';
		}

		$module_class = ET_Builder_Element::add_module_order_class( $module_class, $function_name );

		if ( '' !== $max_width_tablet || '' !== $max_width_phone || '' !== $max_width ) {
			$max_width_values = array(
				'desktop' => $max_width,
				'tablet'  => $max_width_tablet,
				'phone'   => $max_width_phone,
			);

			$additional_css = ' !important;';

			et_pb_generate_responsive_css( $max_width_values, '%%order_class%% .header-content', 'max-width', $function_name, $additional_css );
		}

		if ( '' !== $title_font_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1',
				'declaration' => sprintf(
					'color: %1$s !important;',
					esc_html( $title_font_color )
				),
			) );
		}

		if ( '' !== $subhead_font_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_subhead',
				'declaration' => sprintf(
					'color: %1$s !important;',
					esc_html( $subhead_font_color )
				),
			) );
		}

		if ( '' !== $content_font_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header p',
				'declaration' => sprintf(
					'color: %1$s !important;',
					esc_html( $content_font_color )
				),
			) );
		}

		if ( '' !== $scroll_down_icon_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_scroll a .et-pb-icon',
				'declaration' => sprintf(
					'color: %1$s;',
					esc_html( $scroll_down_icon_color )
				),
			) );
		}

		if ( '' !== $scroll_down_icon_size || '' !== $scroll_down_icon_size_tablet || '' !== $scroll_down_icon_size_phone ) {
			$icon_size_values = array(
				'desktop' => $scroll_down_icon_size,
				'tablet'  => $scroll_down_icon_size_tablet,
				'phone'   => $scroll_down_icon_size_phone,
			);

			et_pb_generate_responsive_css( $icon_size_values, '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_scroll a .et-pb-icon', 'font-size', $function_name );
		}

		//added custom image/icon size
		if ( '' !== $icon_max_width_tablet || '' !== $icon_max_width_phone || '' !== $icon_max_width ) {
			$icon_max_width_values = array(
				'desktop' => $icon_max_width,
				'tablet'  => $icon_max_width_tablet,
				'phone'   => $icon_max_width_phone,
			);

			$additional_css = ' !important;';

			et_pb_generate_responsive_css( $icon_max_width_values, '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_scroll.dwd-custom-scroll a .et-pb-icon img', 'width', $function_name, $additional_css );
		}

		if ( 'on' === $background_gradient && 'top-to-bottom' == $background_gradient_type ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_gradient',
				'declaration' => sprintf(
					'background: %1$s;
					background: -moz-linear-gradient(top, %1$s 0%%, %2$s 100%%);
					background: -webkit-gradient(left top, left bottom, color-stop(0%%, %1$s), color-stop(100%%, %2$s));
					background: -webkit-linear-gradient(top, %1$s 0%%, %2$s 100%%);
					background: -o-linear-gradient(top, %1$s 0%%, %2$s 100%%);
					background: -ms-linear-gradient(top, %1$s 0%%, %2$s 100%%);
					background: linear-gradient(to bottom, %1$s 0%%, %2$s 100%%);
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="%1$s", endColorstr="%2$s", GradientType=0 );
					',
					esc_html( $background_gradient_color_one ),
					esc_html( $background_gradient_color_two )
				),
			) );
		}
		//left-to-right
		if ( 'on' === $background_gradient && 'left-to-right' == $background_gradient_type ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_gradient',
				'declaration' => sprintf(
					'background: %1$s;
					background: -moz-linear-gradient(left, %1$s 0%%, %2$s 100%%);
					background: -webkit-gradient(left top, right top, color-stop(0%%, %1$s), color-stop(100%%, %2$s));
					background: -webkit-linear-gradient(left, %1$s 0%%, %2$s 100%%);
					background: -o-linear-gradient(left, %1$s 0%%, %2$s 100%%);
					background: -ms-linear-gradient(left, %1$s 0%%, %2$s 100%%);
					background: linear-gradient(to rigjt, %1$s 0%%, %2$s 100%%);
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="%1$s", endColorstr="%2$s", GradientType=0 );
					',
					esc_html( $background_gradient_color_one ),
					esc_html( $background_gradient_color_two )
				),
			) );
		}
		//radial
		if ( 'on' === $background_gradient && 'radial' == $background_gradient_type ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_gradient',
				'declaration' => sprintf(
					'background: %1$s;
					background: -moz-radial-gradient(center, ellipse cover, %1$s 0%%, %2$s 100%%);
					background: -webkit-gradient(radial, center center, 0px, center center, 100%%, color-stop(0%%, %1$s), color-stop(100%%, %2$s));
					background: -webkit-radial-gradient(center, ellipse cover, %1$s 0%%, %2$s 100%%);
					background: -o-radial-gradient(center, ellipse cover, %1$s 0%%, %2$s 100%%);
					background: -ms-radial-gradient(center, ellipse cover, %1$s 0%%, %2$s 100%%);
					background: radial-gradient(ellipse at center, %1$s 0%%, %2$s 100%%);
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="%1$s", endColorstr="%2$s", GradientType=1 );
					',
					esc_html( $background_gradient_color_one ),
					esc_html( $background_gradient_color_two )
				),
			) );
		}
		//diagonal top
		if ( 'on' === $background_gradient && 'diagonal-top' == $background_gradient_type ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_gradient',
				'declaration' => sprintf(
					'background: %1$s;
					background: -moz-linear-gradient(-45deg, %1$s 0%%, %2$s 100%%);
					background: -webkit-gradient(left top, right bottom, color-stop(0%%, %1$s), color-stop(100%%, %2$s));
					background: -webkit-linear-gradient(-45deg, %1$s 0%%, %2$s 100%%);
					background: -o-linear-gradient(-45deg, %1$s 0%%, %2$s 100%%);
					background: -ms-linear-gradient(-45deg, %1$s 0%%, %2$s 100%%);
					background: linear-gradient(135deg, %1$s 0%, %2$s 100%%);
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="%1$s", endColorstr="%2$s", GradientType=1 );
					',
					esc_html( $background_gradient_color_one ),
					esc_html( $background_gradient_color_two )
				),
			) );
		}
		//diagonal bottom
		if ( 'on' === $background_gradient && 'diagonal-bottom' == $background_gradient_type ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_gradient',
				'declaration' => sprintf(
					'background: %1$s;
					background: -moz-linear-gradient(45deg, %1$s 0%%, %2$s 100%%);
					background: -webkit-gradient(left bottom, right top, color-stop(0%%, %1$s), color-stop(100%%, %2$s));
					background: -webkit-linear-gradient(45deg, %1$s 0%%, %2$s 100%%);
					background: -o-linear-gradient(45deg, %1$s 0%%, %2$s 100%%);
					background: -ms-linear-gradient(45deg, %1$s 0%%, %2$s 100%%);
					background: linear-gradient(45deg, %1$s 0%, %2$s 100%%);
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="%1$s", endColorstr="%2$s", GradientType=1 );
					',
					esc_html( $background_gradient_color_one ),
					esc_html( $background_gradient_color_two )
				),
			) );
		}

		if ( '' !== $typing_effect_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1 span.dwd-typing',
				'declaration' => sprintf(
					'color: %1$s;',
					esc_html( $typing_effect_color )
				),
			) );
		}

		if ( '' !== $typing_cursor ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1 span.typed-cursor',
				'declaration' => sprintf(
					'color: %1$s;',
					esc_html( $typing_cursor )
				),
			) );
		}

		if ( '' !== $rotator_effect_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1 span.dwd-rotator',
				'declaration' => sprintf(
					'color: %1$s;',
					esc_html( $rotator_effect_color )
				),
			) );
		}
		// fancyline before
		if ( 'on' == $fancyline_styles_on_off && '' !== $fancyline_color && 'on' == $title_fancyline && 'before' == $title_before_after ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1:before',
				'declaration' => sprintf(
					'background-color: %1$s;',
					esc_html( $fancyline_color )
				),
			) );
		}
		if ( 'on' == $fancyline_styles_on_off && 'on' == $title_fancyline && 'before' == $title_before_after ) {
			$fancyline_width_values = array(
				'desktop' => $fancyline_width,
				'tablet'   => $fancyline_width_tablet,
				'phone'   => $fancyline_width_phone,
			);

			$additional_css = ' !important;';

			et_pb_generate_responsive_css( $fancyline_width_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:before', 'width', $function_name, $additional_css );

			$fancyline_height_values = array(
				'desktop' => $fancyline_height,
				'tablet'   => $fancyline_height_tablet,
				'phone'   => $fancyline_height_phone,
			);

			et_pb_generate_responsive_css( $fancyline_height_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:before', 'height', $function_name, $additional_css );

			$fancyline_margin_top_values = array(
				'desktop' => $fancyline_margin_top,
				'tablet'   => $fancyline_margin_top_tablet,
				'phone'   => $fancyline_margin_top_phone,
			);

			et_pb_generate_responsive_css( $fancyline_margin_top_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:before', 'margin-top', $function_name, $additional_css );

			$fancyline_margin_bottom_values = array(
				'desktop' => $fancyline_margin_bottom,
				'tablet'   => $fancyline_margin_bottom_tablet,
				'phone'   => $fancyline_margin_bottom_phone,
			);

			et_pb_generate_responsive_css( $fancyline_margin_bottom_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:before', 'margin-bottom', $function_name, $additional_css );
		}

		// fancyline after
		if ( 'on' == $fancyline_styles_on_off && '' !== $fancyline_color && 'on' == $title_fancyline && 'after' == $title_before_after ) {

			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .header-content h1:after',
				'declaration' => sprintf(
					'background-color: %1$s;',
					esc_html( $fancyline_color )
				),
			) );
		}
		if ( 'on' == $fancyline_styles_on_off && 'on' == $title_fancyline && 'after' == $title_before_after ) {
			$fancyline_width_values = array(
				'desktop' => $fancyline_width,
				'tablet'   => $fancyline_width_tablet,
				'phone'   => $fancyline_width_phone,
			);

			$additional_css = ' !important;';

			et_pb_generate_responsive_css( $fancyline_width_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:after', 'width', $function_name, $additional_css );

			$fancyline_height_values = array(
				'desktop' => $fancyline_height,
				'tablet'   => $fancyline_height_tablet,
				'phone'   => $fancyline_height_phone,
			);

			et_pb_generate_responsive_css( $fancyline_height_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:after', 'height', $function_name, $additional_css );

			$fancyline_margin_top_values = array(
				'desktop' => $fancyline_margin_top,
				'tablet'   => $fancyline_margin_top_tablet,
				'phone'   => $fancyline_margin_top_phone,
			);

			et_pb_generate_responsive_css( $fancyline_margin_top_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:after', 'margin-top', $function_name, $additional_css );

			$fancyline_margin_bottom_values = array(
				'desktop' => $fancyline_margin_bottom,
				'tablet'   => $fancyline_margin_bottom_tablet,
				'phone'   => $fancyline_margin_bottom_phone,
			);

			et_pb_generate_responsive_css( $fancyline_margin_bottom_values, '%%order_class%%.et_pb_fullwidth_header .header-content .fancyline:after', 'margin-bottom', $function_name, $additional_css );
		}
		//search
		if ( 'on' === $search_max_width_on_off && '' !== $search_max_width_tablet || '' !== $search_max_width_phone || '' !== $search_max_width ) {
			$search_max_width_values = array(
				'desktop' => $search_max_width,
				'tablet'  => $search_max_width_tablet,
				'phone'   => $search_max_width_phone,
			);

			$additional_css = ' !important;';

			et_pb_generate_responsive_css( $search_max_width_values, '%%order_class%%.et_pb_fullwidth_header .et_pb_search_extended .et_pb_searchform', 'max-width', $function_name, $additional_css );
		}

		if ( '' !== $search_icon_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%% .et_pb_searchsubmit .dwd_search_icon:before',
				'declaration' => sprintf(
					'color:%1$s !important;',
					esc_html( $search_icon_color )
				),
			) );
		}

		if ( '' !== $search_button_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%% button.et_pb_searchsubmit',
				'declaration' => sprintf(
					'background: %1$s !important;border-color:%1$s !important;',
					esc_html( $search_button_color )
				),
			) );

			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%% .et_pb_search_extended input.et_pb_s',
				'declaration' => sprintf(
					'border-color:%1$s !important;',
					esc_html( $search_button_color )
				),
			) );
		}


		if ( '' !== $search_field_bg ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%% .et_pb_search_extended input.et_pb_s',
				'declaration' => sprintf(
					'background: %1$s !important;',
					esc_html( $search_field_bg )
				),
			) );
		}

		if ( '' !== $placeholder_color ) {
			$placeholder_selectors = array(
				'%%order_class%% form input.et_pb_s::-webkit-input-placeholder',
				'%%order_class%% form input.et_pb_s::-moz-placeholder',
				'%%order_class%% form input.et_pb_s:-ms-input-placeholder',
			);

			foreach ( $placeholder_selectors as $single_selector ) {
				ET_Builder_Element::set_style( $function_name, array(
					'selector'    => $single_selector,
					'declaration' => sprintf(
						'color: %1$s !important;',
						esc_html( $placeholder_color )
					),
				) );
			}
		}

		//ended
		if ( '' !== $background_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header',
				'declaration' => sprintf(
					'background-color: %1$s;',
					esc_html( $background_color )
				),
			) );
		}

		if ( '' !== $background_overlay_color ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header .et_pb_fullwidth_header_overlay',
				'declaration' => sprintf(
					'background-color: %1$s;',
					esc_html( $background_overlay_color )
				),
			) );
		}

		if ( '' !== $background_url && 'off' === $parallax ) {
			ET_Builder_Element::set_style( $function_name, array(
				'selector'    => '%%order_class%%.et_pb_fullwidth_header',
				'declaration' => sprintf(
					'background-image: url(%1$s);',
					esc_url( $background_url )
				),
			) );
		}

		$button_output = '';
		if ( '' !== $button_one_text ) {
			$button_output .= sprintf(
				'<a href="%2$s" class="et_pb_more_button et_pb_button et_pb_button_one%4$s%5$s%7$s"%3$s%6$s%8$s%9$s>%1$s</a>',
				( '' !== $button_one_text ? esc_attr( $button_one_text ) : '' ),
				( '' !== $button_one_url ? esc_url( $button_one_url ) : '#' ),
				'' !== $custom_icon_1 && 'on' === $button_custom_1 ? sprintf(
					' data-icon="%1$s"',
					esc_attr( et_pb_process_font_icon( $custom_icon_1 ) )
				) : '',
				'' !== $custom_icon_1 && 'on' === $button_custom_1 ? ' et_pb_custom_button_icon' : '',
				//add
				//%5$			
				( 'off' !== $button_one_animation_reveal ? ' dwd-animation' : '' ),
				//%6$s
				( 'off' !== $button_one_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( " data-dwd-animation={$button_one_animation} data-dwd-animation-delay={$button_one_animation_speed}s" ) : '' ),	
				//%7$s
				( 'off' !== $button_one_animation_on_off && 'off' !== $button_one_animation_reveal && 'off'  === $whole_header_animation_on_off ? '' : esc_attr( " $button_one_animation animated" ) ),
				//%8$s
				( 'off' !== $popup_video_on_off_one ? ' data-rel=lightcase' : '' ),
				//%9$s
				('on' === $url_new_window_one ? ' target="_blank"' : '')
			);
		}

		if ( '' !== $button_two_text ) {
			$button_output .= sprintf(
				'<a href="%2$s" class="et_pb_more_button et_pb_button et_pb_button_two%4$s%5$s%7$s"%3$s%6$s%8$s%9$s>%1$s</a>',
				( '' !== $button_two_text ? esc_attr( $button_two_text ) : '' ),
				( '' !== $button_two_url ? esc_url( $button_two_url ) : '#' ),
				'' !== $custom_icon_2 && 'on' === $button_custom_2 ? sprintf(
					' data-icon="%1$s"',
					esc_attr( et_pb_process_font_icon( $custom_icon_2 ) )
				) : '',
				'' !== $custom_icon_2 && 'on' === $button_custom_2 ? ' et_pb_custom_button_icon' : '',
				//add
				//%5$			
				( 'off' !== $button_two_animation_reveal ? ' dwd-animation' : '' ),
				//%6$s
				( 'off' !== $button_two_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( " data-dwd-animation={$button_two_animation} data-dwd-animation-delay={$button_two_animation_speed}s" ) : '' ),	
				//%7$s
				( 'off' !== $button_two_animation_on_off && 'off' !== $button_two_animation_reveal && 'off'  === $whole_header_animation_on_off ? '' : esc_attr( " $button_two_animation animated" ) ),
				//%8$s
				( 'off' !== $popup_video_on_off_two ? ' data-rel=lightcase' : '' ),
				//%9$s
				('on' === $url_new_window_two ? ' target="_blank"' : '')
			);
		}

		$class = " et_pb_module et_pb_bg_layout_{$background_layout} et_pb_text_align_{$text_orientation}";

		$header_content = '';
		if ( '' !== $title || '' !== $subhead || '' !== $content || '' !== $button_output || '' !== $logo_image_url ) {
			$logo_image = '';
			if ( '' !== $logo_image_url ){
				$logo_image = sprintf(
					'<img class="et_pb_fullwidth_logo_image  %4$s %6$s"%5$s%3$s src="%1$s" alt="%2$s"  />',
					esc_url( $logo_image_url ),
					esc_attr( $logo_alt_text ),
					( '' !== $logo_title ? sprintf( ' title="%1$s"', esc_attr( $logo_title ) ) : '' ),
					//added
					//%4$s
					( 'off' !== $logo_image_animation_reveal ? ' dwd-animation' : '' ),				
					//%5$s
					( 'off' !== $logo_image_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( "data-dwd-animation={$logo_image_animation} data-dwd-animation-delay={$logo_image_animation_speed}s" ) : '' ),
					//%6$s
					( 'off' !== $logo_image_animation_on_off && 'off' !== $logo_image_animation_reveal  && 'off' === $whole_header_animation_on_off ? '': esc_attr( "$logo_image_animation animated" )  ) 
				);
			}
			//ended
			if( $subhead_before_after == 'before' ) {
				$header_content = sprintf(
					'<div class="header-content-container%6$s%7$s %9$s"%8$s>
						<div class="header-content">
							<div class="et_pb_header_description" %11$s %12$s %13$s %14$s %15$s %16$s%17$s>
							%3$s
							%2$s
							%1$s							
							%10$s
							%18$s
							%19$s
							%5$s
							</div>
						</div>
					</div>',
				//%1$s	//title		
				( $title ? sprintf( '<h1 class="%4$s %6$s%11$s%13$s%14$s"%12$s %5$s>%1$s%10$s%9$s%8$s%7$s %2$s%3$s</h1>',
				( 'on' !== $typing_effect && 'on' !== $rotator_effect ? $title : '' ),
				( 'off' !== $typing_effect && 'off' === $typing_static_on_off ? sprintf( '<span class="dwd-typing">%1$s</span>', $title ) : '' ),
				( 'off' !== $rotator_effect && 'off' === $rotator_static_on_off ? sprintf( '<span class="dwd-rotator">%1$s</span>', $title ) : '' ),
				( 'off' !== $title_animation_reveal ? ' dwd-animation' : '' ),
				( 'off' !== $title_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( "data-dwd-animation={$title_animation} data-dwd-animation-delay={$title_animation_speed}s data-title-delay={$title_animation_speed}" ) : '' ),
				( 'off' !== $title_animation_on_off && 'off' === $title_animation_reveal ? esc_attr( "$title_animation animated" ) : '' ),
				( 'off' !== $typing_effect && 'on' === $typing_static_on_off && 'off' !== $typing_static_break ? sprintf( '%1$s <br><span class="dwd-typing">%2$s</span>', $title, $typing_static_text ) : '' ),
				( 'off' !== $rotator_effect  && 'on' === $rotator_static_on_off && 'off' !== $rotator_static_break ? sprintf( '%1$s <br><span class="dwd-rotator">%2$s</span>', $title, $rotator_static_text ) : '' ),
				//break 9
				( 'off' !== $typing_effect && 'on' === $typing_static_on_off && 'on' !== $typing_static_break ? sprintf( '%1$s <span class="dwd-typing">%2$s</span>', $title, $typing_static_text ) : '' ),
				( 'off' !== $rotator_effect  && 'on' === $rotator_static_on_off && 'on' !== $rotator_static_break ? sprintf( '%1$s <span class="dwd-rotator">%2$s</span>', $title, $rotator_static_text ) : '' ),
				//textillate
				( 'off' !== $textillate_effect && 'off' === $rotator_static_on_off && 'off' === $typing_effect ? ' tlt' : '' ),
				( 'off' !== $textillate_effect && 'off' === $rotator_static_on_off && 'off' === $typing_effect ? esc_attr(" data-in-effect={$textillate_in_effect} data-out-effect={$textillate_out_effect} data-in-{$textillate_in_type}=true data-out-{$textillate_out_type}=true") : '' ),
				//textgif 13
				( 'off' !== $textgif_on_off ? ' textgif' : '' ),
				//fancy 14
				( 'off' !== $title_fancyline ? sprintf( ' fancyline%1$s%2$s',
				esc_attr( " fancyline_{$title_before_after}" ),
				esc_attr( " fancyline_text_{$title_fancy_orientation}" )
				) : '' )
				) : '' ),	
				//%2$s  //subhead
				( $subhead ? sprintf( '<span class="et_pb_fullwidth_header_subhead %2$s %4$s" %3$s>%1$s</span>',$subhead,
				( 'off' !== $subheading_animation_reveal ? ' dwd-animation' : '' ),
				( 'off' !== $subheading_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr(
				"data-dwd-animation={$subheading_animation} data-dwd-animation-delay={$subheading_animation_speed}s" ) : '' ),				
				( 'off' !== $subheading_animation_on_off && 'off' === $subheading_animation_reveal ? esc_attr( "$subheading_animation animated") : '' )
				) : '' ),
				//%3$s //logo_image
				$logo_image,					
				$this->shortcode_content,
				//description skipped
				//%5$s  //button
				( '' !== $button_output ? $button_output : '' ),
				( '' !== $content_orientation ? sprintf( ' %1$s', $content_orientation ) : '' ),
				//header animation
				( 'off' !== $whole_header_animation_on_off ? esc_attr( " dwd-animation" ) : '' ),
				( 'off' !== $whole_header_animation_on_off && 'off' !== $whole_animation_reveal ? esc_attr( "data-dwd-animation={$whole_animation} data-dwd-animation-delay={$whole_animation_speed}s" ) : '' ),
				( 'off' !== $whole_header_animation_on_off && 'off' === $whole_animation_reveal ? esc_attr( "$whole_animation animated" ) : '' ),
				//%10$s  //content
				( $this->shortcode_content ? sprintf( '<div class="et_pb_header_content %2$s %4$s" %3$s>%1$s</div>', $this->shortcode_content,		
				( 'off' !== $content_animation_reveal ? ' dwd-animation' : '' ),
				( 'off' !== $content_animation_reveal ? esc_attr( "data-dwd-animation={$content_animation} data-dwd-animation-delay={$content_animation_speed}s" ) : '' ),
				( 'off' !== $content_animation_on_off && 'off' === $content_animation_reveal ? esc_attr( "$content_animation animated" ) : '' )
				) : '' ),
				//add effect data 11%
				( '' !== $typing_speed && 'off' !== $typing_effect ? esc_attr( "data-typing-speed={$typing_speed}" ) : '' ),
				( '' !== $typing_delay && 'off' !== $typing_effect ? esc_attr( "data-typing-delay={$typing_delay}" ) : '' ),
				( '' !== $typing_backdelay && 'off' !== $typing_effect ? esc_attr( "data-typing-backdelay={$typing_backdelay}" ) : '' ),
				//typing loop 14
				( 'off' !== $typing_loop && 'on' === $typing_effect ? esc_attr( "data-typing-loop=false" ) : esc_attr( "data-typing-loop=true" ) ),
				//rotator speed 15%
				( '' !== $rotator_speed && 'off' !== $rotator_effect ? esc_attr( "data-rotator-speed={$rotator_speed}" ) : '' ),
				( '' !== $rotator_type && 'off' !== $rotator_effect ? esc_attr( "data-rotator-type={$rotator_type}" ) : '' ),
				//textgif bg 17
				( 'off' !== $textgif_on_off && '' !== $textgif_bg ? esc_attr( " data-textgif-bg={$textgif_bg}" ) : '' ),
				//search 18
				('off' !== $search_on_off && 'off' === $woocommerce_search_on_off ? sprintf ( '<div class="et_pb_search_extended%7$s%6$s%9$s%10$s"><form role="search" method="get" class="et_pb_searchform" action="%1$s"><label class="screen-reader-text" for="s">Search for:</label><input type="text" value="" name="s" class="et_pb_s"%5$s><input type="hidden" name="et_pb_searchform_submit" value="et_search_proccess"/>%2$s%3$s%4$s<button type="submit" value="Search" class="et_pb_searchsubmit">%8$s</button></form></div>',
				esc_url( home_url( '/' ) ),
				'' !== $exclude_categories ? sprintf( '<input type="hidden" name="et_pb_search_cat" value="%1$s" />',
				esc_attr( $exclude_categories ) ) : '',
				'on' !== $exclude_posts ? '<input type="hidden" name="et_pb_include_posts" value="yes" />' : '',
				'on' !== $exclude_pages ? '<input type="hidden" name="et_pb_include_pages" value="yes" />' : '',
				'' !== $placeholder ? sprintf( ' placeholder="%1$s"', esc_attr( $placeholder ) ) : '',
				('off' !== $search_on_off ? esc_attr( " et_pb_bg_layout_{$s_background_layout} et_pb_text_align_{$s_text_orientation}" ) : '' ),
				'on' === $hide_button ? ' et_pb_hide_search_button' : '',
				'on' === $search_icon_button ? sprintf( '<span class="dwd_search_icon"></span><span class="dwd_search_button_txt">Search</span>' ) : '',
				'on' === $hide_search_txt ? ' dwd_hide_search_txt' : '',
				//search 10%
				'on' == $search_button_align_on_off ? esc_attr( " dwd_search_button_{$search_button_align}" ) : ''
				) : '' ),
				//woosearch 19
				('off' !== $search_on_off && 'on' === $woocommerce_search_on_off ? sprintf ( '<div class="et_pb_search_extended%7$s%6$s%9$s%10$s">
					<form role="search" method="get" class="et_pb_searchform" action="%1$s">
					<label class="screen-reader-text" for="woocommerce-product-search-field">Search for:</label>
					<input type="search" id="woocommerce-product-search-field" class="et_pb_s" %5$s value="" name="s" title="Search for:" />
					<button type="submit" value="Search" class="et_pb_searchsubmit">%8$s</button>
					<input type="hidden" name="post_type" value="product" />
					</form>
					</div>',
				esc_url( home_url( '/' ) ),
				'' !== $exclude_categories ? sprintf( '<input type="hidden" name="et_pb_search_cat" value="%1$s" />',
				esc_attr( $exclude_categories ) ) : '',
				'on' !== $exclude_posts ? '<input type="hidden" name="et_pb_include_posts" value="yes" />' : '',
				'on' !== $exclude_pages ? '<input type="hidden" name="et_pb_include_pages" value="yes" />' : '',
				'' !== $placeholder ? sprintf( ' placeholder="%1$s"', esc_attr( $placeholder ) ) : '',
				('off' !== $search_on_off ? esc_attr( " et_pb_bg_layout_{$s_background_layout} et_pb_text_align_{$s_text_orientation}" ) : '' ),
				'on' === $hide_button ? ' et_pb_hide_search_button' : '',
				'on' === $search_icon_button ? sprintf( '<span class="dwd_search_icon"></span><span class="dwd_search_button_txt">Search</span>' ) : '',
				'on' === $hide_search_txt ? ' dwd_hide_search_txt' : '',
				//search 10%
				'on' == $search_button_align_on_off ? esc_attr( " dwd_search_button_{$search_button_align}" ) : ''
				) : '' )
				);
				} else {
				$header_content = sprintf(
					'<div class="header-content-container%6$s%7$s %9$s"%8$s>
						<div class="header-content">
							<div class="et_pb_header_description" %11$s %12$s %13$s %14$s %15$s %16$s%17$s>
							%3$s						
							%1$s	
							%2$s						
							%10$s
							%18$s
							%19$s
							%5$s
							</div>
						</div>
					</div>',
					//%1$s	//title		
					( $title ? sprintf( '<h1 class="%4$s %6$s%11$s%13$s%14$s"%12$s %5$s>%1$s%10$s%9$s%8$s%7$s %2$s%3$s</h1>',
					( 'on' !== $typing_effect && 'on' !== $rotator_effect ? $title : '' ),
					( 'off' !== $typing_effect && 'off' === $typing_static_on_off ? sprintf( '<span class="dwd-typing">%1$s</span>', $title ) : '' ),
					( 'off' !== $rotator_effect && 'off' === $rotator_static_on_off ? sprintf( '<span class="dwd-rotator">%1$s</span>', $title ) : '' ),
					( 'off' !== $title_animation_reveal ? ' dwd-animation' : '' ),
					( 'off' !== $title_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( "data-dwd-animation={$title_animation} data-dwd-animation-delay={$title_animation_speed}s data-title-delay={$title_animation_speed}" ) : '' ),
					( 'off' !== $title_animation_on_off && 'off' === $title_animation_reveal ? esc_attr( "$title_animation animated" ) : '' ),
					( 'off' !== $typing_effect && 'on' === $typing_static_on_off && 'off' !== $typing_static_break ? sprintf( '%1$s <br><span class="dwd-typing">%2$s</span>', $title, $typing_static_text ) : '' ),
					( 'off' !== $rotator_effect  && 'on' === $rotator_static_on_off && 'off' !== $rotator_static_break ? sprintf( '%1$s <br><span class="dwd-rotator">%2$s</span>', $title, $rotator_static_text ) : '' ),
					//break 9
					( 'off' !== $typing_effect && 'on' === $typing_static_on_off && 'on' !== $typing_static_break ? sprintf( '%1$s <span class="dwd-typing">%2$s</span>', $title, $typing_static_text ) : '' ),
					( 'off' !== $rotator_effect  && 'on' === $rotator_static_on_off && 'on' !== $rotator_static_break ? sprintf( '%1$s <span class="dwd-rotator">%2$s</span>', $title, $rotator_static_text ) : '' ),
					//textillate
					( 'off' !== $textillate_effect && 'off' === $rotator_static_on_off && 'off' === $typing_effect ? ' tlt' : '' ),
					( 'off' !== $textillate_effect && 'off' === $rotator_static_on_off && 'off' === $typing_effect ? esc_attr(" data-in-effect={$textillate_in_effect} data-out-effect={$textillate_out_effect} data-in-{$textillate_in_type}=true data-out-{$textillate_out_type}=true") : '' ),
					//textgif 13
					( 'off' !== $textgif_on_off ? ' textgif' : '' ),
					//fancy 14
					( 'off' !== $title_fancyline ? sprintf( ' fancyline%1$s%2$s',
					esc_attr( " fancyline_{$title_before_after}" ),
					esc_attr( " fancyline_text_{$title_fancy_orientation}" )
					) : '' )
					) : '' ),	
					//%2$s  //subhead
					( $subhead ? sprintf( '<span class="et_pb_fullwidth_header_subhead %2$s %4$s" %3$s>%1$s</span>',$subhead,
					( 'off' !== $subheading_animation_reveal ? ' dwd-animation' : '' ),
					( 'off' !== $subheading_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr(
					"data-dwd-animation={$subheading_animation} data-dwd-animation-delay={$subheading_animation_speed}s" ) : '' ),				
					( 'off' !== $subheading_animation_on_off && 'off' === $subheading_animation_reveal ? esc_attr( "$subheading_animation animated") : '' )
					) : '' ),
					//%3$s //logo_image
					$logo_image,					
					$this->shortcode_content,
					//description skipped
					//%5$s  //button
					( '' !== $button_output ? $button_output : '' ),
					( '' !== $content_orientation ? sprintf( ' %1$s', $content_orientation ) : '' ),
					//header animation
					( 'off' !== $whole_header_animation_on_off ? esc_attr( " dwd-animation" ) : '' ),
					( 'off' !== $whole_header_animation_on_off && 'off' !== $whole_animation_reveal ? esc_attr( "data-dwd-animation={$whole_animation} data-dwd-animation-delay={$whole_animation_speed}s" ) : '' ),
					( 'off' !== $whole_header_animation_on_off && 'off' === $whole_animation_reveal ? esc_attr( "$whole_animation animated" ) : '' ),
					//%10$s  //content
					( $this->shortcode_content ? sprintf( '<div class="et_pb_header_content %2$s %4$s" %3$s>%1$s</div>', $this->shortcode_content,		
					( 'off' !== $content_animation_reveal ? ' dwd-animation' : '' ),
					( 'off' !== $content_animation_reveal ? esc_attr( "data-dwd-animation={$content_animation} data-dwd-animation-delay={$content_animation_speed}s" ) : '' ),
					( 'off' !== $content_animation_on_off && 'off' === $content_animation_reveal ? esc_attr( "$content_animation animated" ) : '' )
					) : '' ),
					//add effect data 11%
					( '' !== $typing_speed && 'off' !== $typing_effect ? esc_attr( "data-typing-speed={$typing_speed}" ) : '' ),
					( '' !== $typing_delay && 'off' !== $typing_effect ? esc_attr( "data-typing-delay={$typing_delay}" ) : '' ),
					( '' !== $typing_backdelay && 'off' !== $typing_effect ? esc_attr( "data-typing-backdelay={$typing_backdelay}" ) : '' ),
					//typing loop 14
					( 'off' !== $typing_loop && 'on' === $typing_effect ? esc_attr( "data-typing-loop=false" ) :  esc_attr( "data-typing-loop=true" ) ),
					//rotator speed 15%
					( '' !== $rotator_speed && 'off' !== $rotator_effect ? esc_attr( "data-rotator-speed={$rotator_speed}" ) : '' ),
					( '' !== $rotator_type && 'off' !== $rotator_effect ? esc_attr( "data-rotator-type={$rotator_type}" ) : '' ),
					//textgif bg 17
					( 'off' !== $textgif_on_off && '' !== $textgif_bg ? esc_attr( " data-textgif-bg={$textgif_bg}" ) : '' ),
					//search 18
					('off' !== $search_on_off && 'off' === $woocommerce_search_on_off ? sprintf ( '<div class="et_pb_search_extended%7$s%6$s%9$s%10$s"><form role="search" method="get" class="et_pb_searchform" action="%1$s"><label class="screen-reader-text" for="s">Search for:</label><input type="text" value="" name="s" class="et_pb_s"%5$s><input type="hidden" name="et_pb_searchform_submit" value="et_search_proccess"/>%2$s%3$s%4$s<button type="submit" value="Search" class="et_pb_searchsubmit">%8$s</button></form></div>',
					esc_url( home_url( '/' ) ),
					'' !== $exclude_categories ? sprintf( '<input type="hidden" name="et_pb_search_cat" value="%1$s" />',
					esc_attr( $exclude_categories ) ) : '',
					'on' !== $exclude_posts ? '<input type="hidden" name="et_pb_include_posts" value="yes" />' : '',
					'on' !== $exclude_pages ? '<input type="hidden" name="et_pb_include_pages" value="yes" />' : '',
					'' !== $placeholder ? sprintf( ' placeholder="%1$s"', esc_attr( $placeholder ) ) : '',
					('off' !== $search_on_off ? esc_attr( " et_pb_bg_layout_{$s_background_layout} et_pb_text_align_{$s_text_orientation}" ) : '' ),
					'on' === $hide_button ? ' et_pb_hide_search_button' : '',
					'on' === $search_icon_button ? sprintf( '<span class="dwd_search_icon"></span><span class="dwd_search_button_txt">Search</span>' ) : '',
					'on' === $hide_search_txt ? ' dwd_hide_search_txt' : '',
					'on' == $search_button_align_on_off ? esc_attr( "dwd_search_button_{$search_button_align}" ) : ''
					) : '' ),
					//woosearch 19
					('off' !== $search_on_off && 'on' === $woocommerce_search_on_off ? sprintf ( '<div class="et_pb_search_extended%7$s%6$s%9$s%10$s">
						<form role="search" method="get" class="et_pb_searchform" action="%1$s">
						<label class="screen-reader-text" for="woocommerce-product-search-field">Search for:</label>
						<input type="search" id="woocommerce-product-search-field" class="et_pb_s" %5$s value="" name="s" title="Search for:" />
						<button type="submit" value="Search" class="et_pb_searchsubmit">%8$s</button>
						<input type="hidden" name="post_type" value="product" />
						</form>
						</div>',
					esc_url( home_url( '/' ) ),
					'' !== $exclude_categories ? sprintf( '<input type="hidden" name="et_pb_search_cat" value="%1$s" />',
					esc_attr( $exclude_categories ) ) : '',
					'on' !== $exclude_posts ? '<input type="hidden" name="et_pb_include_posts" value="yes" />' : '',
					'on' !== $exclude_pages ? '<input type="hidden" name="et_pb_include_pages" value="yes" />' : '',
					'' !== $placeholder ? sprintf( ' placeholder="%1$s"', esc_attr( $placeholder ) ) : '',
					('off' !== $search_on_off ? esc_attr( " et_pb_bg_layout_{$s_background_layout} et_pb_text_align_{$s_text_orientation}" ) : '' ),
					'on' === $hide_button ? ' et_pb_hide_search_button' : '',
					'on' === $search_icon_button ? sprintf( '<span class="dwd_search_icon"></span><span class="dwd_search_button_txt">Search</span>' ) : '',
					'on' === $hide_search_txt ? ' dwd_hide_search_txt' : '',
					//search 10%
					'on' == $search_button_align_on_off ? esc_attr( " dwd_search_button_{$search_button_align}" ) : ''
					) : '' )
				);
			}
			//ended
		}

		$header_image = '';
		if ( '' !== $header_image_url && 'off' !== $header_image_custom_url_on_off && '' !== $header_image_custom_url ) {
			$header_image = sprintf(
				'<div class="header-image-container%2$s">
					<div class="header-image%3$s%5$s"%4$s>
						<a href="%6$s"%7$s>
							<img src="%1$s" />	
						</a>
					</div>
				</div>',
				( '' !== $header_image_url ? esc_url( $header_image_url ) : ''),
				( '' !== $image_orientation ? sprintf( ' %1$s', $image_orientation ) : '' ),
				//added
				//%3$s
				( 'off' !== $header_image_animation_reveal ? ' dwd-animation' : '' ),
				//%4$s	
				( 'off' !== $header_image_animation_reveal && 'off' === $whole_header_animation_on_off? esc_attr( " data-dwd-animation={$header_image_animation} data-dwd-animation-delay={$header_image_animation_speed}s" ) : '' ) ,				
				//%5$s				
				( 'off' !== $header_image_animation_on_off && 'off' === $header_image_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( " $header_image_animation animated" ) : '' ),
				//6
				$header_image_custom_url,
				( 'on' === $header_image_custom_url_new_window ? ' target="_blank"' : '' )
			);
			$module_class .= ' et_pb_header_with_image';
		} else {
		if ( '' !== $header_image_url && 'on' !== $header_image_custom_url_on_off ) {
			$header_image = sprintf(
				'<div class="header-image-container%2$s">
					<div class="header-image%3$s%5$s"%4$s>
						<img src="%1$s" />	
					</div>
				</div>',
				( '' !== $header_image_url ? esc_url( $header_image_url ) : ''),
				( '' !== $image_orientation ? sprintf( ' %1$s', $image_orientation ) : '' ),
				//added
				//%3$s
				( 'off' !== $header_image_animation_reveal ? ' dwd-animation' : '' ),
				//%4$s	
				( 'off' !== $header_image_animation_reveal && 'off' === $whole_header_animation_on_off? esc_attr( " data-dwd-animation={$header_image_animation} data-dwd-animation-delay={$header_image_animation_speed}s" ) : '' ) ,				
				//%5$s				
				( 'off' !== $header_image_animation_on_off && 'off' === $header_image_animation_reveal && 'off' === $whole_header_animation_on_off ? esc_attr( " $header_image_animation animated" ) : '' )
			);
			$module_class .= ' et_pb_header_with_image';
		}
	}

		$scroll_down_output = '';
		if ( 'off' !== $header_scroll_down || '' !== $scroll_down_icon ) {
			$scroll_down_output .= sprintf(
				'<a href="#"><span class="scroll-down et-pb-icon %2$s">%1$s%3$s</a>',
				( 'off' !== $custom_scroll_down_icon_on_off ? '' : esc_html( et_pb_process_font_icon( $scroll_down_icon, 'et_pb_get_font_down_icon_symbols' ) ) ),
				//added animation on scroll down icon
				( 'off' !== $header_scroll_down_effect_on_off ? esc_attr( "$header_scroll_down_effect animated infinite" ) : '' ),
				( 'off' !== $custom_scroll_down_icon_on_off ? sprintf( ' <img src="%1$s" />', $custom_scroll_down_icon_src ) : '' )
			);
		}

		$output = sprintf(
			'<section%9$s class="dwd-fwe et_pb_fullwidth_header%1$s%7$s%8$s%10$s%11$s%12$s%13$s%14$s%16$s%19$s%20$s"%18$s>
				%6$s
				%15$s
				<div class="et_pb_fullwidth_header_container%5$s">
					%2$s
					%3$s
				</div>
				<div class="et_pb_fullwidth_header_gradient"></div>
				<div class="et_pb_fullwidth_header_overlay"></div>
				<div class="et_pb_fullwidth_header_scroll%17$s">%4$s</div>
			</section>				
			',
			//%1$s
			( 'off' !== $header_fullscreen ? ' et_pb_fullscreen' : '' ),						
			( '' !== $header_content ? $header_content : '' ),
			( '' !== $header_image ? $header_image : '' ),
			//%4$s
			( 'off' !== $header_scroll_down ? $scroll_down_output : '' ),
			( '' !== $text_orientation ? sprintf( ' %1$s', esc_attr( $text_orientation ) ) : '' ),
			( '' !== $background_url && 'on' === $parallax
				? sprintf(
					'<div class="et_parallax_bg%2$s" style="background-image: url(%1$s);"></div>',
					esc_attr( $background_url ),
					( 'off' === $parallax_method ? ' et_pb_parallax_css' : '' )
				)
				: ''
			),
			( '' !== $background_url && 'on' === $parallax ? ' et_pb_section_parallax' : '' ),
			esc_attr( $class ),
			//%8$s
			( '' !== $module_id ? sprintf( ' id="%1$s"', esc_attr( $module_id ) ) : '' ),
			( '' !== $module_class ? sprintf( ' %1$s', esc_attr( $module_class ) ) : '' ),
			//added to check if animated bg is on
			//%11$s
			( $animated_gradient == 'on' ? ' et_pb_bg_animated' : '' ),
			//%12$s
			( $animated_gradient === 'on' && $animated_gradient_style === 'off' ? ' et_pb_animated_solid_bg' : ' et_pb_animated_transparent_bg' ),
			//%13$s
			( 'off' !== $typing_effect ? ' et_pb_typing_effect' : '' ),
			//%14$s
			( 'off' !== $rotator_effect ? ' et_pb_rotator_effect' : '' ),
			//%15$s
			( 'off' !== $particles_effect ? sprintf( ' <div id="particles-js"></div>' ) : '' ),
			//16
			( 'off' !== $typing_static_on_off  ? ' dwd-typing-static' : '' ),
			//17
			( 'off' !== $custom_scroll_down_icon_on_off  ? ' dwd-custom-scroll' : '' ),
			//18
			( $animated_gradient === 'on' ? esc_attr(" data-animated-gradient-speed={$animated_gradient_speed}" ) : '' ),
			//19
			( 'off' !== $textillate_effect ? ' et_pb_textillate_effect' : '' ),
			//20
			( 'off' !== $button_mobile_fullwidth ? ' dwd-mobile-fullwidth' : '' )
		);
		// check if on and which method..
		$handle = 'dwd-fullwidth';
		$list = 'enqueued';
	    	if (wp_script_is( $handle, $list )) {
	    		return;
	    } else {
	    	wp_enqueue_style( 'dwd-fullwidth' );
	    }
	    if (!wp_script_is( 'dwd-animation-load-s', 'enqueued' )) {
    		wp_enqueue_script( 'dwd-animation-load' );
	    }
		if( $typing_effect == 'on' ) {
			$handle = 'dwd-typed-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-typed-script' );
		    } else {
		    	wp_enqueue_script( 'dwd-typed' );
		    	wp_enqueue_script( 'dwd-typed-script' );
		    }
		} 
		if ( $rotator_effect == 'on' ) {
			$handle = 'dwd-morptext-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-textrotator' );
		    } else {
		    	wp_enqueue_script( 'dwd-morphext' );
		    	wp_enqueue_script( 'dwd-textrotator' );
		    }
		}
		if ( $textillate_effect == 'on' ) {
			$handle = 'dwd-textillate-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-textillate-start' );
		    } else {
		    	wp_enqueue_script( 'dwd-lettering' );
		    	wp_enqueue_script( 'dwd-textillate' );
		    	wp_enqueue_script( 'dwd-textillate-start' );
		    }
		}
		if ( $particles_effect == 'on' ) {
			$handle = 'dwd-particles-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-particles-start' );
		    } else {
		    	wp_enqueue_script( 'dwd-particles' );
				wp_enqueue_script( 'dwd-particles-start' );
		    }		
		}
		if ( $animated_gradient == 'on' && $animated_gradient_style == 'off' ) {			
			wp_enqueue_script( 'dwd-animated-bg' );
		}
		if ( $animated_gradient == 'on' && $animated_gradient_style == 'on' ) {
			wp_enqueue_script( 'dwd-animated-transparent-bg' );
		}
		if ( $textgif_on_off == 'on' ) {
			$handle = 'dwd-textgif-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-textgif-start' );
		    } else {
		    	wp_enqueue_script( 'dwd-textgif' );
		    	wp_enqueue_script( 'dwd-textgif-start' );
		    }
		}
		if ( $popup_video_on_off_one or $popup_video_on_off_two == 'on' ) {
			$handle = 'dwd-lightcase-s';
			$list = 'enqueued';
		    	if (wp_script_is( $handle, $list )) {
		    		wp_enqueue_script( 'dwd-lightcase-start' );
		    		wp_enqueue_style( 'dwd-lightcase-css' );
		    } else {
		    	wp_enqueue_script( 'dwd-lightcase' );
		    	wp_enqueue_script( 'dwd-lightcase-start' );
		    	wp_enqueue_style( 'dwd-lightcase-css' );
		    }
		}
		return $output;
	}
}

$et_builder_fullwidth_header_extended = new ET_Builder_Module_Fullwidth_Header_Extended();
add_shortcode( 'et_pb_fullwidth_header_extended', array($et_builder_fullwidth_header_extended, '_shortcode_callback') );

class ET_Builder_Module_Fullwith_Text_Extended extends ET_Builder_Module {
	function init() {
		$this->name       = esc_html__( 'Fullwidth Text Extender', 'et_builder' );
		$this->slug       = 'et_pb_text_extender';
		$this->fullwidth        = true;
		$this->fb_support = true;

		$this->whitelisted_fields = array(
			'background_layout',
			'text_orientation',
			'content_new',
			'admin_label',
			'module_id',
			'module_class',
			'max_width',
			'max_width_tablet',
			'max_width_phone',
		);

		$this->fields_defaults = array(
			'background_layout' => array( 'light' ),
			'text_orientation'  => array( 'left' ),
		);

		$this->main_css_element = '%%order_class%%';
		$this->advanced_options = array(
			'fonts' => array(
				'header'   => array(
					'label'    => esc_html__( 'Header', 'et_builder' ),
					'css'      => array(
						'main' => "{$this->main_css_element} h3",
					),
					'description'       => esc_html__( 'H3 Tag', 'et_builder' ),
				),
				'text'   => array(
					'label'    => esc_html__( 'Text', 'et_builder' ),
					'css'      => array(
						'line_height' => "{$this->main_css_element} p",
						'color' => "{$this->main_css_element}.et_pb_text_extender",
					),
				),
			),
			'background' => array(
				'settings' => array(
					'color' => 'alpha',
				),
			),
			'border' => array(),
			'custom_margin_padding' => array(
				'css' => array(
					'important' => 'all',
				),
			),
		);
		$this->custom_css_options = array(
			'header' => array(
				'label'    => esc_html__( 'Header', 'et_builder' ),
				'selector' => '.et_pb_text_extender h3',
			),
		);
	}

	function get_fields() {
		$fields = array(
			'background_layout' => array(
				'label'             => esc_html__( 'Text Color', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => array(
					'light' => esc_html__( 'Dark', 'et_builder' ),
					'dark'  => esc_html__( 'Light', 'et_builder' ),
				),
				'description'       => esc_html__( 'Here you can choose the value of your text. If you are working with a dark background, then your text should be set to light. If you are working with a light background, then your text should be dark.', 'et_builder' ),
			),
			'text_orientation' => array(
				'label'             => esc_html__( 'Text Orientation', 'et_builder' ),
				'type'              => 'select',
				'option_category'   => 'layout',
				'options'           => et_builder_get_text_orientation_options(),
				'description'       => esc_html__( 'This controls the how your text is aligned within the module.', 'et_builder' ),
			),
			'content_new' => array(
				'label'           => esc_html__( 'Content', 'et_builder' ),
				'type'            => 'tiny_mce',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Here you can create the content that will be used within the module.', 'et_builder' ),
			),
			'max_width' => array(
				'label'           => esc_html__( 'Max Width', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'tab_slug'        => 'advanced',
				'validate_unit'   => true,
			),
			'max_width_tablet' => array(
				'type'      => 'skip',
				'tab_slug'  => 'advanced',
			),
			'max_width_phone' => array(
				'type'      => 'skip',
				'tab_slug'  => 'advanced',
			),
			'disabled_on' => array(
				'label'           => esc_html__( 'Disable on', 'et_builder' ),
				'type'            => 'multiple_checkboxes',
				'options'         => array(
					'phone'   => esc_html__( 'Phone', 'et_builder' ),
					'tablet'  => esc_html__( 'Tablet', 'et_builder' ),
					'desktop' => esc_html__( 'Desktop', 'et_builder' ),
				),
				'additional_att'  => 'disable_on',
				'option_category' => 'configuration',
				'description'     => esc_html__( 'This will disable the module on selected devices', 'et_builder' ),
			),
			'admin_label' => array(
				'label'       => esc_html__( 'Admin Label', 'et_builder' ),
				'type'        => 'text',
				'description' => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
			),
			'module_id' => array(
				'label'           => esc_html__( 'CSS ID', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
			'module_class' => array(
				'label'           => esc_html__( 'CSS Class', 'et_builder' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'tab_slug'        => 'custom_css',
				'option_class'    => 'et_pb_custom_css_regular',
			),
		);
		return $fields;
	}

	function shortcode_callback( $atts, $content = null, $function_name ) {
		$module_id            = $this->shortcode_atts['module_id'];
		$module_class         = $this->shortcode_atts['module_class'];
		$background_layout    = $this->shortcode_atts['background_layout'];
		$text_orientation     = $this->shortcode_atts['text_orientation'];
		$max_width            = $this->shortcode_atts['max_width'];
		$max_width_tablet     = $this->shortcode_atts['max_width_tablet'];
		$max_width_phone      = $this->shortcode_atts['max_width_phone'];

		$module_class = ET_Builder_Element::add_module_order_class( $module_class, $function_name );

		$this->shortcode_content = et_builder_replace_code_content_entities( $this->shortcode_content );

		if ( '' !== $max_width_tablet || '' !== $max_width_phone || '' !== $max_width ) {
			$max_width_values = array(
				'desktop' => $max_width,
				'tablet'  => $max_width_tablet,
				'phone'   => $max_width_phone,
			);

			et_pb_generate_responsive_css( $max_width_values, '%%order_class%%', 'max-width', $function_name );
		}

		if ( is_rtl() && 'left' === $text_orientation ) {
			$text_orientation = 'right';
		}

		$class = " et_pb_module et_pb_bg_layout_{$background_layout} et_pb_text_align_{$text_orientation}";

		$output = sprintf(
			'<div%3$s class="et_pb_text_extender%2$s%4$s">
				%1$s
			</div> <!-- .et_pb_text -->',
			$this->shortcode_content,
			esc_attr( $class ),
			( '' !== $module_id ? sprintf( ' id="%1$s"', esc_attr( $module_id ) ) : '' ),
			( '' !== $module_class ? sprintf( ' %1$s', esc_attr( $module_class ) ) : '' )
		);

		return $output;
	}
}
new ET_Builder_Module_Fullwith_Text_Extended;